/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitMergeSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialogKt;
import git4idea.merge.GitMergeOption;
import git4idea.merge.dialog.CmdLabel;
import git4idea.merge.dialog.FlatComboBoxUI;
import git4idea.merge.dialog.GitOptionsPanel;
import git4idea.merge.dialog.GitOptionsPopupBuilder;
import git4idea.merge.dialog.OptionInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.ui.ComboBoxWithAutoCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComboBoxUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 d2\u00020\u0001:\u0001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00100\u001a\u00020'H\u0014J\u0016\u00101\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00180\u00180%H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0007H\u0014J\b\u00104\u001a\u000205H\u0014J\b\u00106\u001a\u00020\u0018H\u0014J\b\u00107\u001a\u000208H\u0014J\b\u00109\u001a\u00020\u0018H\u0007J\u0006\u0010:\u001a\u00020\u0005J\u0006\u0010;\u001a\u00020\u001dJ\u000f\u0010<\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b=H\u0002J\u0006\u0010>\u001a\u00020/J\b\u0010?\u001a\u000208H\u0002J\b\u0010@\u001a\u000208H\u0002J'\u0010A\u001a!\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\u000f\u0012\r\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00190\u00070\u0017H\u0002J\b\u0010B\u001a\u000208H\u0002J\u0018\u0010C\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010D\u001a\u00020\u0013H\u0003J\n\u0010E\u001a\u0004\u0018\u000103H\u0002J\b\u0010F\u001a\u000208H\u0002J&\u0010G\u001a\r\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00190\u00072\u0011\u0010H\u001a\r\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00190\u0007H\u0002J\u0013\u0010I\u001a\r\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00190\u0007H\u0002J\u0010\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u0005H\u0002J\u0006\u0010L\u001a\u00020\u0013J\b\u0010M\u001a\u000208H\u0002J\b\u0010N\u001a\u00020'H\u0002J\b\u0010O\u001a\u00020/H\u0002J\b\u0010P\u001a\u00020'H\u0002J\u0016\u0010Q\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130#H\u0002J\b\u0010R\u001a\u00020SH\u0002J\u0016\u0010T\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00180\u00180%H\u0002J\b\u0010U\u001a\u00020'H\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0!H\u0002J\u001d\u0010W\u001a\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\u0002\bY\u00a2\u0006\u0002\bZ\u00a2\u0006\u0002\b[0XH\u0002J\u0010\u0010\\\u001a\u00020/2\u0006\u0010]\u001a\u00020\fH\u0002J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010]\u001a\u00020\fH\u0002J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\u0010\u0010`\u001a\u00020/2\u0006\u0010]\u001a\u00020\fH\u0002J\u0010\u0010a\u001a\u0002082\u0006\u0010]\u001a\u00020\fH\u0002J\b\u0010b\u001a\u000208H\u0002J\b\u0010c\u001a\u000208H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0011\u001a0\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0017\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00150\u0012\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0016\u001a!\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\u000f\u0012\r\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00190\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u001a\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c\u0018\u00010\u00170\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00180\u00180%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lgit4idea/merge/GitMergeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "defaultRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "selectedOptions", "", "Lgit4idea/merge/GitMergeOption;", "getSelectedOptions", "()Ljava/util/Set;", "mergeSettings", "Lgit4idea/config/GitMergeSettings;", "repositories", "", "Lgit4idea/repo/GitRepository;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Unmodifiable;", "allBranches", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "unmergedBranches", "", "", "Lgit4idea/GitBranch;", "optionInfos", "Lgit4idea/merge/dialog/OptionInfo;", "popupBuilder", "Lgit4idea/merge/dialog/GitOptionsPopupBuilder;", "repositoryField", "Lcom/intellij/openapi/ui/ComboBox;", "branchField", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "commandPanel", "Ljavax/swing/JPanel;", "optionsPanel", "Lgit4idea/merge/dialog/GitOptionsPanel;", "commitMsgField", "Lcom/intellij/ui/components/JBTextArea;", "commitMsgPanel", "panel", "isNoVerifySupported", "", "createCenterPanel", "getPreferredFocusedComponent", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "createSouthPanel", "Ljavax/swing/JComponent;", "getHelpId", "doOKAction", "", "getCommitMessage", "getSelectedRoot", "getSelectedBranch", "tryGetSelectedBranch", "Lorg/jetbrains/annotations/Nullable;", "shouldCommitAfterMerge", "saveSettings", "loadSettings", "collectAllBranches", "loadUnmergedBranchesInBackground", "loadUnmergedBranchesForRoot", "repository", "validateBranchField", "updateBranchesField", "splitAndSortBranches", "branches", "getBranches", "getRepository", "root", "getSelectedRepository", "updateDialogTitle", "createPanel", "showRootField", "createCommandPanel", "createRepoField", "createCmdLabel", "Lgit4idea/merge/dialog/CmdLabel;", "createBranchField", "createCommitMsgPanel", "createPopupBuilder", "createOptionsDropDown", "Lcom/intellij/ui/components/DropDownLink;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/jvm/internal/EnhancedNullability;", "isOptionSelected", "option", "getOptionInfo", "getOptions", "isOptionEnabled", "optionChosen", "updateUi", "updateCommitMessagePanel", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitMergeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMergeDialog.kt\ngit4idea/merge/GitMergeDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,463:1\n30#2,2:464\n1642#3,10:466\n1915#3:476\n1916#3:478\n1652#3:479\n777#3:480\n873#3,2:481\n1915#3,2:483\n1300#3,2:485\n1315#3,2:487\n1586#3:490\n1661#3,3:491\n1318#3:494\n1786#3,3:495\n1#4:477\n1#4:489\n13#5:498\n*S KotlinDebug\n*F\n+ 1 GitMergeDialog.kt\ngit4idea/merge/GitMergeDialog\n*L\n97#1:464,2\n144#1:466,10\n144#1:476\n144#1:478\n144#1:479\n178#1:480\n178#1:481,2\n179#1:483,2\n182#1:485,2\n182#1:487,2\n185#1:490\n185#1:491,3\n182#1:494\n422#1:495,3\n144#1:477\n451#1:498\n*E\n"})
public final class GitMergeDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile defaultRoot;
    @NotNull
    private final List<VirtualFile> roots;
    @NotNull
    private final Set<GitMergeOption> selectedOptions;
    @NotNull
    private final GitMergeSettings mergeSettings;
    private final List<GitRepository> repositories;
    @NotNull
    private final Map<GitRepository, List<String>> allBranches;
    private final Map<GitRepository, Set<GitBranch>> unmergedBranches;
    @NotNull
    private final Map<GitMergeOption, OptionInfo<GitMergeOption>> optionInfos;
    @NotNull
    private final GitOptionsPopupBuilder<GitMergeOption> popupBuilder;
    @NotNull
    private final ComboBox<GitRepository> repositoryField;
    @NotNull
    private final ComboBoxWithAutoCompletion<String> branchField;
    @NotNull
    private final JPanel commandPanel;
    @NotNull
    private final GitOptionsPanel<GitMergeOption> optionsPanel;
    @NotNull
    private final JBTextArea commitMsgField;
    @NotNull
    private final JPanel commitMsgPanel;
    @NotNull
    private final JPanel panel;
    private final boolean isNoVerifySupported;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String UNMERGED_BRANCHES_FORMAT;
    private static final Pattern BRANCH_NAME_REGEX;
    @NlsSafe
    @NotNull
    private static final String REMOTE_REF = "remotes/";

    public GitMergeDialog(@NotNull Project project, @NotNull VirtualFile defaultRoot, @NotNull List<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)defaultRoot, (String)"defaultRoot");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        super(project);
        this.project = project;
        this.defaultRoot = defaultRoot;
        this.roots = roots;
        this.selectedOptions = new LinkedHashSet();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitMergeSettings> serviceClass$iv = GitMergeSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.mergeSettings = (GitMergeSettings)object;
        this.repositories = DvcsUtil.sortRepositories((Collection)GitRepositoryManager.getInstance(this.project).getRepositories());
        this.allBranches = this.collectAllBranches();
        this.unmergedBranches = Collections.synchronizedMap(new HashMap());
        this.optionInfos = new LinkedHashMap();
        this.popupBuilder = this.createPopupBuilder();
        this.repositoryField = this.createRepoField();
        this.branchField = this.createBranchField();
        this.commandPanel = this.createCommandPanel();
        this.optionsPanel = new GitOptionsPanel((Function1)new Function1<GitMergeOption, Unit>((Object)this){

            public final void invoke(GitMergeOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitMergeDialog.access$optionChosen((GitMergeDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitMergeOption, OptionInfo<GitMergeOption>>((Object)this){

            public final OptionInfo<GitMergeOption> invoke(GitMergeOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitMergeDialog.access$getOptionInfo((GitMergeDialog)((Object)this.receiver), p0);
            }
        });
        this.commitMsgField = new JBTextArea("");
        this.commitMsgPanel = this.createCommitMsgPanel();
        this.panel = this.createPanel();
        this.isNoVerifySupported = GitVersionSpecialty.NO_VERIFY_SUPPORTED.existsIn(GitExecutableManager.getInstance().getVersion(this.project));
        this.loadUnmergedBranchesInBackground();
        this.updateDialogTitle();
        this.setOKButtonText(GitBundle.message((String)"merge.action.name", (Object[])new Object[0]));
        this.loadSettings();
        this.updateBranchesField();
        this.setAutoAdjustable(false);
        this.init();
        this.getWindow().setMinimumSize((Dimension)new JBDimension(200, 60));
        this.updateUi();
        this.validate();
        this.pack();
    }

    @NotNull
    public final Set<GitMergeOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.panel;
    }

    @NotNull
    public ComboBoxWithAutoCompletion<String> getPreferredFocusedComponent() {
        return this.branchField;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object)new Function0<ValidationInfo>((Object)this){

            public final ValidationInfo invoke() {
                return GitMergeDialog.access$validateBranchField((GitMergeDialog)((Object)this.receiver));
            }
        });
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)((Function0)it).invoke() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createSouthPanel(...)");
        return GitMergeDialogKt.createSouthPanelWithOptionsDropDown(jComponent, this.createOptionsDropDown());
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.MergeBranches";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        try {
            this.saveSettings();
        }
        finally {
            super.doOKAction();
        }
    }

    @NlsSafe
    @NotNull
    public final String getCommitMessage() {
        String string = this.commitMsgField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final VirtualFile getSelectedRoot() {
        VirtualFile virtualFile = ((GitRepository)this.repositoryField.getItem()).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return virtualFile;
    }

    @NotNull
    public final GitBranch getSelectedBranch() {
        GitBranch gitBranch = this.tryGetSelectedBranch();
        if (gitBranch == null) {
            String string = this.branchField.getText();
            if (string == null) {
                string = "";
            }
            throw new IllegalStateException(("Unable to find branch: " + string).toString());
        }
        return gitBranch;
    }

    private final GitBranch tryGetSelectedBranch() {
        GitBranchesCollection gitBranchesCollection = this.getSelectedRepository().getBranches();
        String string = this.branchField.getText();
        if (string == null) {
            string = "";
        }
        return gitBranchesCollection.findBranchByName(string);
    }

    public final boolean shouldCommitAfterMerge() {
        return !this.isOptionSelected(GitMergeOption.NO_COMMIT);
    }

    private final void saveSettings() {
        this.mergeSettings.setBranch(this.branchField.getText());
        this.mergeSettings.setOptions(this.selectedOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSettings() {
        void $this$filterTo$iv$iv;
        this.branchField.setItem(this.mergeSettings.getBranch());
        Set<GitMergeOption> set = this.mergeSettings.getOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOptions(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitMergeOption option = (GitMergeOption)((Object)element$iv$iv);
            boolean bl = false;
            if (!(option != GitMergeOption.NO_VERIFY || this.isNoVerifySupported)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitMergeOption option = (GitMergeOption)((Object)element$iv);
            boolean bl = false;
            ((Collection)this.selectedOptions).add(option);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, List<String>> collectAllBranches() {
        void $this$associateWithTo$iv$iv;
        List<GitRepository> list = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list, (String)"repositories");
        Iterable $this$associateWith$iv = list;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void repo;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            GitBranchesCollection it = repo.getBranches();
            boolean $i$a$-let-GitMergeDialog$collectAllBranches$1$22 = false;
            Collection<GitLocalBranch> collection = it.getLocalBranches();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getLocalBranches(...)");
            Collection<GitRemoteBranch> collection2 = it.getRemoteBranches();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getRemoteBranches(...)");
            Iterable iterable2 = CollectionsKt.plus(collection, (Iterable)collection2);
            boolean $i$f$map = false;
            void $i$a$-let-GitMergeDialog$collectAllBranches$1$22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                GitBranch gitBranch = (GitBranch)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                collection3.add(it2.getName());
            }
            List list2 = (List)destination$iv$iv2;
            map2.put(t, list2);
        }
        return destination$iv$iv;
    }

    private final void loadUnmergedBranchesInBackground() {
        Project project = this.project;
        String string = GitBundle.message((String)"merge.branch.loading.branches.progress", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project, string){
            final /* synthetic */ GitMergeDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable<Object> iterable = new LinkedHashSet<VirtualFile>(GitMergeDialog.access$getRoots$p(this.this$0).size());
                GitMergeDialog gitMergeDialog = this.this$0;
                LinkedHashSet<VirtualFile> $this$run_u24lambda_u240 = iterable;
                boolean bl = false;
                $this$run_u24lambda_u240.add(GitMergeDialog.access$getDefaultRoot$p(gitMergeDialog));
                $this$run_u24lambda_u240.addAll(GitMergeDialog.access$getRoots$p(gitMergeDialog));
                LinkedHashSet<VirtualFile> sortedRoots = iterable;
                iterable = sortedRoots;
                gitMergeDialog = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Set branches;
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    GitRepository repository2 = GitMergeDialog.access$getRepository(gitMergeDialog, root);
                    if (GitMergeDialog.access$loadUnmergedBranchesForRoot(gitMergeDialog, repository2) == null) continue;
                    boolean bl3 = false;
                    Map map2 = GitMergeDialog.access$getUnmergedBranches$p(gitMergeDialog);
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"access$getUnmergedBranches$p(...)");
                    map2.put(repository2, branches);
                }
            }
        });
    }

    @RequiresBackgroundThread
    private final Set<GitBranch> loadUnmergedBranchesForRoot(GitRepository repository2) {
        VirtualFile virtualFile = repository2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        try {
            GitLineHandler handler = new GitLineHandler(this.project, root, GitCommand.BRANCH);
            String[] stringArray = new String[]{UNMERGED_BRANCHES_FORMAT, "--no-color", "--all", "--no-merged"};
            handler.addParameters(stringArray);
            GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
            GitCommandResult result2 = gitCommandResult;
            result2.throwOnError(new int[0]);
            Collection<GitRemote> collection = repository2.getRemotes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemotes(...)");
            Collection<GitRemote> remotes = collection;
            List<String> list = result2.getOutput();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getOutput(...)");
            return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), GitMergeDialog::loadUnmergedBranchesForRoot$lambda$0), arg_0 -> GitMergeDialog.loadUnmergedBranchesForRoot$lambda$1(remotes, arg_0)));
        }
        catch (Exception e) {
            LOG.warn("Failed to load unmerged branches for root: " + root, (Throwable)e);
            return null;
        }
    }

    private final ValidationInfo validateBranchField() {
        boolean selectedBranchMerged;
        ValidationInfo validationInfo;
        String string = GitBundle.message((String)"merge.no.branch.selected.error", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationInfo validationInfo2 = validationInfo = GitMergeDialogKt.validateBranchExists(this.branchField, string);
        if (validationInfo2 != null) {
            return validationInfo2;
        }
        GitBranch gitBranch = this.tryGetSelectedBranch();
        if (gitBranch == null) {
            return new ValidationInfo(GitBundle.message((String)"merge.no.matching.branch.error", (Object[])new Object[0]));
        }
        GitBranch selectedBranch = gitBranch;
        GitRepository selectedRepository = this.getSelectedRepository();
        Set<GitBranch> set = this.unmergedBranches.get(selectedRepository);
        if (set == null) {
            return null;
        }
        Set<GitBranch> unmergedBranches = set;
        boolean bl = selectedBranchMerged = !unmergedBranches.contains(selectedBranch);
        if (selectedBranchMerged) {
            Object[] objectArray = new Object[]{selectedBranch};
            return new ValidationInfo(GitBundle.message((String)"merge.branch.already.merged", (Object[])objectArray), (JComponent)((Object)this.branchField));
        }
        return null;
    }

    private final void updateBranchesField() {
        String branchToSelect = (String)this.branchField.getItem();
        List<String> branches = this.splitAndSortBranches(this.getBranches());
        ComboBoxModel comboBoxModel = this.branchField.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<@[FlexibleNullability] kotlin.String?>");
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        model.update(branches);
        if (branchToSelect == null || !branches.contains(branchToSelect)) {
            String string;
            Object v2;
            block5: {
                GitRepository repository2 = this.getSelectedRepository();
                GitLocalBranch gitLocalBranch = repository2.getCurrentBranch();
                String currentRemoteBranch = gitLocalBranch != null && (gitLocalBranch = gitLocalBranch.findTrackedBranch(repository2)) != null ? gitLocalBranch.getNameForRemoteOperations() : null;
                Iterable iterable = branches;
                for (Object t : iterable) {
                    String branch = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)branch, (Object)currentRemoteBranch)) continue;
                    v2 = t;
                    break block5;
                }
                v2 = null;
            }
            if ((string = (String)v2) == null) {
                String string2;
                int n = 0;
                List<String> list = branches;
                if (n < list.size()) {
                    string2 = list.get(n);
                } else {
                    int it = n;
                    boolean bl = false;
                    string2 = "";
                }
                string = string2;
            }
            branchToSelect = string;
        }
        this.branchField.setItem(branchToSelect);
        this.branchField.selectAll();
    }

    private final List<String> splitAndSortBranches(List<String> branches) {
        List local = new ArrayList();
        List remote = new ArrayList();
        for (String branch : branches) {
            if (StringsKt.startsWith$default((String)branch, (String)REMOTE_REF, (boolean)false, (int)2, null)) {
                Collection collection = remote;
                String string = branch.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(string);
                continue;
            }
            ((Collection)local).add(branch);
        }
        List<String> list = GitBranchUtil.sortBranchNames(local);
        Intrinsics.checkNotNullExpressionValue(list, (String)"sortBranchNames(...)");
        Collection collection = list;
        List<String> list2 = GitBranchUtil.sortBranchNames(remote);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"sortBranchNames(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private final List<String> getBranches() {
        GitRepository repository2 = this.getSelectedRepository();
        List list = this.allBranches.get(repository2);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final GitRepository getRepository(VirtualFile root) {
        Object v1;
        block2: {
            List<GitRepository> list = this.repositories;
            Intrinsics.checkNotNullExpressionValue(list, (String)"repositories");
            Iterable iterable = list;
            for (Object t : iterable) {
                GitRepository repo = (GitRepository)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)repo.getRoot(), (Object)root)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        GitRepository gitRepository = v1;
        if (gitRepository == null) {
            throw new IllegalStateException(("Unable to find repository for root: " + root.getPresentableUrl()).toString());
        }
        return gitRepository;
    }

    @NotNull
    public final GitRepository getSelectedRepository() {
        return this.getRepository(this.getSelectedRoot());
    }

    private final void updateDialogTitle() {
        String string;
        String currentBranchName = this.getSelectedRepository().getCurrentBranchName();
        Object[] objectArray = (Object[])currentBranchName;
        if (objectArray == null || objectArray.length() == 0) {
            string = GitBundle.message((String)"merge.branch.title", (Object[])new Object[0]);
        } else {
            objectArray = new Object[]{currentBranchName};
            string = GitBundle.message((String)"merge.branch.into.current.title", (Object[])objectArray);
        }
        this.setTitle(string);
    }

    private final JPanel createPanel() {
        JPanel jPanel;
        JPanel $this$createPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3), new AC().grow()));
        $this$createPanel_u24lambda_u240.add((Component)this.commandPanel, new CC().growX());
        $this$createPanel_u24lambda_u240.add((Component)this.optionsPanel, new CC().newline().width("100%").alignY("top"));
        $this$createPanel_u24lambda_u240.add((Component)this.commitMsgPanel, new CC().newline().push().grow());
        return jPanel;
    }

    private final boolean showRootField() {
        return this.roots.size() > 1;
    }

    private final JPanel createCommandPanel() {
        AC aC;
        JPanel jPanel;
        JPanel $this$createCommandPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        if (this.showRootField()) {
            var4_4 = new int[]{0, 2};
            aC = new AC().grow(100.0f, var4_4);
        } else {
            var4_4 = new int[]{1};
            aC = new AC().grow(100.0f, var4_4);
        }
        AC colConstraints = aC;
        $this$createCommandPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").gridGap("0", "0").noVisualPadding(), colConstraints));
        if (this.showRootField()) {
            $this$createCommandPanel_u24lambda_u240.add((Component)this.repositoryField, new CC().gapAfter("0").minWidth("135").growX());
        }
        $this$createCommandPanel_u24lambda_u240.add((Component)this.createCmdLabel(), new CC().gapAfter("0").alignY("top").minWidth("100"));
        $this$createCommandPanel_u24lambda_u240.add((Component)((Object)this.branchField), new CC().alignY("top").minWidth("300").growX());
        return jPanel;
    }

    private final ComboBox<GitRepository> createRepoField() {
        ComboBox<GitRepository> comboBox;
        List<GitRepository> list = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list, (String)"repositories");
        ComboBox<GitRepository> $this$createRepoField_u24lambda_u240 = comboBox = GitMergeDialogKt.createRepositoryField(list, this.defaultRoot);
        boolean bl = false;
        $this$createRepoField_u24lambda_u240.addItemListener(arg_0 -> GitMergeDialog.createRepoField$lambda$0$0(this, arg_0));
        return comboBox;
    }

    private final CmdLabel createCmdLabel() {
        return new CmdLabel("git merge", new Insets(1, this.showRootField() ? 0 : 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)100), this.branchField.getPreferredSize().height, true));
    }

    private final ComboBoxWithAutoCompletion<String> createBranchField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$createBranchField_u24lambda_u240 = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel((List)new ArrayList()), this.project);
        boolean bl = false;
        $this$createBranchField_u24lambda_u240.setPrototypeDisplayValue("origin/long-enough-branch-name");
        String string = GitBundle.message((String)"merge.branch.field.placeholder", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createBranchField_u24lambda_u240.setPlaceholder(string);
        Insets insets = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), DarculaUIUtil.BW.get());
        String string2 = GitBundle.message((String)"merge.branch.popup.empty.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$createBranchField_u24lambda_u240.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, insets, string2, null, 9, null)));
        return comboBoxWithAutoCompletion;
    }

    private final JPanel createCommitMsgPanel() {
        JPanel jPanel;
        JPanel $this$createCommitMsgPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createCommitMsgPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().insets("0").fill()));
        $this$createCommitMsgPanel_u24lambda_u240.setVisible(false);
        $this$createCommitMsgPanel_u24lambda_u240.add((Component)new JLabel(GitBundle.message((String)"merge.commit.message.label", (Object[])new Object[0])), new CC().alignY("top").wrap());
        $this$createCommitMsgPanel_u24lambda_u240.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.commitMsgField), (int)20, (int)30), new CC().alignY("top").grow().push().minHeight("75"));
        return jPanel;
    }

    private final GitOptionsPopupBuilder<GitMergeOption> createPopupBuilder() {
        String string = GitBundle.message((String)"merge.options.modify.popup.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new GitOptionsPopupBuilder<GitMergeOption>(this.project, string, (Function0)new Function0<List<? extends GitMergeOption>>((Object)this){

            public final List<GitMergeOption> invoke() {
                return GitMergeDialog.access$getOptions((GitMergeDialog)((Object)this.receiver));
            }
        }, (Function1)new Function1<GitMergeOption, OptionInfo<GitMergeOption>>((Object)this){

            public final OptionInfo<GitMergeOption> invoke(GitMergeOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitMergeDialog.access$getOptionInfo((GitMergeDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitMergeOption, Boolean>((Object)this){

            public final Boolean invoke(GitMergeOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitMergeDialog.access$isOptionSelected((GitMergeDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitMergeOption, Boolean>((Object)this){

            public final Boolean invoke(GitMergeOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitMergeDialog.access$isOptionEnabled((GitMergeDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitMergeOption, Unit>((Object)this){

            public final void invoke(GitMergeOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitMergeDialog.access$optionChosen((GitMergeDialog)((Object)this.receiver), p0);
            }
        }, null, 128, null);
    }

    private final DropDownLink<String> createOptionsDropDown() {
        DropDownLink dropDownLink;
        DropDownLink $this$createOptionsDropDown_u24lambda_u241 = dropDownLink = new DropDownLink((Object)GitBundle.message((String)"merge.options.modify", (Object[])new Object[0]), arg_0 -> GitMergeDialog.createOptionsDropDown$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createOptionsDropDown_u24lambda_u241.setMnemonic(77);
        return dropDownLink;
    }

    private final boolean isOptionSelected(GitMergeOption option) {
        return this.selectedOptions.contains((Object)option);
    }

    private final OptionInfo<GitMergeOption> getOptionInfo(GitMergeOption option) {
        OptionInfo optionInfo = this.optionInfos.computeIfAbsent(option, arg_0 -> GitMergeDialog.getOptionInfo$lambda$1(arg_0 -> GitMergeDialog.getOptionInfo$lambda$0(option, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionInfo, (String)"computeIfAbsent(...)");
        return optionInfo;
    }

    private final List<GitMergeOption> getOptions() {
        List list;
        List $this$getOptions_u24lambda_u240 = list = ArraysKt.toMutableList((Object[])GitMergeOption.values());
        boolean bl = false;
        if (!this.isNoVerifySupported) {
            $this$getOptions_u24lambda_u240.remove((Object)GitMergeOption.NO_VERIFY);
        }
        return list;
    }

    private final boolean isOptionEnabled(GitMergeOption option) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.selectedOptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitMergeOption it = (GitMergeOption)((Object)element$iv);
                    boolean bl2 = false;
                    if (it.isOptionSuitable(option)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void optionChosen(GitMergeOption option) {
        if (!this.isOptionSelected(option)) {
            ((Collection)this.selectedOptions).add(option);
        } else {
            ((Collection)this.selectedOptions).remove((Object)option);
        }
        this.updateUi();
        this.validate();
        this.pack();
    }

    private final void updateUi() {
        this.optionsPanel.rerender(this.selectedOptions);
        this.updateCommitMessagePanel();
        this.panel.invalidate();
    }

    private final void updateCommitMessagePanel() {
        boolean useCommitMsg = this.isOptionSelected(GitMergeOption.COMMIT_MESSAGE);
        this.commitMsgPanel.setVisible(useCommitMsg);
        if (!useCommitMsg) {
            this.commitMsgField.setText("");
        }
    }

    private static final String loadUnmergedBranchesForRoot$lambda$0(String line) {
        Matcher matcher = BRANCH_NAME_REGEX.matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private static final GitBranch loadUnmergedBranchesForRoot$lambda$1(Collection $remotes, String refName) {
        Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
        return GitRepositoryReader.Companion.parseBranchRef($remotes, refName);
    }

    private static final void createRepoField$lambda$0$0(GitMergeDialog this$0, ItemEvent e) {
        if (e.getStateChange() == 1 && e.getItem() != null) {
            this$0.updateDialogTitle();
            this$0.updateBranchesField();
        }
    }

    private static final JBPopup createOptionsDropDown$lambda$0(GitMergeDialog this$0, DropDownLink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JBPopup)this$0.popupBuilder.createPopup();
    }

    private static final OptionInfo getOptionInfo$lambda$0(GitMergeOption $option, GitMergeOption it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new OptionInfo<GitMergeOption>($option, $option.getOption(), $option.getDescription());
    }

    private static final OptionInfo getOptionInfo$lambda$1(Function1 $tmp0, Object p0) {
        return (OptionInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ValidationInfo access$validateBranchField(GitMergeDialog $this) {
        return $this.validateBranchField();
    }

    public static final /* synthetic */ List access$getRoots$p(GitMergeDialog $this) {
        return $this.roots;
    }

    public static final /* synthetic */ VirtualFile access$getDefaultRoot$p(GitMergeDialog $this) {
        return $this.defaultRoot;
    }

    public static final /* synthetic */ GitRepository access$getRepository(GitMergeDialog $this, VirtualFile root) {
        return $this.getRepository(root);
    }

    public static final /* synthetic */ Set access$loadUnmergedBranchesForRoot(GitMergeDialog $this, GitRepository repository2) {
        return $this.loadUnmergedBranchesForRoot(repository2);
    }

    public static final /* synthetic */ Map access$getUnmergedBranches$p(GitMergeDialog $this) {
        return $this.unmergedBranches;
    }

    public static final /* synthetic */ List access$getOptions(GitMergeDialog $this) {
        return $this.getOptions();
    }

    public static final /* synthetic */ OptionInfo access$getOptionInfo(GitMergeDialog $this, GitMergeOption option) {
        return $this.getOptionInfo(option);
    }

    public static final /* synthetic */ boolean access$isOptionSelected(GitMergeDialog $this, GitMergeOption option) {
        return $this.isOptionSelected(option);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(GitMergeDialog $this, GitMergeOption option) {
        return $this.isOptionEnabled(option);
    }

    public static final /* synthetic */ void access$optionChosen(GitMergeDialog $this, GitMergeOption option) {
        $this.optionChosen(option);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitMergeDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        UNMERGED_BRANCHES_FORMAT = "--format=%(refname) [%(symref)]";
        BRANCH_NAME_REGEX = Pattern.compile("(\\S+) \\[]");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/merge/GitMergeDialog$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "UNMERGED_BRANCHES_FORMAT", "", "getUNMERGED_BRANCHES_FORMAT$annotations", "BRANCH_NAME_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REMOTE_REF", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getUNMERGED_BRANCHES_FORMAT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

