/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitWorkingTree;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ!\u0010\u001f\u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J<\u0010#\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u00072\b\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0002R\u0018\u0010\u0006\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgit4idea/workingTrees/GitListWorktreeLineListener;", "Lgit4idea/commands/GitLineHandlerListener;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "currentRoot", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "badLineReported", "", "currentWorktreePath", "branchFullName", "isDetached", "", "isLocked", "isPrunable", "isFirst", "trees", "", "Lgit4idea/GitWorkingTree;", "getTrees", "()Ljava/util/List;", "_trees", "", "report", "", "line", "e", "Lcom/intellij/openapi/vcs/VcsException;", "onLineAvailable", "Lcom/intellij/openapi/util/NlsSafe;", "outputType", "Lcom/intellij/openapi/util/Key;", "createWorkingTree", "path", "branch", "detached", "main", "locked", "prunable", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitListWorktreeLineListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitListWorktreeLineListener.kt\ngit4idea/workingTrees/GitListWorktreeLineListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n23#2:103\n23#2:104\n23#2:105\n*S KotlinDebug\n*F\n+ 1 GitListWorktreeLineListener.kt\ngit4idea/workingTrees/GitListWorktreeLineListener\n*L\n31#1:103\n87#1:104\n90#1:105\n*E\n"})
public final class GitListWorktreeLineListener
implements GitLineHandlerListener {
    @NotNull
    private final String currentRoot;
    private int badLineReported;
    @Nullable
    private String currentWorktreePath;
    @Nullable
    private String branchFullName;
    private boolean isDetached;
    private boolean isLocked;
    private boolean isPrunable;
    private boolean isFirst;
    @NotNull
    private final List<GitWorkingTree> _trees;

    public GitListWorktreeLineListener(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        String string = repository2.getRoot().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.currentRoot = string;
        this.isFirst = true;
        this._trees = new ArrayList();
    }

    @NotNull
    public final List<GitWorkingTree> getTrees() {
        return (List)ExtensionsKt.toImmutableList((Iterable)this._trees);
    }

    public final void report(@NotNull String line, @Nullable VcsException e) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int n = this.badLineReported;
        this.badLineReported = n + 1;
        if (this.badLineReported < 5) {
            GitListWorktreeLineListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitListWorktreeLineListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unexpected worktree output: " + line, (Throwable)e);
        }
    }

    public static /* synthetic */ void report$default(GitListWorktreeLineListener gitListWorktreeLineListener, String string, VcsException vcsException, int n, Object object) {
        if ((n & 2) != 0) {
            vcsException = null;
        }
        gitListWorktreeLineListener.report(string, vcsException);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onLineAvailable(@NotNull String line, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (StringsKt.isBlank((CharSequence)line)) {
            this.createWorkingTree(this.currentWorktreePath, this.branchFullName, this.isDetached, this.isFirst, this.isLocked, this.isPrunable);
            return;
        }
        try {
            if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDOUT)) return;
            if (Intrinsics.areEqual((Object)line, (Object)"detached")) {
                this.isDetached = true;
                return;
            }
            if (Intrinsics.areEqual((Object)line, (Object)"locked")) {
                this.isLocked = true;
                return;
            }
            StringScanner scanner = new StringScanner(line);
            String string = scanner.spaceToken();
            if (string == null) {
                return;
            }
            String name = string;
            String string2 = scanner.line();
            if (string2 == null) {
                return;
            }
            String value = string2;
            switch (name) {
                case "worktree": {
                    this.currentWorktreePath = value;
                    return;
                }
                case "branch": {
                    this.branchFullName = value;
                    return;
                }
                case "prunable": {
                    this.isPrunable = true;
                    return;
                }
                case "locked": {
                    this.isLocked = true;
                    return;
                }
                default: {
                    GitListWorktreeLineListener.report$default(this, line, null, 2, null);
                    return;
                }
                case "HEAD": {
                    return;
                }
            }
        }
        catch (VcsException e) {
            this.report(line, e);
        }
    }

    private final void createWorkingTree(String path, String branch, boolean detached, boolean main, boolean locked, boolean prunable) {
        if (path == null) {
            GitListWorktreeLineListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitListWorktreeLineListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            String string = branch;
            if (string == null) {
                string = "<detached>";
            }
            logger.warn("'worktree' wasn't reported for branch " + string);
        } else if (!detached && branch == null) {
            GitListWorktreeLineListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitListWorktreeLineListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("'branch' wasn't reported for path " + path);
        } else {
            this._trees.add(new GitWorkingTree(path, branch, main, Intrinsics.areEqual((Object)path, (Object)this.currentRoot), locked, prunable));
        }
        this.currentWorktreePath = null;
        this.branchFullName = null;
        this.isDetached = false;
        this.isLocked = false;
        this.isPrunable = false;
        this.isFirst = false;
    }
}

