// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package git4idea.annotate

import com.intellij.openapi.project.Project
import com.intellij.openapi.vcs.annotate.FileAnnotation
import com.intellij.openapi.vcs.impl.VcsCacheManager
import com.intellij.openapi.vfs.VirtualFile
import com.intellij.vcsUtil.VcsUtil
import com.intellij.vcsUtil.VcsUtil.getLastCommitPath
import git4idea.GitRevisionNumber
import git4idea.GitVcs
import git4idea.repo.GitRepositoryManager
import org.jetbrains.annotations.CalledInAny

@CalledInAny
internal fun getAnnotationFromCache(project: Project, file: VirtualFile): FileAnnotation? {
  val repository = GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file) ?: return null
  val currentRevision = repository.currentRevision ?: return null

  val cache = VcsCacheManager.getInstance(project).vcsHistoryCache
  val filePath = getLastCommitPath(project, VcsUtil.getFilePath(file))
  val lastRevision = cache.getLastRevision(filePath, GitVcs.getKey(), GitRevisionNumber(currentRevision)) ?: return null
  val annotationData = cache.getAnnotation(filePath, GitVcs.getKey(), lastRevision) as? GitAnnotationProvider.CachedData ?: return null

  return GitFileAnnotation(project, file, filePath, repository.root, lastRevision, annotationData.lines)
}