/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.checkin.GitCheckinHandler;
import git4idea.checkin.GitCheckinHandlerFactoryKt;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler;", "Lgit4idea/checkin/GitCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runGitCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "committedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDetachedRoot", "Lgit4idea/checkin/GitDetachedRootCheckinHandler$DetachedRoot;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "GitRebaseCommitProblem", "GitDetachedRootCommitProblem", "DetachedRoot", "intellij.vcs.git"})
final class GitDetachedRootCheckinHandler
extends GitCheckinHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DETACHED_HEAD_HELP_LINK = "https://git-scm.com/docs/git-checkout#_detached_head";
    @NotNull
    private static final String REBASE_HELP_LINK = "https://git-scm.com/docs/git-rebase";

    public GitDetachedRootCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    public boolean isEnabled() {
        return GitVcsSettings.getInstance((Project)this.getProject()).warnAboutDetachedHead();
    }

    @Override
    @Nullable
    public Object runGitCheck(@NotNull CommitInfo commitInfo, @NotNull List<? extends Change> committedChanges, @NotNull Continuation<? super CommitProblem> $completion) {
        List selectedRoots = GitCheckinHandlerFactoryKt.access$getSelectedRoots(this.getProject(), committedChanges);
        DetachedRoot detachedRoot = this.getDetachedRoot(selectedRoots);
        if (detachedRoot == null) {
            return null;
        }
        if (detachedRoot.isDuringRebase()) {
            return new GitRebaseCommitProblem(detachedRoot.getRoot());
        }
        return new GitDetachedRootCommitProblem(detachedRoot.getRoot());
    }

    private final DetachedRoot getDetachedRoot(List<? extends VirtualFile> roots) {
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile virtualFile : roots) {
            GitRepository repository2;
            if ((GitRepository)repositoryManager.getRepositoryForRootQuick(virtualFile) == null || repository2.isOnBranch() || GitRebaseUtils.isInteractiveRebaseInProgress(repository2)) continue;
            return new DetachedRoot(virtualFile, repository2.isRebaseInProgress());
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$Companion;", "", "<init>", "()V", "DETACHED_HEAD_HELP_LINK", "", "REBASE_HELP_LINK", "detachedHeadDoNotAsk", "Lcom/intellij/openapi/ui/DoNotAskOption;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final DoNotAskOption detachedHeadDoNotAsk(Project project) {
            return (DoNotAskOption)new DoNotAskOption.Adapter(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public void rememberChoice(boolean isSelected, int exitCode) {
                    GitVcsSettings.getInstance((Project)this.$project).setWarnAboutDetachedHead(!isSelected);
                }

                public String getDoNotShowMessage() {
                    String string = GitBundle.message((String)"checkbox.dont.warn.again", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$DetachedRoot;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDuringRebase", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "intellij.vcs.git"})
    private static final class DetachedRoot {
        @NotNull
        private final VirtualFile root;
        private final boolean isDuringRebase;

        public DetachedRoot(@NotNull VirtualFile root, boolean isDuringRebase) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
            this.isDuringRebase = isDuringRebase;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        public final boolean isDuringRebase() {
            return this.isDuringRebase;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$GitDetachedRootCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "getText", "()Ljava/lang/String;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "project", "Lcom/intellij/openapi/project/Project;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "showDetailsLink", "getShowDetailsLink", "showDetailsAction", "getShowDetailsAction", "showDetails", "", "intellij.vcs.git"})
    private static final class GitDetachedRootCommitProblem
    implements CommitProblemWithDetails {
        @NotNull
        private final VirtualFile root;

        public GitDetachedRootCommitProblem(@NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.root.getPresentableUrl()};
            String string = GitBundle.message((String)"commit.check.warning.title.commit.with.detached.head", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
            String string = GitBundle.message((String)"warning.title.commit.with.detached.head", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            Object[] objectArray = new Object[]{HtmlChunk.text((String)this.root.getPresentableUrl()).bold().toString()};
            HtmlBuilder message = new HtmlBuilder().appendRaw(GitBundle.message((String)"warning.message.commit.with.detached.head", (Object[])objectArray)).br().appendLink(GitDetachedRootCheckinHandler.DETACHED_HEAD_HELP_LINK, GitBundle.message((String)"link.label.commit.with.detached.head.read.more", (Object[])new Object[0]));
            String string2 = message.wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            boolean commit = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string2).yesText(commitInfo.getCommitActionText())).icon(Messages.getWarningIcon())).doNotAsk(Companion.detachedHeadDoNotAsk(project))).ask(project);
            if (commit) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        public String getShowDetailsLink() {
            String string = GitBundle.message((String)"commit.check.warning.title.commit.with.detached.head.details", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getShowDetailsAction() {
            String string = GitBundle.message((String)"commit.check.warning.title.commit.with.detached.head.details", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void showDetails(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BrowserUtil.browse((String)GitDetachedRootCheckinHandler.DETACHED_HEAD_HELP_LINK);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$GitRebaseCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "getText", "()Ljava/lang/String;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "project", "Lcom/intellij/openapi/project/Project;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "showDetailsLink", "getShowDetailsLink", "showDetailsAction", "getShowDetailsAction", "showDetails", "", "intellij.vcs.git"})
    private static final class GitRebaseCommitProblem
    implements CommitProblemWithDetails {
        @NotNull
        private final VirtualFile root;

        public GitRebaseCommitProblem(@NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.root.getPresentableUrl()};
            String string = GitBundle.message((String)"commit.check.warning.title.commit.during.rebase", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
            String string = GitBundle.message((String)"warning.title.commit.with.unfinished.rebase", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            Object[] objectArray = new Object[]{HtmlChunk.text((String)this.root.getPresentableUrl()).bold().toString()};
            HtmlBuilder message = new HtmlBuilder().appendRaw(GitBundle.message((String)"warning.message.commit.with.unfinished.rebase", (Object[])objectArray)).br().appendLink(GitDetachedRootCheckinHandler.REBASE_HELP_LINK, GitBundle.message((String)"link.label.commit.with.unfinished.rebase.read.more", (Object[])new Object[0]));
            String string2 = message.wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            boolean commit = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string2).yesText(commitInfo.getCommitActionText())).icon(Messages.getWarningIcon())).doNotAsk(Companion.detachedHeadDoNotAsk(project))).ask(project);
            if (commit) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        public String getShowDetailsLink() {
            String string = GitBundle.message((String)"commit.check.warning.title.commit.during.rebase.details", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getShowDetailsAction() {
            String string = GitBundle.message((String)"commit.check.warning.title.commit.during.rebase.details", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void showDetails(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BrowserUtil.browse((String)GitDetachedRootCheckinHandler.REBASE_HELP_LINK);
        }
    }
}

