/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.merge.MergeConflictManager;
import com.intellij.openapi.vcs.util.paths.RecursiveFilePathSet;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.changes.GitChangeUtils;
import git4idea.repo.CopyOnWriteFilePathSet;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/merge/GitResolvedMergeConflictsFilesHolder;", "Lcom/intellij/openapi/Disposable;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "inUpdate", "", "resolvedFiles", "Lgit4idea/repo/CopyOnWriteFilePathSet;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resolvedConflictsFilePaths", "", "Lcom/intellij/openapi/vcs/FilePath;", "isInUpdateMode", "containsResolvedFile", "filePath", "invalidate", "", "scheduleUpdate", "update", "notifyListeners", "dispose", "clear", "intellij.vcs.git"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGitResolvedMergeConflictsFilesHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitResolvedMergeConflictsFilesHolder.kt\ngit4idea/merge/GitResolvedMergeConflictsFilesHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class GitResolvedMergeConflictsFilesHolder
implements Disposable {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final ReentrantReadWriteLock LOCK;
    private boolean inUpdate;
    @NotNull
    private final CopyOnWriteFilePathSet resolvedFiles;
    @NotNull
    private final MergingUpdateQueue queue;

    public GitResolvedMergeConflictsFilesHolder(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        this.LOCK = new ReentrantReadWriteLock();
        this.resolvedFiles = new CopyOnWriteFilePathSet(this.repository.getRoot().isCaseSensitive());
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.queue = VcsIgnoreManagerImpl.Companion.getInstanceImpl(project).getIgnoreRefreshQueue();
        this.scheduleUpdate();
    }

    @NotNull
    public final Collection<FilePath> resolvedConflictsFilePaths() {
        return this.resolvedFiles.toSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInUpdateMode() {
        boolean bl;
        ReentrantReadWriteLock.ReadLock readLock = this.LOCK.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.inUpdate;
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    public final boolean containsResolvedFile(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.resolvedFiles.hasAncestor(filePath);
    }

    public final void invalidate() {
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleUpdate() {
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!MergeConflictManager.Companion.isNonModalMergeEnabled(project2)) {
            this.clear();
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.LOCK;
        Object[] objectArray = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            objectArray.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.inUpdate = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                objectArray.lock();
            }
            writeLock.unlock();
        }
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)project2, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
        objectArray = new Object[]{this, "update resolved conflicts"};
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)this, (Object)new ComparableObject.Impl(objectArray), () -> GitResolvedMergeConflictsFilesHolder.scheduleUpdate$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.queue.queue((Update)disposableUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update() {
        if (this.repository.getState() == Repository.State.NORMAL) {
            this.clear();
            this.notifyListeners();
            return;
        }
        List<FilePath> list = GitChangeUtils.getResolvedFiles(this.repository);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getResolvedFiles(...)");
        List<FilePath> actualResolvedFiles = list;
        if (actualResolvedFiles.isEmpty()) {
            this.clear();
            this.notifyListeners();
            return;
        }
        Object object = new RecursiveFilePathSet(this.repository.getRoot().isCaseSensitive());
        RecursiveFilePathSet $this$update_u24lambda_u240 = object;
        boolean bl = false;
        $this$update_u24lambda_u240.addAll((Collection)actualResolvedFiles);
        RecursiveFilePathSet actualResolvedFilesSet = object;
        object = this.LOCK;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            this.resolvedFiles.set(actualResolvedFilesSet);
            this.inUpdate = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.notifyListeners();
    }

    private final void notifyListeners() {
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ChangeListManagerImpl.getInstanceImpl((Project)project2).notifyUnchangedFileStatusChanged();
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)project2, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
    }

    public void dispose() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.resolvedFiles.getInitialized()) {
                this.resolvedFiles.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private static final void scheduleUpdate$lambda$1(GitResolvedMergeConflictsFilesHolder this$0) {
        this$0.update();
    }
}

