/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.notification.NotificationAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitNotification;
import com.intellij.vcs.commit.CommitSuccessNotificationActionProvider;
import com.intellij.vcs.commit.VcsCommitter;
import com.intellij.vcs.log.Hash;
import git4idea.checkin.GitPostCommitChangeConverter;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRewordService;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/rebase/log/GitCommitSuccessNotificationRewordProvider;", "Lcom/intellij/vcs/commit/CommitSuccessNotificationActionProvider;", "<init>", "()V", "getActions", "", "Lcom/intellij/notification/NotificationAction;", "committer", "Lcom/intellij/vcs/commit/VcsCommitter;", "notification", "Lcom/intellij/vcs/commit/CommitNotification;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitSuccessNotificationRewordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitSuccessNotificationRewordProvider.kt\ngit4idea/rebase/log/GitCommitSuccessNotificationRewordProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,32:1\n30#2,2:33\n*S KotlinDebug\n*F\n+ 1 GitCommitSuccessNotificationRewordProvider.kt\ngit4idea/rebase/log/GitCommitSuccessNotificationRewordProvider\n*L\n28#1:33,2\n*E\n"})
public final class GitCommitSuccessNotificationRewordProvider
implements CommitSuccessNotificationActionProvider {
    @NotNull
    public List<NotificationAction> getActions(@NotNull VcsCommitter committer, @NotNull CommitNotification notification) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Map<GitRepository, Hash> map2 = GitPostCommitChangeConverter.Companion.getRecordedPostCommitHashes(committer.getCommitContext());
        if (map2 == null) {
            return CollectionsKt.emptyList();
        }
        Map<GitRepository, Hash> repoWithCommitHash = map2;
        if (repoWithCommitHash.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project = ((GitRepository)CollectionsKt.first((Iterable)repoWithCommitHash.keySet())).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        MessageBusConnection connection = project2.getMessageBus().connect();
        notification.whenExpired(() -> GitCommitSuccessNotificationRewordProvider.getActions$lambda$0(connection));
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitCommitSuccessNotificationRewordProvider.getActions$lambda$1(repoWithCommitHash, notification, arg_0));
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)GitBundle.message((String)"action.Git.Reword.Commit.text", (Object[])new Object[0]), () -> GitCommitSuccessNotificationRewordProvider.getActions$lambda$2(project2, repoWithCommitHash));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        NotificationAction rewordAction = notificationAction;
        return CollectionsKt.listOf((Object)rewordAction);
    }

    private static final void getActions$lambda$0(MessageBusConnection $connection) {
        $connection.disconnect();
    }

    private static final void getActions$lambda$1(Map $repoWithCommitHash, CommitNotification $notification, GitRepository repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Hash hash = (Hash)$repoWithCommitHash.get(repo);
        if (!Intrinsics.areEqual((Object)repo.getCurrentRevision(), (Object)(hash != null ? hash.asString() : null))) {
            $notification.expire();
        }
    }

    private static final void getActions$lambda$2(Project $project, Map $repoWithCommitHash) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<GitRewordService> serviceClass$iv = GitRewordService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GitRewordService)object).launchReword($repoWithCommitHash);
    }
}

