/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryExtKt;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.impl.shared.RepositoryId;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\nJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/repo/GitRepositoryIdCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "cache", "", "Lcom/intellij/platform/vcs/impl/shared/RepositoryId;", "Lgit4idea/repo/GitRepository;", "get", "repositoryId", "resolveAll", "", "repositoryIds", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryIdCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryIdCache.kt\ngit4idea/repo/GitRepositoryIdCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1642#2,10:45\n1915#2:55\n1916#2:57\n1652#2:58\n1661#2,3:59\n832#2:62\n862#2,2:63\n1#3:56\n1#3:65\n*S KotlinDebug\n*F\n+ 1 GitRepositoryIdCache.kt\ngit4idea/repo/GitRepositoryIdCache\n*L\n30#1:45,10\n30#1:55\n30#1:57\n30#1:58\n33#1:59,3\n34#1:62\n34#1:63,2\n30#1:56\n*E\n"})
public final class GitRepositoryIdCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<RepositoryId, GitRepository> cache;

    public GitRepositoryIdCache(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cache = new ConcurrentHashMap();
        this.project.getMessageBus().connect(cs).subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> GitRepositoryIdCache._init_$lambda$0(this));
    }

    @Nullable
    public final GitRepository get(@NotNull RepositoryId repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        return this.cache.compute(repositoryId, (arg_0, arg_1) -> GitRepositoryIdCache.get$lambda$1((arg_0, arg_1) -> GitRepositoryIdCache.get$lambda$0(this, repositoryId, arg_0, arg_1), arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GitRepository> resolveAll(@NotNull List<RepositoryId> repositoryIds) {
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(repositoryIds, (String)"repositoryIds");
        Iterable $this$mapNotNull$iv = repositoryIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            GitRepository it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            RepositoryId p0 = (RepositoryId)element$iv$iv;
            boolean bl2 = false;
            if (this.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resolved = (List)destination$iv$iv;
        if (!(resolved.size() == repositoryIds.size())) {
            void $this$filterNotTo$iv$iv;
            void destination$iv;
            void $this$mapTo$iv;
            boolean bl = false;
            $this$mapNotNullTo$iv$iv = resolved;
            destination$iv$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                object = (GitRepository)item$iv;
                void var11_14 = destination$iv;
                boolean bl4 = false;
                var11_14.add(RepositoryExtKt.repositoryId((Repository)((Repository)it)));
            }
            Set resolvedIds = (Set)destination$iv;
            Iterable $this$filterNot$iv = repositoryIds;
            boolean $i$f$filterNot = false;
            $this$forEach$iv$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                RepositoryId it = (RepositoryId)element$iv$iv;
                boolean bl5 = false;
                if (resolvedIds.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List notFound = (List)destination$iv$iv2;
            String string = "Failed to resolve repositories: " + notFound;
            throw new IllegalStateException(string.toString());
        }
        return resolved;
    }

    private static final void _init_$lambda$0(GitRepositoryIdCache this$0) {
        this$0.cache.clear();
    }

    private static final GitRepository get$lambda$0(GitRepositoryIdCache this$0, RepositoryId $repositoryId, RepositoryId repositoryId, GitRepository value) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"<unused var>");
        GitRepository gitRepository = value;
        if (gitRepository == null) {
            Object v2;
            block2: {
                List<GitRepository> list = GitRepositoryManager.getInstance(this$0.project).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    GitRepository it = (GitRepository)t;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Intrinsics.areEqual((Object)RepositoryExtKt.repositoryId((Repository)it), (Object)$repositoryId)) continue;
                    v2 = t;
                    break block2;
                }
                v2 = null;
            }
            gitRepository = v2;
        }
        return gitRepository;
    }

    private static final GitRepository get$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (GitRepository)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/repo/GitRepositoryIdCache$Companion;", "", "<init>", "()V", "getInstance", "Lgit4idea/repo/GitRepositoryIdCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRepositoryIdCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryIdCache.kt\ngit4idea/repo/GitRepositoryIdCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,44:1\n30#2,2:45\n*S KotlinDebug\n*F\n+ 1 GitRepositoryIdCache.kt\ngit4idea/repo/GitRepositoryIdCache$Companion\n*L\n42#1:45,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitRepositoryIdCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitRepositoryIdCache> serviceClass$iv = GitRepositoryIdCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitRepositoryIdCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

