/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitTag;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryTagsHolder;
import git4idea.repo.GitRepositoryTagsState;
import git4idea.repo.GitTagsHolderListener;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0007J\b\u0010\u0014\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/repo/GitRepositoryTagsHolderImpl;", "Lgit4idea/repo/GitRepositoryTagsHolder;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "cs", "Lkotlinx/coroutines/CoroutineScope;", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lgit4idea/repo/GitRepositoryTagsState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "updateRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "reload", "loadTagsFromGit", "updateForTests", "TagsLineListener", "LoadedState", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryTagsHolderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryTagsHolderImpl.kt\ngit4idea/repo/GitRepositoryTagsHolderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n13#2:140\n*S KotlinDebug\n*F\n+ 1 GitRepositoryTagsHolderImpl.kt\ngit4idea/repo/GitRepositoryTagsHolderImpl\n*L\n126#1:140\n*E\n"})
public final class GitRepositoryTagsHolderImpl
implements GitRepositoryTagsHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final MutableStateFlow<GitRepositoryTagsState> _state;
    @NotNull
    private final StateFlow<GitRepositoryTagsState> state;
    @NotNull
    private final MutableSharedFlow<Unit> updateRequests;
    @NotNull
    private static final Logger LOG;

    public GitRepositoryTagsHolderImpl(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        CoroutineScope coroutineScope = this.repository.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"GitRepositoryTagsHolder", null, (boolean)false, (int)6, null);
        this._state = StateFlowKt.MutableStateFlow((Object)GitRepositoryTagsState.NotLoaded.INSTANCE);
        this.state = FlowKt.asStateFlow(this._state);
        this.updateRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitRepositoryTagsHolderImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.updateRequests), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ GitRepositoryTagsHolderImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0._state.setValue((Object)this.this$0.loadTagsFromGit());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitRepositoryTagsHolderImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0._state.collect(new FlowCollector(){

                            public final Object emit(GitRepositoryTagsState it, Continuation<? super Unit> $completion) {
                                ((GitTagsHolderListener)this$0.repository.getProject().getMessageBus().syncPublisher(GitRepositoryTagsHolder.Companion.getTAGS_UPDATED())).tagsUpdated(this$0.repository);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public StateFlow<GitRepositoryTagsState> getState() {
        return this.state;
    }

    @Override
    public void reload() {
        this.updateRequests.tryEmit((Object)Unit.INSTANCE);
    }

    @VisibleForTesting
    @NotNull
    public final GitRepositoryTagsState loadTagsFromGit() {
        GitLineHandler handler = new GitLineHandler(this.repository.getProject(), this.repository.getRoot(), GitCommand.FOR_EACH_REF);
        String[] stringArray = new String[]{"refs/tags/**"};
        handler.addParameters(stringArray);
        stringArray = new String[]{"--no-color"};
        handler.addParameters(stringArray);
        stringArray = new String[]{"--format=%(refname)\t%(*objectname)\t%(objectname)"};
        handler.addParameters(stringArray);
        TagsLineListener listener2 = new TagsLineListener();
        handler.addLineListener(listener2);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        return listener2.getTagsState();
    }

    @TestOnly
    @RequiresBackgroundThread
    public final void updateForTests() {
        this._state.setValue((Object)this.loadTagsFromGit());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRepositoryTagsHolderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/repo/GitRepositoryTagsHolderImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003H\u00c6\u0003J;\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lgit4idea/repo/GitRepositoryTagsHolderImpl$LoadedState;", "Lgit4idea/repo/GitRepositoryTagsState;", "tagsToCommitHashes", "", "Lgit4idea/GitTag;", "Lcom/intellij/vcs/log/Hash;", "commitHashesToTags", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getTagsToCommitHashes", "()Ljava/util/Map;", "getCommitHashesToTags", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
    @VisibleForTesting
    public static final class LoadedState
    implements GitRepositoryTagsState {
        @NotNull
        private final Map<GitTag, Hash> tagsToCommitHashes;
        @NotNull
        private final Map<Hash, List<GitTag>> commitHashesToTags;

        public LoadedState(@NotNull Map<GitTag, ? extends Hash> tagsToCommitHashes, @NotNull Map<Hash, ? extends List<GitTag>> commitHashesToTags) {
            Intrinsics.checkNotNullParameter(tagsToCommitHashes, (String)"tagsToCommitHashes");
            Intrinsics.checkNotNullParameter(commitHashesToTags, (String)"commitHashesToTags");
            this.tagsToCommitHashes = tagsToCommitHashes;
            this.commitHashesToTags = commitHashesToTags;
        }

        @Override
        @NotNull
        public Map<GitTag, Hash> getTagsToCommitHashes() {
            return this.tagsToCommitHashes;
        }

        @Override
        @NotNull
        public Map<Hash, List<GitTag>> getCommitHashesToTags() {
            return this.commitHashesToTags;
        }

        @NotNull
        public final Map<GitTag, Hash> component1() {
            return this.tagsToCommitHashes;
        }

        @NotNull
        public final Map<Hash, List<GitTag>> component2() {
            return this.commitHashesToTags;
        }

        @NotNull
        public final LoadedState copy(@NotNull Map<GitTag, ? extends Hash> tagsToCommitHashes, @NotNull Map<Hash, ? extends List<GitTag>> commitHashesToTags) {
            Intrinsics.checkNotNullParameter(tagsToCommitHashes, (String)"tagsToCommitHashes");
            Intrinsics.checkNotNullParameter(commitHashesToTags, (String)"commitHashesToTags");
            return new LoadedState(tagsToCommitHashes, commitHashesToTags);
        }

        public static /* synthetic */ LoadedState copy$default(LoadedState loadedState, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = loadedState.tagsToCommitHashes;
            }
            if ((n & 2) != 0) {
                map3 = loadedState.commitHashesToTags;
            }
            return loadedState.copy(map2, map3);
        }

        @NotNull
        public String toString() {
            return "LoadedState(tagsToCommitHashes=" + this.tagsToCommitHashes + ", commitHashesToTags=" + this.commitHashesToTags + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.tagsToCommitHashes).hashCode();
            result2 = result2 * 31 + ((Object)this.commitHashesToTags).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoadedState)) {
                return false;
            }
            LoadedState loadedState = (LoadedState)other;
            if (!Intrinsics.areEqual(this.tagsToCommitHashes, loadedState.tagsToCommitHashes)) {
                return false;
            }
            return Intrinsics.areEqual(this.commitHashesToTags, loadedState.commitHashesToTags);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/repo/GitRepositoryTagsHolderImpl$TagsLineListener;", "Lgit4idea/commands/GitLineHandlerListener;", "<init>", "()V", "tagsToHashes", "", "Lgit4idea/GitTag;", "Lcom/intellij/vcs/log/Hash;", "hashesToTags", "", "badLineReported", "", "onLineAvailable", "", "line", "", "Lcom/intellij/openapi/util/NlsSafe;", "outputType", "Lcom/intellij/openapi/util/Key;", "addTag", "tagName", "hash", "getTagsState", "Lgit4idea/repo/GitRepositoryTagsState;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRepositoryTagsHolderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryTagsHolderImpl.kt\ngit4idea/repo/GitRepositoryTagsHolderImpl$TagsLineListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,139:1\n1#2:140\n383#3,7:141\n*S KotlinDebug\n*F\n+ 1 GitRepositoryTagsHolderImpl.kt\ngit4idea/repo/GitRepositoryTagsHolderImpl$TagsLineListener\n*L\n112#1:141,7\n*E\n"})
    private static final class TagsLineListener
    implements GitLineHandlerListener {
        @NotNull
        private final Map<GitTag, Hash> tagsToHashes = new LinkedHashMap();
        @NotNull
        private final Map<Hash, List<GitTag>> hashesToTags = new LinkedHashMap();
        private int badLineReported;

        public void onLineAvailable(@NotNull String line, @NotNull Key<?> outputType) {
            block8: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                try {
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDOUT)) {
                        CharSequence charSequence;
                        StringScanner scanner = new StringScanner(line);
                        String string = scanner.tabToken();
                        if (string == null) {
                            return;
                        }
                        String tagName = string;
                        String string2 = scanner.tabToken();
                        if (string2 == null) {
                            return;
                        }
                        String dereferencedHash = string2;
                        String string3 = scanner.line();
                        if (string3 == null) {
                            return;
                        }
                        String tagHash = string3;
                        CharSequence charSequence2 = dereferencedHash;
                        if (StringsKt.isBlank((CharSequence)charSequence2)) {
                            boolean bl = false;
                            charSequence = tagHash;
                        } else {
                            charSequence = charSequence2;
                        }
                        String commitHash = (String)charSequence;
                        this.addTag(tagName, commitHash);
                    }
                }
                catch (VcsException e) {
                    int n = this.badLineReported;
                    this.badLineReported = n + 1;
                    if (this.badLineReported >= 5) break block8;
                    LOG.warn("Unexpected output: " + line, (Throwable)e);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void addTag(String tagName, String hash) {
            Object object;
            void $this$getOrPut$iv;
            GitTag gitTag = new GitTag(tagName);
            Hash hash2 = HashImpl.build((String)hash);
            Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"build(...)");
            Hash hashObj = hash2;
            Map<Hash, List<GitTag>> map2 = this.hashesToTags;
            Hash key$iv = hashObj;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(gitTag);
            this.tagsToHashes.put(gitTag, hashObj);
        }

        @NotNull
        public final GitRepositoryTagsState getTagsState() {
            return new LoadedState(this.tagsToHashes, this.hashesToTags);
        }
    }
}

