/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lgit4idea/actions/branch/GitUpdateSelectedBranchAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "<init>", "()V", "disabledForRemote", "", "getDisabledForRemote", "()Z", "updateIfEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "actionPerformed", "intellij.vcs.git"})
public final class GitUpdateSelectedBranchAction
extends GitSingleBranchAction {
    private final boolean disabledForRemote;

    public GitUpdateSelectedBranchAction() {
        Supplier supplier = GitBundle.messagePointer((String)"branches.update", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        super(supplier);
        this.disabledForRemote = true;
    }

    @Override
    public boolean getDisabledForRemote() {
        return this.disabledForRemote;
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        if (!GitBranchActionsUtilKt.hasAnyRemotes((Collection<? extends GitRepository>)repositories)) {
            $this$updateIfEnabledAndVisible_u24lambda_u240.setEnabledAndVisible(false);
            return;
        }
        String branchName = branch.getName();
        Object[] objectArray = GitVcsSettings.getInstance((Project)project).getUpdateMethod().getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getMethodName(...)");
        Object[] objectArray2 = objectArray;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string = objectArray2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String updateMethod = string;
        objectArray2 = new Object[]{CollectionsKt.listOf((Object)branchName).size(), updateMethod};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message((String)"action.Git.Update.Selected.description", (Object[])objectArray2));
        boolean fetchRunning = GitFetchSupport.fetchSupport(project).isFetchRunning();
        $this$updateIfEnabledAndVisible_u24lambda_u240.setEnabled(!fetchRunning);
        if (fetchRunning) {
            $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message((String)"branches.update.is.already.running", (Object[])new Object[0]));
            return;
        }
        boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(CollectionsKt.listOf((Object)branchName), (Collection<? extends GitRepository>)repositories);
        $this$updateIfEnabledAndVisible_u24lambda_u240.setEnabled(trackingInfosExist);
        if (!trackingInfosExist) {
            Object[] objectArray3 = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(branchName)};
            $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message((String)"branches.tracking.branch.doesn.t.configured.for.s", (Object[])objectArray3));
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        GitBranchActionsUtilKt.updateBranches(project, (Collection<? extends GitRepository>)repositories, CollectionsKt.listOf((Object)branch.getName()));
    }
}

