/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.workingTree;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.vcs.VcsShowToolWindowTabAction;
import git4idea.workingTrees.GitWorkingTreesService;
import git4idea.workingTrees.GitWorkingTreesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/actions/workingTree/ShowWorkingTreesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "shouldShow", "", "actionPerformed", "intellij.vcs.git"})
public final class ShowWorkingTreesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.shouldShow(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean shouldShow(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!GitWorkingTreesUtil.INSTANCE.isWorkingTreesFeatureEnabled()) {
            return false;
        }
        if (ToolWindowManager.Companion.getInstance(project2).getToolWindow("Version Control") == null) {
            return false;
        }
        return GitWorkingTreesService.Companion.getInstance(project2).getSingleRepositoryInProjectRootOrNull() != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GitWorkingTreesService.Companion.getInstance(project2).workingTreesTabOpenedByUser();
        ((ChangesViewContentManagerListener)project2.getMessageBus().syncPublisher(ChangesViewContentManagerListener.TOPIC)).toolWindowMappingChanged();
        VcsShowToolWindowTabAction.Companion.activateVcsTab(project2, "Working Trees", false);
    }
}

