/*
 * Decompiled with CFR 0.152.
 */
package git4idea.applyChanges;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.history.ActivityId;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.notification.Notification;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.GitUtil;
import git4idea.actions.GitAbortOperationAction;
import git4idea.applyChanges.ChangeListGitApplyChangesCommit;
import git4idea.applyChanges.GitApplyChangesCommitStrategy;
import git4idea.applyChanges.GitApplyChangesConflictNotification;
import git4idea.applyChanges.GitApplyChangesConflictResolver;
import git4idea.applyChanges.GitApplyChangesLocalChangesDetectedNotification;
import git4idea.applyChanges.GitApplyChangesNothingToDoNotification;
import git4idea.applyChanges.GitApplyChangesNotificationsHandler;
import git4idea.applyChanges.SimplifiedGitApplyChangesCommit;
import git4idea.applyChanges.StagingAreaGitApplyChangesCommit;
import git4idea.changes.GitChangeUtils;
import git4idea.cherrypick.GitLocalChangesConflictDetector;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineEventDetector;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageManagerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0002\b \u0018\u0000 L2\u00020\u0001:\u0001LB\\\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u0012\u000b\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000b\u0010\u000f\u001a\u00070\b\u00a2\u0006\u0002\b\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010 \u001a\u00020!J \u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J:\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0014J:\u0010+\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0014J6\u0010,\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u00062\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060.2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060.H\u0002J\u0010\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H$J\u0010\u00102\u001a\u00020!2\u0006\u0010%\u001a\u00020&H&J\u001d\u00103\u001a\u00070\b\u00a2\u0006\u0002\b42\u0006\u0010%\u001a\u00020&2\u0006\u00105\u001a\u00020\u0006H$J\u001e\u00106\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H$J,\u00107\u001a\u0002012\u0006\u0010%\u001a\u00020&2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u0006082\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u0005H$J\u0010\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020=H\u0002J)\u0010>\u001a\u00070?\u00a2\u0006\u0002\b\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u0006082\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0002J&\u0010A\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u00105\u001a\u00020\u00062\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0002J.\u0010B\u001a\u00020!2\b\b\u0001\u0010C\u001a\u00020\b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0006082\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0002J(\u0010E\u001a\u00020!2\u0006\u00105\u001a\u00020\u00062\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u0006082\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010F\u001a\u00020\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0003J\u001e\u0010G\u001a\u00020\b2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u0006082\u0006\u0010H\u001a\u00020\u000eH\u0003J\"\u0010I\u001a\u00020\b2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050KH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\b\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lgit4idea/applyChanges/GitApplyChangesProcess;", "", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "appliedWord", "abortCommand", "Lgit4idea/actions/GitAbortOperationAction;", "preserveCommitMetadata", "", "activityName", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lgit4idea/actions/GitAbortOperationAction;ZLjava/lang/String;Lcom/intellij/history/ActivityId;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerEx;", "notificationsHandler", "Lgit4idea/applyChanges/GitApplyChangesNotificationsHandler;", "execute", "", "changesSaver", "Lgit4idea/stash/GitChangesSaver;", "executeForRepository", "repository", "Lgit4idea/repo/GitRepository;", "repoCommits", "successfulCommits", "", "alreadyPicked", "executeForCommitChunk", "handleLocalChangesDetected", "failedOnCommit", "", "isEmptyCommit", "result", "Lgit4idea/commands/GitCommandResult;", "cleanupBeforeCommit", "generateDefaultMessage", "Lorg/jetbrains/annotations/NonNls;", "commit", "findStoppedCommitInSequence", "applyChanges", "", "listeners", "Lgit4idea/commands/GitLineHandlerListener;", "refreshStagedVfs", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "notifyResult", "Lcom/intellij/notification/Notification;", "skipped", "notifyConflictWarning", "notifyError", "content", "failedCommit", "notifyCommitCancelled", "getSuccessfulCommitDetailsIfAny", "formSkippedDescription", "but", "toString", "commitsInRoots", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitApplyChangesProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitApplyChangesProcess.kt\ngit4idea/applyChanges/GitApplyChangesProcess\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,334:1\n30#2,2:335\n126#3:337\n153#3,3:338\n1740#4,3:341\n774#4:345\n865#4,2:346\n1#5:344\n13#6:348\n*S KotlinDebug\n*F\n+ 1 GitApplyChangesProcess.kt\ngit4idea/applyChanges/GitApplyChangesProcess\n*L\n62#1:335,2\n79#1:337\n79#1:338,3\n117#1:341,3\n225#1:345\n225#1:346,2\n314#1:348\n*E\n"})
public abstract class GitApplyChangesProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<VcsCommitMetadata> commits;
    @NotNull
    private final String operationName;
    @NotNull
    private final String appliedWord;
    @NotNull
    private final GitAbortOperationAction abortCommand;
    private final boolean preserveCommitMetadata;
    @NotNull
    private final String activityName;
    @NotNull
    private final ActivityId activityId;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    @NotNull
    private final VcsNotifier vcsNotifier;
    @NotNull
    private final ChangeListManagerEx changeListManager;
    @NotNull
    private final GitApplyChangesNotificationsHandler notificationsHandler;
    @NotNull
    private static final Logger LOG;

    public GitApplyChangesProcess(@NotNull Project project, @NotNull List<? extends VcsCommitMetadata> commits, @NotNull String operationName, @NotNull String appliedWord, @NotNull GitAbortOperationAction abortCommand, boolean preserveCommitMetadata, @NotNull String activityName, @NotNull ActivityId activityId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)appliedWord, (String)"appliedWord");
        Intrinsics.checkNotNullParameter((Object)((Object)abortCommand), (String)"abortCommand");
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        this.project = project;
        this.commits = commits;
        this.operationName = operationName;
        this.appliedWord = appliedWord;
        this.abortCommand = abortCommand;
        this.preserveCommitMetadata = preserveCommitMetadata;
        this.activityName = activityName;
        this.activityId = activityId;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        this.repositoryManager = gitRepositoryManager;
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
        this.vcsNotifier = vcsNotifier;
        ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
        this.changeListManager = changeListManagerEx;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitApplyChangesNotificationsHandler> serviceClass$iv = GitApplyChangesNotificationsHandler.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.notificationsHandler = (GitApplyChangesNotificationsHandler)object;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public final void execute() {
        this.notificationsHandler.beforeApply();
        this.execute(null, this.commits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void execute(GitChangesSaver changesSaver, List<? extends VcsCommitMetadata> commits) {
        if (this.changeListManager.areChangeListsEnabled()) {
            this.changeListManager.waitForUpdate();
        }
        Map map2 = DvcsUtil.groupCommitsByRoots((RepositoryManager)((RepositoryManager)this.repositoryManager), commits);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"groupCommitsByRoots(...)");
        Map commitsInRoots = map2;
        LOG.info(this.operationName + "ing commits: " + this.toString(commitsInRoots));
        if (changesSaver != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map3 = commitsInRoots;
            GitChangesSaver gitChangesSaver = changesSaver;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GitRepository repo = (GitRepository)entry.getKey();
                collection.add(repo.getRoot());
            }
            if (!gitChangesSaver.trySaveLocalChanges((List)destination$iv$iv)) {
                return;
            }
        }
        Set successfulCommits = new LinkedHashSet();
        Set skippedCommits = new LinkedHashSet();
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            GitRepository repository2 = (GitRepository)entry.getKey();
            List repoCommits = (List)entry.getValue();
            try {
                Intrinsics.checkNotNull((Object)repository2);
                Intrinsics.checkNotNull((Object)repoCommits);
                if (this.executeForRepository(repository2, repoCommits, successfulCommits, skippedCommits)) continue;
                this.notificationsHandler.operationFailed(this.operationName, repository2, changesSaver);
                return;
            }
            finally {
                repository2.update();
            }
        }
        this.notifyResult(successfulCommits, skippedCommits);
        if (changesSaver != null) {
            LOG.info("Restoring saved changes after successful " + this.operationName);
            changesSaver.load();
        }
    }

    protected boolean executeForRepository(@NotNull GitRepository repository2, @NotNull List<? extends VcsCommitMetadata> repoCommits, @NotNull Set<VcsCommitMetadata> successfulCommits, @NotNull Set<VcsCommitMetadata> alreadyPicked) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(repoCommits, (String)"repoCommits");
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            Iterable $this$all$iv = repoCommits;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VcsCommitMetadata commit = (VcsCommitMetadata)element$iv;
                    boolean bl2 = false;
                    if (this.executeForCommitChunk(repository2, CollectionsKt.listOf((Object)commit), successfulCommits, alreadyPicked)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeForCommitChunk(@NotNull GitRepository repository2, @NotNull List<? extends VcsCommitMetadata> commits, @NotNull Set<VcsCommitMetadata> successfulCommits, @NotNull Set<VcsCommitMetadata> alreadyPicked) {
        GitApplyChangesCommitStrategy gitApplyChangesCommitStrategy;
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
        Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
        GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.CHERRY_PICK_CONFLICT);
        GitLocalChangesConflictDetector localChangesOverwrittenDetector = new GitLocalChangesConflictDetector();
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(repository2.getRoot());
        VcsCommitMetadata base = (VcsCommitMetadata)CollectionsKt.first(commits);
        String commitMessage = this.generateDefaultMessage(repository2, base);
        if (GitStageManagerKt.isStagingAreaAvailable(this.project)) {
            Project project = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            gitApplyChangesCommitStrategy = new StagingAreaGitApplyChangesCommit(project, commitMessage);
        } else {
            gitApplyChangesCommitStrategy = this.changeListManager.areChangeListsEnabled() && VcsApplicationSettings.getInstance().CREATE_CHANGELISTS_AUTOMATICALLY ? (GitApplyChangesCommitStrategy)new ChangeListGitApplyChangesCommit(repository2, this, base, commitMessage, this.preserveCommitMetadata) : (GitApplyChangesCommitStrategy)new SimplifiedGitApplyChangesCommit(repository2, this, base, commitMessage, this.preserveCommitMetadata);
        }
        GitApplyChangesCommitStrategy strategy = gitApplyChangesCommitStrategy;
        LocalHistoryAction action = LocalHistory.Companion.getInstance().startAction(this.activityName, this.activityId);
        strategy.start();
        try {
            Hash startHash = GitUtil.getHead(repository2);
            Object[] objectArray = new GitLineEventDetector[]{conflictDetector, localChangesOverwrittenDetector, untrackedFilesDetector};
            GitCommandResult result2 = this.applyChanges(repository2, (Collection<? extends VcsCommitMetadata>)commits, CollectionsKt.listOf((Object[])objectArray));
            if (result2.success()) {
                GitUtil.refreshChangedVfs(repository2, startHash);
                successfulCommits.addAll((Collection<VcsCommitMetadata>)commits);
                boolean bl = true;
                return bl;
            }
            VcsCommitMetadata stoppedAtCommit = this.findStoppedCommitInSequence(repository2, commits);
            List<? extends VcsCommitMetadata> toAdd = commits.subList(0, commits.indexOf(stoppedAtCommit));
            successfulCommits.addAll((Collection<VcsCommitMetadata>)toAdd);
            if (conflictDetector.isDetected()) {
                VirtualFile virtualFile = repository2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                String string = ((Hash)stoppedAtCommit.getId()).toShortString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
                String string2 = VcsUserUtil.getShortPresentation((VcsUser)stoppedAtCommit.getAuthor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortPresentation(...)");
                String string3 = stoppedAtCommit.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSubject(...)");
                boolean mergeCompleted = new GitApplyChangesConflictResolver(this.project, virtualFile, string, string2, string3, this.operationName).merge();
                VirtualFile virtualFile2 = repository2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                this.refreshStagedVfs(virtualFile2);
                VcsDirtyScopeManager.getInstance((Project)this.project).rootDirty(repository2.getRoot());
                this.changeListManager.waitForUpdate();
                strategy.afterChangesRefreshed();
                if (mergeCompleted) {
                    LOG.debug("All conflicts resolved, will show commit dialog.");
                    boolean bl = strategy.doUserCommit((Function1<? super VcsCommitMetadata, Unit>)((Function1)new Function1<VcsCommitMetadata, Unit>(successfulCommits){

                        public final void invoke(VcsCommitMetadata p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((Set)this.receiver).add(p0);
                        }
                    }), (Function1<? super VcsCommitMetadata, Unit>)((Function1)new Function1<VcsCommitMetadata, Unit>(alreadyPicked){

                        public final void invoke(VcsCommitMetadata p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((Set)this.receiver).add(p0);
                        }
                    }), (Function1<? super VcsCommitMetadata, Unit>)((Function1)arg_0 -> GitApplyChangesProcess.executeForCommitChunk$lambda$1(successfulCommits, this, arg_0)));
                    return bl;
                }
                this.notifyConflictWarning(repository2, stoppedAtCommit, (Collection<? extends VcsCommitMetadata>)successfulCommits);
                boolean bl = false;
                return bl;
            }
            if (untrackedFilesDetector.isDetected()) {
                String description = this.getSuccessfulCommitDetailsIfAny((Collection<? extends VcsCommitMetadata>)successfulCommits);
                GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.project, repository2.getRoot(), (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), this.operationName, description);
                boolean bl = false;
                return bl;
            }
            if (localChangesOverwrittenDetector.isDetected()) {
                VcsCommitMetadata vcsCommitMetadata;
                VcsCommitMetadata vcsCommitMetadata2 = vcsCommitMetadata = stoppedAtCommit;
                GitRepository gitRepository = repository2;
                GitApplyChangesProcess gitApplyChangesProcess = this;
                boolean bl = false;
                boolean bl2 = localChangesOverwrittenDetector.getByMerge();
                gitApplyChangesProcess.handleLocalChangesDetected(gitRepository, (VcsCommitMetadata)(bl2 ? vcsCommitMetadata : null), successfulCommits, alreadyPicked);
                boolean bl3 = false;
                return bl3;
            }
            if (this.isEmptyCommit(result2)) {
                alreadyPicked.add(stoppedAtCommit);
                boolean bl = true;
                return bl;
            }
            String string = result2.getErrorOutputAsHtmlString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorOutputAsHtmlString(...)");
            this.notifyError(string, (Collection<? extends VcsCommitMetadata>)commits, (Collection<? extends VcsCommitMetadata>)successfulCommits);
            boolean bl = false;
            return bl;
        }
        finally {
            strategy.finish();
            action.finish();
        }
    }

    private final void handleLocalChangesDetected(GitRepository repository2, VcsCommitMetadata failedOnCommit, Set<? extends VcsCommitMetadata> successfulCommits, Set<? extends VcsCommitMetadata> alreadyPicked) {
        GitApplyChangesLocalChangesDetectedNotification notification = new GitApplyChangesLocalChangesDetectedNotification(this.operationName, failedOnCommit, CollectionsKt.toList((Iterable)successfulCommits), repository2, (Function1<? super GitChangesSaver, Unit>)((Function1)arg_0 -> GitApplyChangesProcess.handleLocalChangesDetected$lambda$0(alreadyPicked, successfulCommits, this, arg_0)));
        this.vcsNotifier.notify((Notification)notification);
    }

    protected abstract boolean isEmptyCommit(@NotNull GitCommandResult var1);

    public abstract void cleanupBeforeCommit(@NotNull GitRepository var1);

    @NotNull
    protected abstract String generateDefaultMessage(@NotNull GitRepository var1, @NotNull VcsCommitMetadata var2);

    @NotNull
    protected abstract VcsCommitMetadata findStoppedCommitInSequence(@NotNull GitRepository var1, @NotNull List<? extends VcsCommitMetadata> var2);

    @NotNull
    protected abstract GitCommandResult applyChanges(@NotNull GitRepository var1, @NotNull Collection<? extends VcsCommitMetadata> var2, @NotNull List<? extends GitLineHandlerListener> var3);

    private final void refreshStagedVfs(VirtualFile root) {
        Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges(this.project, root);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getStagedChanges(...)");
        Collection<GitChangeUtils.GitDiffChange> staged2 = collection;
        RefreshVFsSynchronously.refresh$default((RefreshVFsSynchronously)RefreshVFsSynchronously.INSTANCE, staged2, (boolean)false, (int)2, null);
    }

    private final Notification notifyResult(Collection<? extends VcsCommitMetadata> successfulCommits, Collection<? extends VcsCommitMetadata> skipped) {
        Notification notification;
        if (skipped.isEmpty()) {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
            notification = this.vcsNotifier.notifySuccess("git.apply.changes.success", GitBundle.message((String)"apply.changes.operation.successful", (Object[])objectArray), Companion.getCommitsDetails$intellij_vcs_git(successfulCommits));
        } else if (!successfulCommits.isEmpty()) {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.appliedWord), successfulCommits.size(), successfulCommits.size() + skipped.size()};
            String string = GitBundle.message((String)"apply.changes.applied.for.commits", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String description = Companion.getCommitsDetails$intellij_vcs_git(successfulCommits) + "<hr/>" + this.formSkippedDescription(skipped, true);
            notification = this.vcsNotifier.notifySuccess("git.apply.changes.success", title, description);
        } else {
            notification = this.vcsNotifier.notify((Notification)new GitApplyChangesNothingToDoNotification(this.operationName, this.formSkippedDescription(skipped, false)));
        }
        Notification notification2 = notification;
        Intrinsics.checkNotNull((Object)notification2);
        return notification2;
    }

    private final void notifyConflictWarning(GitRepository repository2, VcsCommitMetadata commit, Collection<? extends VcsCommitMetadata> successfulCommits) {
        String description = Companion.commitDetails$intellij_vcs_git(commit) + "<br/>" + GitBundle.message((String)"apply.changes.unresolved.conflicts.text", (Object[])new Object[0]) + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        this.vcsNotifier.notify((Notification)new GitApplyChangesConflictNotification(this.operationName, description, commit, repository2, this.abortCommand));
    }

    private final void notifyError(@Nls String content, Collection<? extends VcsCommitMetadata> failedCommit, Collection<? extends VcsCommitMetadata> successfulCommits) {
        String description = CollectionsKt.joinToString$default((Iterable)failedCommit, null, null, null, (int)0, null, GitApplyChangesProcess::notifyError$lambda$0, (int)31, null) + "<br/>" + content + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
        this.vcsNotifier.notifyError("git.apply.changes.error", GitBundle.message((String)"apply.changes.operation.failed", (Object[])objectArray), description);
    }

    private final void notifyCommitCancelled(VcsCommitMetadata commit, Collection<? extends VcsCommitMetadata> successfulCommits, @Nls String operationName) {
        String description = Companion.commitDetails$intellij_vcs_git(commit) + Companion.getSuccessfulCommitDetailsIfAny$intellij_vcs_git(successfulCommits, operationName);
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)operationName)};
        this.vcsNotifier.notifyMinorWarning("git.commit.cancelled", GitBundle.message((String)"apply.changes.operation.canceled", (Object[])objectArray), description);
    }

    @Nls
    private final String getSuccessfulCommitDetailsIfAny(Collection<? extends VcsCommitMetadata> successfulCommits) {
        return Companion.getSuccessfulCommitDetailsIfAny$intellij_vcs_git(successfulCommits, this.operationName);
    }

    @Nls
    private final String formSkippedDescription(Collection<? extends VcsCommitMetadata> skipped, boolean but) {
        String string;
        String hashes = CollectionsKt.joinToString$default((Iterable)skipped, null, null, null, (int)0, null, GitApplyChangesProcess::formSkippedDescription$lambda$0, (int)31, null);
        if (but) {
            Object[] objectArray = new Object[]{hashes, skipped.size(), this.appliedWord};
            String string2 = GitBundle.message((String)"apply.changes.skipped", (Object[])objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{hashes, this.appliedWord};
            String string3 = GitBundle.message((String)"apply.changes.everything.applied", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final String toString(Map<GitRepository, ? extends List<? extends VcsCommitMetadata>> commitsInRoots) {
        return CollectionsKt.joinToString$default((Iterable)commitsInRoots.entrySet(), (CharSequence)"; ", null, null, (int)0, null, GitApplyChangesProcess::toString$lambda$0, (int)30, null);
    }

    private static final Unit executeForCommitChunk$lambda$1(Set $successfulCommits, GitApplyChangesProcess this$0, VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!((Collection)$successfulCommits).isEmpty()) {
            this$0.notifyCommitCancelled(it, $successfulCommits, this$0.operationName);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit handleLocalChangesDetected$lambda$0(Set $alreadyPicked, Set $successfulCommits, GitApplyChangesProcess this$0, GitChangesSaver saver) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)saver, (String)"saver");
        Set alreadyPickedSet = SetsKt.plus((Set)$alreadyPicked, (Iterable)$successfulCommits);
        LOG.info("Re-trying " + this$0.operationName + ", skipping " + alreadyPickedSet.size() + " already processed commits");
        Iterable iterable = this$0.commits;
        GitChangesSaver gitChangesSaver = saver;
        GitApplyChangesProcess gitApplyChangesProcess = this$0;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsCommitMetadata commit = (VcsCommitMetadata)element$iv$iv;
            boolean bl = false;
            if (!(!alreadyPickedSet.contains(commit))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gitApplyChangesProcess.execute(gitChangesSaver, list);
        return Unit.INSTANCE;
    }

    private static final CharSequence notifyError$lambda$0(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.commitDetails$intellij_vcs_git(it);
    }

    private static final CharSequence formSkippedDescription$lambda$0(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = ((Hash)it.getId()).toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
        return string;
    }

    private static final CharSequence toString$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String commits = CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), null, null, null, (int)0, null, GitApplyChangesProcess::toString$lambda$0$0, (int)31, null);
        return DvcsUtil.getShortRepositoryName((Repository)((Repository)entry.getKey())) + ": [" + commits + "]";
    }

    private static final CharSequence toString$lambda$0$0(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = ((Hash)it.getId()).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitApplyChangesProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0001\u00a2\u0006\u0002\b\tJ#\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\u000eJ\u0017\u0010\u000f\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\b0\fH\u0001\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/applyChanges/GitApplyChangesProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "commitDetails", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitDetails$intellij_vcs_git", "getSuccessfulCommitDetailsIfAny", "successfulCommits", "", "operationName", "getSuccessfulCommitDetailsIfAny$intellij_vcs_git", "getCommitsDetails", "getCommitsDetails$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NlsSafe
        @NotNull
        public final String commitDetails$intellij_vcs_git(@NotNull VcsCommitMetadata $this$commitDetails) {
            Intrinsics.checkNotNullParameter((Object)$this$commitDetails, (String)"<this>");
            return ((Hash)$this$commitDetails.getId()).toShortString() + " " + StringUtil.escapeXmlEntities((String)$this$commitDetails.getSubject());
        }

        @NlsSafe
        @NotNull
        public final String getSuccessfulCommitDetailsIfAny$intellij_vcs_git(@NotNull Collection<? extends VcsCommitMetadata> successfulCommits, @NotNull String operationName) {
            String string;
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
            if (successfulCommits.isEmpty()) {
                string = "";
            } else {
                StringBuilder stringBuilder;
                StringBuilder $this$getSuccessfulCommitDetailsIfAny_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$getSuccessfulCommitDetailsIfAny_u24lambda_u240.append("<hr/>");
                Object[] objectArray = new Object[]{operationName, successfulCommits.size()};
                $this$getSuccessfulCommitDetailsIfAny_u24lambda_u240.append(GitBundle.message((String)"apply.changes.operation.successful.for.commits", (Object[])objectArray));
                $this$getSuccessfulCommitDetailsIfAny_u24lambda_u240.append("<br/>");
                $this$getSuccessfulCommitDetailsIfAny_u24lambda_u240.append(Companion.getCommitsDetails$intellij_vcs_git(successfulCommits));
                string = stringBuilder.toString();
            }
            return string;
        }

        @NlsSafe
        @NotNull
        public final String getCommitsDetails$intellij_vcs_git(@NotNull Collection<? extends VcsCommitMetadata> $this$getCommitsDetails) {
            Intrinsics.checkNotNullParameter($this$getCommitsDetails, (String)"<this>");
            return CollectionsKt.joinToString$default((Iterable)$this$getCommitsDetails, (CharSequence)"<br/>", null, null, (int)0, null, Companion::getCommitsDetails$lambda$0, (int)30, null);
        }

        private static final CharSequence getCommitsDetails$lambda$0(VcsCommitMetadata it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.commitDetails$intellij_vcs_git(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

