/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.DataPackUtilKt;
import git4idea.branch.GitCompareUtilKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 52\u00020\u0001:\u000245B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u001dH\u0007J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J \u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\"\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J \u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J<\u0010'\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0002J4\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u0010 \u001a\u00020!2\b\b\u0001\u00100\u001a\u00020\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/02H\u0082\b\u00a2\u0006\u0002\u00103R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00066"}, d2={"Lgit4idea/branch/DeepComparator;", "", "project", "Lcom/intellij/openapi/project/Project;", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "repositoriesWithTargetBranches", "", "Lgit4idea/repo/GitRepository;", "", "comparedBranch", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/data/DataPack;Ljava/util/Map;Ljava/lang/String;)V", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "collectedNonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "getCollectedNonPickedCommits", "()Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "value", "Lcom/intellij/openapi/vcs/VcsException;", "exception", "getException", "()Lcom/intellij/openapi/vcs/VcsException;", "compare", "Lgit4idea/branch/DeepComparator$ComparatorResult;", "getCommitsByPatch", "Lit/unimi/dsi/fastutil/ints/IntSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetBranch", "sourceBranch", "getCommitsByIndexReliable", "getCommitsByIndexFast", "getCommitsFromGit", "getCommitsFromIndex", "sourceBranchRef", "Lcom/intellij/vcs/log/VcsRef;", "targetBranchRef", "sourceBranchCommits", "reliable", "", "recordSpan", "R", "actionName", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ComparatorResult", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nDeepComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,181:1\n175#1:184\n176#1,2:190\n175#1:200\n176#1,2:206\n175#1:216\n176#1,2:222\n216#2,2:182\n27#3:185\n87#3,2:186\n28#3,2:188\n30#3:192\n98#3:193\n90#3,6:194\n27#3:201\n87#3,2:202\n28#3,2:204\n30#3:208\n98#3:209\n90#3,6:210\n27#3:217\n87#3,2:218\n28#3,2:220\n30#3:224\n98#3:225\n90#3,6:226\n27#3:232\n87#3,2:233\n28#3,3:235\n98#3:238\n90#3,6:239\n106#4:245\n78#4,22:246\n*S KotlinDebug\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator\n*L\n82#1:184\n82#1:190,2\n92#1:200\n92#1:206,2\n104#1:216\n104#1:222,2\n53#1:182,2\n82#1:185\n82#1:186,2\n82#1:188,2\n82#1:192\n82#1:193\n82#1:194,6\n92#1:201\n92#1:202,2\n92#1:204,2\n92#1:208\n92#1:209\n92#1:210,6\n104#1:217\n104#1:218,2\n104#1:220,2\n104#1:224\n104#1:225\n104#1:226,6\n175#1:232\n175#1:233,2\n175#1:235,3\n175#1:238\n175#1:239,6\n128#1:245\n128#1:246,22\n*E\n"})
public final class DeepComparator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogData vcsLogData;
    @Nullable
    private final DataPack dataPack;
    @NotNull
    private final Map<GitRepository, String> repositoriesWithTargetBranches;
    @NotNull
    private final String comparedBranch;
    @NotNull
    private final IntOpenHashSet collectedNonPickedCommits;
    @Nullable
    private VcsException exception;
    @NotNull
    private static final Logger LOG;

    public DeepComparator(@NotNull Project project, @NotNull VcsLogData vcsLogData, @Nullable DataPack dataPack, @NotNull Map<GitRepository, String> repositoriesWithTargetBranches, @NotNull String comparedBranch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        Intrinsics.checkNotNullParameter(repositoriesWithTargetBranches, (String)"repositoriesWithTargetBranches");
        Intrinsics.checkNotNullParameter((Object)comparedBranch, (String)"comparedBranch");
        this.project = project;
        this.vcsLogData = vcsLogData;
        this.dataPack = dataPack;
        this.repositoriesWithTargetBranches = repositoriesWithTargetBranches;
        this.comparedBranch = comparedBranch;
        this.collectedNonPickedCommits = new IntOpenHashSet();
    }

    private final VcsLogStorage getStorage() {
        return this.vcsLogData.getStorage();
    }

    @NotNull
    public final IntOpenHashSet getCollectedNonPickedCommits() {
        return this.collectedNonPickedCommits;
    }

    @Nullable
    public final VcsException getException() {
        return this.exception;
    }

    @RequiresBackgroundThread
    @NotNull
    public final ComparatorResult compare() {
        try {
            Map<GitRepository, String> $this$forEach$iv = this.repositoriesWithTargetBranches;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<GitRepository, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                IntSet intSet;
                Map.Entry<GitRepository, String> element$iv;
                Map.Entry<GitRepository, String> entry = element$iv = iterator.next();
                boolean bl = false;
                GitRepository repo = entry.getKey();
                String targetBranch = entry.getValue();
                if (Registry.Companion.is("git.log.use.index.for.find.picked.commits")) {
                    if (Registry.Companion.is("git.log.fast.find.picked.commits")) {
                        VirtualFile virtualFile = repo.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                        intSet = this.getCommitsByIndexFast(virtualFile, this.comparedBranch, targetBranch);
                        if (intSet == null) {
                            VirtualFile virtualFile2 = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                            intSet = this.getCommitsByIndexReliable(virtualFile2, this.comparedBranch, targetBranch);
                        }
                    } else {
                        VirtualFile virtualFile = repo.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                        intSet = this.getCommitsByIndexReliable(virtualFile, this.comparedBranch, targetBranch);
                    }
                } else {
                    VirtualFile virtualFile = repo.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    intSet = this.getCommitsByPatch(virtualFile, this.comparedBranch, targetBranch);
                }
                IntSet commits = intSet;
                this.collectedNonPickedCommits.addAll((IntCollection)commits);
            }
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            this.exception = e;
        }
        return new ComparatorResult((IntSet)this.collectedNonPickedCommits, this.exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IntSet getCommitsByPatch(VirtualFile root, String targetBranch, String sourceBranch) throws VcsException {
        IntSet intSet;
        DeepComparator deepComparator = this;
        VirtualFile virtualFile = root;
        String actionName$iv = "Getting non picked commits with git";
        boolean $i$f$recordSpan = false;
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            IntSet intSet2;
            Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                void root$iv;
                Scope it$iv$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span$iv = span$iv$iv;
                boolean bl3 = false;
                span$iv.setAttribute("rootName", root$iv.getName());
                boolean bl4 = false;
                intSet2 = this.getCommitsFromGit(root, targetBranch, sourceBranch);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            intSet = intSet2;
        }
        catch (CancellationException e$iv$iv$iv) {
            throw e$iv$iv$iv;
        }
        catch (Throwable e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv$iv.end();
        }
        return intSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IntSet getCommitsByIndexReliable(VirtualFile root, String sourceBranch, String targetBranch) throws VcsException {
        IntSet intSet;
        IntSet resultFromGit = this.getCommitsByPatch(root, targetBranch, sourceBranch);
        if (this.dataPack == null || !this.dataPack.isFull()) {
            return resultFromGit;
        }
        DeepComparator deepComparator = this;
        VirtualFile virtualFile = root;
        String actionName$iv = "Getting non picked commits with index reliable";
        boolean $i$f$recordSpan = false;
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            IntSet intSet2;
            Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                IntSet intSet3;
                void root$iv;
                Scope it$iv$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span$iv = span$iv$iv;
                boolean bl3 = false;
                span$iv.setAttribute("rootName", root$iv.getName());
                boolean bl4 = false;
                RefsModel refsModel = this.dataPack.getRefsModel();
                Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
                VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root);
                if (vcsRef == null) {
                    intSet3 = resultFromGit;
                } else {
                    VcsRef sourceBranchRef = vcsRef;
                    RefsModel refsModel2 = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"getRefsModel(...)");
                    VcsRef vcsRef2 = DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)targetBranch, (VirtualFile)root);
                    if (vcsRef2 == null) {
                        intSet3 = resultFromGit;
                    } else {
                        VcsRef targetBranchRef = vcsRef2;
                        intSet3 = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, resultFromGit, true);
                    }
                }
                intSet2 = intSet3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            intSet = intSet2;
        }
        catch (CancellationException e$iv$iv$iv) {
            throw e$iv$iv$iv;
        }
        catch (Throwable e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv$iv.end();
        }
        IntSet resultFromIndex = intSet;
        IntSet intSet4 = resultFromIndex;
        if (intSet4 == null) {
            intSet4 = resultFromGit;
        }
        return intSet4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IntSet getCommitsByIndexFast(VirtualFile root, String sourceBranch, String targetBranch) {
        IntSet intSet;
        if (!this.vcsLogData.getIndex().isIndexed(root) || this.dataPack == null || !this.dataPack.isFull()) {
            return null;
        }
        DeepComparator deepComparator = this;
        VirtualFile virtualFile = root;
        String actionName$iv = "Getting non picked commits with index fast";
        boolean $i$f$recordSpan = false;
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            IntSet intSet2;
            Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                IntSet intSet3;
                void root$iv;
                Scope it$iv$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span$iv = span$iv$iv;
                boolean bl3 = false;
                span$iv.setAttribute("rootName", root$iv.getName());
                boolean bl4 = false;
                RefsModel refsModel = this.dataPack.getRefsModel();
                Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
                VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root);
                if (vcsRef == null) {
                    intSet3 = null;
                } else {
                    VcsRef sourceBranchRef = vcsRef;
                    RefsModel refsModel2 = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"getRefsModel(...)");
                    VcsRef vcsRef2 = DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)targetBranch, (VirtualFile)root);
                    if (vcsRef2 == null) {
                        intSet3 = null;
                    } else {
                        VcsRef targetBranchRef = vcsRef2;
                        IntSet intSet4 = DataPackUtilKt.subgraphDifference((DataPack)this.dataPack, (VcsRef)sourceBranchRef, (VcsRef)targetBranchRef, (VcsLogStorage)this.getStorage());
                        if (intSet4 == null) {
                            intSet3 = null;
                        } else {
                            IntSet sourceBranchCommits = intSet4;
                            intSet3 = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, sourceBranchCommits, false);
                        }
                    }
                }
                intSet2 = intSet3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            intSet = intSet2;
        }
        catch (CancellationException e$iv$iv$iv) {
            throw e$iv$iv$iv;
        }
        catch (Throwable e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv$iv.end();
        }
        return intSet;
    }

    private final IntSet getCommitsFromGit(VirtualFile root, String targetBranch, String comparedBranch) throws VcsException {
        GitLineHandler handler = new GitLineHandler(this.project, root, GitCommand.CHERRY);
        String[] stringArray = new String[]{targetBranch, comparedBranch};
        handler.addParameters(stringArray);
        IntOpenHashSet pickedCommits = new IntOpenHashSet();
        handler.addLineListener((arg_0, arg_1) -> DeepComparator.getCommitsFromGit$lambda$0(pickedCommits, this, root, arg_0, arg_1));
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        return (IntSet)pickedCommits;
    }

    private final IntSet getCommitsFromIndex(DataPack dataPack, VirtualFile root, VcsRef sourceBranchRef, VcsRef targetBranchRef, IntSet sourceBranchCommits, boolean reliable) {
        if (dataPack == null) {
            return null;
        }
        if (sourceBranchCommits.isEmpty()) {
            return sourceBranchCommits;
        }
        if (!this.vcsLogData.getIndex().isIndexed(root)) {
            return null;
        }
        IndexDataGetter indexDataGetter = this.vcsLogData.getIndex().getDataGetter();
        if (indexDataGetter == null) {
            return null;
        }
        IndexDataGetter dataGetter = indexDataGetter;
        IntSet intSet = DataPackUtilKt.subgraphDifference((DataPack)dataPack, (VcsRef)targetBranchRef, (VcsRef)sourceBranchRef, (VcsLogStorage)this.getStorage());
        if (intSet == null) {
            return null;
        }
        IntSet targetBranchCommits = intSet;
        if (targetBranchCommits.isEmpty()) {
            return sourceBranchCommits;
        }
        IntSet match = GitCompareUtilKt.match(dataGetter, root, sourceBranchCommits, targetBranchCommits, reliable);
        sourceBranchCommits.removeAll((IntCollection)match);
        if (!match.isEmpty()) {
            LOG.debug("Using index, detected " + match.size() + " commits in " + sourceBranchRef.getName() + "#" + root.getName() + " that were picked to the target branch" + (reliable ? " with different patch id but matching cherry-picked suffix" : " with matching author, author time and message"));
        }
        return sourceBranchCommits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R recordSpan(VirtualFile root, @NonNls String actionName, Function0<? extends R> block) {
        Object object;
        boolean $i$f$recordSpan = false;
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Object object2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span2 = span$iv;
                boolean bl3 = false;
                span2.setAttribute("rootName", root.getName());
                object2 = block.invoke();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$useWithoutActiveScope$iv$iv.end();
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getCommitsFromGit$lambda$0(IntOpenHashSet $pickedCommits, DeepComparator this$0, VirtualFile $root, String l, Key key) {
        String line;
        String string = line = l;
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
            try {
                int firstSpace;
                void $this$trim$iv;
                string = line;
                Intrinsics.checkNotNull((Object)string);
                int n = 2;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((firstSpace = StringsKt.indexOf$default((CharSequence)(line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)' ', (int)0, (boolean)false, (int)6, null)) > 0) {
                    String string3 = line.substring(0, firstSpace);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    line = string3;
                }
                VcsLogStorage vcsLogStorage = this$0.getStorage();
                Hash hash = HashImpl.build((String)line);
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(...)");
                $pickedCommits.add(vcsLogStorage.getCommitIndex(hash, $root));
            }
            catch (Exception e) {
                LOG.error("Couldn't parse line [" + line + "]", (Throwable)e);
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(DeepComparator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/branch/DeepComparator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lgit4idea/branch/DeepComparator$ComparatorResult;", "", "nonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "<init>", "(Lit/unimi/dsi/fastutil/ints/IntSet;Lcom/intellij/openapi/vcs/VcsException;)V", "getNonPickedCommits", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "getException", "()Lcom/intellij/openapi/vcs/VcsException;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    public static final class ComparatorResult {
        @NotNull
        private final IntSet nonPickedCommits;
        @Nullable
        private final VcsException exception;

        public ComparatorResult(@NotNull IntSet nonPickedCommits, @Nullable VcsException exception) {
            Intrinsics.checkNotNullParameter((Object)nonPickedCommits, (String)"nonPickedCommits");
            this.nonPickedCommits = nonPickedCommits;
            this.exception = exception;
        }

        @NotNull
        public final IntSet getNonPickedCommits() {
            return this.nonPickedCommits;
        }

        @Nullable
        public final VcsException getException() {
            return this.exception;
        }

        @NotNull
        public final IntSet component1() {
            return this.nonPickedCommits;
        }

        @Nullable
        public final VcsException component2() {
            return this.exception;
        }

        @NotNull
        public final ComparatorResult copy(@NotNull IntSet nonPickedCommits, @Nullable VcsException exception) {
            Intrinsics.checkNotNullParameter((Object)nonPickedCommits, (String)"nonPickedCommits");
            return new ComparatorResult(nonPickedCommits, exception);
        }

        public static /* synthetic */ ComparatorResult copy$default(ComparatorResult comparatorResult, IntSet intSet, VcsException vcsException, int n, Object object) {
            if ((n & 1) != 0) {
                intSet = comparatorResult.nonPickedCommits;
            }
            if ((n & 2) != 0) {
                vcsException = comparatorResult.exception;
            }
            return comparatorResult.copy(intSet, vcsException);
        }

        @NotNull
        public String toString() {
            return "ComparatorResult(nonPickedCommits=" + this.nonPickedCommits + ", exception=" + this.exception + ")";
        }

        public int hashCode() {
            int result2 = this.nonPickedCommits.hashCode();
            result2 = result2 * 31 + (this.exception == null ? 0 : this.exception.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComparatorResult)) {
                return false;
            }
            ComparatorResult comparatorResult = (ComparatorResult)other;
            if (!Intrinsics.areEqual((Object)this.nonPickedCommits, (Object)comparatorResult.nonPickedCommits)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.exception), (Object)((Object)comparatorResult.exception));
        }
    }
}

