/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchHunkUtil;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import git4idea.changes.GitBranchComparisonResultImplKt;
import git4idea.changes.GitFileHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 +2\u00020\u0001:\u0002*+B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J%\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J2\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0018J<\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0002J<\u0010!\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0002J&\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lgit4idea/changes/GitTextFilePatchWithHistory;", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "isCumulative", "", "fileHistory", "Lgit4idea/changes/GitFileHistory;", "<init>", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;ZLgit4idea/changes/GitFileHistory;)V", "getPatch", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "()Z", "getFileHistory", "()Lgit4idea/changes/GitFileHistory;", "contains", "commitSha", "", "filePath", "forcefullyMapLine", "", "fromCommitSha", "lineIndex", "side", "Lcom/intellij/diff/util/Side;", "(Ljava/lang/String;ILcom/intellij/diff/util/Side;)Ljava/lang/Integer;", "mapLine", "Lkotlin/Pair;", "Lcom/intellij/collaboration/ui/codereview/diff/DiffLineLocation;", "bias", "transferToParent", "beforeSha", "afterSha", "transferToChild", "transferLine", "Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult;", "patchChain", "", "rightToLeft", "reverseRange", "Lcom/intellij/diff/util/Range;", "range", "TransferResult", "Companion", "intellij.vcs.git"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGitTextFilePatchWithHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitTextFilePatchWithHistory.kt\ngit4idea/changes/GitTextFilePatchWithHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,205:1\n1563#2:206\n1634#2,2:207\n1563#2:209\n1634#2,3:210\n1636#2:213\n13#3:214\n*S KotlinDebug\n*F\n+ 1 GitTextFilePatchWithHistory.kt\ngit4idea/changes/GitTextFilePatchWithHistory\n*L\n151#1:206\n151#1:207,2\n153#1:209\n153#1:210,3\n151#1:213\n203#1:214\n*E\n"})
public final class GitTextFilePatchWithHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextFilePatch patch;
    private final boolean isCumulative;
    @NotNull
    private final GitFileHistory fileHistory;
    @NotNull
    private static final Logger LOG;

    public GitTextFilePatchWithHistory(@NotNull TextFilePatch patch, boolean isCumulative, @NotNull GitFileHistory fileHistory) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)fileHistory, (String)"fileHistory");
        this.patch = patch;
        this.isCumulative = isCumulative;
        this.fileHistory = fileHistory;
    }

    @NotNull
    public final TextFilePatch getPatch() {
        return this.patch;
    }

    public final boolean isCumulative() {
        return this.isCumulative;
    }

    @NotNull
    public final GitFileHistory getFileHistory() {
        return this.fileHistory;
    }

    public final boolean contains(@NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.fileHistory.contains(commitSha, filePath);
    }

    @Nullable
    public final Integer forcefullyMapLine(@NotNull String fromCommitSha, int lineIndex, @NotNull Side side) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fromCommitSha, (String)"fromCommitSha");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (this.isCumulative) {
            String string2 = this.fileHistory.findStartCommit();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            String string3 = this.patch.getBeforeVersionId();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        String beforeSha = string;
        String string4 = this.patch.getAfterVersionId();
        Intrinsics.checkNotNull((Object)string4);
        String afterSha = string4;
        if (Intrinsics.areEqual((Object)fromCommitSha, (Object)beforeSha) && side == Side.LEFT) {
            return lineIndex;
        }
        if (Intrinsics.areEqual((Object)fromCommitSha, (Object)afterSha) && side == Side.RIGHT) {
            return lineIndex;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> {
                List<TextFilePatch> patches = this.fileHistory.getPatchesBetween(beforeSha, fromCommitSha);
                yield this.transferLine(patches, lineIndex, true).getLine();
            }
            case 2 -> {
                List<TextFilePatch> patches = this.fileHistory.getPatchesBetween(fromCommitSha, afterSha);
                yield this.transferLine(patches, lineIndex, false).getLine();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final Pair<Side, Integer> mapLine(@NotNull String fromCommitSha, int lineIndex, @NotNull Side bias) {
        Pair<Side, Integer> pair;
        String string;
        Intrinsics.checkNotNullParameter((Object)fromCommitSha, (String)"fromCommitSha");
        Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
        if (this.isCumulative) {
            String string2 = this.fileHistory.findStartCommit();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            String string3 = this.patch.getBeforeVersionId();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        String beforeSha = string;
        String string4 = this.patch.getAfterVersionId();
        Intrinsics.checkNotNull((Object)string4);
        String afterSha = string4;
        if (Intrinsics.areEqual((Object)fromCommitSha, (Object)beforeSha)) {
            return new Pair((Object)Side.LEFT, (Object)lineIndex);
        }
        if (Intrinsics.areEqual((Object)fromCommitSha, (Object)afterSha)) {
            return new Pair((Object)Side.RIGHT, (Object)lineIndex);
        }
        if (!this.fileHistory.contains(fromCommitSha, GitBranchComparisonResultImplKt.getFilePath((FilePatch)this.patch))) {
            return null;
        }
        try {
            Pair<Side, Integer> pair2;
            switch (WhenMappings.$EnumSwitchMapping$0[bias.ordinal()]) {
                case 1: {
                    pair2 = this.transferToParent(lineIndex, beforeSha, fromCommitSha, afterSha);
                    if (pair2 != null) break;
                    pair2 = this.transferToChild(lineIndex, beforeSha, fromCommitSha, afterSha);
                    break;
                }
                case 2: {
                    pair2 = this.transferToChild(lineIndex, beforeSha, fromCommitSha, afterSha);
                    if (pair2 != null) break;
                    pair2 = this.transferToParent(lineIndex, beforeSha, fromCommitSha, afterSha);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            pair = pair2;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            pair = null;
        }
        return pair;
    }

    private final Pair<Side, Integer> transferToParent(int lineIndex, String beforeSha, String fromCommitSha, String afterSha) {
        Pair pair;
        if (this.fileHistory.compare(afterSha, fromCommitSha) < 0) {
            List<TextFilePatch> patches = this.fileHistory.getPatchesBetween(afterSha, fromCommitSha);
            Integer n = this.transferLine(patches, lineIndex, true).exactLocation();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                pair = TuplesKt.to((Object)Side.RIGHT, (Object)it);
            } else {
                pair = null;
            }
        } else if (this.fileHistory.compare(beforeSha, fromCommitSha) < 0) {
            List<TextFilePatch> patches = this.fileHistory.getPatchesBetween(beforeSha, fromCommitSha);
            Integer n = this.transferLine(patches, lineIndex, true).exactLocation();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                pair = TuplesKt.to((Object)Side.LEFT, (Object)it);
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    private final Pair<Side, Integer> transferToChild(int lineIndex, String beforeSha, String fromCommitSha, String afterSha) {
        Pair pair;
        if (this.fileHistory.compare(fromCommitSha, beforeSha) < 0) {
            List<TextFilePatch> patches = this.fileHistory.getPatchesBetween(fromCommitSha, beforeSha);
            Integer n = this.transferLine(patches, lineIndex, false).exactLocation();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                pair = TuplesKt.to((Object)Side.LEFT, (Object)it);
            } else {
                pair = null;
            }
        } else if (this.fileHistory.compare(fromCommitSha, afterSha) < 0) {
            List<TextFilePatch> patches = this.fileHistory.getPatchesBetween(fromCommitSha, afterSha);
            Integer n = this.transferLine(patches, lineIndex, false).exactLocation();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                pair = TuplesKt.to((Object)Side.RIGHT, (Object)it);
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final TransferResult transferLine(List<? extends TextFilePatch> patchChain, int lineIndex, boolean rightToLeft) {
        TransferResult transferResult;
        double currentLine = lineIndex;
        boolean isEstimate = false;
        List patches = rightToLeft ? CollectionsKt.asReversed(patchChain) : patchChain;
        for (TextFilePatch patch : patches) {
            void $this$mapTo$iv$iv;
            List list = patch.getHunks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHunks(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list2;
                void hunk;
                PatchHunk patchHunk = (PatchHunk)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)hunk);
                List ranges = PatchHunkUtil.INSTANCE.getChangeOnlyRanges((PatchHunk)hunk);
                if (rightToLeft) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = ranges;
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Range range = (Range)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(this.reverseRange((Range)it));
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = ranges;
                }
                collection.add(list2);
            }
            List changeOnlyRanges = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            double offset = 0.0;
            for (Range range : changeOnlyRanges) {
                if (currentLine < (double)range.start1) break;
                if ((double)range.start1 <= currentLine && currentLine < (double)range.end1) {
                    isEstimate = true;
                    double relativePosition = (currentLine - (double)range.start1 + 1.0) / (double)(range.end1 - range.start1 + 1);
                    offset -= currentLine - (double)range.start1;
                    offset += relativePosition * (double)(range.end2 - range.start2);
                    continue;
                }
                if (!((double)range.end1 <= currentLine)) continue;
                offset += (double)(range.end2 - range.start2 - (range.end1 - range.start1));
            }
            currentLine += offset;
        }
        boolean bl = isEstimate;
        if (!bl) {
            transferResult = new TransferResult.ExactTransfer((int)Math.floor(currentLine));
        } else if (bl) {
            transferResult = new TransferResult.EstimatedTransfer((int)Math.floor(currentLine));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return transferResult;
    }

    private final Range reverseRange(Range range) {
        return new Range(range.start2, range.end2, range.start1, range.end1);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitTextFilePatchWithHistory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/changes/GitTextFilePatchWithHistory$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0007\bJ\u000f\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult;", "", "line", "", "getLine", "()Ljava/lang/Integer;", "exactLocation", "ExactTransfer", "EstimatedTransfer", "Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult$EstimatedTransfer;", "Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult$ExactTransfer;", "intellij.vcs.git"})
    private static sealed interface TransferResult {
        @Nullable
        public Integer getLine();

        @Nullable
        default public Integer exactLocation() {
            ExactTransfer exactTransfer = this instanceof ExactTransfer ? (ExactTransfer)this : null;
            return exactTransfer != null ? exactTransfer.getLine() : null;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult$EstimatedTransfer;", "Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult;", "line", "", "<init>", "(I)V", "getLine", "()Ljava/lang/Integer;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.vcs.git"})
        public static final class EstimatedTransfer
        implements TransferResult {
            private final int line;

            public EstimatedTransfer(int line) {
                this.line = line;
            }

            @Override
            @NotNull
            public Integer getLine() {
                return this.line;
            }

            public final int component1() {
                return this.line;
            }

            @NotNull
            public final EstimatedTransfer copy(int line) {
                return new EstimatedTransfer(line);
            }

            public static /* synthetic */ EstimatedTransfer copy$default(EstimatedTransfer estimatedTransfer, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = estimatedTransfer.line;
                }
                return estimatedTransfer.copy(n);
            }

            @NotNull
            public String toString() {
                return "EstimatedTransfer(line=" + this.line + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.line);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EstimatedTransfer)) {
                    return false;
                }
                EstimatedTransfer estimatedTransfer = (EstimatedTransfer)other;
                return this.line == estimatedTransfer.line;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult$ExactTransfer;", "Lgit4idea/changes/GitTextFilePatchWithHistory$TransferResult;", "line", "", "<init>", "(I)V", "getLine", "()Ljava/lang/Integer;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.vcs.git"})
        public static final class ExactTransfer
        implements TransferResult {
            private final int line;

            public ExactTransfer(int line) {
                this.line = line;
            }

            @Override
            @NotNull
            public Integer getLine() {
                return this.line;
            }

            public final int component1() {
                return this.line;
            }

            @NotNull
            public final ExactTransfer copy(int line) {
                return new ExactTransfer(line);
            }

            public static /* synthetic */ ExactTransfer copy$default(ExactTransfer exactTransfer, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = exactTransfer.line;
                }
                return exactTransfer.copy(n);
            }

            @NotNull
            public String toString() {
                return "ExactTransfer(line=" + this.line + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.line);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExactTransfer)) {
                    return false;
                }
                ExactTransfer exactTransfer = (ExactTransfer)other;
                return this.line == exactTransfer.line;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

