/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import git4idea.changes.GitFileHistory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\""}, d2={"Lgit4idea/changes/MutableLinearGitFileHistory;", "Lgit4idea/changes/GitFileHistory;", "commitHashes", "", "", "<init>", "(Ljava/util/List;)V", "history", "", "Lgit4idea/changes/MutableLinearGitFileHistory$Entry;", "firstKnownFilePath", "getFirstKnownFilePath", "()Ljava/lang/String;", "lastKnownFilePath", "getLastKnownFilePath", "findStartCommit", "findFirstParent", "commitSha", "append", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "filePath", "contains", "", "compare", "", "commitSha1", "commitSha2", "getPatchesBetween", "parent", "child", "Entry", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nMutableLinearGitFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableLinearGitFileHistory.kt\ngit4idea/changes/MutableLinearGitFileHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class MutableLinearGitFileHistory
implements GitFileHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> commitHashes;
    @NotNull
    private final Map<String, Entry> history;

    public MutableLinearGitFileHistory(@NotNull List<String> commitHashes) {
        Intrinsics.checkNotNullParameter(commitHashes, (String)"commitHashes");
        this.commitHashes = commitHashes;
        this.history = new LinkedHashMap();
        for (String sha : this.commitHashes) {
            this.history.put(sha, new Entry(null, null, 2, null));
        }
    }

    private final String getFirstKnownFilePath() {
        Entry entry;
        Object v0;
        block2: {
            Iterable iterable = this.history.values();
            for (Object t : iterable) {
                Entry it = (Entry)t;
                boolean bl = false;
                if (!(it.getPatch() != null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((entry = (Entry)v0) == null || (entry = entry.getPatch()) == null) {
            throw new IllegalStateException("Empty history".toString());
        }
        return entry.getBeforeName();
    }

    @Nullable
    public final String getLastKnownFilePath() {
        Iterable iterable = this.history.values();
        Object var3_2 = null;
        for (Object t : iterable) {
            Entry it = (Entry)t;
            boolean bl = false;
            if (!(it.getPatch() != null)) continue;
            var3_2 = t;
        }
        Entry entry = var3_2;
        if (entry == null || (entry = entry.getPatch()) == null) {
            throw new IllegalStateException("Empty history".toString());
        }
        String lastFilePath = entry.getAfterName();
        String string = lastFilePath;
        if (string == null) {
            string = this.getFirstKnownFilePath();
        }
        return string;
    }

    @Override
    @Nullable
    public String findStartCommit() {
        return (String)CollectionsKt.firstOrNull(this.commitHashes);
    }

    @Override
    @Nullable
    public String findFirstParent(@NotNull String commitSha) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        String parentSha = null;
        for (String commitHash : this.commitHashes) {
            if (Intrinsics.areEqual((Object)commitSha, (Object)commitHash)) break;
            parentSha = commitHash;
        }
        return parentSha;
    }

    public final void append(@NotNull String commitSha, @NotNull TextFilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Entry entry = this.history.get(commitSha);
        if (!(entry != null)) {
            boolean $i$a$-check-MutableLinearGitFileHistory$append$32 = false;
            String $i$a$-check-MutableLinearGitFileHistory$append$32 = "Adding entry for an unknown commit " + commitSha + ". Known commits - " + this.commitHashes;
            throw new IllegalStateException($i$a$-check-MutableLinearGitFileHistory$append$32.toString());
        }
        if (!(entry.getPatch() == null)) {
            boolean bl = false;
            TextFilePatch textFilePatch = entry.getPatch();
            String string = "Entry patch was already recorded for commit " + commitSha + ". Existing patch - " + (textFilePatch != null ? MutableLinearGitFileHistory.Companion.getHeaderString(textFilePatch) : null) + ". New patch - " + MutableLinearGitFileHistory.Companion.getHeaderString(patch);
            throw new IllegalStateException(string.toString());
        }
        this.history.put(commitSha, new Entry(patch, null, 2, null));
    }

    public final void append(@NotNull String commitSha, @Nullable String filePath) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Entry entry = this.history.get(commitSha);
        if (!(entry != null)) {
            boolean bl = false;
            String string = "Adding entry for an unknown commit " + commitSha + ". Known commits - " + this.commitHashes;
            throw new IllegalStateException(string.toString());
        }
        this.history.put(commitSha, new Entry(null, filePath));
    }

    @Override
    public boolean contains(@NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String lastPath = null;
        for (Map.Entry<String, Entry> entry : this.history.entrySet()) {
            String sha = entry.getKey();
            Entry entry2 = entry.getValue();
            String entryPath = entry2.getFilePath();
            if (entryPath != null) {
                lastPath = entryPath;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha) || !Intrinsics.areEqual((Object)lastPath, (Object)filePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(@NotNull String commitSha1, @NotNull String commitSha2) {
        Intrinsics.checkNotNullParameter((Object)commitSha1, (String)"commitSha1");
        Intrinsics.checkNotNullParameter((Object)commitSha2, (String)"commitSha2");
        if (Intrinsics.areEqual((Object)commitSha1, (Object)commitSha2)) {
            return 0;
        }
        Iterator<Map.Entry<String, Entry>> iterator = this.history.entrySet().iterator();
        while (iterator.hasNext()) {
            String sha = iterator.next().getKey();
            if (Intrinsics.areEqual((Object)sha, (Object)commitSha1)) {
                return -1;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha2)) continue;
            return 1;
        }
        throw new IllegalStateException("Unknown commit sha".toString());
    }

    @Override
    @NotNull
    public List<TextFilePatch> getPatchesBetween(@NotNull String parent, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        List patches = new ArrayList();
        boolean foundParent = false;
        for (Map.Entry<String, Entry> entry : this.history.entrySet()) {
            String sha = entry.getKey();
            Entry entry2 = entry.getValue();
            if (!foundParent) {
                if (!Intrinsics.areEqual((Object)sha, (Object)parent)) continue;
                foundParent = true;
                continue;
            }
            if (entry2.getPatch() != null) {
                TextFilePatch it;
                boolean bl = false;
                patches.add(it);
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)child)) continue;
            break;
        }
        return patches;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0005*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lgit4idea/changes/MutableLinearGitFileHistory$Companion;", "", "<init>", "()V", "filePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)Ljava/lang/String;", "headerString", "getHeaderString", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final String getFilePath(TextFilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private final String getHeaderString(TextFilePatch $this$headerString) {
            return $this$headerString.getBeforeVersionId() + " " + $this$headerString.getBeforeName() + " -> " + $this$headerString.getAfterVersionId() + " " + $this$headerString.getAfterName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lgit4idea/changes/MutableLinearGitFileHistory$Entry;", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "filePath", "", "<init>", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Ljava/lang/String;)V", "getPatch", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class Entry {
        @Nullable
        private final TextFilePatch patch;
        @Nullable
        private final String filePath;

        public Entry(@Nullable TextFilePatch patch, @Nullable String filePath) {
            this.patch = patch;
            this.filePath = filePath;
        }

        public /* synthetic */ Entry(TextFilePatch textFilePatch, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                TextFilePatch textFilePatch2 = textFilePatch;
                string = textFilePatch2 != null ? Companion.getFilePath(textFilePatch2) : null;
            }
            this(textFilePatch, string);
        }

        @Nullable
        public final TextFilePatch getPatch() {
            return this.patch;
        }

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final TextFilePatch component1() {
            return this.patch;
        }

        @Nullable
        public final String component2() {
            return this.filePath;
        }

        @NotNull
        public final Entry copy(@Nullable TextFilePatch patch, @Nullable String filePath) {
            return new Entry(patch, filePath);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, TextFilePatch textFilePatch, String string, int n, Object object) {
            if ((n & 1) != 0) {
                textFilePatch = entry.patch;
            }
            if ((n & 2) != 0) {
                string = entry.filePath;
            }
            return entry.copy(textFilePatch, string);
        }

        @NotNull
        public String toString() {
            return "Entry(patch=" + this.patch + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            int result2 = this.patch == null ? 0 : this.patch.hashCode();
            result2 = result2 * 31 + (this.filePath == null ? 0 : this.filePath.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.patch, (Object)entry.patch)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePath, (Object)entry.filePath);
        }
    }
}

