/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.checkin.GitStagingAreaStateManager;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0000\u0018\u0000 82\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!H\u0002J\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!H\u0002J&\u0010%\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!H\u0002J\b\u0010&\u001a\u00020\u0015H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u001f2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020*H\u0002J \u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0002J#\u00102\u001a\u00070\u001f\u00a2\u0006\u0002\b32\u0006\u00104\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c06H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager;", "Lgit4idea/checkin/GitStagingAreaStateManager;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "savedStagedChanges", "", "Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange$Staged;", "prepareStagingArea", "", "toAdd", "", "Lcom/intellij/openapi/vcs/FilePath;", "toRemove", "restore", "listStagedChanges", "Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange;", "parseStatusLinePorcelainV2", "line", "", "result", "", "parseUnmerged", "s", "Lgit4idea/util/StringScanner;", "parseOrdinary", "resetExcluded", "createUpdateIndexLine", "change", "toHead", "", "resolveMode", "isSubmodule", "isExecutable", "formatIndexInfo", "mode", "hash", "relativePath", "getStagedLogString", "Lorg/jetbrains/annotations/NonNls;", "rootPath", "changes", "", "StagedChange", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIndexInfoStagingAreaStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexInfoStagingAreaStateManager.kt\ngit4idea/checkin/GitIndexInfoStagingAreaStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n808#2,11:237\n808#2,11:248\n774#2:264\n865#2,2:265\n1617#2,9:267\n1869#2:276\n1870#2:278\n1626#2:279\n1617#2,9:290\n1869#2:299\n1870#2:301\n1626#2:302\n60#3,5:259\n60#3,5:280\n60#3,5:285\n60#3,5:303\n13#3:308\n1#4:277\n1#4:300\n*S KotlinDebug\n*F\n+ 1 GitIndexInfoStagingAreaStateManager.kt\ngit4idea/checkin/GitIndexInfoStagingAreaStateManager\n*L\n34#1:237,11\n39#1:248,11\n42#1:264\n42#1:265,2\n49#1:267,9\n49#1:276\n49#1:278\n49#1:279\n159#1:290,9\n159#1:299\n159#1:301\n159#1:302\n40#1:259,5\n52#1:280,5\n97#1:285,5\n162#1:303,5\n232#1:308\n49#1:277\n159#1:300\n*E\n"})
public final class GitIndexInfoStagingAreaStateManager
implements GitStagingAreaStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private List<StagedChange.Staged> savedStagedChanges;
    @NotNull
    private static final String STATUS_ORDINARY = "1";
    @NotNull
    private static final String STATUS_UNMERGED = "u";
    @NotNull
    private static final String SUBMODULE_NONE = "N...";
    @NotNull
    private static final Logger LOG;

    public GitIndexInfoStagingAreaStateManager(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        this.root = virtualFile;
        this.savedStagedChanges = CollectionsKt.emptyList();
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepareStagingArea(@NotNull Set<? extends FilePath> toAdd, @NotNull Set<? extends FilePath> toRemove) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter(toRemove, (String)"toRemove");
        Set pathsToIgnore = CollectionsKt.union((Iterable)toAdd, (Iterable)toRemove);
        String string = this.repository.getRoot().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String rootPath = string;
        List<StagedChange> all = this.listStagedChanges(this.repository);
        Iterable $this$filterIsInstance$iv = all;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof StagedChange.Unmerged)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unmerged = (List)destination$iv$iv;
        if (!((Collection)unmerged).isEmpty()) {
            throw new VcsException(GitBundle.message((String)"error.commit.cant.commit.with.unmerged.paths", (Object[])new Object[0]));
        }
        Iterable $this$filterIsInstance$iv2 = all;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof StagedChange.Staged)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List staged2 = (List)destination$iv$iv2;
        Object $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("Found staged changes: " + this.getStagedLogString(rootPath, staged2), t$iv);
        }
        $this$debug_u24default$iv = staged2;
        object = this;
        boolean $i$f$filter = false;
        void $i$f$debug22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StagedChange.Staged it = (StagedChange.Staged)element$iv$iv;
            boolean bl = false;
            if (!(!pathsToIgnore.contains(it.getFilePath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object.savedStagedChanges = (List)destination$iv$iv;
        LOG.info("Staged changes excluded for commit: " + this.getStagedLogString(rootPath, (Collection<? extends StagedChange>)this.savedStagedChanges));
        this.resetExcluded();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void restore() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.savedStagedChanges;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            StagedChange.Staged it = (StagedChange.Staged)element$iv$iv;
            boolean bl2 = false;
            if (this.createUpdateIndexLine(it, false) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updateIndexLines = (List)destination$iv$iv;
        if (!((Collection)updateIndexLines).isEmpty()) {
            try {
                GitLineHandler gitLineHandler;
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Restoring staged changes after commit", t$iv);
                }
                GitLineHandler $this$restore_u24lambda_u242 = gitLineHandler = new GitLineHandler(this.project, this.root, GitCommand.UPDATE_INDEX);
                boolean bl = false;
                String[] stringArray = new String[]{"--index-info"};
                $this$restore_u24lambda_u242.addParameters(stringArray);
                $this$restore_u24lambda_u242.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(updateIndexLines, $this$restore_u24lambda_u242.getCharset()));
                GitLineHandler handler = gitLineHandler;
                Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private final List<StagedChange> listStagedChanges(GitRepository repository2) {
        GitLineHandler gitLineHandler;
        List result2 = new ArrayList();
        GitLineHandler $this$listStagedChanges_u24lambda_u240 = gitLineHandler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.STATUS);
        boolean bl = false;
        String[] stringArray = new String[]{"--porcelain=2"};
        $this$listStagedChanges_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{"--no-renames"};
        $this$listStagedChanges_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{"--no-ahead-behind"};
        $this$listStagedChanges_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{"--no-show-stash"};
        $this$listStagedChanges_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{"--untracked-files=no"};
        $this$listStagedChanges_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{"--ignored=no"};
        $this$listStagedChanges_u24lambda_u240.addParameters(stringArray);
        $this$listStagedChanges_u24lambda_u240.endOptions();
        $this$listStagedChanges_u24lambda_u240.addLineListener((arg_0, arg_1) -> GitIndexInfoStagingAreaStateManager.listStagedChanges$lambda$0$0(this, result2, arg_0, arg_1));
        GitLineHandler h = gitLineHandler;
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        return result2;
    }

    private final void parseStatusLinePorcelainV2(String line, List<StagedChange> result2) {
        try {
            StringScanner s = new StringScanner(line);
            String string = s.spaceToken();
            if (Intrinsics.areEqual((Object)string, (Object)STATUS_ORDINARY)) {
                this.parseOrdinary(s, line, result2);
            } else if (Intrinsics.areEqual((Object)string, (Object)STATUS_UNMERGED)) {
                this.parseUnmerged(s, result2);
            } else {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Unknown status line: " + line, t$iv);
                }
            }
        }
        catch (VcsException e) {
            LOG.error((Throwable)e);
        }
    }

    private final void parseUnmerged(StringScanner s, List<StagedChange> result2) {
        s.spaceToken();
        boolean isSubmodule = !Intrinsics.areEqual((Object)s.spaceToken(), (Object)SUBMODULE_NONE);
        s.spaceToken();
        s.spaceToken();
        s.spaceToken();
        s.spaceToken();
        s.spaceToken();
        s.spaceToken();
        s.spaceToken();
        String filePath = s.line();
        FilePath filePath2 = VcsUtil.getFilePath((VirtualFile)this.root, (String)GitUtil.unescapePath(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
        FilePath path = filePath2;
        result2.add(new StagedChange.Unmerged(path, isSubmodule));
    }

    private final void parseOrdinary(StringScanner s, String line, List<StagedChange> result2) {
        boolean isFileStaged;
        String status = s.spaceToken();
        boolean isSubmodule = !Intrinsics.areEqual((Object)s.spaceToken(), (Object)SUBMODULE_NONE);
        boolean headIsExecutable = Intrinsics.areEqual((Object)s.spaceToken(), (Object)"100755");
        boolean stagedIsExecutable = Intrinsics.areEqual((Object)s.spaceToken(), (Object)"100755");
        s.spaceToken();
        Hash hash = HashImpl.build((String)s.spaceToken());
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(...)");
        Hash headHash = hash;
        Hash hash2 = HashImpl.build((String)s.spaceToken());
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"build(...)");
        Hash stagedHash = hash2;
        String filePath = s.line();
        if (status.length() != 2) {
            LOG.warn("Unknown file status: " + line);
            return;
        }
        char stagedStatus = status.charAt(0);
        boolean bl = isFileStaged = stagedStatus != '.';
        if (isFileStaged) {
            FilePath filePath2 = VcsUtil.getFilePath((VirtualFile)this.root, (String)GitUtil.unescapePath(filePath));
            Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
            FilePath path = filePath2;
            result2.add(new StagedChange.Staged(path, isSubmodule, headHash, stagedHash, headIsExecutable, stagedIsExecutable));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resetExcluded() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.savedStagedChanges;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            StagedChange.Staged it = (StagedChange.Staged)element$iv$iv;
            boolean bl2 = false;
            if (this.createUpdateIndexLine(it, true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updateIndexLines = (List)destination$iv$iv;
        if (!((Collection)updateIndexLines).isEmpty()) {
            try {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Resetting staged changes after commit", t$iv);
                }
                GitLineHandler handler = new GitLineHandler(this.project, this.root, GitCommand.UPDATE_INDEX);
                String[] stringArray = new String[]{"--index-info"};
                handler.addParameters(stringArray);
                handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(updateIndexLines, handler.getCharset()));
                Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private final String createUpdateIndexLine(StagedChange.Staged change, boolean toHead) {
        String string = VcsFileUtil.relativePath((VirtualFile)this.root, (FilePath)change.getFilePath());
        if (string == null) {
            return null;
        }
        String relativePath = string;
        Pair pair = toHead ? TuplesKt.to((Object)change.getHeadHash(), (Object)change.getHeadIsExecutable()) : TuplesKt.to((Object)change.getStagedHash(), (Object)change.getStagedIsExecutable());
        Hash hash = (Hash)pair.component1();
        boolean isExecutable = (Boolean)pair.component2();
        if (Intrinsics.areEqual((Object)hash, (Object)GitIndexUtil.NULL_HASH)) {
            return "0 " + hash + "\t" + relativePath;
        }
        String mode = this.resolveMode(change.isSubmodule(), isExecutable);
        String string2 = hash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.formatIndexInfo(mode, string2, relativePath);
    }

    private final String resolveMode(boolean isSubmodule, boolean isExecutable) {
        return isSubmodule ? "160000" : (isExecutable ? "100755" : "100644");
    }

    private final String formatIndexInfo(String mode, String hash, String relativePath) {
        return mode + " " + hash + " 0\t" + relativePath;
    }

    private final String getStagedLogString(String rootPath, Collection<? extends StagedChange> changes) {
        return CollectionsKt.joinToString$default((Iterable)changes, (CharSequence)", ", null, null, (int)0, null, arg_0 -> GitIndexInfoStagingAreaStateManager.getStagedLogString$lambda$0(rootPath, arg_0), (int)30, null);
    }

    private static final void listStagedChanges$lambda$0$0(GitIndexInfoStagingAreaStateManager this$0, List $result, String line, Key outputType) {
        if (outputType == ProcessOutputTypes.STDOUT) {
            Intrinsics.checkNotNull((Object)line);
            this$0.parseStatusLinePorcelainV2(line, $result);
        }
    }

    private static final CharSequence getStagedLogString$lambda$0(String $rootPath, StagedChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = GitUtil.getLogString($rootPath, it.getFilePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogString(...)");
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitIndexInfoStagingAreaStateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$Companion;", "", "<init>", "()V", "STATUS_ORDINARY", "", "STATUS_UNMERGED", "SUBMODULE_NONE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange;", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "isSubmodule", "", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;Z)V", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "()Z", "Unmerged", "Staged", "Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange$Staged;", "Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange$Unmerged;", "intellij.vcs.git"})
    private static abstract sealed class StagedChange {
        @NotNull
        private final FilePath filePath;
        private final boolean isSubmodule;

        private StagedChange(FilePath filePath, boolean isSubmodule) {
            this.filePath = filePath;
            this.isSubmodule = isSubmodule;
        }

        @NotNull
        public final FilePath getFilePath() {
            return this.filePath;
        }

        public final boolean isSubmodule() {
            return this.isSubmodule;
        }

        public /* synthetic */ StagedChange(FilePath filePath, boolean isSubmodule, DefaultConstructorMarker $constructor_marker) {
            this(filePath, isSubmodule);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange$Staged;", "Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "isSubmodule", "", "headHash", "Lcom/intellij/vcs/log/Hash;", "stagedHash", "headIsExecutable", "stagedIsExecutable", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;ZLcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/Hash;ZZ)V", "getHeadHash", "()Lcom/intellij/vcs/log/Hash;", "getStagedHash", "getHeadIsExecutable", "()Z", "getStagedIsExecutable", "intellij.vcs.git"})
        public static final class Staged
        extends StagedChange {
            @NotNull
            private final Hash headHash;
            @NotNull
            private final Hash stagedHash;
            private final boolean headIsExecutable;
            private final boolean stagedIsExecutable;

            public Staged(@NotNull FilePath filePath, boolean isSubmodule, @NotNull Hash headHash, @NotNull Hash stagedHash, boolean headIsExecutable, boolean stagedIsExecutable) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                Intrinsics.checkNotNullParameter((Object)headHash, (String)"headHash");
                Intrinsics.checkNotNullParameter((Object)stagedHash, (String)"stagedHash");
                super(filePath, isSubmodule, null);
                this.headHash = headHash;
                this.stagedHash = stagedHash;
                this.headIsExecutable = headIsExecutable;
                this.stagedIsExecutable = stagedIsExecutable;
            }

            @NotNull
            public final Hash getHeadHash() {
                return this.headHash;
            }

            @NotNull
            public final Hash getStagedHash() {
                return this.stagedHash;
            }

            public final boolean getHeadIsExecutable() {
                return this.headIsExecutable;
            }

            public final boolean getStagedIsExecutable() {
                return this.stagedIsExecutable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange$Unmerged;", "Lgit4idea/checkin/GitIndexInfoStagingAreaStateManager$StagedChange;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "isSubmodule", "", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;Z)V", "intellij.vcs.git"})
        public static final class Unmerged
        extends StagedChange {
            public Unmerged(@NotNull FilePath filePath, boolean isSubmodule) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                super(filePath, isSubmodule, null);
            }
        }
    }
}

