/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.BaseOutputReader;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.config.GitExecutable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitTextHandler
extends GitHandler {
    private static final int WAIT_TIMEOUT_MS = 50;
    private static final int TERMINATION_TIMEOUT_MS = 60000;
    private OSProcessHandler myHandler;
    private volatile boolean myIsDestroyed;
    private final Object myProcessStateLock;
    @Deprecated(forRemoval=true)
    protected boolean myWithMediator;
    private int myTerminationTimeoutMs;

    protected GitTextHandler(@Nullable Project project, @NotNull Path directory, @NotNull GitCommand command) {
        if (directory == null) {
            GitTextHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(1);
        }
        super(project, directory, command, Collections.emptyList());
        this.myProcessStateLock = new Object();
        this.myWithMediator = false;
        this.myTerminationTimeoutMs = 60000;
    }

    protected GitTextHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (vcsRoot == null) {
            GitTextHandler.$$$reportNull$$$0(2);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(3);
        }
        super(project, vcsRoot, command, Collections.emptyList());
        this.myProcessStateLock = new Object();
        this.myWithMediator = false;
        this.myTerminationTimeoutMs = 60000;
    }

    protected GitTextHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, List<String> configParameters) {
        if (vcsRoot == null) {
            GitTextHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(5);
        }
        super(project, vcsRoot, command, configParameters);
        this.myProcessStateLock = new Object();
        this.myWithMediator = false;
        this.myTerminationTimeoutMs = 60000;
    }

    public GitTextHandler(@Nullable Project project, @NotNull Path directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitTextHandler.$$$reportNull$$$0(6);
        }
        if (executable == null) {
            GitTextHandler.$$$reportNull$$$0(7);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(8);
        }
        if (configParameters == null) {
            GitTextHandler.$$$reportNull$$$0(9);
        }
        super(project, directory, executable, command, configParameters);
        this.myProcessStateLock = new Object();
        this.myWithMediator = false;
        this.myTerminationTimeoutMs = 60000;
    }

    @Deprecated(forRemoval=true)
    public void setWithMediator(boolean value) {
    }

    public void setTerminationTimeout(int timeoutMs) {
        this.myTerminationTimeoutMs = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Process startProcess() throws ExecutionException {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return null;
            }
            this.myHandler = this.createProcess(this.myCommandLine);
            this.listeners().processStarted();
            return this.myHandler.getProcess();
        }
    }

    @Override
    protected void startHandlingStreams() {
        this.myHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                int exitCode = event.getExitCode();
                GitHandler.OUTPUT_LOG.debug(String.format("%s %% %s terminated (%s)", GitTextHandler.this.getCommand(), GitTextHandler.this.hashCode(), exitCode));
                try {
                    GitTextHandler.this.setExitCode(exitCode);
                    GitTextHandler.this.processTerminated(exitCode);
                }
                finally {
                    GitTextHandler.this.listeners().processTerminated(exitCode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/commands/GitTextHandler$1", "processTerminated"));
            }
        });
        this.myHandler.startNotify();
    }

    protected abstract void processTerminated(int var1);

    @Override
    protected void waitForProcess() {
        if (this.myHandler != null) {
            while (!this.myHandler.waitFor(50L)) {
                try {
                    ProgressManager.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    this.tryKillProcess();
                    throw pce;
                }
            }
        }
    }

    private void tryKillProcess() {
        ProgressManager.getInstance().executeNonCancelableSection(() -> this.myHandler.destroyProcess());
        if (ApplicationManager.getApplication().isReadAccessAllowed() || GitTextHandler.shouldSuppressReadLocks()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.waitAndHardKillProcess());
        } else {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.waitAndHardKillProcess());
        }
    }

    private void waitAndHardKillProcess() {
        if (this.myHandler.waitFor((long)this.myTerminationTimeoutMs)) {
            return;
        }
        LOG.warn("Soft-kill failed for [" + this.printableCommandLine() + "].");
        ExecutionManagerImpl.stopProcess((ProcessHandler)this.myHandler);
        if (this.myHandler.waitFor((long)this.myTerminationTimeoutMs)) {
            return;
        }
        LOG.warn("Could not terminate [" + this.printableCommandLine() + "].");
    }

    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GitTextHandler.$$$reportNull$$$0(10);
        }
        return new MyOSProcessHandler(commandLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitTextHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class MyOSProcessHandler
    extends KillableProcessHandler {
        protected MyOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                MyOSProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        @Deprecated(forRemoval=true)
        protected MyOSProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
            if (commandLine == null) {
                MyOSProcessHandler.$$$reportNull$$$0(1);
            }
            this(commandLine);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = Registry.is((String)"git.blocking.read") ? BaseOutputReader.Options.BLOCKING : BaseOutputReader.Options.NON_BLOCKING;
            if (options == null) {
                MyOSProcessHandler.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitTextHandler$MyOSProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitTextHandler$MyOSProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

