/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitExecutableFileTester {
    private static final Logger LOG = Logger.getInstance(GitExecutableFileTester.class);
    private static final int FILE_TEST_TIMEOUT_MS = 30000;
    private final ReentrantLock LOCK = new ReentrantLock();
    @NotNull
    private final ConcurrentMap<GitExecutable, TestResult> myTestMap = new ConcurrentHashMap<GitExecutable, TestResult>();

    GitExecutableFileTester() {
    }

    @NotNull
    final TestResult getResultFor(@Nullable Project project, @NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableFileTester.$$$reportNull$$$0(0);
        }
        TestResult testResult = (TestResult)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.LOCK, (int)50, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
            TestResult result2 = (TestResult)this.myTestMap.get(executable);
            long currentLastModificationDate = 0L;
            try {
                currentLastModificationDate = executable.getModificationTime();
                executable.getModificationTime();
                if (result2 == null || result2.getFileLastModifiedTimestamp() != currentLastModificationDate) {
                    result2 = new TestResult(GitExecutableFileTester.testOrAbort(project, executable), currentLastModificationDate);
                    this.myTestMap.put(executable, result2);
                }
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                result2 = new TestResult(e, currentLastModificationDate);
                this.myTestMap.put(executable, result2);
            }
            return result2;
        });
        if (testResult == null) {
            GitExecutableFileTester.$$$reportNull$$$0(1);
        }
        return testResult;
    }

    @NotNull
    private static GitVersion testOrAbort(@Nullable Project project, @NotNull GitExecutable executable) throws Exception {
        if (executable == null) {
            GitExecutableFileTester.$$$reportNull$$$0(2);
        }
        int maxAttempts = 1;
        if (SystemInfo.isMac && "/usr/bin/git".equals(executable.getExePath())) {
            maxAttempts = 3;
        }
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            GitVersion result2 = GitExecutableFileTester.runTestWithTimeout(project, executable);
            if (result2 == null) continue;
            GitVersion gitVersion = result2;
            if (gitVersion == null) {
                GitExecutableFileTester.$$$reportNull$$$0(3);
            }
            return gitVersion;
        }
        throw new GitVersionIdentificationException(GitBundle.message((String)"git.executable.validation.error.no.response.in.n.attempts.message", (Object[])new Object[]{maxAttempts}), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static GitVersion runTestWithTimeout(@Nullable Project project, @NotNull GitExecutable executable) throws Exception {
        if (executable == null) {
            GitExecutableFileTester.$$$reportNull$$$0(4);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        Ref exceptionRef = new Ref();
        Ref resultRef = new Ref();
        Semaphore semaphore = new Semaphore(0);
        AppJavaExecutorUtil.executeOnPooledIoThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                resultRef.set((Object)GitExecutableFileTester.testExecutable(project, executable));
            }
            catch (Exception e) {
                exceptionRef.set((Object)e);
            }
            finally {
                semaphore.release();
            }
        }, (ProgressIndicator)indicator));
        try {
            long start = System.currentTimeMillis();
            do {
                ProgressManager.checkCanceled();
            } while (!semaphore.tryAcquire(50L, TimeUnit.MILLISECONDS) && System.currentTimeMillis() - start <= 30000L);
            if (!resultRef.isNull()) {
                GitVersion gitVersion = (GitVersion)resultRef.get();
                return gitVersion;
            }
            if (!exceptionRef.isNull()) {
                throw (Exception)exceptionRef.get();
            }
            GitVersion gitVersion = null;
            return gitVersion;
        }
        finally {
            indicator.cancel();
        }
    }

    @Nullable
    public TestResult getCachedResultFor(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableFileTester.$$$reportNull$$$0(5);
        }
        return (TestResult)this.myTestMap.get(executable);
    }

    public void dropCache(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableFileTester.$$$reportNull$$$0(6);
        }
        this.myTestMap.remove(executable);
    }

    public void dropCache() {
        this.myTestMap.clear();
    }

    @NotNull
    private static GitVersion testExecutable(@Nullable Project project, @NotNull GitExecutable executable) throws Exception {
        if (executable == null) {
            GitExecutableFileTester.$$$reportNull$$$0(7);
        }
        GitVersion.Type type = null;
        Path workingDirectory = Optional.ofNullable(project).map(Project::getBasePath).map(x$0 -> Path.of(x$0, new String[0])).map(p -> Files.exists(p, new LinkOption[0]) ? p : null).orElse(Path.of(".", new String[0]));
        if (executable instanceof GitExecutable.Unknown) {
            type = GitVersion.Type.UNDEFINED;
        } else if (executable instanceof GitExecutable.Wsl) {
            WSLDistribution distribution = ((GitExecutable.Wsl)executable).getDistribution();
            type = distribution.getVersion() == 1 ? GitVersion.Type.WSL1 : GitVersion.Type.WSL2;
            workingDirectory = Path.of(distribution.getWindowsPath("/"), new String[0]);
        } else if (executable instanceof GitExecutable.Eel) {
            EelApi eelApi = ((GitExecutable.Eel)executable).getEel();
            if (eelApi.getDescriptor() instanceof WslEelDescriptor) {
                WSLDistribution distribution = ((WslEelDescriptor)eelApi.getDescriptor()).getDistribution();
                type = distribution.getVersion() == 1 ? GitVersion.Type.WSL1 : GitVersion.Type.WSL2;
            } else if (eelApi.getDescriptor() instanceof LocalEelDescriptor && eelApi.getPlatform().getOsFamily().equals((Object)EelOsFamily.Posix)) {
                type = GitVersion.Type.UNIX;
            }
            workingDirectory = EelNioBridgeServiceKt.asNioPath((EelPath)eelApi.getUserInfo().getHome());
        }
        LOG.debug("Acquiring git version for " + String.valueOf(executable));
        GitLineHandler handler = new GitLineHandler(null, workingDirectory, executable, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setTerminationTimeout(1000);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult, type);
        LOG.info("Git version for " + String.valueOf(executable) + ": " + String.valueOf(version));
        GitVersion gitVersion = version;
        if (gitVersion == null) {
            GitExecutableFileTester.$$$reportNull$$$0(8);
        }
        return gitVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableFileTester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableFileTester";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "testOrAbort";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "testExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResultFor";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "testOrAbort";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runTestWithTimeout";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResultFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dropCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "testExecutable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 8 -> new IllegalStateException(string);
        };
    }

    public static class TestResult {
        @Nullable
        private final GitVersion myResult;
        @Nullable
        private final Exception myException;
        private final long myFileLastModifiedTimestamp;

        TestResult(@NotNull GitVersion result2, long timestamp) {
            if (result2 == null) {
                TestResult.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
            this.myFileLastModifiedTimestamp = timestamp;
            this.myException = null;
        }

        TestResult(@NotNull Exception exception, long timestamp) {
            if (exception == null) {
                TestResult.$$$reportNull$$$0(1);
            }
            this.myFileLastModifiedTimestamp = timestamp;
            this.myResult = null;
            this.myException = exception;
        }

        @Nullable
        public GitVersion getResult() {
            return this.myResult;
        }

        @Nullable
        public Exception getException() {
            return this.myException;
        }

        private long getFileLastModifiedTimestamp() {
            return this.myFileLastModifiedTimestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exception";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitExecutableFileTester$TestResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

