/*
 * Decompiled with CFR 0.152.
 */
package git4idea.inMemory;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lgit4idea/inMemory/GitCommitMessageFormatter;", "", "<init>", "()V", "format", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "message", "cleanupMessage", "commentChar", "isCommentLine", "", "CleanupMode", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitMessageFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitMessageFormatter.kt\ngit4idea/inMemory/GitCommitMessageFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n360#2,7:97\n388#2,7:104\n*S KotlinDebug\n*F\n+ 1 GitCommitMessageFormatter.kt\ngit4idea/inMemory/GitCommitMessageFormatter\n*L\n34#1:97,7\n37#1:104,7\n*E\n"})
public final class GitCommitMessageFormatter {
    @NotNull
    public static final GitCommitMessageFormatter INSTANCE = new GitCommitMessageFormatter();

    private GitCommitMessageFormatter() {
    }

    @NotNull
    public final String format(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CleanupMode cleanupMode = GitConfigUtil.getCommitMessageCleanupModeCached(project, root);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cleanupMode), (String)"getCommitMessageCleanupModeCached(...)");
        CleanupMode mode = cleanupMode;
        if (mode == CleanupMode.NONE) {
            return message;
        }
        if (mode == CleanupMode.ALL) {
            String string = GitConfigUtil.getCommitMessageCommentCharCached(project, root);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommitMessageCommentCharCached(...)");
            String commentChar = string;
            return this.cleanupMessage(message, commentChar);
        }
        return this.cleanupMessage(message, null);
    }

    private final String cleanupMessage(String message, String commentChar) {
        int n;
        int startIndex;
        List lines;
        block12: {
            block11: {
                int n2;
                List $this$indexOfFirst$iv = lines = StringsKt.lines((CharSequence)message);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (!StringsKt.isBlank((CharSequence)it) && !INSTANCE.isCommentLine(it, commentChar)) {
                        n2 = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n2 = startIndex = -1;
            }
            if (startIndex == -1) {
                return "";
            }
            List $this$indexOfLast$iv = lines;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)it) && !INSTANCE.isCommentLine(it, commentChar))) continue;
                n = iterator$iv.nextIndex();
                break block12;
            }
            n = -1;
        }
        int endIndex = n;
        StringBuilder result2 = new StringBuilder();
        boolean previousLineEmpty = false;
        int i = startIndex;
        if (i <= endIndex) {
            while (true) {
                String line;
                if (!this.isCommentLine(line = ((Object)StringsKt.trimEnd((CharSequence)((String)lines.get(i)))).toString(), commentChar)) {
                    if (((CharSequence)line).length() == 0) {
                        if (!previousLineEmpty) {
                            result2.append('\n');
                        }
                        previousLineEmpty = true;
                    } else {
                        if (((CharSequence)result2).length() > 0) {
                            result2.append('\n');
                        }
                        result2.append(line);
                        previousLineEmpty = false;
                    }
                }
                if (i == endIndex) break;
                ++i;
            }
        }
        result2.append('\n');
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isCommentLine(String $this$isCommentLine, String commentChar) {
        return commentChar != null && StringsKt.startsWith$default((String)$this$isCommentLine, (String)commentChar, (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lgit4idea/inMemory/GitCommitMessageFormatter$CleanupMode;", "", "<init>", "(Ljava/lang/String;I)V", "SPACE", "NONE", "SCISSORS", "ALL", "Companion", "intellij.vcs.git"})
    public static final class CleanupMode
    extends Enum<CleanupMode> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ CleanupMode SPACE;
        public static final /* enum */ CleanupMode NONE;
        public static final /* enum */ CleanupMode SCISSORS;
        public static final /* enum */ CleanupMode ALL;
        private static final /* synthetic */ CleanupMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CleanupMode[] values() {
            return (CleanupMode[])$VALUES.clone();
        }

        public static CleanupMode valueOf(String value) {
            return Enum.valueOf(CleanupMode.class, value);
        }

        @NotNull
        public static EnumEntries<CleanupMode> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @NotNull
        public static final CleanupMode parse(@Nullable String value) {
            return Companion.parse(value);
        }

        static {
            SPACE = new CleanupMode();
            NONE = new CleanupMode();
            SCISSORS = new CleanupMode();
            ALL = new CleanupMode();
            $VALUES = cleanupModeArray = new CleanupMode[]{CleanupMode.SPACE, CleanupMode.NONE, CleanupMode.SCISSORS, CleanupMode.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\t"}, d2={"Lgit4idea/inMemory/GitCommitMessageFormatter$CleanupMode$Companion;", "", "<init>", "()V", "parse", "Lgit4idea/inMemory/GitCommitMessageFormatter$CleanupMode;", "value", "", "parseOrNull", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final CleanupMode parse(@Nullable String value) {
                CleanupMode cleanupMode = this.parseOrNull(value);
                if (cleanupMode == null) {
                    throw new IllegalArgumentException("Invalid commit message cleanup mode '" + value + "'");
                }
                return cleanupMode;
            }

            private final CleanupMode parseOrNull(String value) {
                if (value == null) {
                    return SPACE;
                }
                return switch (value) {
                    case "default" -> SPACE;
                    case "verbatim" -> NONE;
                    case "strip" -> ALL;
                    case "scissors" -> SPACE;
                    default -> null;
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

