/*
 * Decompiled with CFR 0.152.
 */
package git4idea.inMemory;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitObjectType;
import git4idea.config.gpg.GitGpgConfigUtilsKt;
import git4idea.inMemory.GitCommitMessageFormatter;
import git4idea.inMemory.MergeConflictException;
import git4idea.inMemory.objects.GitObject;
import git4idea.inMemory.objects.Oid;
import git4idea.repo.GitRepository;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 =2\u00020\u0001:\u0001=B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\nJN\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u001fJ*\u0010(\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\n2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*J\u001a\u0010(\u001a\u00020\r2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*J\u0016\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001fJ2\u0010/\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$2\u0006\u0010&\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007JD\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\u00192\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\n2\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0018\u00102\u001a\u00020\n2\u0006\u00103\u001a\u0002042\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u00105\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0007J\u0010\u00106\u001a\u0002042\u0006\u0010\u0013\u001a\u00020\nH\u0003J\u001c\u00107\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\n2\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0003J)\u00108\u001a\u00020\r*\u00020\u00002\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006>"}, d2={"Lgit4idea/inMemory/GitObjectRepository;", "", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "objectCache", "", "Lgit4idea/inMemory/objects/Oid;", "Lgit4idea/inMemory/objects/GitObject;", "emptyTree", "Lgit4idea/inMemory/objects/GitObject$Tree;", "getEmptyTree", "()Lgit4idea/inMemory/objects/GitObject$Tree;", "emptyTree$delegate", "Lkotlin/Lazy;", "findObjectFromCache", "oid", "cacheObject", "", "obj", "clearCache", "findCommit", "Lgit4idea/inMemory/objects/GitObject$Commit;", "findTree", "findBlob", "Lgit4idea/inMemory/objects/GitObject$Blob;", "createCommit", "body", "", "author", "Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "committer", "parentsOids", "", "treeOid", "message", "gpgSignature", "createTree", "entries", "", "Lgit4idea/inMemory/objects/GitObject$Tree$FileName;", "Lgit4idea/inMemory/objects/GitObject$Tree$Entry;", "createBlob", "content", "commitTree", "commitTreeWithOverrides", "commit", "fetchOid", "type", "Lgit4idea/commands/GitObjectType;", "persistObject", "fetchObjectType", "loadObjectFromDisk", "mergeTrees", "ours", "theirs", "base", "mergeTrees$intellij_vcs_git", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitObjectRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitObjectRepository.kt\ngit4idea/inMemory/GitObjectRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,299:1\n1#2:300\n1869#3,2:301\n1869#3,2:303\n13#4:305\n*S KotlinDebug\n*F\n+ 1 GitObjectRepository.kt\ngit4idea/inMemory/GitObjectRepository\n*L\n138#1:301,2\n196#1:303,2\n29#1:305\n*E\n"})
public final class GitObjectRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final Map<Oid, GitObject> objectCache;
    @NotNull
    private final Lazy emptyTree$delegate;
    @NotNull
    private static final Logger LOG;

    public GitObjectRepository(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        this.objectCache = new HashMap();
        this.emptyTree$delegate = LazyKt.lazy(() -> GitObjectRepository.emptyTree_delegate$lambda$0(this));
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final GitObject.Tree getEmptyTree() {
        Lazy lazy = this.emptyTree$delegate;
        return (GitObject.Tree)lazy.getValue();
    }

    private final GitObject findObjectFromCache(Oid oid) {
        return this.objectCache.get(oid);
    }

    private final void cacheObject(GitObject obj) {
        this.objectCache.putIfAbsent(obj.getOid(), obj);
    }

    @TestOnly
    public final void clearCache() {
        this.objectCache.clear();
    }

    @NotNull
    public final GitObject.Commit findCommit(@NotNull Oid oid) {
        GitObject obj;
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        GitObject gitObject = this.findObjectFromCache(oid);
        if (gitObject == null) {
            gitObject = this.loadObjectFromDisk(oid, GitObjectType.COMMIT);
        }
        if (!((obj = gitObject) instanceof GitObject.Commit)) {
            boolean bl = false;
            String string = "Object " + oid + " is not a commit";
            throw new IllegalArgumentException(string.toString());
        }
        return (GitObject.Commit)obj;
    }

    @NotNull
    public final GitObject.Tree findTree(@NotNull Oid oid) {
        GitObject obj;
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        GitObject gitObject = this.findObjectFromCache(oid);
        if (gitObject == null) {
            gitObject = this.loadObjectFromDisk(oid, GitObjectType.TREE);
        }
        if (!((obj = gitObject) instanceof GitObject.Tree)) {
            boolean bl = false;
            String string = "Object " + oid + " is not a tree";
            throw new IllegalArgumentException(string.toString());
        }
        return (GitObject.Tree)obj;
    }

    @NotNull
    public final GitObject.Blob findBlob(@NotNull Oid oid) {
        GitObject obj;
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        GitObject gitObject = this.findObjectFromCache(oid);
        if (gitObject == null) {
            gitObject = this.loadObjectFromDisk(oid, GitObjectType.BLOB);
        }
        if (!((obj = gitObject) instanceof GitObject.Blob)) {
            boolean bl = false;
            String string = "Object " + oid + " is not a blob";
            throw new IllegalArgumentException(string.toString());
        }
        return (GitObject.Blob)obj;
    }

    @NotNull
    public final GitObject.Commit createCommit(@NotNull byte[] body, @NotNull Oid oid, @NotNull GitObject.Commit.Author author, @NotNull GitObject.Commit.Author committer, @NotNull List<Oid> parentsOids, @NotNull Oid treeOid, @NotNull byte[] message, @Nullable byte[] gpgSignature) {
        GitObject.Commit commit;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        Intrinsics.checkNotNullParameter(parentsOids, (String)"parentsOids");
        Intrinsics.checkNotNullParameter((Object)treeOid, (String)"treeOid");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitObject.Commit it = commit = new GitObject.Commit(body, oid, author, committer, parentsOids, treeOid, message, gpgSignature);
        boolean bl = false;
        this.cacheObject(it);
        return commit;
    }

    @NotNull
    public final GitObject.Tree createTree(@NotNull byte[] body, @NotNull Oid oid, @NotNull Map<GitObject.Tree.FileName, GitObject.Tree.Entry> entries) {
        GitObject.Tree tree;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        GitObject.Tree it = tree = new GitObject.Tree(body, oid, entries);
        boolean bl = false;
        this.cacheObject(it);
        return tree;
    }

    @NotNull
    public final GitObject.Tree createTree(@NotNull Map<GitObject.Tree.FileName, GitObject.Tree.Entry> entries) {
        GitObject.Tree tree;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        byte[] body = GitObject.Tree.Companion.buildBody(entries);
        Oid oid = this.fetchOid(GitObjectType.TREE, body);
        GitObject.Tree it = tree = new GitObject.Tree(body, oid, entries);
        boolean bl = false;
        this.cacheObject(it);
        return tree;
    }

    @NotNull
    public final GitObject.Blob createBlob(@NotNull byte[] content, @NotNull Oid oid) {
        GitObject.Blob blob;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        GitObject.Blob it = blob = new GitObject.Blob(content, oid);
        boolean bl = false;
        this.cacheObject(it);
        return blob;
    }

    @NotNull
    public final GitObject.Blob createBlob(@NotNull byte[] content) {
        GitObject.Blob blob;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Oid oid = this.fetchOid(GitObjectType.BLOB, content);
        GitObject.Blob it = blob = new GitObject.Blob(content, oid);
        boolean bl = false;
        this.cacheObject(it);
        return blob;
    }

    @RequiresBackgroundThread
    @NotNull
    public final Oid commitTree(@NotNull Oid treeOid, @NotNull List<Oid> parentsOids, @NotNull byte[] message, @Nullable GitObject.Commit.Author author) {
        String[] stringArray;
        File file;
        Intrinsics.checkNotNullParameter((Object)treeOid, (String)"treeOid");
        Intrinsics.checkNotNullParameter(parentsOids, (String)"parentsOids");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LOG.debug("Starting commitTree operation: treeOid=" + treeOid + ", parents=" + parentsOids);
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        String formattedMessage = GitCommitMessageFormatter.INSTANCE.format(project2, root, new String(message, Charsets.UTF_8));
        try {
            file = GitCheckinEnvironment.Companion.createCommitMessageFile(project2, root, formattedMessage);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.warn("Couldn't create message file", (Throwable)e);
            throw e;
        }
        File messageFile = file;
        GitLineHandler $this$commitTree_u24lambda_u240 = e = new GitLineHandler(project2, root, GitCommand.COMMIT_TREE);
        boolean bl = false;
        $this$commitTree_u24lambda_u240.setSilent(true);
        Iterable $this$forEach$iv = parentsOids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Oid it = (Oid)element$iv;
            boolean bl2 = false;
            String[] stringArray2 = new String[]{"-p", it.hex()};
            $this$commitTree_u24lambda_u240.addParameters(stringArray2);
        }
        if (author != null) {
            $this$commitTree_u24lambda_u240.addCustomEnvironmentVariable("GIT_AUTHOR_NAME", author.getName());
            $this$commitTree_u24lambda_u240.addCustomEnvironmentVariable("GIT_AUTHOR_EMAIL", author.getEmail());
            $this$commitTree_u24lambda_u240.addCustomEnvironmentVariable("GIT_AUTHOR_DATE", author.getTimestamp());
        }
        if (GitGpgConfigUtilsKt.isGpgSignEnabledCached(this.repository)) {
            stringArray = new String[]{"--gpg-sign"};
            $this$commitTree_u24lambda_u240.addParameters(stringArray);
        }
        stringArray = new String[]{"-F"};
        $this$commitTree_u24lambda_u240.addParameters(stringArray);
        $this$commitTree_u24lambda_u240.addAbsoluteFile(messageFile);
        stringArray = new String[]{treeOid.hex()};
        $this$commitTree_u24lambda_u240.addParameters(stringArray);
        if (((CharSequence)formattedMessage).length() == 0) {
            $this$commitTree_u24lambda_u240.setInputProcessor(GitHandlerInputProcessorUtil.redirectStream(new ByteArrayInputStream(new byte[0])));
        }
        GitLineHandler handler = e;
        String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        Oid oid = Oid.Companion.fromHex(string);
        LOG.debug("Successfully created commit: " + oid);
        return oid;
    }

    public static /* synthetic */ Oid commitTree$default(GitObjectRepository gitObjectRepository, Oid oid, List list, byte[] byArray, GitObject.Commit.Author author, int n, Object object) {
        if ((n & 8) != 0) {
            author = null;
        }
        return gitObjectRepository.commitTree(oid, list, byArray, author);
    }

    @NotNull
    public final Oid commitTreeWithOverrides(@NotNull GitObject.Commit commit, @Nullable Oid treeOid, @Nullable List<Oid> parentsOids, @Nullable byte[] message, @Nullable GitObject.Commit.Author author) {
        GitObject.Commit.Author author2;
        byte[] newMessage;
        List<Oid> list;
        Oid newTree;
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Oid oid = treeOid;
        if (oid == null) {
            oid = newTree = commit.getTreeOid();
        }
        if ((list = parentsOids) == null) {
            list = commit.getParentsOids();
        }
        List<Oid> newParents = list;
        byte[] byArray = message;
        if (message == null) {
            byArray = newMessage = commit.getMessage();
        }
        if ((author2 = author) == null) {
            author2 = commit.getAuthor();
        }
        GitObject.Commit.Author newAuthor = author2;
        return this.commitTree(newTree, newParents, newMessage, newAuthor);
    }

    public static /* synthetic */ Oid commitTreeWithOverrides$default(GitObjectRepository gitObjectRepository, GitObject.Commit commit, Oid oid, List list, byte[] byArray, GitObject.Commit.Author author, int n, Object object) {
        if ((n & 2) != 0) {
            oid = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            byArray = null;
        }
        if ((n & 0x10) != 0) {
            author = null;
        }
        return gitObjectRepository.commitTreeWithOverrides(commit, oid, list, byArray, author);
    }

    @RequiresBackgroundThread
    @NotNull
    public final Oid fetchOid(@NotNull GitObjectType type, @NotNull byte[] body) {
        GitLineHandler gitLineHandler;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        GitLineHandler $this$fetchOid_u24lambda_u240 = gitLineHandler = new GitLineHandler(this.repository.getProject(), this.repository.getRoot(), GitCommand.HASH_OBJECT);
        boolean bl = false;
        $this$fetchOid_u24lambda_u240.setSilent(true);
        String[] stringArray = new String[]{"-t", type.getTag()};
        $this$fetchOid_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{"--stdin"};
        $this$fetchOid_u24lambda_u240.addParameters(stringArray);
        $this$fetchOid_u24lambda_u240.setInputProcessor(GitHandlerInputProcessorUtil.redirectStream(new ByteArrayInputStream(body)));
        GitLineHandler handler = gitLineHandler;
        String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        String hash = string;
        return Oid.Companion.fromHex(hash);
    }

    @RequiresBackgroundThread
    public final void persistObject(@NotNull GitObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj.getPersisted()) {
            return;
        }
        Iterable $this$forEach$iv = obj.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitObject it;
            Oid oid = (Oid)element$iv;
            boolean bl = false;
            if (this.findObjectFromCache(oid) == null) continue;
            boolean bl2 = false;
            this.persistObject(it);
        }
        try {
            GitLineHandler $this$persistObject_u24lambda_u241 = $i$f$forEach = new GitLineHandler(this.repository.getProject(), this.repository.getRoot(), GitCommand.HASH_OBJECT);
            boolean bl = false;
            $this$persistObject_u24lambda_u241.setSilent(true);
            String[] stringArray = new String[]{"-t", obj.getType().getTag(), "-w", "--stdin"};
            $this$persistObject_u24lambda_u241.addParameters(stringArray);
            $this$persistObject_u24lambda_u241.setInputProcessor(GitHandlerInputProcessorUtil.redirectStream(new ByteArrayInputStream(obj.getBody())));
            GitLineHandler handler = $i$f$forEach;
            String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
            Oid newOid = Oid.Companion.fromHex(string);
            if (!Intrinsics.areEqual((Object)newOid, (Object)obj.getOid())) {
                boolean bl3 = false;
                String string2 = "Computed by git OID " + newOid + " does not match expected OID " + obj.getOid();
                throw new IllegalStateException(string2.toString());
            }
            obj.setPersisted(true);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to persist object " + obj.getOid(), (Throwable)e);
            throw e;
        }
    }

    @RequiresBackgroundThread
    private final GitObjectType fetchObjectType(Oid oid) {
        GitObjectType type = Git.getInstance().getObjectTypeEnum(this.repository, oid.hex());
        if (!(type != null)) {
            boolean bl = false;
            String string = "Unknown git object type";
            throw new IllegalArgumentException(string.toString());
        }
        return type;
    }

    @RequiresBackgroundThread
    private final GitObject loadObjectFromDisk(Oid oid, GitObjectType type) {
        try {
            GitBinaryHandler gitBinaryHandler;
            GitObjectType gitObjectType = type;
            if (gitObjectType == null) {
                gitObjectType = this.fetchObjectType(oid);
            }
            GitObjectType type2 = gitObjectType;
            GitBinaryHandler $this$loadObjectFromDisk_u24lambda_u240 = gitBinaryHandler = new GitBinaryHandler(this.repository.getProject(), this.repository.getRoot(), GitCommand.CAT_FILE);
            boolean bl = false;
            $this$loadObjectFromDisk_u24lambda_u240.setSilent(true);
            String[] stringArray = new String[]{type2.getTag(), oid.hex()};
            $this$loadObjectFromDisk_u24lambda_u240.addParameters(stringArray);
            GitBinaryHandler bodyHandler = gitBinaryHandler;
            byte[] byArray = bodyHandler.run();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
            byte[] body = byArray;
            GitObject obj = switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1 -> {
                    LOG.debug("Parsing commit object: " + oid);
                    GitObject.Commit.Companion.ParsedData parsedData = GitObject.Commit.Companion.parseBody(body);
                    yield this.createCommit(body, oid, parsedData.getAuthor(), parsedData.getCommitter(), parsedData.getParentsOids(), parsedData.getTreeOid(), parsedData.getMessage(), parsedData.getGpgSignature());
                }
                case 2 -> {
                    LOG.debug("Parsing tree object: " + oid);
                    Map<GitObject.Tree.FileName, GitObject.Tree.Entry> entries = GitObject.Tree.Companion.parseBody(body);
                    yield this.createTree(body, oid, entries);
                }
                case 3 -> this.createBlob(body, oid);
                default -> throw new NoWhenBranchMatchedException();
            };
            obj.setPersisted(true);
            LOG.debug("Successfully loaded object: " + oid + " (" + obj.getType() + ")");
            return obj;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to load object " + oid + " from git", (Throwable)e);
            throw e;
        }
    }

    static /* synthetic */ GitObject loadObjectFromDisk$default(GitObjectRepository gitObjectRepository, Oid oid, GitObjectType gitObjectType, int n, Object object) {
        if ((n & 2) != 0) {
            gitObjectType = null;
        }
        return gitObjectRepository.loadObjectFromDisk(oid, gitObjectType);
    }

    @RequiresBackgroundThread
    @NotNull
    public final GitObject.Tree mergeTrees$intellij_vcs_git(@NotNull GitObjectRepository $this$mergeTrees, @NotNull GitObject.Tree ours, @NotNull GitObject.Tree theirs, @NotNull GitObject.Tree base) {
        GitLineHandler gitLineHandler;
        Intrinsics.checkNotNullParameter((Object)$this$mergeTrees, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ours, (String)"ours");
        Intrinsics.checkNotNullParameter((Object)theirs, (String)"theirs");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        GitLineHandler $this$mergeTrees_u24lambda_u240 = gitLineHandler = new GitLineHandler($this$mergeTrees.repository.getProject(), $this$mergeTrees.repository.getRoot(), GitCommand.MERGE_TREE);
        boolean bl = false;
        $this$mergeTrees_u24lambda_u240.setSilent(true);
        String[] stringArray = new String[]{"--merge-base=" + base.getOid()};
        $this$mergeTrees_u24lambda_u240.addParameters(stringArray);
        stringArray = new String[]{ours.getOid().hex(), theirs.getOid().hex()};
        $this$mergeTrees_u24lambda_u240.addParameters(stringArray);
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (result2.getExitCode() == 1) {
            String string = result2.getOutputAsJoinedString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputAsJoinedString(...)");
            throw new MergeConflictException(string);
        }
        result2.throwOnError(new int[0]);
        String string = result2.getOutputAsJoinedString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputAsJoinedString(...)");
        return $this$mergeTrees.findTree(Oid.Companion.fromHex(string));
    }

    private static final GitObject.Tree emptyTree_delegate$lambda$0(GitObjectRepository this$0) {
        return this$0.createTree(MapsKt.emptyMap());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitObjectRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/inMemory/GitObjectRepository$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitObjectType.values().length];
            try {
                nArray[GitObjectType.COMMIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitObjectType.TREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitObjectType.BLOB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

