/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.data.index.IndexedDetails;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0012\u001a\u00020\f*\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J:\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "<init>", "()V", "graphType", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "rowHeight", "", "connectionCenterY", "getConnectionCenterY", "()I", "paint", "", "g", "Ljava/awt/Graphics;", "paintFixupGraph", "Ljava/awt/Graphics2D;", "drawCenterLine", "drawDownLine", "drawUpLine", "withArrow", "", "getRowGraphType", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "row", "customizeCellRenderer", "Ljavax/swing/JTable;", "value", "", "selected", "hasFocus", "column", "Companion", "GraphType", "intellij.vcs.git"})
final class SubjectRenderer
extends ColoredTableCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private GraphType graphType = GraphType.NoGraph.INSTANCE;
    private int rowHeight = GitRebaseCommitsTableView.Companion.getDEFAULT_CELL_HEIGHT();
    private static final int GRAPH_WIDTH = 20;
    private static final int CONNECTION_CENTER_X = 5;

    private final int getConnectionCenterY() {
        return this.rowHeight / 2;
    }

    public void paint(@Nullable Graphics g) {
        super.paint(g);
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        this.paintFixupGraph((Graphics2D)g);
    }

    private final void paintFixupGraph(Graphics2D $this$paintFixupGraph) {
        GraphType type = this.graphType;
        if (!(type instanceof GraphType.NoGraph)) {
            if (type instanceof GraphType.FixupGraph) {
                $this$paintFixupGraph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                $this$paintFixupGraph.setColor((Color)GitRebaseCommitsTableView.Companion.getGRAPH_COLOR());
                $this$paintFixupGraph.setStroke(new BasicStroke(GitRebaseCommitsTableView.Companion.getGRAPH_LINE_WIDTH(), 1, 2));
                this.drawCenterLine($this$paintFixupGraph);
                this.drawUpLine($this$paintFixupGraph, ((GraphType.FixupGraph)type).isFirst());
                if (!((GraphType.FixupGraph)type).isLast()) {
                    this.drawDownLine($this$paintFixupGraph);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void drawCenterLine(Graphics2D $this$drawCenterLine) {
        int gap = 4;
        int xRight = 20 - gap;
        $this$drawCenterLine.drawLine(5, this.getConnectionCenterY(), xRight, this.getConnectionCenterY());
    }

    private final void drawDownLine(Graphics2D $this$drawDownLine) {
        $this$drawDownLine.drawLine(5, this.getConnectionCenterY(), 5, this.rowHeight);
    }

    private final void drawUpLine(Graphics2D $this$drawUpLine, boolean withArrow) {
        int triangleSide = JBUI.scale((int)8);
        int triangleBottomY = triangleSide / 2;
        int triangleBottomXDiff = triangleSide / 2;
        int upLineY = withArrow ? triangleBottomY : 0;
        $this$drawUpLine.drawLine(5, this.getConnectionCenterY(), 5, upLineY);
        if (withArrow) {
            int[] nArray = new int[]{5, 5 - triangleBottomXDiff, 5 + triangleBottomXDiff};
            int[] xPoints = nArray;
            int[] nArray2 = new int[]{0, triangleBottomY, triangleBottomY};
            int[] yPoints = nArray2;
            $this$drawUpLine.fillPolygon(xPoints, yPoints, xPoints.length);
        }
    }

    private final GraphType getRowGraphType(GitRebaseCommitsTableView table2, int row) {
        GitRebaseTodoModel.Element<?> element = table2.getModel().getElement(row);
        return element instanceof GitRebaseTodoModel.Element.UniteChild ? (GraphType)new GraphType.FixupGraph(table2.getModel().isFirstFixup((GitRebaseTodoModel.Element.UniteChild)element), table2.getModel().isLastFixup((GitRebaseTodoModel.Element.UniteChild)element)) : (GraphType)GraphType.NoGraph.INSTANCE;
    }

    protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        if (value != null) {
            this.setBorder(null);
            this.setOpaque(false);
            GitRebaseCommitsTableView commitsTable2 = (GitRebaseCommitsTableView)((Object)table2);
            this.graphType = this.getRowGraphType(commitsTable2, row);
            this.rowHeight = table2.getRowHeight(row);
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            GitRebaseTodoModel.Element<?> element = commitsTable2.getModel().getRebaseTodoModel().getElements().get(row);
            GitRebaseTodoModel.Type type = element.getType();
            if (Intrinsics.areEqual((Object)type, (Object)GitRebaseTodoModel.Type.NonUnite.Drop.INSTANCE)) {
                attributes = new SimpleTextAttributes(4, null);
            } else if (type instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword) {
                attributes = new SimpleTextAttributes(0, (Color)JBColor.BLUE);
            } else if (Intrinsics.areEqual((Object)type, (Object)GitRebaseTodoModel.Type.Unite.INSTANCE)) {
                this.append("");
                this.appendTextPadding(20);
            }
            this.append(IndexedDetails.Companion.getSubject(commitsTable2.getModel().getPresentation(row)), attributes, true);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table2, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)true, (boolean)selected);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$Companion;", "", "<init>", "()V", "GRAPH_WIDTH", "", "CONNECTION_CENTER_X", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "", "<init>", "()V", "NoGraph", "FixupGraph", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$FixupGraph;", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$NoGraph;", "intellij.vcs.git"})
    private static abstract sealed class GraphType {
        private GraphType() {
        }

        public /* synthetic */ GraphType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$FixupGraph;", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "isFirst", "", "isLast", "<init>", "(ZZ)V", "()Z", "intellij.vcs.git"})
        public static final class FixupGraph
        extends GraphType {
            private final boolean isFirst;
            private final boolean isLast;

            public FixupGraph(boolean isFirst, boolean isLast) {
                super(null);
                this.isFirst = isFirst;
                this.isLast = isLast;
            }

            public final boolean isFirst() {
                return this.isFirst;
            }

            public final boolean isLast() {
                return this.isLast;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType$NoGraph;", "Lgit4idea/rebase/interactive/dialog/SubjectRenderer$GraphType;", "<init>", "()V", "intellij.vcs.git"})
        public static final class NoGraph
        extends GraphType {
            @NotNull
            public static final NoGraph INSTANCE = new NoGraph();

            private NoGraph() {
                super(null);
            }
        }
    }
}

