/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog.view;

import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.util.ArrayUtil;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lgit4idea/rebase/interactive/dialog/view/MoveTableItemRunnable;", "Lcom/intellij/ui/AnActionButtonRunnable;", "delta", "", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "<init>", "(ILgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "getDelta", "()I", "getTable", "()Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.vcs.git"})
public final class MoveTableItemRunnable
implements AnActionButtonRunnable {
    private final int delta;
    @NotNull
    private final GitRebaseCommitsTableView table;

    public MoveTableItemRunnable(int delta, @NotNull GitRebaseCommitsTableView table2) {
        Intrinsics.checkNotNullParameter((Object)((Object)table2), (String)"table");
        this.delta = delta;
        this.table = table2;
    }

    public final int getDelta() {
        return this.delta;
    }

    @NotNull
    public final GitRebaseCommitsTableView getTable() {
        return this.table;
    }

    public void run(@NotNull AnActionButton button2) {
        int newEditingRow;
        Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
        int row = this.table.getEditingRow();
        int col = this.table.getEditingColumn();
        int rowCount = this.table.getModel().getRowCount();
        TableUtil.stopEditing((JTable)((JTable)((Object)this.table)));
        int[] nArray = this.table.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        int[] idx = nArray;
        Arrays.sort(idx);
        if (this.delta > 0) {
            int[] nArray2 = ArrayUtil.reverseArray((int[])idx);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"reverseArray(...)");
            idx = nArray2;
        }
        if (idx.length == 0) {
            return;
        }
        if (idx[0] + this.delta < 0) {
            return;
        }
        if (idx[idx.length - 1] + this.delta > rowCount) {
            return;
        }
        List elementsToSelect = new ArrayList();
        for (int i : idx) {
            elementsToSelect.add(this.table.getModel().getElement(i).getEntry());
            this.table.getModel().exchangeRows(i, i + this.delta);
        }
        List indexesToSelect = new ArrayList();
        int n = this.table.getModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!elementsToSelect.contains(this.table.getModel().getElement(i).getEntry())) continue;
            indexesToSelect.add(i);
        }
        TableUtil.selectRows((JTable)((JTable)((Object)this.table)), (int[])CollectionsKt.toIntArray((Collection)indexesToSelect));
        TableUtil.scrollSelectionToVisible((JTable)((JTable)((Object)this.table)));
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> MoveTableItemRunnable.run$lambda$0(this));
        if (row != -1 && col != -1 && (newEditingRow = row + this.delta) != -1 && newEditingRow < rowCount) {
            this.table.editCellAt(newEditingRow, col);
        }
    }

    private static final void run$lambda$0(MoveTableItemRunnable this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this$0.table), true);
    }
}

