/*
 * Decompiled with CFR 0.152.
 */
package git4idea.troubleshooting;

import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettingType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsSharedProjectSettings;
import com.intellij.troubleshooting.TroubleInfoCollector;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.troubleshooting.GitConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b*\u00060\u000fj\u0002`\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b*\u00060\u000fj\u0002`\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\b*\u00060\u000fj\u0002`\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\b*\u00060\u000fj\u0002`\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\b*\u00060\u000fj\u0002`\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J5\u0010\u0015\u001a\u00020\b*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0016\u001a\u00020\n2\u001b\u0010\u0017\u001a\u0017\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020\b0\u0018\u00a2\u0006\u0002\b\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\b*\u00060\u000fj\u0002`\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/troubleshooting/GitTroubleInfoCollector;", "Lcom/intellij/troubleshooting/TroubleInfoCollector;", "Lcom/intellij/openapi/extensions/PluginAware;", "<init>", "()V", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "setPluginDescriptor", "", "collectInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "toString", "writePathAndVersion", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "writeMappings", "writeModifiedGitAdvancedSettings", "writeSettings", "writeGitConfig", "section", "name", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeGitReposStats", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitTroubleInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitTroubleInfoCollector.kt\ngit4idea/troubleshooting/GitTroubleInfoCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,178:1\n1563#2:179\n1634#2,2:180\n1636#2:183\n1869#2,2:186\n1#3:182\n216#4,2:184\n*S KotlinDebug\n*F\n+ 1 GitTroubleInfoCollector.kt\ngit4idea/troubleshooting/GitTroubleInfoCollector\n*L\n53#1:179\n53#1:180,2\n53#1:183\n117#1:186,2\n103#1:184,2\n*E\n"})
public final class GitTroubleInfoCollector
implements TroubleInfoCollector,
PluginAware {
    private PluginDescriptor pluginDescriptor;

    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        this.pluginDescriptor = pluginDescriptor;
    }

    @NotNull
    public String collectInfo(@NotNull Project project) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StringBuilder $this$collectInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.writePathAndVersion($this$collectInfo_u24lambda_u240, project);
        this.writeSettings($this$collectInfo_u24lambda_u240);
        this.writeGitConfig($this$collectInfo_u24lambda_u240, project);
        this.writeModifiedGitAdvancedSettings($this$collectInfo_u24lambda_u240);
        this.writeMappings($this$collectInfo_u24lambda_u240, project);
        this.writeGitReposStats($this$collectInfo_u24lambda_u240, project);
        return stringBuilder.toString();
    }

    @NotNull
    public String toString() {
        return "Git";
    }

    private final void writePathAndVersion(StringBuilder $this$writePathAndVersion, Project project) {
        GitExecutableManager executableManager = GitExecutableManager.getInstance();
        String string = executableManager.getPathToGit(project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathToGit(...)");
        String pathToGit = string;
        GitVersion gitVersion = executableManager.getVersion(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"getVersion(...)");
        GitVersion version = gitVersion;
        this.section($this$writePathAndVersion, "Git executable", (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> GitTroubleInfoCollector.writePathAndVersion$lambda$0(pathToGit, version, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void writeMappings(StringBuilder $this$writeMappings, Project project) {
        void $this$mapTo$iv$iv;
        boolean mappingAutoDetection = VcsSharedProjectSettings.Companion.getInstance(project).isDetectVcsMappingsAutomatically();
        Iterable $this$map$iv = ProjectLevelVcsManager.Companion.getInstance(project).getDirectoryMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CharSequence charSequence;
            CharSequence charSequence2;
            void it;
            VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence3 = it.getVcs();
            if (charSequence3.length() == 0) {
                boolean bl2 = false;
                charSequence2 = "No VCS";
            } else {
                charSequence2 = charSequence3;
            }
            charSequence3 = it.getDirectory();
            if (charSequence3.length() == 0) {
                CharSequence charSequence4 = charSequence2;
                boolean bl3 = false;
                charSequence = "<default>";
                charSequence2 = charSequence4;
            } else {
                charSequence = charSequence3;
            }
            collection.add(charSequence2 + " -> " + charSequence);
        }
        List mappings = (List)destination$iv$iv;
        this.section($this$writeMappings, "VCS mappings", (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> GitTroubleInfoCollector.writeMappings$lambda$1(mappingAutoDetection, mappings, arg_0)));
    }

    private final void writeModifiedGitAdvancedSettings(StringBuilder $this$writeModifiedGitAdvancedSettings) {
        List customAdvancedSettings = new ArrayList();
        AdvancedSettingBean.EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> GitTroubleInfoCollector.writeModifiedGitAdvancedSettings$lambda$0(this, $this$writeModifiedGitAdvancedSettings, customAdvancedSettings, arg_0, arg_1));
        if (!((Collection)customAdvancedSettings).isEmpty()) {
            this.section($this$writeModifiedGitAdvancedSettings, "Advanced settings", (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> GitTroubleInfoCollector.writeModifiedGitAdvancedSettings$lambda$1(customAdvancedSettings, arg_0)));
        }
    }

    private final void writeSettings(StringBuilder $this$writeSettings) {
        GitVcsApplicationSettings applicationSettings = GitVcsApplicationSettings.getInstance();
        this.section($this$writeSettings, "Settings", (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> GitTroubleInfoCollector.writeSettings$lambda$0(applicationSettings, arg_0)));
    }

    private final void writeGitConfig(StringBuilder $this$writeGitConfig, Project project) {
        Map<String, String> map2 = GitConfigHelper.INSTANCE.readGitConfig(project);
        if (map2 == null) {
            return;
        }
        Map<String, String> config = map2;
        this.section($this$writeGitConfig, "Git config", (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> GitTroubleInfoCollector.writeGitConfig$lambda$0(config, arg_0)));
    }

    private final void section(StringBuilder $this$section, String name, Function1<? super StringBuilder, Unit> block) {
        $this$section.append("==== " + name + " ====").append('\n');
        block.invoke((Object)$this$section);
        $this$section.append("\n").append('\n');
    }

    private final void writeGitReposStats(StringBuilder $this$writeGitReposStats, Project project) {
        this.section($this$writeGitReposStats, "Git repositories stats", (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> GitTroubleInfoCollector.writeGitReposStats$lambda$0(project, arg_0)));
    }

    private static final Unit writePathAndVersion$lambda$0(String $pathToGit, GitVersion $version, StringBuilder $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"$this$section");
        $this$section.append("Path: " + $pathToGit).append('\n');
        $this$section.append("Version: " + $version).append('\n');
        return Unit.INSTANCE;
    }

    private static final Unit writeMappings$lambda$1(boolean $mappingAutoDetection, List $mappings, StringBuilder $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"$this$section");
        $this$section.append("Auto-detection: " + $mappingAutoDetection).append('\n');
        $this$section.append("Mappings (total " + $mappings.size() + "):").append('\n');
        $this$section.append(CollectionsKt.joinToString$default((Iterable)$mappings, (CharSequence)"\n", null, null, (int)0, null, GitTroubleInfoCollector::writeMappings$lambda$1$0, (int)30, null)).append('\n');
        return Unit.INSTANCE;
    }

    private static final CharSequence writeMappings$lambda$1$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + it;
    }

    private static final Unit writeModifiedGitAdvancedSettings$lambda$0(GitTroubleInfoCollector this$0, StringBuilder $this_writeModifiedGitAdvancedSettings, List $customAdvancedSettings, AdvancedSettingBean bean, PluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PluginDescriptor pluginDescriptor = this$0.pluginDescriptor;
        if (pluginDescriptor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginDescriptor");
            pluginDescriptor = null;
        }
        if (Intrinsics.areEqual((Object)pluginDescriptor, (Object)descriptor)) {
            Object object;
            switch (WhenMappings.$EnumSwitchMapping$0[bean.type().ordinal()]) {
                case 1: {
                    object = AdvancedSettings.Companion.getInt(bean.id);
                    break;
                }
                case 2: {
                    object = AdvancedSettings.Companion.getBoolean(bean.id);
                    break;
                }
                case 3: {
                    object = AdvancedSettings.Companion.getString(bean.id);
                    break;
                }
                case 4: {
                    Object object2;
                    Object object3 = $this_writeModifiedGitAdvancedSettings;
                    try {
                        StringBuilder $this$writeModifiedGitAdvancedSettings_u24lambda_u240_u240 = object3;
                        boolean bl = false;
                        Class<?> clazz = descriptor.getClassLoader().loadClass(bean.enumClass);
                        object2 = Result.constructor-impl(clazz instanceof Class ? clazz : null);
                    }
                    catch (Throwable throwable) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object3 = object2;
                    Class clazz = (Class)(Result.isFailure-impl((Object)object3) ? null : object3);
                    if (clazz == null) {
                        return Unit.INSTANCE;
                    }
                    Class enumClass = clazz;
                    object = AdvancedSettings.Companion.getEnum(bean.id, enumClass);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Object value = object;
            if (!Intrinsics.areEqual((Object)value, (Object)bean.getDefaultValueObject())) {
                $customAdvancedSettings.add(bean.id + "=" + value);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeModifiedGitAdvancedSettings$lambda$1(List $customAdvancedSettings, StringBuilder $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"$this$section");
        $this$section.append(CollectionsKt.joinToString$default((Iterable)$customAdvancedSettings, (CharSequence)"\n", null, null, (int)0, null, GitTroubleInfoCollector::writeModifiedGitAdvancedSettings$lambda$1$0, (int)30, null)).append('\n');
        return Unit.INSTANCE;
    }

    private static final CharSequence writeModifiedGitAdvancedSettings$lambda$1$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + it;
    }

    private static final Unit writeSettings$lambda$0(GitVcsApplicationSettings $applicationSettings, StringBuilder $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"$this$section");
        $this$section.append("Credential helper: " + $applicationSettings.isUseCredentialHelper()).append('\n');
        return Unit.INSTANCE;
    }

    private static final Unit writeGitConfig$lambda$0(Map $config, StringBuilder $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"$this$section");
        Map<String, String> $this$forEach$iv = GitConfigHelper.INSTANCE.filter($config);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String k = entry.getKey();
            String v = entry.getValue();
            $this$section.append("  " + k + "=" + v).append('\n');
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeGitReposStats$lambda$0(Project $project, StringBuilder $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"$this$section");
        List<GitRepository> list = GitRepositoryManager.getInstance($project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            int tags = it.getTagHolder().getTags().size();
            int remoteBranches = it.getBranches().getRemoteBranches().size();
            int localBranches = it.getBranches().getLocalBranches().size();
            $this$section.append(it.getRoot().getName() + ": " + localBranches + " branches, " + remoteBranches + " remote branches, " + tags + " tags").append('\n');
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdvancedSettingType.values().length];
            try {
                nArray[AdvancedSettingType.Int.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedSettingType.Bool.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedSettingType.String.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedSettingType.Enum.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

