/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitRevisionNumber;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLogKt;
import git4idea.update.GitUpdateProjectInfoLogProperties;
import git4idea.update.HashRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u000589:;<B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0002J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0003\u00a2\u0006\u0002\u0010\u0013J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0003J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020$H\u0002J$\u0010)\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010*\u001a\u00060+R\u00020\u00002\u0006\u0010%\u001a\u00020\rH\u0002J\b\u00100\u001a\u00020/H\u0002J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020/H\u0002J\b\u00103\u001a\u00020\u0012H\u0002J\b\u00104\u001a\u00020\u0012H\u0002J\"\u00105\u001a\u00020\u00122\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001207H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lgit4idea/update/GitUpdateInfoAsLog;", "", "project", "Lcom/intellij/openapi/project/Project;", "ranges", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/update/HashRange;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "projectLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "notificationShown", "", "calculateDataAndCreateLogTab", "Lgit4idea/update/GitUpdateInfoAsLog$NotificationData;", "isPathFilterSet", "waitForLogRefreshAndCalculate", "", "()Ljava/lang/Integer;", "createLogTabAndCalculateIfRangesAreReachable", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "dataSupplier", "Ljava/util/concurrent/CompletableFuture;", "listener", "Lcom/intellij/vcs/log/data/DataPackChangeListener;", "areRangesInDataPack", "log", "calculateDataFromGit", "Lgit4idea/update/GitUpdateInfoAsLog$CommitsAndFiles;", "findOrCreateLogUi", "rangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "select", "getViewCommitsAction", "Ljava/lang/Runnable;", "createRangeFilter", "createLogUi", "logUiFactory", "Lgit4idea/update/GitUpdateInfoAsLog$MyLogUiFactory;", "tabGroupId", "Lcom/intellij/ui/content/TabGroupId;", "updateTabPrefix", "", "generateUpdateTabId", "isUpdateTabId", "id", "calcUpdatedCommitsCount", "calcUpdatedFilesCount", "calcCount", "sizeForRepo", "Lkotlin/Function2;", "NotificationData", "CommitsAndFiles", "MyLogUiFactory", "MyPropertiesForRange", "MyVisiblePackChangeListener", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUpdateInfoAsLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateInfoAsLog.kt\ngit4idea/update/GitUpdateInfoAsLog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n30#2,2:277\n1563#3:279\n1634#3,3:280\n1563#3:283\n1634#3,3:284\n*S KotlinDebug\n*F\n+ 1 GitUpdateInfoAsLog.kt\ngit4idea/update/GitUpdateInfoAsLog\n*L\n90#1:277,2\n132#1:279\n132#1:280,3\n168#1:283\n168#1:284,3\n*E\n"})
public final class GitUpdateInfoAsLog {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GitRepository, HashRange> ranges;
    @NotNull
    private final VcsProjectLog projectLog;
    private boolean notificationShown;
    @NotNull
    private final TabGroupId tabGroupId;
    @NotNull
    private final String updateTabPrefix;

    public GitUpdateInfoAsLog(@NotNull Project project, @NotNull Map<GitRepository, HashRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.project = project;
        this.ranges = ranges;
        this.projectLog = VcsProjectLog.Companion.getInstance(this.project);
        Supplier supplier = VcsBundle.messagePointer((String)"vcs.update.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        this.tabGroupId = new TabGroupId("Update Info", supplier, false, 4, null);
        this.updateTabPrefix = "git-update-project-info-";
    }

    @RequiresBackgroundThread
    @Nullable
    public final NotificationData calculateDataAndCreateLogTab() {
        CommitsAndFiles commitsAndFiles = this.calculateDataFromGit();
        if (commitsAndFiles == null) {
            return null;
        }
        CommitsAndFiles commitsAndFiles2 = commitsAndFiles;
        if (!VcsProjectLog.Companion.ensureLogCreated(this.project)) {
            return null;
        }
        VcsLogRangeFilter rangeFilter = this.createRangeFilter();
        if (!AdvancedSettings.Companion.getBoolean("git.update.info.auto.open.enabled")) {
            return new NotificationData(commitsAndFiles2.getUpdatedFilesCount(), commitsAndFiles2.getReceivedCommitsCount(), null, this.getViewCommitsAction(rangeFilter), this.ranges);
        }
        if (this.isPathFilterSet()) {
            Integer n = this.waitForLogRefreshAndCalculate();
            if (n == null) {
                return null;
            }
            int commitCount = n;
            return new NotificationData(commitsAndFiles2.getUpdatedFilesCount(), commitsAndFiles2.getReceivedCommitsCount(), commitCount, this.getViewCommitsAction(rangeFilter), this.ranges);
        }
        ActionsKt.runInEdt$default(null, () -> GitUpdateInfoAsLog.calculateDataAndCreateLogTab$lambda$0(this, rangeFilter), (int)1, null);
        return new NotificationData(commitsAndFiles2.getUpdatedFilesCount(), commitsAndFiles2.getReceivedCommitsCount(), null, this.getViewCommitsAction(rangeFilter), this.ranges);
    }

    private final boolean isPathFilterSet() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitUpdateProjectInfoLogProperties> serviceClass$iv = GitUpdateProjectInfoLogProperties.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitUpdateProjectInfoLogProperties gitUpdateProjectInfoLogProperties = (GitUpdateProjectInfoLogProperties)((Object)object);
        String string = VcsLogFilterCollection.STRUCTURE_FILTER.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return gitUpdateProjectInfoLogProperties.getFilterValues(string) != null;
    }

    @RequiresBackgroundThread
    private final Integer waitForLogRefreshAndCalculate() {
        CompletableFuture dataSupplier = new CompletableFuture();
        ActionsKt.runInEdt$default(null, () -> GitUpdateInfoAsLog.waitForLogRefreshAndCalculate$lambda$0(this, dataSupplier), (int)1, null);
        ProgressIndicatorUtils.awaitWithCheckCanceled((Future)dataSupplier);
        return (Integer)dataSupplier.get();
    }

    @RequiresEdt
    private final void createLogTabAndCalculateIfRangesAreReachable(DataPack dataPack, VcsLogManager logManager, CompletableFuture<Integer> dataSupplier, DataPackChangeListener listener2) {
        if (!this.notificationShown && this.areRangesInDataPack(this.projectLog, dataPack)) {
            this.notificationShown = true;
            VcsLogData vcsLogData = this.projectLog.getDataManager();
            if (vcsLogData != null) {
                vcsLogData.removeDataPackChangeListener(listener2);
            }
            VcsLogColorManager vcsLogColorManager = logManager.getColorManager();
            VcsLogRangeFilter vcsLogRangeFilter = this.createRangeFilter();
            MyLogUiFactory logUiFactory2 = new MyLogUiFactory(this, dataSupplier, vcsLogColorManager, vcsLogRangeFilter){
                final /* synthetic */ GitUpdateInfoAsLog this$0;
                final /* synthetic */ CompletableFuture<Integer> $dataSupplier;
                {
                    this.this$0 = $receiver;
                    this.$dataSupplier = $dataSupplier;
                    super($super_call_param$1, $super_call_param$2);
                }

                public MainVcsLogUi createLogUi(Project project, VcsLogData logData) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
                    MainVcsLogUi logUi = super.createLogUi(project, logData);
                    logUi.getRefresher().addVisiblePackChangeListener((VisiblePackChangeListener)this.this$0.new MyVisiblePackChangeListener(logUi, this.$dataSupplier));
                    return logUi;
                }
            };
            this.createLogUi(logManager, logUiFactory2, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areRangesInDataPack(VcsProjectLog log, DataPack dataPack) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.ranges.entrySet();
        DataPack dataPack2 = dataPack;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CommitId(((HashRange)it.getValue()).getEnd(), ((GitRepository)it.getKey()).getRoot()));
        }
        Collection collection = (List)destination$iv$iv;
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        return DataPackUtilKt.containsAll((DataPack)dataPack2, (Collection)collection, (VcsLogStorage)vcsLogData.getStorage());
    }

    private final CommitsAndFiles calculateDataFromGit() {
        int updatedCommitsCount = this.calcUpdatedCommitsCount();
        if (updatedCommitsCount == 0) {
            return null;
        }
        int updatedFilesCount = this.calcUpdatedFilesCount();
        return new CommitsAndFiles(updatedFilesCount, updatedCommitsCount);
    }

    private final void findOrCreateLogUi(VcsLogRangeFilter rangeFilter, boolean select) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VcsLogManager logManager = this.projectLog.getLogManager();
        if (logManager == null) {
            if (select) {
                VcsLogContentUtil.INSTANCE.showLogIsNotAvailableMessage(this.project);
            }
            return;
        }
        VcsLogUiEx logUi = (VcsLogUiEx)VcsLogContentUtil.INSTANCE.findLogUi(this.project, VcsLogUiEx.class, select, arg_0 -> GitUpdateInfoAsLog.findOrCreateLogUi$lambda$0(this, rangeFilter, arg_0));
        if (logUi != null) {
            return;
        }
        this.createLogUi(logManager, new MyLogUiFactory(logManager.getColorManager(), rangeFilter), select);
    }

    private final Runnable getViewCommitsAction(VcsLogRangeFilter rangeFilter) {
        return () -> GitUpdateInfoAsLog.getViewCommitsAction$lambda$0(this, rangeFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final VcsLogRangeFilter createRangeFilter() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.ranges.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HashRange hashRange = (HashRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getStart().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String string2 = it.getEnd().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            collection.add(new VcsLogRangeFilter.RefRange(string, string2));
        }
        return VcsLogFilterObject.fromRange((List)((List)destination$iv$iv));
    }

    private final void createLogUi(VcsLogManager logManager, MyLogUiFactory logUiFactory2, boolean select) {
        String string = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String tabName = string;
        MainVcsLogUi ui2 = (MainVcsLogUi)logManager.createLogUi((VcsLogManager.VcsLogUiFactory)logUiFactory2);
        VcsLogContentUtil.openLogTab((Project)this.project, (VcsLogManager)logManager, (TabGroupId)this.tabGroupId, (VcsLogUiEx)((VcsLogUiEx)ui2), arg_0 -> GitUpdateInfoAsLog.createLogUi$lambda$0(tabName, arg_0), (boolean)select);
    }

    private final String generateUpdateTabId() {
        return this.updateTabPrefix + UUID.randomUUID();
    }

    private final boolean isUpdateTabId(String id) {
        return StringsKt.startsWith$default((String)id, (String)this.updateTabPrefix, (boolean)false, (int)2, null);
    }

    private final int calcUpdatedCommitsCount() {
        return this.calcCount((Function2<? super GitRepository, ? super HashRange, Integer>)((Function2)(arg_0, arg_1) -> GitUpdateInfoAsLog.calcUpdatedCommitsCount$lambda$0(this, arg_0, arg_1)));
    }

    private final int calcUpdatedFilesCount() {
        return this.calcCount((Function2<? super GitRepository, ? super HashRange, Integer>)((Function2)(arg_0, arg_1) -> GitUpdateInfoAsLog.calcUpdatedFilesCount$lambda$0(this, arg_0, arg_1)));
    }

    private final int calcCount(Function2<? super GitRepository, ? super HashRange, Integer> sizeForRepo) {
        int result2 = 0;
        for (Map.Entry<GitRepository, HashRange> entry : this.ranges.entrySet()) {
            GitRepository repository2 = entry.getKey();
            HashRange range = entry.getValue();
            try {
                result2 += ((Number)sizeForRepo.invoke((Object)repository2, (Object)range)).intValue();
            }
            catch (VcsException e) {
                GitUpdateInfoAsLogKt.access$getLOG$p().warn("Couldn't collect commits in root " + repository2.getRoot() + " in range " + range, (Throwable)e);
            }
        }
        return result2;
    }

    private static final Unit calculateDataAndCreateLogTab$lambda$0(GitUpdateInfoAsLog this$0, VcsLogRangeFilter $rangeFilter) {
        this$0.findOrCreateLogUi($rangeFilter, false);
        return Unit.INSTANCE;
    }

    private static final Unit waitForLogRefreshAndCalculate$lambda$0(GitUpdateInfoAsLog this$0, CompletableFuture $dataSupplier) {
        VcsLogManager vcsLogManager = this$0.projectLog.getLogManager();
        if (vcsLogManager != null) {
            VcsLogManager logManager = vcsLogManager;
            boolean bl = false;
            DataPackChangeListener listener2 = new DataPackChangeListener(this$0, logManager, $dataSupplier){
                final /* synthetic */ GitUpdateInfoAsLog this$0;
                final /* synthetic */ VcsLogManager $logManager;
                final /* synthetic */ CompletableFuture<Integer> $dataSupplier;
                {
                    this.this$0 = $receiver;
                    this.$logManager = $logManager;
                    this.$dataSupplier = $dataSupplier;
                }

                public void onDataPackChange(DataPack dataPack) {
                    Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
                    GitUpdateInfoAsLog.access$createLogTabAndCalculateIfRangesAreReachable(this.this$0, dataPack, this.$logManager, this.$dataSupplier, this);
                }
            };
            logManager.getDataManager().addDataPackChangeListener(listener2);
            this$0.createLogTabAndCalculateIfRangesAreReachable(logManager.getDataManager().getDataPack(), logManager, $dataSupplier, listener2);
        } else {
            $dataSupplier.complete(null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean findOrCreateLogUi$lambda$0(GitUpdateInfoAsLog this$0, VcsLogRangeFilter $rangeFilter, VcsLogUiEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return this$0.isUpdateTabId(string) && Intrinsics.areEqual((Object)it.getFilterUi().getFilters().get(VcsLogFilterCollection.RANGE_FILTER), (Object)$rangeFilter);
    }

    private static final void getViewCommitsAction$lambda$0(GitUpdateInfoAsLog this$0, VcsLogRangeFilter $rangeFilter) {
        this$0.findOrCreateLogUi($rangeFilter, true);
    }

    private static final String createLogUi$lambda$0(String $tabName, MainVcsLogUi it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $tabName;
    }

    private static final int calcUpdatedCommitsCount$lambda$0(GitUpdateInfoAsLog this$0, GitRepository repository2, HashRange range) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String[] stringArray = new String[]{range.getStart().asString() + ".." + range.getEnd().asString()};
        return GitHistoryUtils.collectTimedCommits(this$0.project, repository2.getRoot(), stringArray).size();
    }

    private static final int calcUpdatedFilesCount$lambda$0(GitUpdateInfoAsLog this$0, GitRepository repository2, HashRange range) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new MergeChangeCollector(this$0.project, repository2, new GitRevisionNumber(range.getStart().asString())).calcUpdatedFilesCount();
    }

    public static final /* synthetic */ void access$createLogTabAndCalculateIfRangesAreReachable(GitUpdateInfoAsLog $this, DataPack dataPack, VcsLogManager logManager, CompletableFuture dataSupplier, DataPackChangeListener listener2) {
        $this.createLogTabAndCalculateIfRangesAreReachable(dataPack, logManager, dataSupplier, listener2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lgit4idea/update/GitUpdateInfoAsLog$CommitsAndFiles;", "", "updatedFilesCount", "", "receivedCommitsCount", "<init>", "(II)V", "getUpdatedFilesCount", "()I", "getReceivedCommitsCount", "intellij.vcs.git"})
    private static final class CommitsAndFiles {
        private final int updatedFilesCount;
        private final int receivedCommitsCount;

        public CommitsAndFiles(int updatedFilesCount, int receivedCommitsCount) {
            this.updatedFilesCount = updatedFilesCount;
            this.receivedCommitsCount = receivedCommitsCount;
        }

        public final int getUpdatedFilesCount() {
            return this.updatedFilesCount;
        }

        public final int getReceivedCommitsCount() {
            return this.receivedCommitsCount;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lgit4idea/update/GitUpdateInfoAsLog$MyLogUiFactory;", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "rangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "<init>", "(Lgit4idea/update/GitUpdateInfoAsLog;Lcom/intellij/vcs/log/ui/VcsLogColorManager;Lcom/intellij/vcs/log/VcsLogRangeFilter;)V", "getColorManager", "()Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "getRangeFilter", "()Lcom/intellij/vcs/log/VcsLogRangeFilter;", "createLogUi", "project", "Lcom/intellij/openapi/project/Project;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitUpdateInfoAsLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateInfoAsLog.kt\ngit4idea/update/GitUpdateInfoAsLog$MyLogUiFactory\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,276:1\n30#2,2:277\n*S KotlinDebug\n*F\n+ 1 GitUpdateInfoAsLog.kt\ngit4idea/update/GitUpdateInfoAsLog$MyLogUiFactory\n*L\n188#1:277,2\n*E\n"})
    private class MyLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<MainVcsLogUi> {
        @NotNull
        private final VcsLogColorManager colorManager;
        @NotNull
        private final VcsLogRangeFilter rangeFilter;

        public MyLogUiFactory(@NotNull VcsLogColorManager colorManager, VcsLogRangeFilter rangeFilter) {
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            Intrinsics.checkNotNullParameter((Object)rangeFilter, (String)"rangeFilter");
            this.colorManager = colorManager;
            this.rangeFilter = rangeFilter;
        }

        @NotNull
        public final VcsLogColorManager getColorManager() {
            return this.colorManager;
        }

        @NotNull
        public final VcsLogRangeFilter getRangeFilter() {
            return this.rangeFilter;
        }

        @NotNull
        public MainVcsLogUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            String logId = GitUpdateInfoAsLog.this.generateUpdateTabId();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitUpdateProjectInfoLogProperties> serviceClass$iv = GitUpdateProjectInfoLogProperties.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            MyPropertiesForRange properties = new MyPropertiesForRange(this.rangeFilter, (GitUpdateProjectInfoLogProperties)((Object)object));
            VcsLogFiltererImpl vcsLogFilterer = new VcsLogFiltererImpl(logData);
            VcsLogUiProperties.VcsLogUiProperty vcsLogUiProperty = MainVcsLogUiProperties.GRAPH_OPTIONS;
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperty, (String)"GRAPH_OPTIONS");
            PermanentGraph.Options initialGraphOptions = (PermanentGraph.Options)properties.get(vcsLogUiProperty);
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{this.rangeFilter};
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray), initialGraphOptions, (VcsLogFilterer)vcsLogFilterer, logId);
            return (MainVcsLogUi)new VcsLogUiImpl(logId, logData, this.colorManager, (MainVcsLogUiProperties)properties, (VisiblePackRefresher)refresher, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000e2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000fH\u0016J\u0011\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0097\u0001J\u0019\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0097\u0001Jb\u0010\u001d\u001a\u00020\u00162\u0017\b\u0001\u0010\u001e\u001a\u00110\u000e\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\b \u00a2\u0006\u0002\b!2>\b\u0001\u0010\"\u001a8\u0012\f\u0012\n $*\u0004\u0018\u00010\u000e0\u000e $*\u001a\u0012\f\u0012\n $*\u0004\u0018\u00010\u000e0\u000e0%\u00a2\u0006\u0002\b \u00a2\u0006\u0002\b!0#\u00a2\u0006\u0002\b \u00a2\u0006\u0002\b!H\u0096\u0001J#\u0010&\u001a\u00020\u0011\"\n\b\u0000\u0010'*\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0096\u0001J(\u0010+\u001a\u0002H'\"\n\b\u0000\u0010'*\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0097\u0003\u00a2\u0006\u0002\u0010,J\u0090\u0001\u0010-\u001ap\u0012(\u0012&\u0012\f\u0012\n $*\u0004\u0018\u00010\u000e0\u000e $*\u0012\u0012\f\u0012\n $*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0. $*6\u0012(\u0012&\u0012\f\u0012\n $*\u0004\u0018\u00010\u000e0\u000e $*\u0012\u0012\f\u0012\n $*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0.0\u000f\u00a2\u0006\u0002\b \u00a2\u0006\u0002\b!0.\u00a2\u0006\u0002\b \u00a2\u0006\u0002\b!2\u0017\b\u0001\u0010\u001e\u001a\u00110\u000e\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\b \u00a2\u0006\u0002\b!H\u0097\u0001J\u0011\u0010/\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0097\u0001J0\u00100\u001a\u00020\u0016\"\n\b\u0000\u0010'*\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*2\u0006\u00101\u001a\u0002H'H\u0097\u0003\u00a2\u0006\u0002\u00102R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lgit4idea/update/GitUpdateInfoAsLog$MyPropertiesForRange;", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "rangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "mainProperties", "Lgit4idea/update/GitUpdateProjectInfoLogProperties;", "<init>", "(Lcom/intellij/vcs/log/VcsLogRangeFilter;Lgit4idea/update/GitUpdateProjectInfoLogProperties;)V", "getRangeFilter", "()Lcom/intellij/vcs/log/VcsLogRangeFilter;", "getMainProperties", "()Lgit4idea/update/GitUpdateProjectInfoLogProperties;", "filters", "", "", "", "explicitlyRemovedPathsFilter", "", "getFilterValues", "filterName", "getPathsFilterValues", "saveFilterValues", "", "values", "addChangeListener", "listener", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$PropertiesChangeListener;", "parent", "Lcom/intellij/openapi/Disposable;", "addRecentlyFilteredGroup", "p0", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "p1", "", "kotlin.jvm.PlatformType", "", "exists", "T", "", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "get", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;)Ljava/lang/Object;", "getRecentlyFilteredGroups", "", "removeChangeListener", "set", "value", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;Ljava/lang/Object;)V", "intellij.vcs.git"})
    private static final class MyPropertiesForRange
    implements MainVcsLogUiProperties {
        @NotNull
        private final VcsLogRangeFilter rangeFilter;
        @NotNull
        private final GitUpdateProjectInfoLogProperties mainProperties;
        @NotNull
        private final Map<String, List<String>> filters;
        private boolean explicitlyRemovedPathsFilter;

        public MyPropertiesForRange(@NotNull VcsLogRangeFilter rangeFilter, @NotNull GitUpdateProjectInfoLogProperties mainProperties) {
            Intrinsics.checkNotNullParameter((Object)rangeFilter, (String)"rangeFilter");
            Intrinsics.checkNotNullParameter((Object)((Object)mainProperties), (String)"mainProperties");
            this.rangeFilter = rangeFilter;
            this.mainProperties = mainProperties;
            this.filters = new LinkedHashMap();
        }

        @NotNull
        public final VcsLogRangeFilter getRangeFilter() {
            return this.rangeFilter;
        }

        @NotNull
        public final GitUpdateProjectInfoLogProperties getMainProperties() {
            return this.mainProperties;
        }

        @Nullable
        public List<String> getFilterValues(@NotNull String filterName) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            String string = filterName;
            if (Intrinsics.areEqual((Object)string, (Object)VcsLogFilterCollection.RANGE_FILTER.getName())) {
                return new ArrayList(this.rangeFilter.getTextPresentation());
            }
            if (Intrinsics.areEqual((Object)string, (Object)VcsLogFilterCollection.STRUCTURE_FILTER.getName()) || Intrinsics.areEqual((Object)string, (Object)VcsLogFilterCollection.ROOT_FILTER.getName())) {
                return this.getPathsFilterValues(filterName);
            }
            return this.filters.get(filterName);
        }

        private final List<String> getPathsFilterValues(String filterName) {
            if (this.explicitlyRemovedPathsFilter) {
                return null;
            }
            List list = this.filters.get(filterName);
            if (list == null) {
                list = this.mainProperties.getFilterValues(filterName);
            }
            return list;
        }

        public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            if (values != null) {
                this.filters.put(filterName, values);
            } else {
                this.filters.remove(filterName);
            }
            if (Intrinsics.areEqual((Object)filterName, (Object)VcsLogFilterCollection.STRUCTURE_FILTER.getName()) || Intrinsics.areEqual((Object)filterName, (Object)VcsLogFilterCollection.ROOT_FILTER.getName())) {
                this.explicitlyRemovedPathsFilter = values == null;
            }
        }

        public void addRecentlyFilteredGroup(@NonNls @NotNull String p0, @NotNull Collection<String> p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter(p1, (String)"p1");
            this.mainProperties.addRecentlyFilteredGroup(p0, p1);
        }

        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NonNls @NotNull String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            List<List<String>> list = this.mainProperties.getRecentlyFilteredGroups(p0);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRecentlyFilteredGroups(...)");
            return list;
        }

        @RequiresEdt
        public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return (T)this.mainProperties.get(property);
        }

        @RequiresEdt
        public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, T value) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            this.mainProperties.set(property, value);
        }

        public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return this.mainProperties.exists(property);
        }

        @RequiresEdt
        public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.mainProperties.addChangeListener(listener2);
        }

        @RequiresEdt
        public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2, @NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.mainProperties.addChangeListener(listener2, parent);
        }

        @RequiresEdt
        public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.mainProperties.removeChangeListener(listener2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lgit4idea/update/GitUpdateInfoAsLog$MyVisiblePackChangeListener;", "Lcom/intellij/vcs/log/visible/VisiblePackChangeListener;", "logUi", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "dataSupplier", "Ljava/util/concurrent/CompletableFuture;", "", "<init>", "(Lgit4idea/update/GitUpdateInfoAsLog;Lcom/intellij/vcs/log/ui/MainVcsLogUi;Ljava/util/concurrent/CompletableFuture;)V", "getLogUi", "()Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "getDataSupplier", "()Ljava/util/concurrent/CompletableFuture;", "onVisiblePackChange", "", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "intellij.vcs.git"})
    private final class MyVisiblePackChangeListener
    implements VisiblePackChangeListener {
        @NotNull
        private final MainVcsLogUi logUi;
        @NotNull
        private final CompletableFuture<Integer> dataSupplier;

        public MyVisiblePackChangeListener(@NotNull MainVcsLogUi logUi, CompletableFuture<Integer> dataSupplier) {
            Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
            Intrinsics.checkNotNullParameter(dataSupplier, (String)"dataSupplier");
            this.logUi = logUi;
            this.dataSupplier = dataSupplier;
        }

        @NotNull
        public final MainVcsLogUi getLogUi() {
            return this.logUi;
        }

        @NotNull
        public final CompletableFuture<Integer> getDataSupplier() {
            return this.dataSupplier;
        }

        public void onVisiblePackChange(@NotNull VisiblePack visiblePack) {
            Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
            ActionsKt.runInEdt$default(null, () -> MyVisiblePackChangeListener.onVisiblePackChange$lambda$0(this, visiblePack), (int)1, null);
        }

        private static final Unit onVisiblePackChange$lambda$0(MyVisiblePackChangeListener this$0, VisiblePack $visiblePack) {
            if (!this$0.dataSupplier.isDone()) {
                VcsLogFilterCollection vcsLogFilterCollection = $visiblePack.getFilters();
                VcsLogFilterCollection vcsLogFilterCollection2 = this$0.logUi.getFilterUi().getFilters();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection2, (String)"getFilters(...)");
                if (GitUpdateInfoAsLogKt.access$areFiltersEqual(vcsLogFilterCollection, vcsLogFilterCollection2)) {
                    this$0.logUi.getRefresher().removeVisiblePackChangeListener((VisiblePackChangeListener)this$0);
                    this$0.dataSupplier.complete($visiblePack.getVisibleGraph().getVisibleCommitCount());
                }
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lgit4idea/update/GitUpdateInfoAsLog$NotificationData;", "", "updatedFilesCount", "", "receivedCommitsCount", "filteredCommitsCount", "viewCommitAction", "Ljava/lang/Runnable;", "ranges", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/update/HashRange;", "<init>", "(IILjava/lang/Integer;Ljava/lang/Runnable;Ljava/util/Map;)V", "getUpdatedFilesCount", "()I", "getReceivedCommitsCount", "getFilteredCommitsCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getViewCommitAction", "()Ljava/lang/Runnable;", "getRanges", "()Ljava/util/Map;", "intellij.vcs.git"})
    public static final class NotificationData {
        private final int updatedFilesCount;
        private final int receivedCommitsCount;
        @Nullable
        private final Integer filteredCommitsCount;
        @NotNull
        private final Runnable viewCommitAction;
        @NotNull
        private final Map<GitRepository, HashRange> ranges;

        public NotificationData(int updatedFilesCount, int receivedCommitsCount, @Nullable Integer filteredCommitsCount, @NotNull Runnable viewCommitAction, @NotNull Map<GitRepository, HashRange> ranges) {
            Intrinsics.checkNotNullParameter((Object)viewCommitAction, (String)"viewCommitAction");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this.updatedFilesCount = updatedFilesCount;
            this.receivedCommitsCount = receivedCommitsCount;
            this.filteredCommitsCount = filteredCommitsCount;
            this.viewCommitAction = viewCommitAction;
            this.ranges = ranges;
        }

        public final int getUpdatedFilesCount() {
            return this.updatedFilesCount;
        }

        public final int getReceivedCommitsCount() {
            return this.receivedCommitsCount;
        }

        @Nullable
        public final Integer getFilteredCommitsCount() {
            return this.filteredCommitsCount;
        }

        @NotNull
        public final Runnable getViewCommitAction() {
            return this.viewCommitAction;
        }

        @NotNull
        public final Map<GitRepository, HashRange> getRanges() {
            return this.ranges;
        }
    }
}

