/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.index.GitIndexUtil;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.repo.GitRepository;
import git4idea.util.GitTextConvMode;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitFileUtils {
    private static final Logger LOG = Logger.getInstance(GitFileUtils.class);
    public static final String READ_CONTENT_WITH = "git.read.content.with";

    private GitFileUtils() {
    }

    public static void deletePaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(1);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(2);
        }
        if (additionalOptions == null) {
            GitFileUtils.$$$reportNull$$$0(3);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(5);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(6);
        }
        if (additionalOptions == null) {
            GitFileUtils.$$$reportNull$$$0(7);
        }
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(9);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(10);
        }
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    private static void doDelete(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(12);
        }
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(13);
        }
        if (additionalOptions == null) {
            GitFileUtils.$$$reportNull$$$0(14);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RM);
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(16);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(17);
        }
        List paths = ContainerUtil.map(files, VcsUtil::getFilePath);
        GitFileUtils.deletePaths(project, root, paths, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, paths);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(19);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(20);
        }
        List paths = ContainerUtil.mapNotNull(files, VcsUtil::getFilePath);
        GitFileUtils.addPaths(project, root, paths);
    }

    public static void addFilesForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(21);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(22);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(23);
        }
        List paths = ContainerUtil.mapNotNull(files, VcsUtil::getFilePath);
        GitFileUtils.addPathsForce(project, root, paths);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> addedFiles) {
        GitRepository repository2;
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(24);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(25);
        }
        if (addedFiles == null) {
            GitFileUtils.$$$reportNull$$$0(26);
        }
        if ((repository2 = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository2.getUntrackedFilesHolder().removeUntracked(addedFiles);
    }

    private static void updateIgnoredFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> addedFiles) {
        GitRepository repository2;
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(27);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(28);
        }
        if (addedFiles == null) {
            GitFileUtils.$$$reportNull$$$0(29);
        }
        if ((repository2 = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository2.getIgnoredFilesHolder().removeIgnoredFiles(addedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> removedFiles) {
        GitRepository repository2;
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(30);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(31);
        }
        if (removedFiles == null) {
            GitFileUtils.$$$reportNull$$$0(32);
        }
        if ((repository2 = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository2.getUntrackedFilesHolder().addUntracked(removedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileReset(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> resetFiles) {
        GitRepository repository2;
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(33);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(34);
        }
        if (resetFiles == null) {
            GitFileUtils.$$$reportNull$$$0(35);
        }
        if ((repository2 = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository2.getUntrackedFilesHolder().markPossiblyUntracked(resetFiles);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(36);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(37);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(38);
        }
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> paths) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(39);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(40);
        }
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(41);
        }
        GitFileUtils.addPaths(project, root, paths, false);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(42);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(43);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(44);
        }
        GitFileUtils.addPaths(project, root, files, force, !force);
    }

    public static void addPathsToIndex(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(45);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(46);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(47);
        }
        for (FilePath filePath : files) {
            GitIndexUtil.write(project, root, filePath, new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY), false, true);
        }
        GitFileUtils.updateAndRefresh(project, root, files, false);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force, boolean filterOutIgnored) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(48);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(49);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(50);
        }
        GitFileUtils.addPaths(project, root, files, force, filterOutIgnored, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean force, boolean filterOutIgnored, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(51);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(52);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(53);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.addPathsImpl(project, root, paths, force, filterOutIgnored, additionalOptions);
        }
        GitFileUtils.updateAndRefresh(project, root, files, force);
    }

    private static void updateAndRefresh(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, boolean updateIgnoredHolders) {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(54);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(55);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(56);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
        if (updateIgnoredHolders) {
            GitFileUtils.updateIgnoredFilesHolderOnFileAdd(project, root, files);
        }
        GitIndexFileSystemRefresher.refreshFilePaths(project, files);
    }

    public static void addPathsForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(57);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(58);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(59);
        }
        GitFileUtils.addPaths(project, root, files, true, false);
    }

    private static void addPathsImpl(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, boolean force, boolean filterOutIgnored, String ... additionalOptions) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(60);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(61);
        }
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(62);
        }
        if (filterOutIgnored && (paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) {
            return;
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.ADD);
        handler.addParameters("--ignore-errors", "-A");
        if (force) {
            handler.addParameters("-f");
        }
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(63);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(64);
        }
        if (paths == null) {
            GitFileUtils.$$$reportNull$$$0(65);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output2 = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output2)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        ArrayList<String> arrayList = nonIgnoredFiles;
        if (arrayList == null) {
            GitFileUtils.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    public static void resetPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(67);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(68);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(69);
        }
        for (List filesChunk : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(filesChunk);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileReset(project, root, files);
        GitIndexFileSystemRefresher.refreshFilePaths(project, files);
    }

    public static void revertUnstagedPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(70);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(71);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(72);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHECKOUT);
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    public static void restoreStagedAndWorktree(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<FilePath> files, @NotNull String source) throws VcsException {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(73);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(74);
        }
        if (files == null) {
            GitFileUtils.$$$reportNull$$$0(75);
        }
        if (source == null) {
            GitFileUtils.$$$reportNull$$$0(76);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESTORE);
            handler.addParameters("--staged", "--worktree", "--source=" + source);
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    @RequiresBackgroundThread
    public static byte @NotNull [] getFileContent(@Nullable Project project, @NotNull VirtualFile root, @NotNull @NonNls String revisionOrBranch, @NotNull @NonNls String relativePath) throws VcsException {
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(77);
        }
        if (revisionOrBranch == null) {
            GitFileUtils.$$$reportNull$$$0(78);
        }
        if (relativePath == null) {
            GitFileUtils.$$$reportNull$$$0(79);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.CAT_FILE);
        h.setSilent(true);
        GitFileUtils.addTextConvParameters(project, h, true);
        h.addParameters(revisionOrBranch + ":" + relativePath);
        byte[] byArray = h.run();
        if (byArray == null) {
            GitFileUtils.$$$reportNull$$$0(80);
        }
        return byArray;
    }

    public static void addTextConvParameters(@Nullable Project project, @NotNull GitBinaryHandler h, boolean addp) {
        if (h == null) {
            GitFileUtils.$$$reportNull$$$0(81);
        }
        GitFileUtils.addTextConvParameters(GitExecutableManager.getInstance().tryGetVersion(project, h.getExecutable()), h, addp);
    }

    public static void addTextConvParameters(@Nullable GitVersion version, @NotNull GitBinaryHandler h, boolean addp) {
        if (h == null) {
            GitFileUtils.$$$reportNull$$$0(82);
        }
        version = (GitVersion)ObjectUtils.chooseNotNull((Object)version, (Object)GitVersion.NULL);
        GitTextConvMode mode = (GitTextConvMode)AdvancedSettings.getEnum((String)READ_CONTENT_WITH, GitTextConvMode.class);
        if (mode == GitTextConvMode.FILTERS && GitVersionSpecialty.CAT_FILE_SUPPORTS_FILTERS.existsIn(version)) {
            h.addParameters("--filters");
            return;
        }
        if (mode == GitTextConvMode.TEXTCONV && GitVersionSpecialty.CAT_FILE_SUPPORTS_TEXTCONV.existsIn(version)) {
            h.addParameters("--textconv");
            return;
        }
        if (addp) {
            h.addParameters("-p");
        }
    }

    public static void stageForCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> toAdd, @NotNull Collection<? extends FilePath> toRemove, @NotNull List<? super VcsException> exceptions) {
        if (project == null) {
            GitFileUtils.$$$reportNull$$$0(83);
        }
        if (root == null) {
            GitFileUtils.$$$reportNull$$$0(84);
        }
        if (toAdd == null) {
            GitFileUtils.$$$reportNull$$$0(85);
        }
        if (toRemove == null) {
            GitFileUtils.$$$reportNull$$$0(86);
        }
        if (exceptions == null) {
            GitFileUtils.$$$reportNull$$$0(87);
        }
        if (!toRemove.isEmpty()) {
            try {
                GitFileUtils.deletePaths(project, root, toRemove, "--ignore-unmatch", "--cached", "-r");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        }
        if (!toAdd.isEmpty()) {
            try {
                GitFileUtils.addPathsForce(project, root, toAdd);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 66, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 68: 
            case 71: 
            case 74: 
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 38: 
            case 44: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalOptions";
                break;
            }
            case 13: 
            case 41: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedFiles";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetFiles";
                break;
            }
            case 66: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitFileUtils";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionOrBranch";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitFileUtils";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeIgnoredFiles";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deletePaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteFiles";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doDelete";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deleteFilesFromCache";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addFilesForce";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateUntrackedFilesHolderOnFileAdd";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateIgnoredFilesHolderOnFileAdd";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateUntrackedFilesHolderOnFileRemove";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateUntrackedFilesHolderOnFileReset";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addPaths";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addPathsToIndex";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "updateAndRefresh";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addPathsForce";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addPathsImpl";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "excludeIgnoredFiles";
                break;
            }
            case 66: 
            case 80: {
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "resetPaths";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "revertUnstagedPaths";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "restoreStagedAndWorktree";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addTextConvParameters";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "stageForCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 66, 80 -> new IllegalStateException(string);
        };
    }
}

