/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitWorkingTree;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ!\u0010\u001b\u001a\u00020\u00172\u000b\u0010\u0018\u001a\u00070\u0007\u00a2\u0006\u0002\b\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016R\u0018\u0010\u0006\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/workingTrees/GitListWorktreeLineListener;", "Lgit4idea/commands/GitLineHandlerListener;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "currentRoot", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "badLineReported", "", "currentWorktreePath", "isFirst", "", "trees", "", "Lgit4idea/GitWorkingTree;", "getTrees", "()Ljava/util/List;", "_trees", "", "report", "", "line", "e", "Lcom/intellij/openapi/vcs/VcsException;", "onLineAvailable", "Lcom/intellij/openapi/util/NlsSafe;", "outputType", "Lcom/intellij/openapi/util/Key;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitListWorktreeLineListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitListWorktreeLineListener.kt\ngit4idea/workingTrees/GitListWorktreeLineListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n23#2:64\n23#2:65\n*S KotlinDebug\n*F\n+ 1 GitListWorktreeLineListener.kt\ngit4idea/workingTrees/GitListWorktreeLineListener\n*L\n27#1:64\n51#1:65\n*E\n"})
public final class GitListWorktreeLineListener
implements GitLineHandlerListener {
    @NotNull
    private final String currentRoot;
    private int badLineReported;
    @Nullable
    private String currentWorktreePath;
    private boolean isFirst;
    @NotNull
    private final List<GitWorkingTree> _trees;

    public GitListWorktreeLineListener(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        String string = repository2.getRoot().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.currentRoot = string;
        this.isFirst = true;
        this._trees = new ArrayList();
    }

    @NotNull
    public final List<GitWorkingTree> getTrees() {
        return (List)ExtensionsKt.toImmutableList((Iterable)this._trees);
    }

    public final void report(@NotNull String line, @Nullable VcsException e) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int n = this.badLineReported;
        this.badLineReported = n + 1;
        if (this.badLineReported < 5) {
            GitListWorktreeLineListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitListWorktreeLineListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unexpected worktree output: " + line, (Throwable)e);
        }
    }

    public static /* synthetic */ void report$default(GitListWorktreeLineListener gitListWorktreeLineListener, String string, VcsException vcsException, int n, Object object) {
        if ((n & 2) != 0) {
            vcsException = null;
        }
        gitListWorktreeLineListener.report(string, vcsException);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onLineAvailable(@NotNull String line, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (StringsKt.isBlank((CharSequence)line)) {
            return;
        }
        try {
            if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDOUT)) return;
            StringScanner scanner = new StringScanner(line);
            String string = scanner.spaceToken();
            if (string == null) {
                return;
            }
            String name = string;
            String string2 = scanner.line();
            if (string2 == null) {
                return;
            }
            String value = string2;
            switch (name) {
                case "worktree": {
                    this.currentWorktreePath = value;
                    return;
                }
                case "branch": {
                    String path = this.currentWorktreePath;
                    if (path != null) {
                        this._trees.add(new GitWorkingTree(path, value, this.isFirst, Intrinsics.areEqual((Object)path, (Object)this.currentRoot)));
                        this.isFirst = false;
                    } else {
                        GitListWorktreeLineListener $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(GitListWorktreeLineListener.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("'worktree' wasn't reported for branch " + value);
                    }
                    this.currentWorktreePath = null;
                    return;
                }
                default: {
                    GitListWorktreeLineListener.report$default(this, line, null, 2, null);
                    return;
                }
                case "HEAD": {
                    return;
                }
            }
        }
        catch (VcsException e) {
            this.report(line, e);
        }
    }
}

