/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import git4idea.GitWorkingTree;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ'\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesCommandService;", "", "<init>", "()V", "deleteWorkingTree", "Lgit4idea/commands/GitCommandResult;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/GitWorkingTree;", "listWorktrees", "repository", "Lgit4idea/repo/GitRepository;", "listeners", "", "Lgit4idea/commands/GitLineHandlerListener;", "(Lgit4idea/repo/GitRepository;[Lgit4idea/commands/GitLineHandlerListener;)Lgit4idea/commands/GitCommandResult;", "Companion", "intellij.vcs.git"})
public final class GitWorkingTreesCommandService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final GitCommandResult deleteWorkingTree(@NotNull Project project, @NotNull GitWorkingTree tree) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        String string = tree.getPath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        GitLineHandler handler = new GitLineHandler(project, path, GitCommand.WORKTREE);
        Object[] objectArray = new String[3];
        objectArray[0] = "remove";
        Intrinsics.checkNotNullExpressionValue((Object)tree.getPath().getPath(), (String)"getPath(...)");
        objectArray[2] = "--force";
        handler.addParameters(CollectionsKt.listOf((Object[])objectArray));
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        return gitCommandResult;
    }

    @NotNull
    public final GitCommandResult listWorktrees(@NotNull GitRepository repository2, GitLineHandlerListener ... listeners) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.WORKTREE);
        String[] stringArray = new String[]{"list"};
        handler.addParameters(stringArray);
        stringArray = new String[]{"--porcelain"};
        handler.addParameters(stringArray);
        for (GitLineHandlerListener listener2 : listeners) {
            handler.addLineListener(listener2);
        }
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        return gitCommandResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesCommandService$Companion;", "", "<init>", "()V", "getInstance", "Lgit4idea/workingTrees/GitWorkingTreesCommandService;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitWorkingTreesCommandService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitWorkingTreesCommandService.kt\ngit4idea/workingTrees/GitWorkingTreesCommandService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,35:1\n42#2,3:36\n*S KotlinDebug\n*F\n+ 1 GitWorkingTreesCommandService.kt\ngit4idea/workingTrees/GitWorkingTreesCommandService$Companion\n*L\n16#1:36,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitWorkingTreesCommandService getInstance() {
            boolean $i$f$service = false;
            Class<GitWorkingTreesCommandService> serviceClass$iv = GitWorkingTreesCommandService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GitWorkingTreesCommandService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

