/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.rpc.RepositoryId;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.workingTrees.GitWorkingTreesUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "getSingleRepositoryInProjectRootOrNull", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "shouldWorkingTreesTabBeShown", "", "workingTreesTabOpenedByUser", "", "workingTreesTabClosedByUser", "reloadRepository", "repositoryId", "Lcom/intellij/platform/vcs/impl/shared/rpc/RepositoryId;", "Companion", "intellij.vcs.git"})
public final class GitWorkingTreesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final String WORKING_TREE_TAB_CLOSED_BY_USER_PROPERTY = "Git.Working.Tree.Tab.closed.by.user";

    public GitWorkingTreesService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Nullable
    public final GitRepositoryModel getSingleRepositoryInProjectRootOrNull() {
        Set baseDirectories = BaseProjectDirectories.Companion.getBaseDirectories(this.project);
        if (baseDirectories.size() != 1) {
            return null;
        }
        VirtualFile projectRoot = (VirtualFile)CollectionsKt.first((Iterable)baseDirectories);
        GitRepositoriesHolder holder = GitRepositoriesHolder.Companion.getInstance(this.project);
        if (!holder.getInitialized()) {
            return null;
        }
        List repositoryModels = holder.getAll();
        if (repositoryModels.isEmpty()) {
            return null;
        }
        if (repositoryModels.size() > 1) {
            return null;
        }
        GitRepositoryModel model = (GitRepositoryModel)repositoryModels.get(0);
        VirtualFile virtualFile = model.getRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile modelRoot = virtualFile;
        if (!Intrinsics.areEqual((Object)modelRoot, (Object)projectRoot)) {
            return null;
        }
        return model;
    }

    public final boolean shouldWorkingTreesTabBeShown() {
        if (!GitWorkingTreesUtil.INSTANCE.isWorkingTreesFeatureEnabled()) {
            return false;
        }
        if (this.getSingleRepositoryInProjectRootOrNull() == null) {
            return false;
        }
        return !PropertiesComponent.getInstance((Project)this.project).getBoolean(WORKING_TREE_TAB_CLOSED_BY_USER_PROPERTY, false);
    }

    public final void workingTreesTabOpenedByUser() {
        PropertiesComponent.getInstance((Project)this.project).unsetValue(WORKING_TREE_TAB_CLOSED_BY_USER_PROPERTY);
    }

    public final void workingTreesTabClosedByUser() {
        PropertiesComponent.getInstance((Project)this.project).setValue(WORKING_TREE_TAB_CLOSED_BY_USER_PROPERTY, true);
    }

    public final void reloadRepository(@NotNull RepositoryId repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        GitRepositoryModel gitRepositoryModel = GitRepositoriesHolder.Companion.getInstance(this.project).get(repositoryId);
        if (gitRepositoryModel == null) {
            return;
        }
        GitRepositoryModel repositoryModel = gitRepositoryModel;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFile(repositoryModel.getRoot());
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        repository2.getWorkingTreeHolder().reload();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesService$Companion;", "", "<init>", "()V", "WORKING_TREE_TAB_CLOSED_BY_USER_PROPERTY", "", "getInstance", "Lgit4idea/workingTrees/GitWorkingTreesService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitWorkingTreesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitWorkingTreesService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitWorkingTreesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

