/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.SshApiBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface SshConfigManager {
    @Topic.AppLevel
    @Topic.ProjectLevel
    public static final Topic<Listener> SSH_CONFIGS = new Topic(Listener.class, Topic.BroadcastDirection.TO_CHILDREN);
    public static final Topic<SshConfigAuthListener> SSH_CONFIG_AUTH = new Topic(SshConfigAuthListener.class, Topic.BroadcastDirection.NONE);

    @NotNull
    public static SshConfigManager getInstance(@Nullable Project project) {
        Object object = project != null ? project : ApplicationManager.getApplication();
        SshConfigManager sshConfigManager = (SshConfigManager)object.getServiceIfCreated(SshConfigManager.class);
        if (sshConfigManager != null) {
            SshConfigManager sshConfigManager2 = sshConfigManager;
            if (sshConfigManager2 == null) {
                SshConfigManager.z(0);
            }
            return sshConfigManager2;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            new Task.Modal(project, SshApiBundle.message("dialog.title.loading.ssh.credentials", new Object[0]), false, (ComponentManager)object){
                final /* synthetic */ ComponentManager val$componentManager;
                {
                    this.val$componentManager = componentManager;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.z(0);
                    }
                    this.val$componentManager.getService(SshConfigManager.class);
                }

                private static /* synthetic */ void z(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ssh/config/unified/SshConfigManager$1", "run"));
                }
            }.queue();
        }
        SshConfigManager sshConfigManager3 = (SshConfigManager)object.getService(SshConfigManager.class);
        if (sshConfigManager3 == null) {
            SshConfigManager.z(1);
        }
        return sshConfigManager3;
    }

    public @Unmodifiable @NotNull List<SshConfig> getConfigs();

    @NotNull
    public ConfigsData getLastSavedAndCurrentData();

    public void setCurrentData(List<SshUiData> var1, @NotNull Listener var2);

    public void applyData(@NotNull List<SshUiData> var1, @Nullable Listener var2);

    public void disposeCurrentData();

    @Nullable
    public SshConfig findConfigByName(String var1);

    @Nullable
    public SshConfig findConfigById(String var1);

    @Nullable
    public SshConfig findConfig(@Nullable PresentableId var1);

    @Nullable
    public SshUiData findCurrentDataByName(@Nullable String var1);

    @Nullable
    public SshUiData findCurrentData(@Nullable PresentableId var1);

    @Nullable
    public SshUiData findCurrentDataById(@Nullable String var1);

    @NotNull
    public SshUiData moveDataConfig(@NotNull SshUiData var1);

    @NotNull
    public SshConfig register(boolean var1, String var2, String var3, String var4, AuthType var5, String var6, String var7, boolean var8, boolean var9, @Nullable String var10, @Nullable String var11);

    @NotNull
    public SshConfig register(boolean var1, String var2, String var3, String var4, AuthType var5, String var6, String var7, boolean var8, boolean var9, boolean var10, @Nullable String var11, @Nullable String var12);

    @NotNull
    public SshUiData register(@NotNull SshUiData var1);

    @Nullable
    public SshConfig getConfigFromInitialMappingNameToId(@NotNull String var1);

    public boolean isPassphraseMayBeRequired(String var1);

    public void startCollectingNotifications();

    public void handleNotifications(boolean var1);

    @Nullable
    public static SshUiData findData(@Nullable PresentableId presentableId, @NotNull List<SshUiData> data) {
        if (data == null) {
            SshConfigManager.z(2);
        }
        if (presentableId == null || presentableId.getId() == null) {
            return null;
        }
        for (SshUiData sshUiData : data) {
            String string = presentableId.getId();
            if (!string.equals(sshUiData.getConfig().getId())) continue;
            return sshUiData;
        }
        return null;
    }

    private static /* synthetic */ void z(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/config/unified/SshConfigManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener {
        default public void sshConfigsChanged() {
        }
    }

    public static interface SshConfigAuthListener {
        public void sshConfigAuthDataChanged(@NotNull SshConfig var1);
    }

    public static final class ConfigsData {
        private final @Unmodifiable @NotNull List<SshUiData> myLastSavedData;
        private final @Unmodifiable @NotNull List<SshUiData> myCurrentData;

        public ConfigsData() {
            this.myLastSavedData = Collections.emptyList();
            this.myCurrentData = Collections.emptyList();
        }

        public ConfigsData(@Unmodifiable @NotNull List<SshUiData> lastSavedData, @Unmodifiable @NotNull List<SshUiData> currentData) {
            if (lastSavedData == null) {
                ConfigsData.z(0);
            }
            if (currentData == null) {
                ConfigsData.z(1);
            }
            this.myLastSavedData = lastSavedData;
            this.myCurrentData = currentData;
        }

        public ConfigsData(@NotNull SshUiData data) {
            if (data == null) {
                ConfigsData.z(2);
            }
            this.myLastSavedData = Collections.singletonList(data);
            this.myCurrentData = Collections.singletonList(data);
        }

        public @Unmodifiable @NotNull List<SshUiData> getLastSavedData() {
            List<SshUiData> list = this.myLastSavedData;
            if (list == null) {
                ConfigsData.z(3);
            }
            return list;
        }

        public @Unmodifiable @NotNull List<SshUiData> getCurrentData() {
            List<SshUiData> list = this.myCurrentData;
            if (list == null) {
                ConfigsData.z(4);
            }
            return list;
        }

        @NotNull
        public ConfigsData createWithCurrentData(@NotNull List<SshUiData> newData) {
            if (newData == null) {
                ConfigsData.z(5);
            }
            return new ConfigsData(this.myLastSavedData, newData);
        }

        public ConfigsData createMerged(ConfigsData data) {
            ArrayList<SshUiData> arrayList = new ArrayList<SshUiData>(this.myLastSavedData);
            arrayList.addAll(data.myLastSavedData);
            ArrayList<SshUiData> arrayList2 = new ArrayList<SshUiData>(this.myCurrentData);
            arrayList2.addAll(data.myCurrentData);
            return new ConfigsData(arrayList, arrayList2);
        }

        private static /* synthetic */ void z(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastSavedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfigManager$ConfigsData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManager$ConfigsData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastSavedData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithCurrentData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

