/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.injector;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.plugins.cucumber.injector.GherkinInjectorExtensionPoint;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;

@NotNullByDefault
public final class GherkinLanguageInjector
implements MultiHostInjector {
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(GherkinPystring.class);
    }

    public void getLanguagesToInject(MultiHostRegistrar registrar, PsiElement context) {
        TextRange range;
        int newLineCharacterOffset;
        if (!(context instanceof GherkinPystring)) {
            return;
        }
        GherkinPystring host = (GherkinPystring)context;
        String hostText = host.getText();
        for (newLineCharacterOffset = 0; newLineCharacterOffset < hostText.length() && hostText.charAt(newLineCharacterOffset) != '\n'; ++newLineCharacterOffset) {
        }
        if (newLineCharacterOffset >= hostText.length()) {
            return;
        }
        String languageMarker = StringUtil.trimTrailing((String)hostText.substring("\"\"\"".length(), newLineCharacterOffset));
        Language language = InjectorUtils.getLanguageByString((String)languageMarker);
        if (language != null && !(range = TextRange.create((int)newLineCharacterOffset, (int)(host.getTextLength() - "\"\"\"".length()))).isEmpty()) {
            Optional extensionPoint = GherkinInjectorExtensionPoint.EP_NAME.getExtensionList().stream().findFirst();
            String prefix = extensionPoint.map(ep -> ep.getPrefix(languageMarker)).orElse(null);
            String suffix = extensionPoint.map(ep -> ep.getSuffix(languageMarker)).orElse(null);
            registrar.startInjecting(language);
            registrar.addPlace(prefix, suffix, (PsiLanguageInjectionHost)host, range);
            registrar.doneInjecting();
        }
    }
}

