/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.inspections.CucumberStepDefinitionCreationContext;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

@NotNullByDefault
public final class CucumberStepHelper {
    private static final Logger LOG = Logger.getInstance(CucumberStepHelper.class);

    @Nullable
    public static PsiFile createStepDefinitionFile(PsiDirectory dir, String fileNameWithoutExtension, BDDFrameworkType frameworkType) {
        CucumberJvmExtensionPoint ep = CucumberStepHelper.getExtensionMap().get(frameworkType);
        if (ep == null) {
            LOG.error(String.format("Unsupported step definition file type %s", frameworkType));
            return null;
        }
        return ep.getStepDefinitionCreator().createStepDefinitionContainer(dir, fileNameWithoutExtension);
    }

    public static boolean validateNewStepDefinitionFileName(Project project, String fileName, BDDFrameworkType frameworkType) {
        CucumberJvmExtensionPoint ep = CucumberStepHelper.getExtensionMap().get(frameworkType);
        if (ep == null) {
            LOG.error(String.format("No extension point registered for framework type %s", frameworkType));
            return false;
        }
        return ep.getStepDefinitionCreator().validateNewStepDefinitionFileName(project, fileName);
    }

    public static Collection<AbstractStepDefinition> findAllStepDefinitions(PsiFile featureFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        if (module == null) {
            return Collections.emptyList();
        }
        return CucumberStepHelper.loadStepsFor(featureFile, module);
    }

    public static Collection<AbstractStepDefinition> findStepDefinitions(PsiFile featureFile, GherkinStep step) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        if (module == null) {
            return Collections.emptyList();
        }
        String substitutedName = step.getSubstitutedName();
        if (substitutedName == null) {
            return Collections.emptyList();
        }
        HashMap definitionsByClass = new HashMap();
        List<AbstractStepDefinition> allSteps = CucumberStepHelper.loadStepsFor(featureFile, module);
        for (AbstractStepDefinition stepDefinition : allSteps) {
            int newPatternLength;
            boolean matches = stepDefinition.matches(substitutedName);
            if (!matches || !stepDefinition.supportsStep(step)) continue;
            Pattern currentLongestPattern = CucumberStepHelper.getPatternByDefinition((AbstractStepDefinition)definitionsByClass.get(stepDefinition.getClass()));
            Pattern newPattern = CucumberStepHelper.getPatternByDefinition(stepDefinition);
            int n = newPatternLength = newPattern != null ? newPattern.pattern().length() : -1;
            if (currentLongestPattern != null && currentLongestPattern.pattern().length() >= newPatternLength) continue;
            definitionsByClass.put(stepDefinition.getClass(), stepDefinition);
        }
        return definitionsByClass.values();
    }

    public static List<AbstractStepDefinition> findStepDefinitionsByPattern(String pattern, Module module) {
        List<AbstractStepDefinition> allSteps = CucumberStepHelper.loadStepsFor(null, module);
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (AbstractStepDefinition stepDefinition : allSteps) {
            String elementText = stepDefinition.getCucumberRegex();
            if (elementText == null || !elementText.equals(pattern)) continue;
            result.add(stepDefinition);
        }
        return result;
    }

    public static Set<CucumberStepDefinitionCreationContext> getStepDefinitionContainers(GherkinFile featureFile) {
        HashSet<CucumberStepDefinitionCreationContext> result = new HashSet<CucumberStepDefinitionCreationContext>();
        for (CucumberJvmExtensionPoint ep : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            OptionalStepDefinitionExtensionPoint point;
            if (ep instanceof OptionalStepDefinitionExtensionPoint && !(point = (OptionalStepDefinitionExtensionPoint)ep).participateInStepDefinitionCreation((PsiElement)featureFile)) continue;
            Collection<? extends PsiFile> psiFiles = ep.getStepDefinitionContainers(featureFile);
            BDDFrameworkType frameworkType = ep.getStepFileType();
            for (PsiFile psiFile : psiFiles) {
                result.add(new CucumberStepDefinitionCreationContext(psiFile, frameworkType));
            }
        }
        return result;
    }

    public static Map<BDDFrameworkType, CucumberJvmExtensionPoint> getExtensionMap() {
        HashMap<BDDFrameworkType, CucumberJvmExtensionPoint> result = new HashMap<BDDFrameworkType, CucumberJvmExtensionPoint>();
        for (CucumberJvmExtensionPoint ep : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            result.put(ep.getStepFileType(), ep);
        }
        return result;
    }

    public static boolean isGherkin6Supported(Module module) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        for (CucumberJvmExtensionPoint ep : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            if (!ep.isGherkin6Supported(module)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    private static Pattern getPatternByDefinition(@Nullable AbstractStepDefinition definition) {
        if (definition == null) {
            return null;
        }
        return definition.getPattern();
    }

    private static List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, Module module) {
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (CucumberJvmExtensionPoint ep : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            result.addAll(ep.loadStepsFor(featureFile, module));
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static List<AbstractStepDefinition> getAllStepDefinitions(PsiFile featureFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        if (module == null) {
            return Collections.emptyList();
        }
        return CucumberStepHelper.loadStepsFor(featureFile, module);
    }

    @Deprecated(forRemoval=true)
    public static List<CucumberJvmExtensionPoint> getCucumberExtensions() {
        return CucumberJvmExtensionPoint.EP_NAME.getExtensionList();
    }

    @Deprecated(forRemoval=true)
    public static int getExtensionCount() {
        return CucumberStepHelper.getCucumberExtensions().size();
    }
}

