/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 83446598530353L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-321121500 - -((char)-25383), -321121500 - -((char)-29623), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-321121500 - -((char)-25384), -321121500 - -((char)-20477), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 9960896662673L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.z();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(867552330 - 30187, -867552330 - -((char)-28803), (int)l2) + string + WindowsNamedPipeAgentIpc.b(867552330 - 30188, 867552330 - 21914, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(867552330 - 30193, -867552330 - -((char)-23847), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 28112406662007L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.z();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32706, -1845727740 - -20302, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32705, 1845727740 - 13668, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32704, 1845727740 - 25164, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32695, -1845727740 - -20761, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32694, -1845727740 - -((char)-28336), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32693, 1845727740 - 16864, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32695, -1845727740 - -20761, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1845727740 - (char)-32692, 1845727740 - 19476, (int)l2));
            if (ActionTimestamp.z() != null) {
                SshAgentIpcService.z(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 43551477115160L;
                    nArray = SshAgentIpcService.z();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 132368377911886L;
                int[] nArray2 = SshAgentIpcService.z();
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = nArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1780848090 - 21836, 1780848090 - 7530, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21835, -1780848090 - -20197, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21838, 1780848090 - 24648, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1780848090 - 21836, 1780848090 - 7530, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21837, 1780848090 - 29436, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1780848090 - 21836, 1780848090 - 7530, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21832, -1780848090 - -24280, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21831, -1780848090 - -((char)-29093), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21838, 1780848090 - 24648, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1780848090 - 21836, 1780848090 - 7530, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1780848090 - 21840, -1780848090 - -((char)-31746), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1780848090 - 21834, -1780848090 - -30502, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 5915663958969L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1494066930 - (char)-12188, 1494066930 - (char)-16141, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 3046249454478L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1117633890 - 11946, 1117633890 - 13926, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00fe%\\-0\u00ec\u009dQO\u00f3\u00ab\u00adq\\\u008d\u0011\u00e5\u00ee2\u0014.8F\u0088h\u009a\u00eb\u001a\u0003\u009c\u00e7\u0094:\u0082%A\u001d\"*\u00df";
                        var4_3 = "\u00fe%\\-0\u00ec\u009dQO\u00f3\u00ab\u00adq\\\u008d\u0011\u00e5\u00ee2\u0014.8F\u0088h\u009a\u00eb\u001a\u0003\u009c\u00e7\u0094:\u0082%A\u001d\"*\u00df".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 11;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 106;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 90;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 112;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 40;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 40;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 54;
                                        break;
                                    }
                                    default: {
                                        v11 = 34;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x5537) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 82;
                            case 1 -> 124;
                            case 2 -> 3;
                            case 3 -> 114;
                            case 4 -> 241;
                            case 5 -> 23;
                            case 6 -> 2;
                            case 7 -> 60;
                            case 8 -> 5;
                            case 9 -> 67;
                            case 10 -> 190;
                            case 11 -> 122;
                            case 12 -> 155;
                            case 13 -> 220;
                            case 14 -> 226;
                            case 15 -> 163;
                            case 16 -> 147;
                            case 17 -> 158;
                            case 18 -> 204;
                            case 19 -> 69;
                            case 20 -> 208;
                            case 21 -> 119;
                            case 22 -> 61;
                            case 23 -> 128;
                            case 24 -> 129;
                            case 25 -> 42;
                            case 26 -> 181;
                            case 27 -> 250;
                            case 28 -> 160;
                            case 29 -> 188;
                            case 30 -> 37;
                            case 31 -> 173;
                            case 32 -> 168;
                            case 33 -> 205;
                            case 34 -> 187;
                            case 35 -> 4;
                            case 36 -> 90;
                            case 37 -> 78;
                            case 38 -> 120;
                            case 39 -> 230;
                            case 40 -> 6;
                            case 41 -> 186;
                            case 42 -> 156;
                            case 43 -> 252;
                            case 44 -> 227;
                            case 45 -> 35;
                            case 46 -> 214;
                            case 47 -> 133;
                            case 48 -> 255;
                            case 49 -> 52;
                            case 50 -> 51;
                            case 51 -> 116;
                            case 52 -> 66;
                            case 53 -> 170;
                            case 54 -> 131;
                            case 55 -> 55;
                            case 56 -> 125;
                            case 57 -> 177;
                            case 58 -> 105;
                            case 59 -> 31;
                            case 60 -> 104;
                            case 61 -> 240;
                            case 62 -> 63;
                            case 63 -> 251;
                            case 64 -> 130;
                            case 65 -> 48;
                            case 66 -> 145;
                            case 67 -> 146;
                            case 68 -> 9;
                            case 69 -> 142;
                            case 70 -> 107;
                            case 71 -> 47;
                            case 72 -> 87;
                            case 73 -> 206;
                            case 74 -> 89;
                            case 75 -> 71;
                            case 76 -> 102;
                            case 77 -> 192;
                            case 78 -> 57;
                            case 79 -> 81;
                            case 80 -> 219;
                            case 81 -> 242;
                            case 82 -> 157;
                            case 83 -> 234;
                            case 84 -> 7;
                            case 85 -> 199;
                            case 86 -> 137;
                            case 87 -> 103;
                            case 88 -> 8;
                            case 89 -> 213;
                            case 90 -> 75;
                            case 91 -> 26;
                            case 92 -> 28;
                            case 93 -> 218;
                            case 94 -> 243;
                            case 95 -> 249;
                            case 96 -> 194;
                            case 97 -> 233;
                            case 98 -> 13;
                            case 99 -> 109;
                            case 100 -> 207;
                            case 101 -> 22;
                            case 102 -> 162;
                            case 103 -> 32;
                            case 104 -> 235;
                            case 105 -> 92;
                            case 106 -> 56;
                            case 107 -> 195;
                            case 108 -> 11;
                            case 109 -> 108;
                            case 110 -> 15;
                            case 111 -> 24;
                            case 112 -> 217;
                            case 113 -> 216;
                            case 114 -> 12;
                            case 115 -> 184;
                            case 116 -> 33;
                            case 117 -> 93;
                            case 118 -> 237;
                            case 119 -> 112;
                            case 120 -> 169;
                            case 121 -> 140;
                            case 122 -> 117;
                            case 123 -> 150;
                            case 124 -> 138;
                            case 125 -> 30;
                            case 126 -> 247;
                            case 127 -> 244;
                            case 128 -> 34;
                            case 129 -> 203;
                            case 130 -> 209;
                            case 131 -> 53;
                            case 132 -> 222;
                            case 133 -> 58;
                            case 134 -> 121;
                            case 135 -> 29;
                            case 136 -> 191;
                            case 137 -> 100;
                            case 138 -> 153;
                            case 139 -> 139;
                            case 140 -> 126;
                            case 141 -> 185;
                            case 142 -> 1;
                            case 143 -> 96;
                            case 144 -> 62;
                            case 145 -> 189;
                            case 146 -> 238;
                            case 147 -> 45;
                            case 148 -> 229;
                            case 149 -> 99;
                            case 150 -> 176;
                            case 151 -> 106;
                            case 152 -> 254;
                            case 153 -> 73;
                            case 154 -> 127;
                            case 155 -> 148;
                            case 156 -> 20;
                            case 157 -> 72;
                            case 158 -> 215;
                            case 159 -> 85;
                            case 160 -> 83;
                            case 161 -> 88;
                            case 162 -> 212;
                            case 163 -> 179;
                            case 164 -> 143;
                            case 165 -> 154;
                            case 166 -> 77;
                            case 167 -> 74;
                            case 168 -> 65;
                            case 169 -> 21;
                            case 170 -> 134;
                            case 171 -> 239;
                            case 172 -> 46;
                            case 173 -> 172;
                            case 174 -> 136;
                            case 175 -> 80;
                            case 176 -> 225;
                            case 177 -> 253;
                            case 178 -> 245;
                            case 179 -> 193;
                            case 180 -> 224;
                            case 181 -> 25;
                            case 182 -> 64;
                            case 183 -> 197;
                            case 184 -> 19;
                            case 185 -> 54;
                            case 186 -> 182;
                            case 187 -> 151;
                            case 188 -> 201;
                            case 189 -> 95;
                            case 190 -> 17;
                            case 191 -> 123;
                            case 192 -> 0;
                            case 193 -> 43;
                            case 194 -> 248;
                            case 195 -> 135;
                            case 196 -> 175;
                            case 197 -> 41;
                            case 198 -> 210;
                            case 199 -> 171;
                            case 200 -> 86;
                            case 201 -> 111;
                            case 202 -> 68;
                            case 203 -> 141;
                            case 204 -> 118;
                            case 205 -> 16;
                            case 206 -> 246;
                            case 207 -> 50;
                            case 208 -> 91;
                            case 209 -> 236;
                            case 210 -> 18;
                            case 211 -> 39;
                            case 212 -> 196;
                            case 213 -> 167;
                            case 214 -> 44;
                            case 215 -> 59;
                            case 216 -> 79;
                            case 217 -> 180;
                            case 218 -> 152;
                            case 219 -> 36;
                            case 220 -> 178;
                            case 221 -> 27;
                            case 222 -> 232;
                            case 223 -> 49;
                            case 224 -> 76;
                            case 225 -> 70;
                            case 226 -> 161;
                            case 227 -> 94;
                            case 228 -> 40;
                            case 229 -> 84;
                            case 230 -> 228;
                            case 231 -> 132;
                            case 232 -> 211;
                            case 233 -> 144;
                            case 234 -> 200;
                            case 235 -> 165;
                            case 236 -> 113;
                            case 237 -> 101;
                            case 238 -> 223;
                            case 239 -> 164;
                            case 240 -> 198;
                            case 241 -> 183;
                            case 242 -> 10;
                            case 243 -> 149;
                            case 244 -> 38;
                            case 245 -> 231;
                            case 246 -> 221;
                            case 247 -> 115;
                            case 248 -> 110;
                            case 249 -> 166;
                            case 250 -> 14;
                            case 251 -> 174;
                            case 252 -> 202;
                            case 253 -> 159;
                            case 254 -> 98;
                            default -> 97;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray != null) {
                ActionTimestamp.z(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 23360554501445L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.z();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(227406450 - 4845, 227406450 - 2807, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(227406450 - 4849, -227406450 - -25505, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(227406450 - 4824, -227406450 - -26640, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(227406450 - 4845, 227406450 - 2807, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(227406450 - 4849, -227406450 - -25505, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(227406450 - 4821, 227406450 + 326, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 80325107243705L;
                        int[] nArray2 = SshAgentIpcService.z();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(628873860 - 23076, 628873860 + 9433, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(628873860 - 23073, 628873860 - 950, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 22526945158335L;
                int[] nArray2 = SshAgentIpcService.z();
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = nArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-158332560 - -13583, -158332560 + -751, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-158332560 - -13579, 158332560 - 26043, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-158332560 - -13556, 158332560 - 26059, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-158332560 - -13579, 158332560 - 26043, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-158332560 - -13581, -158332560 - -16883, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-158332560 - -13583, -158332560 + -751, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-158332560 - -13579, 158332560 - 26043, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-158332560 - -13563, 158332560 - 2490, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-158332560 - -13583, -158332560 + -751, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-158332560 - -13579, 158332560 - 26043, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-158332560 - -13562, 158332560 - 11571, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-158332560 - -13583, -158332560 + -751, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-158332560 - -13579, 158332560 - 26043, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-158332560 - -13561, -158332560 - -9778, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 26853758479877L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.z();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10879, 1622908740 + (char)-21257, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10883, -1622908740 + -((char)-31155), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10866, 1622908740 + (char)-18084, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10863, 1622908740 + 25774, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10879, 1622908740 + (char)-21257, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10883, -1622908740 + -((char)-31155), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10864, 1622908740 + (char)-15718, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10879, 1622908740 + (char)-21257, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10883, -1622908740 + -((char)-31155), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10861, 1622908740 + (char)-16786, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10879, 1622908740 + (char)-21257, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10883, -1622908740 + -((char)-31155), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10862, 1622908740 + (char)-17206, (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10879, 1622908740 + (char)-21257, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10883, -1622908740 + -((char)-31155), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10843, 1622908740 + (char)-23178, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1622908740 + (char)-10844, 1622908740 + (char)-13567, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "Y\u0012\u0001)w\u00d5\u00bc'\u0014\\[\u0099\u00e7\u009a\u0084\u00ae\u0017I3l2\u001e\u00b3\u00e1\u00d5\u00ed \u00f8\u00dc\u0006\u00cd\u0081\u0093[O\u00da\u0018\u0082\u00ce\"eo\u0011\u0012e\u0016\u0000\u0088$\u00e4\u008e\u00ec\u00f0\u00e5\u00ed\u00d7\u00f8;\u00cd\u00e1i\t\u000b\u00a3\u008dy\u00f1\r\u00d9\u00aeS\u0005\u00be\u00f4\u00fd\u00f5\u0098\bt\u00d6\u00a4\u00c0\u0091\u00cef\u00a6\u0014\u00c4p\u00f2\u0019\u009aS\u009bz\u0081C\u00de\u0088\u0002G\u00d9\u00a6\u00f8\u009d\u00a3)\u0005J\u00a9c^K\u001e\u0085n\u008f\u00c2K!4\u0019w\u009b\u00ef\u00d0D0ZC\u00d2\n\u00e3\u00f0\u0011\u00e3\u00a8a\u0007\u00dd'\u0094\u00125\u0010\u00a9\u009b\u00ee\u00b90|\u00adK9c\u00ab2\u00ca9$\u00fd\t!\u00e4\u001e\u0080\u00d0\u0015\u00db2\u00fd\u0010\u00b60\r\u00ccL\u00d2\"\u009e\u00c8\u00d9\u0095e\r\u00d3\u00dc\u00a0?\\\u00c0\u00bc\u0017 \u0092\u00dc\u0003\u001b\t'y\u00e2\u00f3\u00b3\u0002*G\u0081\u009c\u00d3<\u008b\u00fcs\u0086\u00a4KU\u0098\t\u000f\u00fa\u00e6k\u0004\u00e7O\u00c5\u00b3o\u00a1\u009fi\u00b6Dc\u0007\u00b2\u00c3\tr\u0001H\u00c5%\u00da$/\u00b2\u0012&\u00f9\bq\u00b8\u0004\r\u0085w\u00e4\u0091\fpR4K\u009e\u00ddi\u00c3\u0088:\u00cf\u001dFk\u00f7W\u00ff\u00f2K\u00e4\u00119l\u00f3\u0013\u00ee\u00b6-\u008c\u0005\u00f1d\u00e5}A]a\u009f\u001e\u00caS'\u00b2}vH\u007f\u00ff\u0016\u00af@g\u0096\u00a8\u0010\u00ec\u00a4\u0006x!\u00fd\u001dd\u009a,\u009c\u0015`\u0095\u00f1F\u00dcB_Q\fx\u00b1\u008f\u00e5\t\u00ce|\u001f\u008a\u00e5n\u00b3w\u000f\u00b3\u00dc\u0087#\u00f1\u00c7\u0087\u00cf)\r\u00c7+<\u001e!\u00beya\\\r[B\u0080\u001e\u008b\u000b>C\u00fdi\u00a7\u0099NKl'Y\u0015\u001dZ\u0099I,\u00f5\u00d3\u00bb\u00e1\u00d9 S\u0003\u00f1\u00a4\u009c\u008d\u008d\u00a8\u00b3\u0085)\u0096k\u00edb\u00075\u00bd\u009bF\u00cb\u00c9\u00da\u0084f\u00d7=G\u00a5\u00f7h\u00a8\b\u008e\u00af\u00cd\u009d\u00be(\u0013\u00a7{\u00eavI^]\u00854\u00a9\u00b1\u00d2\u0007\u00f0\u00d5+\u00af\u00fb\u00d1\u00b9\u0007\u00f7l\u00af\u00f4\u008cUA(p\u00e7}\u00d2\u00a5I\u001f3b\tg\u00b4r*K7\u00d3I\u00cb\u00b6N\u00ed=\u00d8+\u00cf\u00d4\u0019i\u00e1\u00ef;\u001f\u0018\u00ed\u00daI\u00b9\u00a3\u00f3\u000f#:Y@\u00c9w77\u0012\u0004\u00c8D'`\u007f\"\u0093\u0016M\u00cd\u0013\u00c0?%\u0016\u001c\u00c3 \u00c65\u00fb\u0099)\u0018\u00b0\u009d\u00aa\u00b6n(B9\u0082b\u00b0\u00dc\u00ad\u0082\u0082\u00b7\u000e\u009c\u00b0\u00ae\u00117]\u00e8r\u00e9\u00ac\u00b7Q\u00c4\u00c8\u001b\u00c2\u00efb\u00ffU51#\u0085\u0001\u00b7\u00e5\u0094h\u0097$\f\u0005\u00a9\u00a2\u00b2e\u001e\u00f4\u0007\u00cf\u007f\n\u00e2@\u00a2\rY\u008fc^d\u00cc\u0018^\u00b8\u00f1\u0018&u~ur\u0002\u008b\u001a\u00aa\u00c4\u00ac\u0090\u001c\u0092|)p_\u001d\u00e0)\u00b3\u0005I\u00af\u0093\u008c/\u00ac\u0014-\u0083\u0006\u00c9\u00f4\u00e1\u0014\u00ff\u00f5?\u00a7\u008b\u00e1\u00a3\u009e\u001d)9R\u00b0\u00b4\u00b4\u0019\u00aa\u00e9\u0010\u00dd\u0092\u0000K7\u008e\t\u00af~\u00cf\u00cd\u00e0s\u008b\u00a5J";
                var4_3 = "Y\u0012\u0001)w\u00d5\u00bc'\u0014\\[\u0099\u00e7\u009a\u0084\u00ae\u0017I3l2\u001e\u00b3\u00e1\u00d5\u00ed \u00f8\u00dc\u0006\u00cd\u0081\u0093[O\u00da\u0018\u0082\u00ce\"eo\u0011\u0012e\u0016\u0000\u0088$\u00e4\u008e\u00ec\u00f0\u00e5\u00ed\u00d7\u00f8;\u00cd\u00e1i\t\u000b\u00a3\u008dy\u00f1\r\u00d9\u00aeS\u0005\u00be\u00f4\u00fd\u00f5\u0098\bt\u00d6\u00a4\u00c0\u0091\u00cef\u00a6\u0014\u00c4p\u00f2\u0019\u009aS\u009bz\u0081C\u00de\u0088\u0002G\u00d9\u00a6\u00f8\u009d\u00a3)\u0005J\u00a9c^K\u001e\u0085n\u008f\u00c2K!4\u0019w\u009b\u00ef\u00d0D0ZC\u00d2\n\u00e3\u00f0\u0011\u00e3\u00a8a\u0007\u00dd'\u0094\u00125\u0010\u00a9\u009b\u00ee\u00b90|\u00adK9c\u00ab2\u00ca9$\u00fd\t!\u00e4\u001e\u0080\u00d0\u0015\u00db2\u00fd\u0010\u00b60\r\u00ccL\u00d2\"\u009e\u00c8\u00d9\u0095e\r\u00d3\u00dc\u00a0?\\\u00c0\u00bc\u0017 \u0092\u00dc\u0003\u001b\t'y\u00e2\u00f3\u00b3\u0002*G\u0081\u009c\u00d3<\u008b\u00fcs\u0086\u00a4KU\u0098\t\u000f\u00fa\u00e6k\u0004\u00e7O\u00c5\u00b3o\u00a1\u009fi\u00b6Dc\u0007\u00b2\u00c3\tr\u0001H\u00c5%\u00da$/\u00b2\u0012&\u00f9\bq\u00b8\u0004\r\u0085w\u00e4\u0091\fpR4K\u009e\u00ddi\u00c3\u0088:\u00cf\u001dFk\u00f7W\u00ff\u00f2K\u00e4\u00119l\u00f3\u0013\u00ee\u00b6-\u008c\u0005\u00f1d\u00e5}A]a\u009f\u001e\u00caS'\u00b2}vH\u007f\u00ff\u0016\u00af@g\u0096\u00a8\u0010\u00ec\u00a4\u0006x!\u00fd\u001dd\u009a,\u009c\u0015`\u0095\u00f1F\u00dcB_Q\fx\u00b1\u008f\u00e5\t\u00ce|\u001f\u008a\u00e5n\u00b3w\u000f\u00b3\u00dc\u0087#\u00f1\u00c7\u0087\u00cf)\r\u00c7+<\u001e!\u00beya\\\r[B\u0080\u001e\u008b\u000b>C\u00fdi\u00a7\u0099NKl'Y\u0015\u001dZ\u0099I,\u00f5\u00d3\u00bb\u00e1\u00d9 S\u0003\u00f1\u00a4\u009c\u008d\u008d\u00a8\u00b3\u0085)\u0096k\u00edb\u00075\u00bd\u009bF\u00cb\u00c9\u00da\u0084f\u00d7=G\u00a5\u00f7h\u00a8\b\u008e\u00af\u00cd\u009d\u00be(\u0013\u00a7{\u00eavI^]\u00854\u00a9\u00b1\u00d2\u0007\u00f0\u00d5+\u00af\u00fb\u00d1\u00b9\u0007\u00f7l\u00af\u00f4\u008cUA(p\u00e7}\u00d2\u00a5I\u001f3b\tg\u00b4r*K7\u00d3I\u00cb\u00b6N\u00ed=\u00d8+\u00cf\u00d4\u0019i\u00e1\u00ef;\u001f\u0018\u00ed\u00daI\u00b9\u00a3\u00f3\u000f#:Y@\u00c9w77\u0012\u0004\u00c8D'`\u007f\"\u0093\u0016M\u00cd\u0013\u00c0?%\u0016\u001c\u00c3 \u00c65\u00fb\u0099)\u0018\u00b0\u009d\u00aa\u00b6n(B9\u0082b\u00b0\u00dc\u00ad\u0082\u0082\u00b7\u000e\u009c\u00b0\u00ae\u00117]\u00e8r\u00e9\u00ac\u00b7Q\u00c4\u00c8\u001b\u00c2\u00efb\u00ffU51#\u0085\u0001\u00b7\u00e5\u0094h\u0097$\f\u0005\u00a9\u00a2\u00b2e\u001e\u00f4\u0007\u00cf\u007f\n\u00e2@\u00a2\rY\u008fc^d\u00cc\u0018^\u00b8\u00f1\u0018&u~ur\u0002\u008b\u001a\u00aa\u00c4\u00ac\u0090\u001c\u0092|)p_\u001d\u00e0)\u00b3\u0005I\u00af\u0093\u008c/\u00ac\u0014-\u0083\u0006\u00c9\u00f4\u00e1\u0014\u00ff\u00f5?\u00a7\u008b\u00e1\u00a3\u009e\u001d)9R\u00b0\u00b4\u00b4\u0019\u00aa\u00e9\u0010\u00dd\u0092\u0000K7\u008e\t\u00af~\u00cf\u00cd\u00e0s\u008b\u00a5J".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 59;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u007f\u00b0\u00c7\u000eU\u00af\u00e0\u00df\u00faTI>\u0087\u00e4?\u00013L\u00e1\u0003\u0012]t\u00c0[\u00e9w\u0018\u00fe\u0014\\7\u008e}o\u00c0\u0007\u0088k\u00d7?\u00b9c\u00d5Y\u000e\u00edL\u00efF";
                    var4_3 = "\u007f\u00b0\u00c7\u000eU\u00af\u00e0\u00df\u00faTI>\u0087\u00e4?\u00013L\u00e1\u0003\u0012]t\u00c0[\u00e9w\u0018\u00fe\u0014\\7\u008e}o\u00c0\u0007\u0088k\u00d7?\u00b9c\u00d5Y\u000e\u00edL\u00efF".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 10;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 8;
                            break;
                        }
                        case 1: {
                            v15 = 104;
                            break;
                        }
                        case 2: {
                            v15 = 121;
                            break;
                        }
                        case 3: {
                            v15 = 27;
                            break;
                        }
                        case 4: {
                            v15 = 10;
                            break;
                        }
                        case 5: {
                            v15 = 103;
                            break;
                        }
                        default: {
                            v15 = 97;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5ACC) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 226;
                case 1 -> 130;
                case 2 -> 17;
                case 3 -> 143;
                case 4 -> 65;
                case 5 -> 25;
                case 6 -> 196;
                case 7 -> 169;
                case 8 -> 89;
                case 9 -> 170;
                case 10 -> 126;
                case 11 -> 166;
                case 12 -> 219;
                case 13 -> 203;
                case 14 -> 87;
                case 15 -> 15;
                case 16 -> 63;
                case 17 -> 145;
                case 18 -> 119;
                case 19 -> 54;
                case 20 -> 178;
                case 21 -> 247;
                case 22 -> 83;
                case 23 -> 200;
                case 24 -> 153;
                case 25 -> 197;
                case 26 -> 187;
                case 27 -> 26;
                case 28 -> 191;
                case 29 -> 69;
                case 30 -> 91;
                case 31 -> 164;
                case 32 -> 248;
                case 33 -> 71;
                case 34 -> 201;
                case 35 -> 223;
                case 36 -> 230;
                case 37 -> 241;
                case 38 -> 108;
                case 39 -> 141;
                case 40 -> 148;
                case 41 -> 95;
                case 42 -> 51;
                case 43 -> 146;
                case 44 -> 122;
                case 45 -> 123;
                case 46 -> 199;
                case 47 -> 44;
                case 48 -> 140;
                case 49 -> 38;
                case 50 -> 84;
                case 51 -> 184;
                case 52 -> 98;
                case 53 -> 172;
                case 54 -> 189;
                case 55 -> 52;
                case 56 -> 10;
                case 57 -> 16;
                case 58 -> 185;
                case 59 -> 103;
                case 60 -> 57;
                case 61 -> 11;
                case 62 -> 22;
                case 63 -> 45;
                case 64 -> 147;
                case 65 -> 27;
                case 66 -> 100;
                case 67 -> 23;
                case 68 -> 14;
                case 69 -> 50;
                case 70 -> 39;
                case 71 -> 114;
                case 72 -> 157;
                case 73 -> 125;
                case 74 -> 217;
                case 75 -> 181;
                case 76 -> 154;
                case 77 -> 1;
                case 78 -> 156;
                case 79 -> 93;
                case 80 -> 229;
                case 81 -> 188;
                case 82 -> 233;
                case 83 -> 8;
                case 84 -> 150;
                case 85 -> 135;
                case 86 -> 86;
                case 87 -> 232;
                case 88 -> 78;
                case 89 -> 55;
                case 90 -> 60;
                case 91 -> 127;
                case 92 -> 183;
                case 93 -> 33;
                case 94 -> 41;
                case 95 -> 231;
                case 96 -> 112;
                case 97 -> 99;
                case 98 -> 175;
                case 99 -> 202;
                case 100 -> 13;
                case 101 -> 171;
                case 102 -> 12;
                case 103 -> 32;
                case 104 -> 210;
                case 105 -> 105;
                case 106 -> 66;
                case 107 -> 47;
                case 108 -> 162;
                case 109 -> 132;
                case 110 -> 236;
                case 111 -> 240;
                case 112 -> 212;
                case 113 -> 64;
                case 114 -> 77;
                case 115 -> 3;
                case 116 -> 161;
                case 117 -> 5;
                case 118 -> 109;
                case 119 -> 37;
                case 120 -> 6;
                case 121 -> 97;
                case 122 -> 96;
                case 123 -> 160;
                case 124 -> 111;
                case 125 -> 120;
                case 126 -> 220;
                case 127 -> 249;
                case 128 -> 253;
                case 129 -> 75;
                case 130 -> 208;
                case 131 -> 138;
                case 132 -> 204;
                case 133 -> 92;
                case 134 -> 179;
                case 135 -> 118;
                case 136 -> 42;
                case 137 -> 182;
                case 138 -> 194;
                case 139 -> 59;
                case 140 -> 18;
                case 141 -> 40;
                case 142 -> 186;
                case 143 -> 115;
                case 144 -> 124;
                case 145 -> 7;
                case 146 -> 216;
                case 147 -> 90;
                case 148 -> 134;
                case 149 -> 251;
                case 150 -> 149;
                case 151 -> 228;
                case 152 -> 56;
                case 153 -> 195;
                case 154 -> 110;
                case 155 -> 213;
                case 156 -> 101;
                case 157 -> 252;
                case 158 -> 180;
                case 159 -> 221;
                case 160 -> 72;
                case 161 -> 225;
                case 162 -> 131;
                case 163 -> 159;
                case 164 -> 43;
                case 165 -> 94;
                case 166 -> 73;
                case 167 -> 168;
                case 168 -> 227;
                case 169 -> 106;
                case 170 -> 46;
                case 171 -> 68;
                case 172 -> 254;
                case 173 -> 58;
                case 174 -> 79;
                case 175 -> 136;
                case 176 -> 155;
                case 177 -> 144;
                case 178 -> 102;
                case 179 -> 117;
                case 180 -> 30;
                case 181 -> 207;
                case 182 -> 151;
                case 183 -> 173;
                case 184 -> 165;
                case 185 -> 76;
                case 186 -> 70;
                case 187 -> 29;
                case 188 -> 113;
                case 189 -> 198;
                case 190 -> 137;
                case 191 -> 53;
                case 192 -> 193;
                case 193 -> 244;
                case 194 -> 206;
                case 195 -> 49;
                case 196 -> 192;
                case 197 -> 74;
                case 198 -> 177;
                case 199 -> 82;
                case 200 -> 36;
                case 201 -> 224;
                case 202 -> 246;
                case 203 -> 62;
                case 204 -> 104;
                case 205 -> 48;
                case 206 -> 35;
                case 207 -> 0;
                case 208 -> 61;
                case 209 -> 250;
                case 210 -> 205;
                case 211 -> 4;
                case 212 -> 234;
                case 213 -> 242;
                case 214 -> 129;
                case 215 -> 163;
                case 216 -> 215;
                case 217 -> 121;
                case 218 -> 158;
                case 219 -> 139;
                case 220 -> 174;
                case 221 -> 152;
                case 222 -> 80;
                case 223 -> 107;
                case 224 -> 167;
                case 225 -> 67;
                case 226 -> 237;
                case 227 -> 235;
                case 228 -> 211;
                case 229 -> 142;
                case 230 -> 2;
                case 231 -> 24;
                case 232 -> 190;
                case 233 -> 88;
                case 234 -> 222;
                case 235 -> 81;
                case 236 -> 9;
                case 237 -> 21;
                case 238 -> 243;
                case 239 -> 245;
                case 240 -> 85;
                case 241 -> 218;
                case 242 -> 176;
                case 243 -> 116;
                case 244 -> 255;
                case 245 -> 214;
                case 246 -> 34;
                case 247 -> 19;
                case 248 -> 133;
                case 249 -> 209;
                case 250 -> 28;
                case 251 -> 31;
                case 252 -> 238;
                case 253 -> 239;
                case 254 -> 20;
                default -> 128;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 88348566310540L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1089060630 - -((char)-24967), -1089060630 - -((char)-32531), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 68018796497489L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.z();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(600562740 - 16501, -600562740 - -15016, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(600562740 - 16504, 600562740 - 10000, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(600562740 - 16503, -600562740 - -10889, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00d6\u00a5\u00a7\\\u00a8\u00f7-\u00e0\u0010M8%NB\u000e\u0089\u0086\u00b9\u008d8\u00e44\u0089x\u00ef";
                    var4_3 = "\u00d6\u00a5\u00a7\\\u00a8\u00f7-\u00e0\u0010M8%NB\u000e\u0089\u0086\u00b9\u008d8\u00e44\u0089x\u00ef".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 122;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "-X\"\u0019\u009254\u00c8\u0016g\u00c6\u00e8\u00fb\u000bz}(\u00c0;\u001df\r#\u0016\u00c6Q\u00b7yU\u00ad\u00b0\u00f2\u00b5\u007f\u009e\u00d0\f8W\u00caJ\u00b9\u00f8\u007f\u001b/r\u008d\u00d2\u00fa\u00e7\u00a4J\u00ff\u00b3S\u00c4\u00e8\u0084";
                        var4_3 = "-X\"\u0019\u009254\u00c8\u0016g\u00c6\u00e8\u00fb\u000bz}(\u00c0;\u001df\r#\u0016\u00c6Q\u00b7yU\u00ad\u00b0\u00f2\u00b5\u007f\u009e\u00d0\f8W\u00caJ\u00b9\u00f8\u007f\u001b/r\u008d\u00d2\u00fa\u00e7\u00a4J\u00ff\u00b3S\u00c4\u00e8\u0084".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 14;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 99;
                                break;
                            }
                            case 1: {
                                v15 = 69;
                                break;
                            }
                            case 2: {
                                v15 = 42;
                                break;
                            }
                            case 3: {
                                v15 = 84;
                                break;
                            }
                            case 4: {
                                v15 = 2;
                                break;
                            }
                            case 5: {
                                v15 = 107;
                                break;
                            }
                            default: {
                                v15 = 99;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF91EF) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 174;
                    case 1 -> 221;
                    case 2 -> 71;
                    case 3 -> 113;
                    case 4 -> 163;
                    case 5 -> 133;
                    case 6 -> 234;
                    case 7 -> 45;
                    case 8 -> 18;
                    case 9 -> 132;
                    case 10 -> 226;
                    case 11 -> 196;
                    case 12 -> 118;
                    case 13 -> 32;
                    case 14 -> 44;
                    case 15 -> 49;
                    case 16 -> 56;
                    case 17 -> 59;
                    case 18 -> 244;
                    case 19 -> 126;
                    case 20 -> 87;
                    case 21 -> 240;
                    case 22 -> 203;
                    case 23 -> 30;
                    case 24 -> 100;
                    case 25 -> 12;
                    case 26 -> 136;
                    case 27 -> 14;
                    case 28 -> 73;
                    case 29 -> 85;
                    case 30 -> 117;
                    case 31 -> 189;
                    case 32 -> 13;
                    case 33 -> 78;
                    case 34 -> 157;
                    case 35 -> 150;
                    case 36 -> 183;
                    case 37 -> 142;
                    case 38 -> 102;
                    case 39 -> 50;
                    case 40 -> 147;
                    case 41 -> 177;
                    case 42 -> 83;
                    case 43 -> 43;
                    case 44 -> 111;
                    case 45 -> 252;
                    case 46 -> 149;
                    case 47 -> 11;
                    case 48 -> 241;
                    case 49 -> 159;
                    case 50 -> 37;
                    case 51 -> 22;
                    case 52 -> 25;
                    case 53 -> 116;
                    case 54 -> 169;
                    case 55 -> 77;
                    case 56 -> 194;
                    case 57 -> 158;
                    case 58 -> 4;
                    case 59 -> 145;
                    case 60 -> 97;
                    case 61 -> 104;
                    case 62 -> 114;
                    case 63 -> 232;
                    case 64 -> 69;
                    case 65 -> 249;
                    case 66 -> 202;
                    case 67 -> 40;
                    case 68 -> 115;
                    case 69 -> 81;
                    case 70 -> 26;
                    case 71 -> 60;
                    case 72 -> 201;
                    case 73 -> 243;
                    case 74 -> 170;
                    case 75 -> 88;
                    case 76 -> 84;
                    case 77 -> 195;
                    case 78 -> 20;
                    case 79 -> 248;
                    case 80 -> 231;
                    case 81 -> 178;
                    case 82 -> 80;
                    case 83 -> 27;
                    case 84 -> 242;
                    case 85 -> 68;
                    case 86 -> 10;
                    case 87 -> 245;
                    case 88 -> 143;
                    case 89 -> 161;
                    case 90 -> 67;
                    case 91 -> 211;
                    case 92 -> 188;
                    case 93 -> 228;
                    case 94 -> 5;
                    case 95 -> 15;
                    case 96 -> 2;
                    case 97 -> 216;
                    case 98 -> 190;
                    case 99 -> 96;
                    case 100 -> 103;
                    case 101 -> 90;
                    case 102 -> 180;
                    case 103 -> 141;
                    case 104 -> 251;
                    case 105 -> 8;
                    case 106 -> 146;
                    case 107 -> 1;
                    case 108 -> 72;
                    case 109 -> 206;
                    case 110 -> 91;
                    case 111 -> 74;
                    case 112 -> 246;
                    case 113 -> 86;
                    case 114 -> 139;
                    case 115 -> 166;
                    case 116 -> 212;
                    case 117 -> 21;
                    case 118 -> 36;
                    case 119 -> 229;
                    case 120 -> 199;
                    case 121 -> 204;
                    case 122 -> 47;
                    case 123 -> 200;
                    case 124 -> 198;
                    case 125 -> 65;
                    case 126 -> 175;
                    case 127 -> 66;
                    case 128 -> 155;
                    case 129 -> 52;
                    case 130 -> 255;
                    case 131 -> 193;
                    case 132 -> 92;
                    case 133 -> 98;
                    case 134 -> 214;
                    case 135 -> 152;
                    case 136 -> 127;
                    case 137 -> 70;
                    case 138 -> 6;
                    case 139 -> 224;
                    case 140 -> 182;
                    case 141 -> 79;
                    case 142 -> 42;
                    case 143 -> 235;
                    case 144 -> 119;
                    case 145 -> 233;
                    case 146 -> 187;
                    case 147 -> 41;
                    case 148 -> 205;
                    case 149 -> 54;
                    case 150 -> 95;
                    case 151 -> 24;
                    case 152 -> 51;
                    case 153 -> 76;
                    case 154 -> 57;
                    case 155 -> 105;
                    case 156 -> 29;
                    case 157 -> 250;
                    case 158 -> 19;
                    case 159 -> 254;
                    case 160 -> 123;
                    case 161 -> 165;
                    case 162 -> 171;
                    case 163 -> 23;
                    case 164 -> 64;
                    case 165 -> 39;
                    case 166 -> 109;
                    case 167 -> 140;
                    case 168 -> 153;
                    case 169 -> 151;
                    case 170 -> 130;
                    case 171 -> 137;
                    case 172 -> 192;
                    case 173 -> 179;
                    case 174 -> 168;
                    case 175 -> 89;
                    case 176 -> 223;
                    case 177 -> 34;
                    case 178 -> 181;
                    case 179 -> 131;
                    case 180 -> 99;
                    case 181 -> 253;
                    case 182 -> 172;
                    case 183 -> 230;
                    case 184 -> 62;
                    case 185 -> 61;
                    case 186 -> 160;
                    case 187 -> 225;
                    case 188 -> 58;
                    case 189 -> 219;
                    case 190 -> 154;
                    case 191 -> 16;
                    case 192 -> 144;
                    case 193 -> 28;
                    case 194 -> 31;
                    case 195 -> 46;
                    case 196 -> 125;
                    case 197 -> 148;
                    case 198 -> 135;
                    case 199 -> 55;
                    case 200 -> 222;
                    case 201 -> 138;
                    case 202 -> 191;
                    case 203 -> 215;
                    case 204 -> 35;
                    case 205 -> 213;
                    case 206 -> 236;
                    case 207 -> 156;
                    case 208 -> 107;
                    case 209 -> 176;
                    case 210 -> 17;
                    case 211 -> 33;
                    case 212 -> 129;
                    case 213 -> 164;
                    case 214 -> 197;
                    case 215 -> 112;
                    case 216 -> 94;
                    case 217 -> 93;
                    case 218 -> 108;
                    case 219 -> 220;
                    case 220 -> 122;
                    case 221 -> 134;
                    case 222 -> 48;
                    case 223 -> 186;
                    case 224 -> 128;
                    case 225 -> 101;
                    case 226 -> 209;
                    case 227 -> 0;
                    case 228 -> 238;
                    case 229 -> 237;
                    case 230 -> 185;
                    case 231 -> 53;
                    case 232 -> 106;
                    case 233 -> 210;
                    case 234 -> 63;
                    case 235 -> 82;
                    case 236 -> 239;
                    case 237 -> 120;
                    case 238 -> 173;
                    case 239 -> 167;
                    case 240 -> 3;
                    case 241 -> 38;
                    case 242 -> 162;
                    case 243 -> 247;
                    case 244 -> 9;
                    case 245 -> 207;
                    case 246 -> 217;
                    case 247 -> 110;
                    case 248 -> 7;
                    case 249 -> 184;
                    case 250 -> 75;
                    case 251 -> 124;
                    case 252 -> 218;
                    case 253 -> 208;
                    case 254 -> 121;
                    default -> 227;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 1489162655905L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "h \u000b\u0001z{\u00151\to*\u0018\u000b79\b-l";
                    var5_4 = "h \u000b\u0001z{\u00151\to*\u0018\u000b79\b-l".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 89;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 90;
                                    break;
                                }
                                case 1: {
                                    v11 = 28;
                                    break;
                                }
                                case 2: {
                                    v11 = 32;
                                    break;
                                }
                                case 3: {
                                    v11 = 54;
                                    break;
                                }
                                case 4: {
                                    v11 = 70;
                                    break;
                                }
                                case 5: {
                                    v11 = 78;
                                    break;
                                }
                                default: {
                                    v11 = 127;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 68961989789362L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u0016`*\u0005G\u001e`\u0004\u0010~&\u001f\n\u001ca-\u001fK\u001cx6`$\t\u001ca-\u001fK\u001cx:j\r\u001bg0\u0012A\u0011b:m7\u0018@\u0018";
                    var5_4 = "\u0016`*\u0005G\u001e`\u0004\u0010~&\u001f\n\u001ca-\u001fK\u001cx6`$\t\u001ca-\u001fK\u001cx:j\r\u001bg0\u0012A\u0011b:m7\u0018@\u0018".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 89;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\\\"lB\u0007Q+\u0006\\\"lB\u000b[";
                        var5_4 = "\\\"lB\u0007Q+\u0006\\\"lB\u000b[".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 25;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 6;
                                break;
                            }
                            case 1: {
                                v15 = 87;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 40;
                                break;
                            }
                            case 4: {
                                v15 = 119;
                                break;
                            }
                            case 5: {
                                v15 = 38;
                                break;
                            }
                            default: {
                                v15 = 85;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 84871945360461L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-903334440 + -((char)-23366), -903334440 + -17194, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 87955218122618L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00fa-&\u00fb\u00b5\u0003\u00c6\u0099\u0015\u0005\u00ce\u000b\u0086\u00fbB\r\u00e6\u001a\u00b5\u0093\u00d1\u001aH3y\u009d\u00b1\u0015\u00d9\u0010 B\u00aas\r\u0093\u00f8?\u00a6\u0098\u00a9\u00f8<\u0092s\u00bd\u0005\u001d^\u00fcQ\r3P8D\u00ea\u0005\u00e4\u00c9\u00c5\u00fd:I\u0085\u00e6l\u0004}\u0087\u008ba\"\u0086\u00e1\u00de\u00ee\u0082A\u00da==\u00e7\u009f\u000b\u00a0\u00ca6\"F\u0096\u00f4\\\u00d2\u00db'\u00c9\u00f08\u0082\u0086A\u00bc\u00a1";
                    var4_3 = "\u00fa-&\u00fb\u00b5\u0003\u00c6\u0099\u0015\u0005\u00ce\u000b\u0086\u00fbB\r\u00e6\u001a\u00b5\u0093\u00d1\u001aH3y\u009d\u00b1\u0015\u00d9\u0010 B\u00aas\r\u0093\u00f8?\u00a6\u0098\u00a9\u00f8<\u0092s\u00bd\u0005\u001d^\u00fcQ\r3P8D\u00ea\u0005\u00e4\u00c9\u00c5\u00fd:I\u0085\u00e6l\u0004}\u0087\u008ba\"\u0086\u00e1\u00de\u00ee\u0082A\u00da==\u00e7\u009f\u000b\u00a0\u00ca6\"F\u0096\u00f4\\\u00d2\u00db'\u00c9\u00f08\u0082\u0086A\u00bc\u00a1".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 91;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "}\u00194-\u00ebm\u0011\u00d5\u00ae\u00f0\u009d\u00c0\u008f\u00a00\u00ceL\u0006V\u00ac\u000e\u00d2\u00c1X.\u000e\u001c%\u00e4\u0096\u00aa\u0080\u00f6'\u001e\u00bfS\u0000\u009e\u0011\u0096m\u00907\u00f4O\u00a2\u000b\u00f9\u0017O\u0084\u00bb\u0017N\u00d1\u0014u\u001a)\u00b9\u0011\u00dd@7\u00de\u008b\u008f\u008a:\u000e\u00de\u00d8\u0001O\u00db\"8\u00cf\u00d3b?\u008c\n\u0088\u0019\u00dc'\u00e8<\u00e2\u00d1[";
                        var4_3 = "}\u00194-\u00ebm\u0011\u00d5\u00ae\u00f0\u009d\u00c0\u008f\u00a00\u00ceL\u0006V\u00ac\u000e\u00d2\u00c1X.\u000e\u001c%\u00e4\u0096\u00aa\u0080\u00f6'\u001e\u00bfS\u0000\u009e\u0011\u0096m\u00907\u00f4O\u00a2\u000b\u00f9\u0017O\u0084\u00bb\u0017N\u00d1\u0014u\u001a)\u00b9\u0011\u00dd@7\u00de\u008b\u008f\u008a:\u000e\u00de\u00d8\u0001O\u00db\"8\u00cf\u00d3b?\u008c\n\u0088\u0019\u00dc'\u00e8<\u00e2\u00d1[".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 33;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 107;
                                break;
                            }
                            case 1: {
                                v15 = 63;
                                break;
                            }
                            case 2: {
                                v15 = 12;
                                break;
                            }
                            case 3: {
                                v15 = 108;
                                break;
                            }
                            case 4: {
                                v15 = 125;
                                break;
                            }
                            case 5: {
                                v15 = 83;
                                break;
                            }
                            default: {
                                v15 = 17;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x553) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 2;
                    case 1 -> 224;
                    case 2 -> 67;
                    case 3 -> 162;
                    case 4 -> 129;
                    case 5 -> 19;
                    case 6 -> 198;
                    case 7 -> 91;
                    case 8 -> 237;
                    case 9 -> 133;
                    case 10 -> 241;
                    case 11 -> 220;
                    case 12 -> 170;
                    case 13 -> 207;
                    case 14 -> 192;
                    case 15 -> 155;
                    case 16 -> 128;
                    case 17 -> 153;
                    case 18 -> 212;
                    case 19 -> 219;
                    case 20 -> 59;
                    case 21 -> 135;
                    case 22 -> 122;
                    case 23 -> 203;
                    case 24 -> 157;
                    case 25 -> 246;
                    case 26 -> 12;
                    case 27 -> 206;
                    case 28 -> 44;
                    case 29 -> 210;
                    case 30 -> 127;
                    case 31 -> 42;
                    case 32 -> 171;
                    case 33 -> 249;
                    case 34 -> 176;
                    case 35 -> 52;
                    case 36 -> 165;
                    case 37 -> 161;
                    case 38 -> 72;
                    case 39 -> 57;
                    case 40 -> 216;
                    case 41 -> 158;
                    case 42 -> 22;
                    case 43 -> 146;
                    case 44 -> 118;
                    case 45 -> 15;
                    case 46 -> 223;
                    case 47 -> 250;
                    case 48 -> 90;
                    case 49 -> 16;
                    case 50 -> 121;
                    case 51 -> 175;
                    case 52 -> 202;
                    case 53 -> 98;
                    case 54 -> 247;
                    case 55 -> 160;
                    case 56 -> 253;
                    case 57 -> 110;
                    case 58 -> 10;
                    case 59 -> 179;
                    case 60 -> 149;
                    case 61 -> 65;
                    case 62 -> 48;
                    case 63 -> 140;
                    case 64 -> 14;
                    case 65 -> 156;
                    case 66 -> 89;
                    case 67 -> 236;
                    case 68 -> 235;
                    case 69 -> 208;
                    case 70 -> 197;
                    case 71 -> 232;
                    case 72 -> 101;
                    case 73 -> 124;
                    case 74 -> 245;
                    case 75 -> 209;
                    case 76 -> 255;
                    case 77 -> 240;
                    case 78 -> 125;
                    case 79 -> 20;
                    case 80 -> 112;
                    case 81 -> 131;
                    case 82 -> 130;
                    case 83 -> 182;
                    case 84 -> 218;
                    case 85 -> 86;
                    case 86 -> 194;
                    case 87 -> 108;
                    case 88 -> 104;
                    case 89 -> 187;
                    case 90 -> 31;
                    case 91 -> 173;
                    case 92 -> 100;
                    case 93 -> 64;
                    case 94 -> 117;
                    case 95 -> 26;
                    case 96 -> 18;
                    case 97 -> 49;
                    case 98 -> 83;
                    case 99 -> 106;
                    case 100 -> 144;
                    case 101 -> 151;
                    case 102 -> 8;
                    case 103 -> 21;
                    case 104 -> 79;
                    case 105 -> 180;
                    case 106 -> 174;
                    case 107 -> 62;
                    case 108 -> 69;
                    case 109 -> 183;
                    case 110 -> 213;
                    case 111 -> 200;
                    case 112 -> 61;
                    case 113 -> 115;
                    case 114 -> 195;
                    case 115 -> 159;
                    case 116 -> 3;
                    case 117 -> 11;
                    case 118 -> 167;
                    case 119 -> 93;
                    case 120 -> 178;
                    case 121 -> 138;
                    case 122 -> 9;
                    case 123 -> 54;
                    case 124 -> 185;
                    case 125 -> 37;
                    case 126 -> 252;
                    case 127 -> 152;
                    case 128 -> 188;
                    case 129 -> 24;
                    case 130 -> 141;
                    case 131 -> 120;
                    case 132 -> 105;
                    case 133 -> 80;
                    case 134 -> 189;
                    case 135 -> 30;
                    case 136 -> 34;
                    case 137 -> 172;
                    case 138 -> 136;
                    case 139 -> 201;
                    case 140 -> 211;
                    case 141 -> 215;
                    case 142 -> 230;
                    case 143 -> 58;
                    case 144 -> 196;
                    case 145 -> 78;
                    case 146 -> 46;
                    case 147 -> 88;
                    case 148 -> 68;
                    case 149 -> 40;
                    case 150 -> 221;
                    case 151 -> 204;
                    case 152 -> 95;
                    case 153 -> 13;
                    case 154 -> 148;
                    case 155 -> 123;
                    case 156 -> 36;
                    case 157 -> 228;
                    case 158 -> 109;
                    case 159 -> 239;
                    case 160 -> 82;
                    case 161 -> 191;
                    case 162 -> 33;
                    case 163 -> 75;
                    case 164 -> 242;
                    case 165 -> 97;
                    case 166 -> 113;
                    case 167 -> 17;
                    case 168 -> 47;
                    case 169 -> 231;
                    case 170 -> 243;
                    case 171 -> 137;
                    case 172 -> 222;
                    case 173 -> 119;
                    case 174 -> 66;
                    case 175 -> 43;
                    case 176 -> 199;
                    case 177 -> 248;
                    case 178 -> 81;
                    case 179 -> 154;
                    case 180 -> 70;
                    case 181 -> 107;
                    case 182 -> 186;
                    case 183 -> 181;
                    case 184 -> 193;
                    case 185 -> 39;
                    case 186 -> 103;
                    case 187 -> 77;
                    case 188 -> 142;
                    case 189 -> 227;
                    case 190 -> 132;
                    case 191 -> 41;
                    case 192 -> 205;
                    case 193 -> 190;
                    case 194 -> 244;
                    case 195 -> 251;
                    case 196 -> 53;
                    case 197 -> 55;
                    case 198 -> 35;
                    case 199 -> 169;
                    case 200 -> 226;
                    case 201 -> 84;
                    case 202 -> 56;
                    case 203 -> 143;
                    case 204 -> 73;
                    case 205 -> 45;
                    case 206 -> 63;
                    case 207 -> 166;
                    case 208 -> 5;
                    case 209 -> 71;
                    case 210 -> 147;
                    case 211 -> 114;
                    case 212 -> 1;
                    case 213 -> 254;
                    case 214 -> 177;
                    case 215 -> 38;
                    case 216 -> 184;
                    case 217 -> 32;
                    case 218 -> 7;
                    case 219 -> 145;
                    case 220 -> 111;
                    case 221 -> 51;
                    case 222 -> 0;
                    case 223 -> 28;
                    case 224 -> 150;
                    case 225 -> 139;
                    case 226 -> 87;
                    case 227 -> 233;
                    case 228 -> 29;
                    case 229 -> 229;
                    case 230 -> 96;
                    case 231 -> 4;
                    case 232 -> 27;
                    case 233 -> 214;
                    case 234 -> 6;
                    case 235 -> 164;
                    case 236 -> 74;
                    case 237 -> 23;
                    case 238 -> 60;
                    case 239 -> 85;
                    case 240 -> 163;
                    case 241 -> 99;
                    case 242 -> 50;
                    case 243 -> 225;
                    case 244 -> 25;
                    case 245 -> 76;
                    case 246 -> 168;
                    case 247 -> 126;
                    case 248 -> 134;
                    case 249 -> 102;
                    case 250 -> 234;
                    case 251 -> 94;
                    case 252 -> 238;
                    case 253 -> 217;
                    case 254 -> 116;
                    default -> 92;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 72569186220829L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1418701680 + (char)-7719, -1418832750 - -((char)-14481), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 129351019833555L;
                    int[] nArray = SshAgentIpcService.z();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-510255510 - -((char)-16356), -510255510 - -((char)-22937), (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 19466899508403L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "I2\u00c4*\u007f\u0003;\u00a4\u00dc";
                var4_3 = "I2\u00c4*\u007f\u0003;\u00a4\u00dc".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 42;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 69;
                                break;
                            }
                            case 1: {
                                v11 = 109;
                                break;
                            }
                            case 2: {
                                v11 = 2;
                                break;
                            }
                            case 3: {
                                v11 = 75;
                                break;
                            }
                            case 4: {
                                v11 = 117;
                                break;
                            }
                            case 5: {
                                v11 = 93;
                                break;
                            }
                            default: {
                                v11 = 92;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7654) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 94;
                    case 1 -> 109;
                    case 2 -> 255;
                    case 3 -> 217;
                    case 4 -> 23;
                    case 5 -> 85;
                    case 6 -> 216;
                    case 7 -> 46;
                    case 8 -> 180;
                    case 9 -> 64;
                    case 10 -> 169;
                    case 11 -> 141;
                    case 12 -> 231;
                    case 13 -> 88;
                    case 14 -> 98;
                    case 15 -> 163;
                    case 16 -> 151;
                    case 17 -> 72;
                    case 18 -> 108;
                    case 19 -> 125;
                    case 20 -> 190;
                    case 21 -> 205;
                    case 22 -> 68;
                    case 23 -> 90;
                    case 24 -> 128;
                    case 25 -> 122;
                    case 26 -> 170;
                    case 27 -> 155;
                    case 28 -> 17;
                    case 29 -> 39;
                    case 30 -> 66;
                    case 31 -> 76;
                    case 32 -> 211;
                    case 33 -> 203;
                    case 34 -> 29;
                    case 35 -> 6;
                    case 36 -> 113;
                    case 37 -> 152;
                    case 38 -> 213;
                    case 39 -> 159;
                    case 40 -> 104;
                    case 41 -> 130;
                    case 42 -> 16;
                    case 43 -> 77;
                    case 44 -> 41;
                    case 45 -> 55;
                    case 46 -> 239;
                    case 47 -> 193;
                    case 48 -> 208;
                    case 49 -> 202;
                    case 50 -> 187;
                    case 51 -> 79;
                    case 52 -> 251;
                    case 53 -> 7;
                    case 54 -> 222;
                    case 55 -> 75;
                    case 56 -> 168;
                    case 57 -> 97;
                    case 58 -> 160;
                    case 59 -> 253;
                    case 60 -> 63;
                    case 61 -> 174;
                    case 62 -> 21;
                    case 63 -> 12;
                    case 64 -> 43;
                    case 65 -> 28;
                    case 66 -> 2;
                    case 67 -> 221;
                    case 68 -> 69;
                    case 69 -> 67;
                    case 70 -> 215;
                    case 71 -> 74;
                    case 72 -> 15;
                    case 73 -> 232;
                    case 74 -> 177;
                    case 75 -> 249;
                    case 76 -> 184;
                    case 77 -> 60;
                    case 78 -> 247;
                    case 79 -> 254;
                    case 80 -> 189;
                    case 81 -> 115;
                    case 82 -> 96;
                    case 83 -> 9;
                    case 84 -> 219;
                    case 85 -> 194;
                    case 86 -> 139;
                    case 87 -> 13;
                    case 88 -> 124;
                    case 89 -> 51;
                    case 90 -> 84;
                    case 91 -> 148;
                    case 92 -> 78;
                    case 93 -> 185;
                    case 94 -> 106;
                    case 95 -> 250;
                    case 96 -> 198;
                    case 97 -> 144;
                    case 98 -> 191;
                    case 99 -> 38;
                    case 100 -> 252;
                    case 101 -> 136;
                    case 102 -> 186;
                    case 103 -> 199;
                    case 104 -> 236;
                    case 105 -> 59;
                    case 106 -> 119;
                    case 107 -> 158;
                    case 108 -> 121;
                    case 109 -> 143;
                    case 110 -> 172;
                    case 111 -> 181;
                    case 112 -> 153;
                    case 113 -> 19;
                    case 114 -> 127;
                    case 115 -> 80;
                    case 116 -> 183;
                    case 117 -> 58;
                    case 118 -> 233;
                    case 119 -> 237;
                    case 120 -> 14;
                    case 121 -> 145;
                    case 122 -> 135;
                    case 123 -> 212;
                    case 124 -> 138;
                    case 125 -> 1;
                    case 126 -> 245;
                    case 127 -> 24;
                    case 128 -> 86;
                    case 129 -> 3;
                    case 130 -> 164;
                    case 131 -> 87;
                    case 132 -> 156;
                    case 133 -> 107;
                    case 134 -> 204;
                    case 135 -> 36;
                    case 136 -> 48;
                    case 137 -> 182;
                    case 138 -> 100;
                    case 139 -> 218;
                    case 140 -> 244;
                    case 141 -> 209;
                    case 142 -> 162;
                    case 143 -> 26;
                    case 144 -> 50;
                    case 145 -> 30;
                    case 146 -> 201;
                    case 147 -> 223;
                    case 148 -> 27;
                    case 149 -> 56;
                    case 150 -> 31;
                    case 151 -> 99;
                    case 152 -> 45;
                    case 153 -> 110;
                    case 154 -> 111;
                    case 155 -> 37;
                    case 156 -> 10;
                    case 157 -> 154;
                    case 158 -> 133;
                    case 159 -> 228;
                    case 160 -> 195;
                    case 161 -> 93;
                    case 162 -> 47;
                    case 163 -> 214;
                    case 164 -> 225;
                    case 165 -> 134;
                    case 166 -> 83;
                    case 167 -> 157;
                    case 168 -> 142;
                    case 169 -> 8;
                    case 170 -> 65;
                    case 171 -> 112;
                    case 172 -> 5;
                    case 173 -> 101;
                    case 174 -> 114;
                    case 175 -> 11;
                    case 176 -> 206;
                    case 177 -> 240;
                    case 178 -> 35;
                    case 179 -> 25;
                    case 180 -> 248;
                    case 181 -> 71;
                    case 182 -> 230;
                    case 183 -> 234;
                    case 184 -> 147;
                    case 185 -> 89;
                    case 186 -> 131;
                    case 187 -> 173;
                    case 188 -> 4;
                    case 189 -> 126;
                    case 190 -> 207;
                    case 191 -> 210;
                    case 192 -> 200;
                    case 193 -> 167;
                    case 194 -> 42;
                    case 195 -> 176;
                    case 196 -> 137;
                    case 197 -> 197;
                    case 198 -> 166;
                    case 199 -> 150;
                    case 200 -> 229;
                    case 201 -> 175;
                    case 202 -> 120;
                    case 203 -> 246;
                    case 204 -> 44;
                    case 205 -> 140;
                    case 206 -> 57;
                    case 207 -> 40;
                    case 208 -> 116;
                    case 209 -> 91;
                    case 210 -> 220;
                    case 211 -> 20;
                    case 212 -> 81;
                    case 213 -> 238;
                    case 214 -> 54;
                    case 215 -> 103;
                    case 216 -> 118;
                    case 217 -> 123;
                    case 218 -> 53;
                    case 219 -> 52;
                    case 220 -> 243;
                    case 221 -> 105;
                    case 222 -> 188;
                    case 223 -> 34;
                    case 224 -> 70;
                    case 225 -> 61;
                    case 226 -> 92;
                    case 227 -> 179;
                    case 228 -> 165;
                    case 229 -> 161;
                    case 230 -> 242;
                    case 231 -> 226;
                    case 232 -> 0;
                    case 233 -> 18;
                    case 234 -> 102;
                    case 235 -> 32;
                    case 236 -> 73;
                    case 237 -> 33;
                    case 238 -> 132;
                    case 239 -> 235;
                    case 240 -> 117;
                    case 241 -> 227;
                    case 242 -> 192;
                    case 243 -> 171;
                    case 244 -> 62;
                    case 245 -> 95;
                    case 246 -> 241;
                    case 247 -> 129;
                    case 248 -> 149;
                    case 249 -> 178;
                    case 250 -> 196;
                    case 251 -> 22;
                    case 252 -> 146;
                    case 253 -> 82;
                    case 254 -> 224;
                    default -> 49;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

