/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import com.jetbrains.lang.ejs.formatter.EjsBlock;
import com.jetbrains.lang.ejs.formatter.EjsFormattingModelBuilder;
import com.jetbrains.lang.ejs.formatter.settings.EjsCustomCodeStyleSettings;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EjsTemplateLanguageBlock
extends TemplateLanguageBlock
implements EjsBlock {
    private final EjsCustomCodeStyleSettings myCustomSettings;

    public EjsTemplateLanguageBlock(EjsFormattingModelBuilder builder, ASTNode compositeNode, Wrap wrap, Alignment alignment, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent) {
        super((AbstractXmlTemplateFormattingModelBuilder)builder, compositeNode, wrap, alignment, settings, xmlFormattingPolicy, indent);
        this.myCustomSettings = (EjsCustomCodeStyleSettings)settings.getCustomSettings(EjsCustomCodeStyleSettings.class);
    }

    public IElementType getElementType() {
        return this.myNode.getElementType();
    }

    @NotNull
    protected Indent getChildIndent(@NotNull ASTNode node) {
        if (node == null) {
            EjsTemplateLanguageBlock.$$$reportNull$$$0(0);
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            EjsTemplateLanguageBlock.$$$reportNull$$$0(1);
        }
        return indent;
    }

    protected Spacing getSpacing(TemplateLanguageBlock adjacentBlock) {
        return this.getSpacing(this, (Block)adjacentBlock);
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            EjsTemplateLanguageBlock.$$$reportNull$$$0(2);
        }
        if (child1 instanceof EjsTemplateLanguageBlock && EjsTokenTypes.OPEN_BRACES.contains(((EjsTemplateLanguageBlock)child1).getElementType())) {
            return this.getSpacingByBraceType(((EjsTemplateLanguageBlock)child1).getElementType());
        }
        if (child2 instanceof EjsTemplateLanguageBlock && ((EjsTemplateLanguageBlock)child2).getElementType() == EjsTokenTypes.CLOSE) {
            return this.getSpacingByBraceType(this.firstNodeElementType());
        }
        if (EjsTemplateLanguageBlock.ejsBlockWithType(child1, EjsTokenTypes.EJS_COLON)) {
            return this.creatSimpleSpaces(this.myCustomSettings.SPACES_AFTER_COLON);
        }
        if (EjsTemplateLanguageBlock.ejsBlockWithType(child2, EjsTokenTypes.EJS_COLON)) {
            return this.creatSimpleSpaces(this.myCustomSettings.SPACES_BEFORE_COLON);
        }
        if (EjsTemplateLanguageBlock.ejsBlockWithType(child1, EjsTokenTypes.EJS_OR) || EjsTemplateLanguageBlock.ejsBlockWithType(child2, EjsTokenTypes.EJS_OR)) {
            return this.creatSimpleSpaces(this.myCustomSettings.SPACES_WITHIN_CHAIN);
        }
        if (child1 instanceof EjsBlock && !((EjsBlock)child1).startsWithEQ() && child2 instanceof EjsBlock && !((EjsBlock)child2).startsWithEQ()) {
            return this.creatSimpleSpaces(true);
        }
        return null;
    }

    private static boolean ejsBlockWithType(Block block, IElementType expectedType) {
        return block instanceof EjsTemplateLanguageBlock && ((EjsTemplateLanguageBlock)block).getElementType() == expectedType;
    }

    private Spacing getSpacingByBraceType(@Nullable IElementType braceType) {
        return this.creatSimpleSpaces(this.myCustomSettings.needSpaces(braceType));
    }

    private Spacing creatSimpleSpaces(boolean spaces) {
        return Spacing.createSpacing((int)(spaces ? 1 : 0), (int)(spaces ? 1 : 0), (int)0, (boolean)this.getSettings().getCommonSettings((Language)JavascriptLanguage.INSTANCE).KEEP_LINE_BREAKS, (int)0);
    }

    protected void addBlocksForNonMarkupChild(List<Block> result, ASTNode child) {
        if (child.getElementType() == EjsTokenTypes.INNER_CONTENT) {
            PsiElement childPsi = child.getPsi();
            FormattingModelBuilder modelBuilder = LanguageFormatting.INSTANCE.forContext((Language)JavascriptLanguage.INSTANCE, childPsi);
            PsiFile jsPsiFile = childPsi.getContainingFile().getViewProvider().getPsi((Language)JavascriptLanguage.INSTANCE);
            if (modelBuilder != null && jsPsiFile != null) {
                FormattingModel childModel = modelBuilder.createModel(FormattingContext.create((PsiElement)jsPsiFile, (CodeStyleSettings)this.getSettings()));
                result.add((Block)new InjectedLanguageBlockWrapper(childModel.getRootBlock(), child.getStartOffset(), child.getTextRange(), Indent.getNoneIndent()));
            }
        } else {
            super.addBlocksForNonMarkupChild(result, child);
        }
    }

    @Override
    public boolean startsWithEQ() {
        IElementType nodeElementType = this.firstNodeElementType();
        return nodeElementType == EjsTokenTypes.OPEN_EQ || nodeElementType == EjsTokenTypes.OPEN_EQ_EQ || nodeElementType == EjsTokenTypes.OPEN_EQ_GENERATOR || nodeElementType == EjsTokenTypes.OPEN_FILTER;
    }

    @Nullable
    private IElementType firstNodeElementType() {
        ASTNode node = this.myNode.getFirstChildNode();
        return node != null ? node.getElementType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/formatter/EjsTemplateLanguageBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/formatter/EjsTemplateLanguageBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

