/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.FileContentUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.file.EjsFileType;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EjsUtils {
    private static final String OPEN_DELIMITER_KEY = "ejs.open.delimiter";
    private static final String CLOSE_DELIMITER_KEY = "ejs.close.delimiter";
    private static final Key<Couple<String>> DELIMITERS_KEY = Key.create((String)"ejs.test.delimiters");
    private static final List<String> myFilterNames = Arrays.asList("first", "last", "capitalize", "downcase", "upcase", "sort", "sort_by", "size", "length", "plus", "minus", "times", "divided_by", "join", "truncate", "truncate_words", "replace", "prepend", "append", "map", "reverse", "get");

    @NotNull
    public static List<Pair<String, IElementType>> getOpenBracesInfo(@Nullable Project project) {
        Couple<String> delimiters = EjsUtils.getDelimiters(project);
        String leftDelimiter = (String)delimiters.first;
        String lastLeftChar = leftDelimiter.substring(leftDelimiter.length() - 1);
        if ("=".equals(lastLeftChar)) {
            lastLeftChar = "%";
        }
        List<Pair<String, IElementType>> list = Arrays.asList(Pair.create((Object)(leftDelimiter + lastLeftChar + "="), (Object)((Object)EjsTokenTypes.OPEN_EQ_GENERATOR)), Pair.create((Object)(leftDelimiter + "=="), (Object)((Object)EjsTokenTypes.OPEN_EQ_EQ)), Pair.create((Object)(leftDelimiter + "="), (Object)((Object)EjsTokenTypes.OPEN_EQ)), Pair.create((Object)(leftDelimiter + "-"), (Object)((Object)EjsTokenTypes.OPEN_EQ)), Pair.create((Object)leftDelimiter, (Object)((Object)EjsTokenTypes.OPEN)));
        if (list == null) {
            EjsUtils.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static Pair<String, IElementType> getFilterBraceInfo(@Nullable Project project) {
        Pair pair = Pair.create((Object)((String)EjsUtils.getDelimiters((Project)project).first + "=:"), (Object)((Object)EjsTokenTypes.OPEN_FILTER));
        if (pair == null) {
            EjsUtils.$$$reportNull$$$0(1);
        }
        return pair;
    }

    @NotNull
    public static List<Pair<String, IElementType>> getCloseBraceInfo(@Nullable Project project) {
        String close = (String)EjsUtils.getDelimiters((Project)project).second;
        List<Pair<String, IElementType>> list = Arrays.asList(Pair.create((Object)close, (Object)EjsTokenTypes.CLOSE), Pair.create((Object)("-" + close), (Object)EjsTokenTypes.CLOSE), Pair.create((Object)("_" + close), (Object)EjsTokenTypes.CLOSE));
        if (list == null) {
            EjsUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static Pair<String, IElementType> getCommentBraceInfo(@Nullable Project project) {
        Pair pair = Pair.create((Object)((String)EjsUtils.getDelimiters((Project)project).first + "#"), (Object)((Object)EjsTokenTypes.BLOCK_COMMENT));
        if (pair == null) {
            EjsUtils.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public static Couple<String> getDelimiters(@Nullable Project project) {
        String defaultOpenDelimiter = "<%";
        String defaultCloseDelimiter = "%>";
        if (project == null) {
            Couple couple = Couple.of((Object)"<%", (Object)"%>");
            if (couple == null) {
                EjsUtils.$$$reportNull$$$0(4);
            }
            return couple;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Couple userData = (Couple)project.getUserData(DELIMITERS_KEY);
            Couple couple = userData != null ? userData : Couple.of((Object)"<%", (Object)"%>");
            if (couple == null) {
                EjsUtils.$$$reportNull$$$0(5);
            }
            return couple;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        Couple couple = Couple.of((Object)propertiesComponent.getValue(OPEN_DELIMITER_KEY, "<%"), (Object)propertiesComponent.getValue(CLOSE_DELIMITER_KEY, "%>"));
        if (couple == null) {
            EjsUtils.$$$reportNull$$$0(6);
        }
        return couple;
    }

    public static void setDelimiters(@Nullable Project project, @Nls String open, @Nls String close) {
        if (project == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            project.putUserData(DELIMITERS_KEY, (Object)Couple.of((Object)open, (Object)close));
        } else {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            propertiesComponent.setValue(OPEN_DELIMITER_KEY, open);
            propertiesComponent.setValue(CLOSE_DELIMITER_KEY, close);
        }
    }

    public static void reparseProjectFiles(final @NotNull Project project) {
        if (project == null) {
            EjsUtils.$$$reportNull$$$0(7);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, EjsBundle.message("ejs.project.reparsing", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList haxeFiles = new ArrayList();
                if (project.getBasePath() != null) {
                    FileBasedIndex.getInstance().iterateIndexableFiles(file -> {
                        if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)EjsFileType.INSTANCE)) {
                            haxeFiles.add(file);
                        }
                        return true;
                    }, project, indicator);
                }
                ApplicationManager.getApplication().invokeAndWait(() -> FileContentUtil.reparseFiles((Project)project, (Collection)haxeFiles, (!project.isDefault() ? 1 : 0) != 0), ModalityState.nonModal());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/lang/ejs/util/EjsUtils$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public static List<String> getFilterNames() {
        return Collections.unmodifiableList(myFilterNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/util/EjsUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenBracesInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterBraceInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseBraceInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentBraceInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/util/EjsUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reparseProjectFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7 -> new IllegalArgumentException(string);
        };
    }
}

