/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.introspector.OraCatalogAccessPermissions;
import com.intellij.database.dialects.oracle.introspector.OraTouchedObjectIds;
import com.intellij.database.dialects.oracle.introspector.OraTypeAndName;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraConstraint;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMajorSchemaObject;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraStoredSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.OraViewTrigger;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModMultiLevelObject;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Level;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0092\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f\u001a\"\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a \u0010\u001d\u001a\u00020\u000b*\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0000\u001a\u0016\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u00192\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0016\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00192\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0016\u0010'\u001a\u0004\u0018\u00010(*\u00020)2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0016\u0010*\u001a\u0004\u0018\u00010+*\u00020\u00192\u0006\u0010,\u001a\u00020\u0002H\u0000\u001a\u0010\u0010-\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002H\u0001\u001ah\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u00022\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u00022\b\u0010:\u001a\u0004\u0018\u00010\u00022\b\u0010;\u001a\u0004\u0018\u00010\u00022\u0006\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020>H\u0000\u001a\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u0002082\u0006\u0010B\u001a\u00020>H\u0000\u001a*\u0010C\u001a\u00020D2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010E\u001a\u00020@H\u0000\u001aL\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u0002012\b\u0010I\u001a\u0004\u0018\u00010\u00022\b\u0010J\u001a\u0004\u0018\u00010\u00022\b\u0010K\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010L\u001a\u00020\u00062\b\b\u0002\u0010M\u001a\u00020\u00062\b\b\u0002\u0010N\u001a\u000208H\u0000\u001a\u001a\u0010T\u001a\u00020\u000b2\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u001a\u0010X\u001a\u00020\u000b2\u0006\u0010Y\u001a\u00020Z2\b\u0010W\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u0012\u0010l\u001a\u00020>2\b\u0010m\u001a\u0004\u0018\u00010nH\u0000\u001a\u0016\u0010o\u001a\u0004\u0018\u00010n*\u0002012\u0006\u0010p\u001a\u00020qH\u0000\u001a\u0012\u0010r\u001a\u0004\u0018\u00010\u00152\u0006\u0010s\u001a\u00020\u0002H\u0000\u001a\u001e\u0010t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100S*\b\u0012\u0004\u0012\u00020v0uH\u0000\u001a\u0012\u0010w\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020v0uH\u0000\u001a\u0012\u0010z\u001a\u00020>2\n\u0010{\u001a\u00060|j\u0002`}\u001a\u0018\u0010~\u001a\u00020\u000b2\u0006\u0010\u007f\u001a\u00020\u00022\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060SX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010[\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010^\"\u0014\u0010_\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010^\"\u0014\u0010a\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010^\"\u0014\u0010c\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010^\"\u0014\u0010e\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010^\"\u0014\u0010g\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010^\"\u0014\u0010i\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010^\"\u000e\u0010k\u001a\u000208X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010x\u001a\u00020\\X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010^\"\u000f\u0010\u0082\u0001\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0083\u0001\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0084\u0001\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001"}, d2={"SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "", "getSYSTEM_SCHEMAS", "()Ljava/util/TreeSet;", "SRC_NAMES_PORTION_SIZE", "", "applicablePortionTypeFor", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "n", "setOracleCatalogAccessModeParameters", "", "permissions", "Lcom/intellij/database/dialects/oracle/introspector/OraCatalogAccessPermissions;", "parameters", "", "", "setOracleSpecificParameters", "version", "Lcom/intellij/database/util/Version;", "oracleKindByMajorInternalCode", "Lcom/intellij/database/model/ObjectKind;", "code", "cleanSchemaIntrospectionInformation", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "dropUnexistentObjectsInSchema", "identifiers", "Lit/unimi/dsi/fastutil/longs/LongSet;", "setCreatedAndModifiedTimestamps", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "findTableOrViewByName", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "name", "findModuleByName", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "findModConstraint", "Lcom/intellij/database/dialects/oracle/model/OraConstraint;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "findTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "triggerName", "unquoteNameIfPossible", "makeArgument", "dasTypeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "position", "", "argName", "argDirection", "", "typeMod", "dataTypeSchemaName", "dataTypePackageName", "dataTypeSpec", "defaulted", "", "handleArgumentDirection", "Lcom/intellij/database/model/ArgumentDirection;", "directionChar", "nameExists", "makeOrGetArgument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "direction", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typePackageName", "typeSpec", "precision", "scale", "unitsCode", "SIMPLE_DATA_TYPES", "", "EXPLICIT_UNIT_DATA_TYPES", "DATA_TYPE_STAR_SIZE", "", "applyStoredProgramSources", "obj", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "NATIVE_TRIGGER_DEFINITION_PATTERN", "Lkotlin/text/Regex;", "getNATIVE_TRIGGER_DEFINITION_PATTERN", "()Lkotlin/text/Regex;", "SIMPLE_QUOTED_NAME_PATTERN", "getSIMPLE_QUOTED_NAME_PATTERN", "AUTO_NOT_NULL_CHECK_PATTERN", "getAUTO_NOT_NULL_CHECK_PATTERN", "COLLECTION_TYPE_SURROGATE_NAME_PATTERN", "getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN", "INDEX_SURROGATE_NAME_PATTERN", "getINDEX_SURROGATE_NAME_PATTERN", "INDEX_EXPRESSION_STUB_PATTERN", "getINDEX_EXPRESSION_STUB_PATTERN", "SEQUENCE_SURROGATE_NAME_PATTERN", "getSEQUENCE_SURROGATE_NAME_PATTERN", "DELIMITER", "canCheckOutdated", "e", "Lcom/intellij/database/model/basic/BasicElement;", "findOracleObjectByStringTypeAndName", "oracleTypeAndName", "Lcom/intellij/database/dialects/oracle/introspector/OraTypeAndName;", "getObjectKindByOracleTypeName", "oracleTypeName", "schemasParameters", "", "Lcom/intellij/database/dialects/oracle/introspector/OraTouchedObjectIds;", "nameStr", "obfuscationTextPattern", "getObfuscationTextPattern", "adjustStringLiteralsForOracle9i", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "analyzeDbLinkSrc", "src", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "DB_LINK_SHARED_PATTERN", "DB_LINK_CONNECT_PATTERN", "DB_LINK_AUTH_PATTERN", "intellij.database.dialects.oracle"})
@JvmName(name="OraIntrospectorFunctions")
@SourceDebugExtension(value={"SMAP\nOraIntrospectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraIntrospectorHelper.kt\ncom/intellij/database/dialects/oracle/introspector/OraIntrospectorFunctions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,604:1\n1#2:605\n1#2:620\n1563#3:606\n1634#3,3:607\n1617#3,9:610\n1869#3:619\n1870#3:621\n1626#3:622\n*S KotlinDebug\n*F\n+ 1 OraIntrospectorHelper.kt\ncom/intellij/database/dialects/oracle/introspector/OraIntrospectorFunctions\n*L\n536#1:620\n535#1:606\n535#1:607,3\n536#1:610,9\n536#1:619\n536#1:621\n536#1:622\n*E\n"})
public final class OraIntrospectorFunctions {
    @NotNull
    private static final TreeSet<String> SYSTEM_SCHEMAS;
    public static final int SRC_NAMES_PORTION_SIZE = 100;
    @NotNull
    private static final Set<String> SIMPLE_DATA_TYPES;
    @NotNull
    private static final Set<String> EXPLICIT_UNIT_DATA_TYPES;
    @NotNull
    private static final Map<String, Integer> DATA_TYPE_STAR_SIZE;
    @NotNull
    private static final Regex NATIVE_TRIGGER_DEFINITION_PATTERN;
    @NotNull
    private static final Regex SIMPLE_QUOTED_NAME_PATTERN;
    @NotNull
    private static final Regex AUTO_NOT_NULL_CHECK_PATTERN;
    @NotNull
    private static final Regex COLLECTION_TYPE_SURROGATE_NAME_PATTERN;
    @NotNull
    private static final Regex INDEX_SURROGATE_NAME_PATTERN;
    @NotNull
    private static final Regex INDEX_EXPRESSION_STUB_PATTERN;
    @NotNull
    private static final Regex SEQUENCE_SURROGATE_NAME_PATTERN;
    public static final char DELIMITER = '\uffff';
    @NotNull
    private static final Regex obfuscationTextPattern;
    @NotNull
    private static final Regex DB_LINK_SHARED_PATTERN;
    @NotNull
    private static final Regex DB_LINK_CONNECT_PATTERN;
    @NotNull
    private static final Regex DB_LINK_AUTH_PATTERN;

    @NotNull
    public static final TreeSet<String> getSYSTEM_SCHEMAS() {
        return SYSTEM_SCHEMAS;
    }

    @NotNull
    public static final PortionType applicablePortionTypeFor(int n) {
        return n <= 1 ? PortionType.ONE : (n <= PortionType.SMALL.getSize() ? PortionType.SMALL : (n <= PortionType.NORMAL.getSize() ? PortionType.NORMAL : PortionType.ALL));
    }

    public static final void setOracleCatalogAccessModeParameters(@NotNull OraCatalogAccessPermissions permissions, @NotNull Map<String, Object> parameters) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (permissions.getHasSCR() || permissions.getHasSAD()) {
            parameters.put("DBA", true);
            parameters.put("CAT", "sys.DBA");
            parameters.put("CATDU", "sys.DBA");
            parameters.remove("SLOW");
            if (permissions.getFast()) {
                parameters.put("FAST", true);
                v0 = Unit.INSTANCE;
            } else {
                v0 = parameters.remove("FAST");
            }
        } else {
            parameters.put("CAT", "sys.ALL");
            parameters.put("CATDU", "sys.USER");
            parameters.put("SLOW", true);
            parameters.remove("DBA");
            v0 = parameters.remove("FAST");
        }
    }

    public static final void setOracleSpecificParameters(@NotNull Version version, @NotNull Map<String, Object> parameters) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        int[] nArray = new int[]{12, 2};
        if (version.isOrGreater(nArray) && Registry.Companion.is("database.oracle.names.long")) {
            parameters.put("N12", true);
        }
    }

    @NotNull
    public static final ObjectKind oracleKindByMajorInternalCode(@NotNull String code) {
        ObjectKind objectKind;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "TA": {
                ObjectKind objectKind2 = ObjectKind.TABLE;
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"TABLE");
                break;
            }
            case "CL": {
                ObjectKind objectKind3 = ObjectKind.CLUSTER;
                objectKind = objectKind3;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"CLUSTER");
                break;
            }
            case "VI": {
                ObjectKind objectKind4 = ObjectKind.VIEW;
                objectKind = objectKind4;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"VIEW");
                break;
            }
            case "SY": {
                ObjectKind objectKind5 = ObjectKind.SYNONYM;
                objectKind = objectKind5;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind5, (String)"SYNONYM");
                break;
            }
            case "SE": {
                ObjectKind objectKind6 = ObjectKind.SEQUENCE;
                objectKind = objectKind6;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind6, (String)"SEQUENCE");
                break;
            }
            case "PR": {
                ObjectKind objectKind7 = ObjectKind.ROUTINE;
                objectKind = objectKind7;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind7, (String)"ROUTINE");
                break;
            }
            case "FU": {
                ObjectKind objectKind8 = ObjectKind.ROUTINE;
                objectKind = objectKind8;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind8, (String)"ROUTINE");
                break;
            }
            case "PA": {
                ObjectKind objectKind9 = ObjectKind.PACKAGE;
                objectKind = objectKind9;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind9, (String)"PACKAGE");
                break;
            }
            case "MA": {
                ObjectKind objectKind10 = ObjectKind.MAT_VIEW;
                objectKind = objectKind10;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind10, (String)"MAT_VIEW");
                break;
            }
            case "YB": {
                ObjectKind objectKind11 = ObjectKind.OBJECT_TYPE;
                objectKind = objectKind11;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind11, (String)"OBJECT_TYPE");
                break;
            }
            case "YC": {
                ObjectKind objectKind12 = ObjectKind.COLLECTION_TYPE;
                objectKind = objectKind12;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind12, (String)"COLLECTION_TYPE");
                break;
            }
            case "DA": {
                ObjectKind objectKind13 = ObjectKind.DB_LINK;
                objectKind = objectKind13;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind13, (String)"DB_LINK");
                break;
            }
            default: {
                ObjectKind objectKind14 = ObjectKind.UNKNOWN_OBJECT;
                objectKind = objectKind14;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind14, (String)"UNKNOWN_OBJECT");
            }
        }
        return objectKind;
    }

    public static final void cleanSchemaIntrospectionInformation(@NotNull OraSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        schema.setLastIntrospectionVersion(0);
        schema.setLastIntrospectionServerTimestamp(null);
        schema.setLastIntrospectionLocalTimestamp(null);
        schema.setLastIntrospectionL1Timestamp(null);
        schema.setLastIntrospectionL2Timestamp(null);
        schema.setLastIntrospectionL3Timestamp(null);
        schema.setCommentsHash(0L);
        schema.setDbLinksHash(0L);
    }

    public static final void dropUnexistentObjectsInSchema(@NotNull OraSchema schema, @NotNull LongSet identifiers) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)identifiers, (String)"identifiers");
        ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = schema.getSequences();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSequences(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily2 = schema.getClusters();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getClusters(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily2), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily3 = schema.getTables();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily3), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily4 = schema.getMatViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getMatViews(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily4), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily5 = schema.getViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getViews(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily5), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily6 = schema.getPackages();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getPackages(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily6), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily7 = schema.getObjectTypes();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getObjectTypes(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily7), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily8 = schema.getCollectionTypes();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getCollectionTypes(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily8), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily9 = schema.getRoutines();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"getRoutines(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily9), (LongSet)identifiers);
        ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily10 = schema.getSynonyms();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"getSynonyms(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily10), (LongSet)identifiers);
        for (OraCluster cluster : schema.getClusters()) {
            ModSingletonFamily<? extends OraClusterIndex> modSingletonFamily = cluster.getIndices();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"getIndices(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, (LongSet)identifiers);
        }
        for (OraStoredSchemaObject table : schema.getTables()) {
            ModNamingIdentifyingFamily<? extends OraIndex> modNamingIdentifyingFamily11 = table.getIndices();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily11, (String)"getIndices(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily11), (LongSet)identifiers);
            ModNamingIdentifyingFamily<? extends OraTableTrigger> modNamingIdentifyingFamily12 = table.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily12, (String)"getTriggers(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily12), (LongSet)identifiers);
        }
        for (Object e : schema.getMatViews()) {
            OraStoredSchemaObject table;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            table = (OraMatView)e;
        }
        for (OraView view : schema.getViews()) {
            ModNamingIdentifyingFamily<? extends OraViewTrigger> modNamingIdentifyingFamily13 = view.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily13, (String)"getTriggers(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily)((ModIdentifyingFamily)modNamingIdentifyingFamily13), (LongSet)identifiers);
        }
        for (OraPackage pack : schema.getPackages()) {
            ModSingletonFamily<? extends OraPackageBody> modSingletonFamily = pack.getBodies();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"getBodies(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, (LongSet)identifiers);
        }
        for (OraObjectType ot : schema.getObjectTypes()) {
            ModSingletonFamily<? extends OraObjectTypeBody> modSingletonFamily = ot.getBodies();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"getBodies(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, (LongSet)identifiers);
        }
    }

    public static final void setCreatedAndModifiedTimestamps(@NotNull OraSchemaObject $this$setCreatedAndModifiedTimestamps, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$setCreatedAndModifiedTimestamps, (String)"<this>");
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    @Nullable
    public static final OraLikeTable findTableOrViewByName(@NotNull OraSchema $this$findTableOrViewByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findTableOrViewByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraLikeTable oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getMatViews().get(name2);
        if (oraLikeTable == null && (oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getTables().get(name2)) == null) {
            oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getViews().get(name2);
        }
        return oraLikeTable;
    }

    @Nullable
    public static final OraModule findModuleByName(@NotNull OraSchema $this$findModuleByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findModuleByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraModule oraModule = (OraModule)$this$findModuleByName.getObjectTypes().get(name2);
        if (oraModule == null) {
            oraModule = (OraModule)$this$findModuleByName.getPackages().get(name2);
        }
        return oraModule;
    }

    @Nullable
    public static final OraConstraint findModConstraint(@NotNull OraTable $this$findModConstraint, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findModConstraint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraConstraint oraConstraint = (OraConstraint)$this$findModConstraint.getKeys().get(name2);
        if (oraConstraint == null && (oraConstraint = (OraConstraint)$this$findModConstraint.getForeignKeys().get(name2)) == null) {
            oraConstraint = (OraConstraint)$this$findModConstraint.getChecks().get(name2);
        }
        return oraConstraint;
    }

    @Nullable
    public static final OraTrigger findTrigger(@NotNull OraSchema $this$findTrigger, @NotNull String triggerName) {
        Intrinsics.checkNotNullParameter((Object)$this$findTrigger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        OraTrigger trigger = null;
        for (OraTable table : $this$findTrigger.getTables()) {
            trigger = (OraTrigger)table.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        for (OraSourceAware view : $this$findTrigger.getViews()) {
            trigger = (OraTrigger)view.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        for (OraSourceAware view : $this$findTrigger.getMatViews()) {
            trigger = (OraTrigger)view.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static final String unquoteNameIfPossible(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = SIMPLE_QUOTED_NAME_PATTERN.matchEntire((CharSequence)name2);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = name2;
        }
        return object;
    }

    public static final void makeArgument(@NotNull DasTypeSystemBase dasTypeSystem, @NotNull BasicSchema schema, @NotNull OraRoutine routine, short position, @Nullable String argName, char argDirection, @Nullable String typeMod, @Nullable String dataTypeSchemaName, @Nullable String dataTypePackageName, @NotNull String dataTypeSpec, boolean defaulted) {
        Intrinsics.checkNotNullParameter((Object)dasTypeSystem, (String)"dasTypeSystem");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)routine, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)dataTypeSpec, (String)"dataTypeSpec");
        ArgumentDirection dir = OraIntrospectorFunctions.handleArgumentDirection(argDirection, argName != null);
        OraArgument argument = OraIntrospectorFunctions.makeOrGetArgument(routine, position, argName, dir);
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema, dataTypeSchemaName, dataTypePackageName, dataTypeSpec, 0, 0, '\u0000', 112, null);
        CharSequence charSequence = typeMod;
        if (!(charSequence == null || charSequence.length() == 0)) {
            DataType dataType2 = DataTypeFactory.withSuffix((DataType)dataType, (String)StringUtil.toUpperCase((String)typeMod));
            Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"withSuffix(...)");
            dataType = dataType2;
        }
        argument.setStoredType(dasTypeSystem.createDasType(dataType));
        CharSequence charSequence2 = charSequence = "???";
        OraArgument oraArgument = argument;
        boolean bl = false;
        boolean bl2 = defaulted;
        oraArgument.setDefaultExpression((String)(bl2 ? charSequence : null));
    }

    @NotNull
    public static final ArgumentDirection handleArgumentDirection(char directionChar, boolean nameExists) {
        ArgumentDirection dir = ArgumentDirection.of((char)directionChar);
        if (dir == null && nameExists) {
            dir = ArgumentDirection.IN;
        }
        if (dir == null) {
            dir = ArgumentDirection.IN;
        }
        return dir;
    }

    @NotNull
    public static final OraArgument makeOrGetArgument(@NotNull OraRoutine routine, short position, @Nullable String name2, @NotNull ArgumentDirection direction) {
        Intrinsics.checkNotNullParameter((Object)routine, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        OraArgument argument = null;
        if (direction == ArgumentDirection.RETURN) {
            BasicModArgument basicModArgument = routine.createOrGetReturnArgument();
            Intrinsics.checkNotNull((Object)basicModArgument, (String)"null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraArgument");
            argument = (OraArgument)basicModArgument;
            argument.setRealName(name2);
        } else {
            ModPositioningNamingFamily<? extends OraArgument> modPositioningNamingFamily = routine.getArguments();
            Object object = name2;
            if (object == null) {
                object = "unnamed_" + position;
            }
            BasicModNamedElement basicModNamedElement = modPositioningNamingFamily.createOrGet((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"createOrGet(...)");
            argument = (OraArgument)basicModNamedElement;
            ((BasicModArrangedElement)argument).setPosition(position);
            ((BasicModArgument)argument).setArgumentDirection(direction);
        }
        return argument;
    }

    @NotNull
    public static final DataType makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typePackageName, @Nullable String typeSpec, int precision, int scale, char unitsCode) {
        Intrinsics.checkNotNullParameter((Object)thisSchema, (String)"thisSchema");
        String spec = typeSpec;
        if (spec != null && spec.length() > 7 && StringsKt.startsWith$default((String)spec, (String)"PL/SQL ", (boolean)false, (int)2, null)) {
            String string = spec.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            spec = string;
        }
        DataType type = null;
        if (spec == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"UNKNOWN");
            type = dataType;
        } else if (StringsKt.startsWith$default((String)spec, (String)"INTERVAL YEAR TO", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)spec, (String)"INTERVAL DAY TO", (boolean)false, (int)2, null)) {
            int p = StringsKt.indexOf$default((CharSequence)spec, (String)"TO", (int)0, (boolean)false, (int)6, null);
            String string = spec.substring(0, p);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string3 = spec.substring(p);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            DataType dataType = DataTypeFactory.of(null, null, (String)string2, (int)precision, (int)0, null, (String)(((Object)StringsKt.trim((CharSequence)string3)).toString() + (String)(scale != 0 ? "(" + scale + ")" : "")), (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)spec, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of((String)spec);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            type = dataType;
        } else {
            DataType dataType;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SIMPLE_DATA_TYPES.contains(spec) && !customType;
            boolean explicitUnits = EXPLICIT_UNIT_DATA_TYPES.contains(spec) && unitsCode == 'C' && !customType;
            switch (unitsCode) {
                case 'B': {
                    LengthUnit lengthUnit = LengthUnit.BYTE;
                    break;
                }
                case 'C': {
                    LengthUnit lengthUnit = LengthUnit.CHAR;
                    break;
                }
                case 'D': {
                    LengthUnit lengthUnit = LengthUnit.DIGIT;
                    break;
                }
                default: {
                    LengthUnit lengthUnit = units = null;
                }
            }
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) || Intrinsics.areEqual((Object)typeSchemaName, (Object)"PUBLIC") ? null : typeSchemaName) : null;
            Integer starSize = DATA_TYPE_STAR_SIZE.get(spec);
            int p = starSize != null && precision == starSize ? 0x7FFFFFFE : precision;
            String suffix = null;
            if (StringsKt.startsWith((String)spec, (String)"TIMESTAMP ", (boolean)true)) {
                suffix = StringsKt.contains((CharSequence)spec, (CharSequence)"LOCAL", (boolean)true) ? "WITH LOCAL TIME ZONE" : "WITH TIME ZONE";
                spec = "TIMESTAMP";
            }
            if (customType) {
                DataType dataType2 = DataTypeFactory.of((String)explicitSchemaName, (String)typePackageName, (String)spec, (int)-1, (int)0, null, (String)suffix, (boolean)false, (boolean)true);
                dataType = dataType2;
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
            } else if (simple) {
                DataType dataType3 = DataTypeFactory.of(null, (String)typePackageName, (String)spec, (int)-1, (int)-1, (LengthUnit)units, (String)suffix, (boolean)false, (boolean)false);
                dataType = dataType3;
                Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"of(...)");
            } else {
                DataType dataType4 = DataTypeFactory.of(null, (String)typePackageName, (String)spec, (int)p, (int)scale, (LengthUnit)units, (String)suffix, (boolean)explicitUnits, (boolean)false);
                dataType = dataType4;
                Intrinsics.checkNotNullExpressionValue((Object)dataType4, (String)"of(...)");
            }
            type = dataType;
        }
        return type;
    }

    public static /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, String string3, int n, int n2, char c, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = -1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            c = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, string3, n, n2, c);
    }

    public static final void applyStoredProgramSources(@NotNull OraSourceAware obj, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        CharSequence charSequence = text;
        if (!(charSequence == null || charSequence.length() == 0)) {
            obj.setSourceText((CompositeText)new SimpleCompositeText((CharSequence)text, CompositeText.Kind.ORIGINAL_TEXT));
            if (obj instanceof OraMajorSchemaObject) {
                ((BasicModMultiLevelObject)obj).setDetailsLevel(Level.L3);
            }
        } else {
            obj.setSourceText(null);
        }
    }

    public static final void applyViewSources(@NotNull BasicModSourceAware view, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        CharSequence charSequence = text;
        if (!(charSequence == null || charSequence.length() == 0)) {
            view.setSourceText((CompositeText)new SimpleCompositeText((CharSequence)text, CompositeText.Kind.ORIGINAL_TEXT));
            if (view instanceof OraMajorSchemaObject) {
                ((BasicModMultiLevelObject)view).setDetailsLevel(Level.L3);
            }
        } else {
            view.setSourceText(null);
        }
    }

    @NotNull
    public static final Regex getNATIVE_TRIGGER_DEFINITION_PATTERN() {
        return NATIVE_TRIGGER_DEFINITION_PATTERN;
    }

    @NotNull
    public static final Regex getSIMPLE_QUOTED_NAME_PATTERN() {
        return SIMPLE_QUOTED_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getAUTO_NOT_NULL_CHECK_PATTERN() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @NotNull
    public static final Regex getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN() {
        return COLLECTION_TYPE_SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getINDEX_SURROGATE_NAME_PATTERN() {
        return INDEX_SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getINDEX_EXPRESSION_STUB_PATTERN() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    @NotNull
    public static final Regex getSEQUENCE_SURROGATE_NAME_PATTERN() {
        return SEQUENCE_SURROGATE_NAME_PATTERN;
    }

    public static final boolean canCheckOutdated(@Nullable BasicElement e) {
        return e == null || e instanceof OraCatalogObject && !(e instanceof OraSchema) && ((OraCatalogObject)e).getObjectId() != Long.MIN_VALUE && ((OraCatalogObject)e).getModifiedTimestamp() != null;
    }

    @Nullable
    public static final BasicElement findOracleObjectByStringTypeAndName(@NotNull BasicSchema $this$findOracleObjectByStringTypeAndName, @NotNull OraTypeAndName oracleTypeAndName) {
        Intrinsics.checkNotNullParameter((Object)$this$findOracleObjectByStringTypeAndName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)oracleTypeAndName, (String)"oracleTypeAndName");
        String string = oracleTypeAndName.getType();
        if (string == null) {
            return null;
        }
        String objectTypeName = string;
        ObjectKind objectKind = OraIntrospectorFunctions.getObjectKindByOracleTypeName(objectTypeName);
        if (objectKind == null) {
            return null;
        }
        ObjectKind objectKind2 = objectKind;
        String string2 = oracleTypeAndName.getName();
        if (string2 == null) {
            return null;
        }
        String objectName = string2;
        ObjectKind objectKind3 = objectKind2;
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.OBJECT_TYPE)) {
            BasicNamedElement o;
            Family family1 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.OBJECT_TYPE);
            NamingFamily namingFamily = family1 instanceof NamingFamily ? (NamingFamily)family1 : null;
            Object object = o = namingFamily != null ? namingFamily.get(objectName) : null;
            if (o == null) {
                Family family2 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.COLLECTION_TYPE);
                NamingFamily namingFamily2 = family2 instanceof NamingFamily ? (NamingFamily)family2 : null;
                o = namingFamily2 != null ? namingFamily2.get(objectName) : null;
            }
            return (BasicElement)o;
        }
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.BODY)) {
            ObjectKind objectKind4;
            switch (objectTypeName.charAt(0)) {
                case 'P': {
                    objectKind4 = ObjectKind.PACKAGE;
                    break;
                }
                case 'T': {
                    objectKind4 = ObjectKind.OBJECT_TYPE;
                    break;
                }
                default: {
                    return null;
                }
            }
            ObjectKind parentKind = objectKind4;
            Family family = $this$findOracleObjectByStringTypeAndName.familyOf(parentKind);
            if (family == null) {
                return null;
            }
            Family parentFamily = family;
            NamingFamily namingFamily = parentFamily instanceof NamingFamily ? (NamingFamily)parentFamily : null;
            if (namingFamily == null || (namingFamily = namingFamily.get(objectName)) == null) {
                return null;
            }
            NamingFamily parent = namingFamily;
            Family family2 = parent.familyOf(ObjectKind.BODY);
            return family2 != null ? (BasicElement)CollectionsKt.firstOrNull((Iterable)((Iterable)family2)) : null;
        }
        Family family = $this$findOracleObjectByStringTypeAndName.familyOf(objectKind2);
        if (family == null) {
            return null;
        }
        Family family3 = family;
        return family3 instanceof NamingFamily ? (BasicElement)((NamingFamily)family3).get(objectName) : null;
    }

    @Nullable
    public static final ObjectKind getObjectKindByOracleTypeName(@NotNull String oracleTypeName) {
        Intrinsics.checkNotNullParameter((Object)oracleTypeName, (String)"oracleTypeName");
        return switch (oracleTypeName) {
            case "INDEX" -> ObjectKind.INDEX;
            case "TABLE" -> ObjectKind.TABLE;
            case "CLUSTER" -> ObjectKind.CLUSTER;
            case "VIEW" -> ObjectKind.VIEW;
            case "SYNONYM" -> ObjectKind.SYNONYM;
            case "SEQUENCE" -> ObjectKind.SEQUENCE;
            case "PROCEDURE" -> ObjectKind.ROUTINE;
            case "FUNCTION" -> ObjectKind.ROUTINE;
            case "PACKAGE" -> ObjectKind.PACKAGE;
            case "PACKAGE BODY" -> ObjectKind.BODY;
            case "TRIGGER" -> ObjectKind.TRIGGER;
            case "TYPE" -> ObjectKind.OBJECT_TYPE;
            case "TYPE BODY" -> ObjectKind.BODY;
            case "MATERIALIZED VIEW" -> ObjectKind.MAT_VIEW;
            case "DATABASE LINK" -> ObjectKind.DB_LINK;
            default -> null;
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> schemasParameters(@NotNull Collection<OraTouchedObjectIds> $this$schemasParameters) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$schemasParameters, (String)"<this>");
        Iterable $this$map$iv = $this$schemasParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            OraTouchedObjectIds oraTouchedObjectIds = (OraTouchedObjectIds)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getSchemaId());
        }
        long[] schemaIds = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv = $this$schemasParameters;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OraTouchedObjectIds p0 = (OraTouchedObjectIds)element$iv$iv;
            boolean bl2 = false;
            if (p0.getSchemaName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List schemaNames = (List)destination$iv$iv2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"schema_ids", (Object)schemaIds), TuplesKt.to((Object)"schema_names", (Object)schemaNames)};
        SortedMap map = MapsKt.sortedMapOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Pair[])pairArray);
        return map;
    }

    @NotNull
    public static final String nameStr(@NotNull Collection<OraTouchedObjectIds> $this$nameStr) {
        Intrinsics.checkNotNullParameter($this$nameStr, (String)"<this>");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$nameStr), OraIntrospectorFunctions::nameStr$lambda$0), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final Regex getObfuscationTextPattern() {
        return obfuscationTextPattern;
    }

    public static final boolean adjustStringLiteralsForOracle9i(@NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int q = buf.indexOf("q'{");
        if (q < 0) {
            return false;
        }
        int p = buf.indexOf("}'", q + 3);
        if (p < 0) {
            return false;
        }
        buf.delete(p, p + 1);
        int i2 = p - 1;
        int n = q + 3;
        if (n <= i2) {
            while (true) {
                if (buf.charAt(i2) == '\'') {
                    buf.insert(i2 + 1, '\'');
                }
                if (i2 == n) break;
                --i2;
            }
        }
        buf.delete(q + 2, q + 3);
        buf.delete(q, q + 1);
        return true;
    }

    public static final void analyzeDbLinkSrc(@NotNull String src, @NotNull OraDbLink dbLink) {
        OraDbLink oraDbLink;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dbLink, (String)"dbLink");
        Pair<String, String> pair = (Pair<String, String>)src;
        boolean shared = DB_LINK_SHARED_PATTERN.matches((CharSequence)pair);
        pair = OraIntrospectorFunctions.analyzeDbLinkSrc$extractNamePwd(src, DB_LINK_CONNECT_PATTERN, 1, 4);
        String connName = (String)pair.component1();
        String connPwd = (String)pair.component2();
        Pair<String, String> pair2 = OraIntrospectorFunctions.analyzeDbLinkSrc$extractNamePwd(src, DB_LINK_AUTH_PATTERN, 1, 4);
        String authName = (String)pair2.component1();
        String authPwd = (String)pair2.component2();
        OraDbLink $this$analyzeDbLinkSrc_u24lambda_u240 = oraDbLink = dbLink;
        boolean bl = false;
        $this$analyzeDbLinkSrc_u24lambda_u240.setShared(shared);
        $this$analyzeDbLinkSrc_u24lambda_u240.setConnectUserName(connName);
        $this$analyzeDbLinkSrc_u24lambda_u240.setConnectUserPassword(connPwd);
        $this$analyzeDbLinkSrc_u24lambda_u240.setAuthUserName(authName);
        $this$analyzeDbLinkSrc_u24lambda_u240.setAuthUserPassword(authPwd);
    }

    private static final String nameStr$lambda$0(OraTouchedObjectIds it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSchemaName();
        if (object == null) {
            object = "<unnamed-schema-" + it.getSchemaId() + ">";
        }
        return object;
    }

    private static final Pair<String, String> analyzeDbLinkSrc$extractNamePwd(String $src, Regex pattern, int index1, int index2) {
        Pair np = StringFun.extract((CharSequence)$src, (Regex)pattern, (int)index1, (int)index2);
        if (np.getSecond() != null) {
            Object object = np.getSecond();
            Intrinsics.checkNotNull((Object)object);
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)':', (boolean)false, (int)2, null)) {
                np = new Pair(np.getFirst(), null);
            }
        }
        return np;
    }

    static {
        Object[] objectArray = new String[]{"SYS", "SYSTEM", "ORDDATA", "AUDSYS", "CTXSYS", "ORDSYS", "MDSYS", "CTXSYS", "WMSYS", "DVSYS", "LBACSYS", "OLAPSYS", "OJVMSYS", "APPQOSSYS", "XDB", "PUBLIC"};
        SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])objectArray);
        objectArray = new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"};
        SIMPLE_DATA_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"CHAR", "VARCHAR", "VARCHAR2"};
        EXPLICIT_UNIT_DATA_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)0x7FFFFFFE), TuplesKt.to((Object)"FLOAT", (Object)126)};
        DATA_TYPE_STAR_SIZE = MapsKt.mapOf((Pair[])objectArray);
        NATIVE_TRIGGER_DEFINITION_PATTERN = new Regex("(?s)^CREATE(\\s*OR\\s*REPLACE)?(\\s*[EN][A-Z]+)?\\s+TRIGGER.+$");
        SIMPLE_QUOTED_NAME_PATTERN = new Regex("^\\s*\"([^\"]*)\"\\s*$");
        AUTO_NOT_NULL_CHECK_PATTERN = new Regex("\".+\" IS NOT NULL");
        COLLECTION_TYPE_SURROGATE_NAME_PATTERN = new Regex("^SYS_PLSQL_[0-9A-F_]+(DUMMY[0-9A-F_]*)?$");
        INDEX_SURROGATE_NAME_PATTERN = new Regex("^SYS_\\w*\\d+\\$*$");
        INDEX_EXPRESSION_STUB_PATTERN = new Regex("^SYS_NC\\d+.$");
        SEQUENCE_SURROGATE_NAME_PATTERN = new Regex("^ISEQ\\$+_\\d+$");
        obfuscationTextPattern = new Regex("^[^\\n]*wrapped\\s*\\n", RegexOption.DOT_MATCHES_ALL);
        objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.IGNORE_CASE};
        DB_LINK_SHARED_PATTERN = new Regex("^\\s*CREATE\\s+(PUBLIC\\s+)?SHARED\\s.*$", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.COMMENTS, RegexOption.IGNORE_CASE};
        DB_LINK_CONNECT_PATTERN = new Regex("CONNECT \\s+ TO \\s+ \"(.*?)(\"|\\s) \\s* (IDENTIFIED \\s+ BY \\s+ VALUES? \\s* '(.*?)')?", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.COMMENTS, RegexOption.IGNORE_CASE};
        DB_LINK_AUTH_PATTERN = new Regex("AUTHENTICATED \\s+ BY \\s+ \"(.*?)(\"|\\s) \\s* (IDENTIFIED \\s+ BY \\s+ VALUES? \\s* '(.*?)')?", SetsKt.setOf((Object[])objectArray));
    }
}

