/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.graph.GraphCommit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\u0013J\u001c\u0010\u0012\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0006J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0015J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u000eR*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\t\u001a6\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\u0005j\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/data/LogInfo;", "", "<init>", "()V", "refsByRoot", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "Lkotlin/collections/HashMap;", "commitsByRoot", "", "Lcom/intellij/vcs/log/graph/GraphCommit;", "", "put", "", "root", "commits", "refs", "getCommits", "", "getRefs", "", "clear", "intellij.platform.vcs.log.impl"})
final class LogInfo {
    @NotNull
    private final HashMap<VirtualFile, CompressedRefs> refsByRoot = new HashMap();
    @NotNull
    private final HashMap<VirtualFile, List<GraphCommit<Integer>>> commitsByRoot = new HashMap();

    public final void put(@NotNull VirtualFile root, @NotNull List<? extends GraphCommit<Integer>> commits) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        ((Map)this.commitsByRoot).put(root, commits);
    }

    public final void put(@NotNull VirtualFile root, @NotNull CompressedRefs refs) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
        ((Map)this.refsByRoot).put(root, refs);
    }

    @NotNull
    public final Collection<List<GraphCommit<Integer>>> getCommits() {
        Collection<List<GraphCommit<Integer>>> collection = this.commitsByRoot.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @Nullable
    public final List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.commitsByRoot.get(root);
    }

    @NotNull
    public final Map<VirtualFile, CompressedRefs> getRefs() {
        return MapsKt.toMap((Map)this.refsByRoot);
    }

    @Nullable
    public final CompressedRefs getRefs(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.refsByRoot.get(root);
    }

    public final void clear() {
        this.refsByRoot.clear();
        this.commitsByRoot.clear();
    }
}

