/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.file;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.HbLanguage;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import icons.HandlebarsIcons;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbFileType
extends XmlLikeFileType
implements TemplateLanguageFileType {
    public static final LanguageFileType INSTANCE = new HbFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "handlebars;hbs;mustache";

    private HbFileType() {
        this(HbLanguage.INSTANCE);
    }

    protected HbFileType(Language lang) {
        super(lang);
    }

    @NotNull
    public String getName() {
        return "Handlebars/Mustache";
    }

    @NotNull
    public String getDescription() {
        String string = HbBundle.message("filetype.hb.description", new Object[0]);
        if (string == null) {
            HbFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return HandlebarsIcons.Handlebars_icon;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        LanguageFileType associatedFileType;
        if (content == null) {
            HbFileType.$$$reportNull$$$0(1);
        }
        if ((associatedFileType = HbFileType.getAssociatedFileType(file, project)) == null) {
            return null;
        }
        return CharsetUtil.extractCharsetFromFileContent((Project)project, (VirtualFile)file, (FileType)associatedFileType, (CharSequence)content);
    }

    private static LanguageFileType getAssociatedFileType(VirtualFile file, Project project) {
        if (project == null) {
            return null;
        }
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(file);
        LanguageFileType associatedFileType = null;
        if (language != null) {
            associatedFileType = language.getAssociatedFileType();
        }
        if (language == null || associatedFileType == null) {
            associatedFileType = HbLanguage.getDefaultTemplateLang();
        }
        return associatedFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/file/HbFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/file/HbFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

