/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewKt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)J \u0010*\u001a\u00020!2\n\u0010+\u001a\u00060,j\u0002`-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J#\u00101\u001a\u00020!2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00102\u001a\u00020)H\u0000\u00a2\u0006\u0002\b3J\r\u00104\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b5R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00067"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;", "", "initialText", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/project/Project;)V", "virtualFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getVirtualFile$intellij_js_liveEdit", "()Lcom/intellij/testFramework/LightVirtualFile;", "viewProvider", "Lcom/intellij/psi/SingleRootFileViewProvider;", "document", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "getDocument$intellij_js_liveEdit", "()Lcom/intellij/openapi/editor/impl/DocumentImpl;", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "getPsiFile$intellij_js_liveEdit", "()Lcom/intellij/psi/xml/XmlFile;", "nodeIdToRangeMarker", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "getNodeIdToRangeMarker$intellij_js_liveEdit", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "value", "", "isReformatInProgress", "isReformatInProgress$intellij_js_liveEdit", "()Z", "scheduleReformat", "", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "scheduleReformat$intellij_js_liveEdit", "buildItemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "nodeId", "", "loadDocument", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nodeIdToOffset", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/openapi/util/Segment;", "createPointers", "insertionOffset", "createPointers$intellij_js_liveEdit", "requestCommitted", "requestCommitted$intellij_js_liveEdit", "Companion", "intellij.js.liveEdit"})
@SourceDebugExtension(value={"SMAP\nElementsViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsViewState.kt\ncom/jetbrains/liveEdit/elementsInspector/ElementsViewState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1869#2,2:144\n*S KotlinDebug\n*F\n+ 1 ElementsViewState.kt\ncom/jetbrains/liveEdit/elementsInspector/ElementsViewState\n*L\n65#1:144,2\n*E\n"})
public final class ElementsViewState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LightVirtualFile virtualFile;
    @NotNull
    private final SingleRootFileViewProvider viewProvider;
    @NotNull
    private final Int2ObjectOpenHashMap<RangeMarker> nodeIdToRangeMarker;
    private volatile boolean isReformatInProgress;
    @NotNull
    private static final Key<Boolean> ELEMENTS_VIEW_FILE;

    public ElementsViewState(@NotNull CharSequence initialText, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.nodeIdToRangeMarker = new Int2ObjectOpenHashMap();
        LightVirtualFile virtualFile = new LightVirtualFile("", (Language)HTMLLanguage.INSTANCE, initialText);
        virtualFile.putUserData(ELEMENTS_VIEW_FILE, (Object)true);
        this.virtualFile = virtualFile;
        this.viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)this.project), (VirtualFile)virtualFile, true);
    }

    @NotNull
    public final LightVirtualFile getVirtualFile$intellij_js_liveEdit() {
        return this.virtualFile;
    }

    @NotNull
    public final DocumentImpl getDocument$intellij_js_liveEdit() {
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.virtualFile);
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        return (DocumentImpl)document;
    }

    @NotNull
    public final XmlFile getPsiFile$intellij_js_liveEdit() {
        PsiFile psiFile = this.viewProvider.getPsi(this.viewProvider.getBaseLanguage());
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        return (XmlFile)psiFile;
    }

    @NotNull
    public final Int2ObjectOpenHashMap<RangeMarker> getNodeIdToRangeMarker$intellij_js_liveEdit() {
        return this.nodeIdToRangeMarker;
    }

    public final boolean isReformatInProgress$intellij_js_liveEdit() {
        return this.isReformatInProgress;
    }

    public final void scheduleReformat$intellij_js_liveEdit(@NotNull List<TextRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.isReformatInProgress = true;
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> ElementsViewState.scheduleReformat$lambda$0(this, ranges));
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"nonBlocking(...)");
        NonBlockingReadAction reformatTask = nonBlockingReadAction;
        reformatTask.submit((Executor)AppExecutorUtil.getAppExecutorService()).onError(arg_0 -> ElementsViewState.scheduleReformat$lambda$2(arg_0 -> ElementsViewState.scheduleReformat$lambda$1(this, arg_0), arg_0));
    }

    @Nullable
    public final ItemPresentation buildItemPresentation(int nodeId) {
        HtmlTagTreeElement htmlTagTreeElement;
        RangeMarker rangeMarker = (RangeMarker)this.nodeIdToRangeMarker.get(nodeId);
        if (rangeMarker != null) {
            RangeMarker rangeMarker2 = rangeMarker;
            boolean bl = false;
            XmlTag xmlTag = (XmlTag)ActionsKt.runReadAction(() -> ElementsViewState.buildItemPresentation$lambda$0$0(this, rangeMarker2));
            if (xmlTag != null) {
                XmlTag tag = xmlTag;
                boolean bl2 = false;
                htmlTagTreeElement = new HtmlTagTreeElement(tag);
            } else {
                htmlTagTreeElement = null;
            }
        } else {
            htmlTagTreeElement = null;
        }
        return (ItemPresentation)htmlTagTreeElement;
    }

    public final void loadDocument(@NotNull StringBuilder builder, @NotNull Int2ObjectMap<Segment> nodeIdToOffset) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(nodeIdToOffset, (String)"nodeIdToOffset");
        ApplicationManager.getApplication().invokeLater(() -> ElementsViewState.loadDocument$lambda$0(this, nodeIdToOffset, builder));
    }

    public final void createPointers$intellij_js_liveEdit(@NotNull Int2ObjectMap<Segment> nodeIdToOffset, int insertionOffset) {
        Intrinsics.checkNotNullParameter(nodeIdToOffset, (String)"nodeIdToOffset");
        ObjectIterator objectIterator = nodeIdToOffset.int2ObjectEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (((Iterator)objectIterator2).hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            Segment range = (Segment)entry.getValue();
            ((Map)this.nodeIdToRangeMarker).put(entry.getIntKey(), this.getDocument$intellij_js_liveEdit().createRangeMarker(insertionOffset + range.getStartOffset(), insertionOffset + range.getEndOffset()));
        }
    }

    public final boolean requestCommitted$intellij_js_liveEdit() {
        return PsiDocumentManager.getInstance((Project)this.project).isCommitted((Document)this.getDocument$intellij_js_liveEdit());
    }

    private static final void scheduleReformat$lambda$0(ElementsViewState this$0, List $ranges) {
        if (this$0.getDocument$intellij_js_liveEdit().getTextLength() > ElementsViewKt.getMAX_SIZE_FOR_HIGHLIGHTING() * 1024) {
            this$0.isReformatInProgress = false;
            return;
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        Iterable $this$forEach$iv = $ranges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange range = (TextRange)element$iv;
            boolean bl = false;
            formatRanges.add(range, true);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this$0.project).createFileFromText("", (Language)HTMLLanguage.INSTANCE, this$0.getDocument$intellij_js_liveEdit().getCharsSequence(), false, false);
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)((PsiFile)this$0.getPsiFile$intellij_js_liveEdit()));
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
        Intrinsics.checkNotNull((Object)formattingModelBuilder);
        FormattingModelBuilder builder = formattingModelBuilder;
        FormattingModel formattingModel = CoreFormatterUtil.buildModel((FormattingModelBuilder)builder, (PsiElement)((PsiElement)psiFile), (CodeStyleSettings)settings, (FormattingMode)FormattingMode.REFORMAT);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"buildModel(...)");
        FormattingModel model = formattingModel;
        Document document = model.getDocumentModel().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document copiedDocument = document;
        Int2ObjectOpenHashMap copiedMarkers = new Int2ObjectOpenHashMap(this$0.nodeIdToRangeMarker.size());
        ObjectIterator objectIterator = this$0.nodeIdToRangeMarker.int2ObjectEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (((Iterator)objectIterator2).hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            ((Map)copiedMarkers).put(entry.getIntKey(), copiedDocument.createRangeMarker(((RangeMarker)entry.getValue()).getTextRange()));
        }
        FormatterEx.getInstance().format(model, settings, settings.getIndentOptions(), formatRanges);
        PsiDocumentManager.getInstance((Project)this$0.project).performForCommittedDocument(copiedDocument, () -> ElementsViewState.scheduleReformat$lambda$0$1(this$0, copiedDocument, copiedMarkers));
    }

    private static final void scheduleReformat$lambda$0$1(ElementsViewState this$0, Document $copiedDocument, Int2ObjectOpenHashMap $copiedMarkers) {
        ApplicationManager.getApplication().invokeLater(() -> ElementsViewState.scheduleReformat$lambda$0$1$0(this$0, $copiedDocument, $copiedMarkers));
    }

    private static final void scheduleReformat$lambda$0$1$0(ElementsViewState this$0, Document $copiedDocument, Int2ObjectOpenHashMap $copiedMarkers) {
        ApplicationManager.getApplication().runWriteAction(() -> ElementsViewState.scheduleReformat$lambda$0$1$0$0(this$0, $copiedDocument, $copiedMarkers));
    }

    private static final void scheduleReformat$lambda$0$1$0$0(ElementsViewState this$0, Document $copiedDocument, Int2ObjectOpenHashMap $copiedMarkers) {
        RangeMarker v;
        ObjectIterator objectIterator = ((ObjectCollection)this$0.nodeIdToRangeMarker.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            v = (RangeMarker)objectIterator2.next();
            v.dispose();
        }
        this$0.nodeIdToRangeMarker.clear();
        this$0.getDocument$intellij_js_liveEdit().setText((CharSequence)$copiedDocument.getText());
        ObjectIterator objectIterator3 = $copiedMarkers.int2ObjectEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator3, (String)"fastIterator(...)");
        objectIterator2 = objectIterator3;
        while (((Iterator)objectIterator2).hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            ((Map)this$0.nodeIdToRangeMarker).put(entry.getIntKey(), this$0.getDocument$intellij_js_liveEdit().createRangeMarker(((RangeMarker)entry.getValue()).getTextRange()));
        }
        ObjectIterator objectIterator4 = ((ObjectCollection)$copiedMarkers.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator4, (String)"iterator(...)");
        objectIterator2 = objectIterator4;
        while (objectIterator2.hasNext()) {
            v = (RangeMarker)objectIterator2.next();
            v.dispose();
        }
        this$0.isReformatInProgress = false;
    }

    private static final Unit scheduleReformat$lambda$1(ElementsViewState this$0, Throwable it) {
        ApplicationInspectorImplKt.getLOG().warn(it);
        this$0.isReformatInProgress = false;
        return Unit.INSTANCE;
    }

    private static final void scheduleReformat$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final XmlTag buildItemPresentation$lambda$0$0(ElementsViewState this$0, RangeMarker $rangeMarker) {
        PsiElement psiElement = this$0.getPsiFile$intellij_js_liveEdit().findElementAt($rangeMarker.getStartOffset());
        PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
        return psiElement2 instanceof XmlTag ? (XmlTag)psiElement2 : null;
    }

    private static final void loadDocument$lambda$0(ElementsViewState this$0, Int2ObjectMap $nodeIdToOffset, StringBuilder $builder) {
        ApplicationManager.getApplication().runWriteAction(() -> ElementsViewState.loadDocument$lambda$0$0(this$0, $builder));
        this$0.createPointers$intellij_js_liveEdit((Int2ObjectMap<Segment>)$nodeIdToOffset, 0);
        Object[] objectArray = new TextRange[1];
        Intrinsics.checkNotNullExpressionValue((Object)this$0.getPsiFile$intellij_js_liveEdit().getTextRange(), (String)"getTextRange(...)");
        this$0.scheduleReformat$intellij_js_liveEdit(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    private static final void loadDocument$lambda$0$0(ElementsViewState this$0, StringBuilder $builder) {
        this$0.getDocument$intellij_js_liveEdit().setText((CharSequence)$builder);
    }

    static {
        Key key = Key.create((String)"web.debugger.elements.view.file");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ELEMENTS_VIEW_FILE = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState$Companion;", "", "<init>", "()V", "ELEMENTS_VIEW_FILE", "Lcom/intellij/openapi/util/Key;", "", "isElementsViewFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.js.liveEdit"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isElementsViewFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Boolean bl = (Boolean)file.getUserData(ELEMENTS_VIEW_FILE);
            return bl != null ? bl : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

