/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.update.RemoteCssStyleSheet;
import com.jetbrains.liveEdit.update.SetSourceExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.SetStyleTextsResult;
import org.jetbrains.wip.protocol.css.SourceRange;
import org.jetbrains.wip.protocol.css.StyleDeclarationEdit;

public final class CssHelper {
    @NotNull
    public static SetSourceExecutor createSetSourceExecutor(final @NotNull List<RemoteCssStyleSheet> styleSheets, final @NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (styleSheets == null) {
            CssHelper.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            CssHelper.$$$reportNull$$$0(1);
        }
        return new SetSourceExecutor(){

            @Override
            @NotNull
            public List<Promise<?>> execute(@NotNull VirtualFile file, @NotNull CharSequence source) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (source == null) {
                    1.$$$reportNull$$$0(1);
                }
                SmartList callbacks = null;
                for (RemoteCssStyleSheet styleSheet : styleSheets) {
                    if (!CssHelper.sourceEquals(file, styleSheet.url, styleSheet.project, debugProcess.getFinder())) continue;
                    if (callbacks == null) {
                        callbacks = new SmartList();
                    }
                    callbacks.add(styleSheet.commandProcessor.send((Request)CSSKt.SetStyleSheetText((CharSequence)styleSheet.descriptor.styleSheetId(), (CharSequence)source)));
                    styleSheet.removeIncrementalUpdates();
                }
                List<Object> list = callbacks == null ? Collections.emptyList() : callbacks;
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/liveEdit/update/CssHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/liveEdit/update/CssHelper$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static boolean sourceEquals(@NotNull VirtualFile file, @NotNull Url remoteUrl, @NotNull Project project, @NotNull JSCachingFileFinder fileFinder) {
        if (file == null) {
            CssHelper.$$$reportNull$$$0(2);
        }
        if (remoteUrl == null) {
            CssHelper.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CssHelper.$$$reportNull$$$0(4);
        }
        if (fileFinder == null) {
            CssHelper.$$$reportNull$$$0(5);
        }
        return file.equals(fileFinder.findFile(remoteUrl, project, true, null, null)) || Urls.equalsIgnoreParameters((Url)remoteUrl, (Collection)fileFinder.getRemoteUrls(file), (boolean)file.isCaseSensitive());
    }

    @NotNull
    private static SourceRange getSourceRange(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            CssHelper.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CssHelper.$$$reportNull$$$0(7);
        }
        int start = element.getNode().getStartOffset();
        int end = start + element.getNode().getTextLength();
        int startLine = document.getLineNumber(start);
        int startColumn = start - document.getLineStartOffset(startLine);
        int endLine = document.getLineNumber(end);
        int endColumn = end - document.getLineStartOffset(endLine);
        return new SourceRange(startLine, startColumn, endLine, endColumn + 1);
    }

    private static boolean compareSelectorList(@Nullable CssSelectorList local, @Nullable CssSelectorList remote) {
        CssSelector[] remoteSelectors;
        if (local == null || remote == null) {
            return false;
        }
        CssSelector[] localSelectors = local.getSelectors();
        if (localSelectors.length != (remoteSelectors = remote.getSelectors()).length) {
            return false;
        }
        int n = remoteSelectors.length;
        for (int i = 0; i < n; ++i) {
            PsiElement[] remoteSelectorElements;
            CssSelector localSelector = localSelectors[i];
            CssSelector remoteSelector = remoteSelectors[i];
            if (Comparing.compare((Comparable)localSelector.getSpecificity(), (Comparable)remoteSelector.getSpecificity()) != 0) {
                return false;
            }
            PsiElement[] localSelectorElements = localSelector.getElements();
            if (localSelectorElements.length != (remoteSelectorElements = remoteSelector.getElements()).length) {
                return false;
            }
            for (int j = 0; j < localSelectorElements.length; ++j) {
                PsiElement psiElement = localSelectorElements[j];
                if (psiElement instanceof CssSimpleSelector) {
                    CssSimpleSelector localSelectorElement = (CssSimpleSelector)psiElement;
                    psiElement = remoteSelectorElements[j];
                    if (psiElement instanceof CssSimpleSelector) {
                        CssSimpleSelector remoteSelectorElement = (CssSimpleSelector)psiElement;
                        if (localSelectorElement.isUniversalSelector() == remoteSelectorElement.isUniversalSelector()) continue;
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Processor<RemoteCssStyleSheet> createSetCssPropertyProcessor(final @NotNull CssDeclaration localDeclaration, final @Nullable CharSequence value) {
        if (localDeclaration == null) {
            CssHelper.$$$reportNull$$$0(8);
        }
        return new Processor<RemoteCssStyleSheet>(){

            public boolean process(RemoteCssStyleSheet styleSheet) {
                styleSheet.getFile().doWhenDone(remoteFile -> {
                    String styleSheetId = styleSheet.descriptor.styleSheetId();
                    Ref message = new Ref();
                    Ref newIdeaValue = new Ref();
                    Ref remoteDeclaration = new Ref();
                    Ref success = new Ref((Object)true);
                    ReadAction.run(() -> {
                        if (!localDeclaration.isValid()) {
                            success.set((Object)false);
                            return;
                        }
                        CssRuleset cssRuleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)localDeclaration, CssRuleset.class);
                        CssStylesheet cssStyleSheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)cssRuleset, CssStylesheet.class);
                        if (cssStyleSheet == null) {
                            success.set((Object)false);
                            return;
                        }
                        Object @NotNull [] objects = cssStyleSheet.getRulesets(true);
                        int sourceRulesetIndex = ArrayUtilRt.indexOf((Object[])objects, (Object)cssRuleset, (int)0, (int)objects.length);
                        CssStylesheet remoteCssStylesheet = remoteFile.getStylesheet();
                        assert (remoteCssStylesheet != null);
                        CssRuleset[] remoteCssRulesets = remoteCssStylesheet.getRulesets(true);
                        if (sourceRulesetIndex < 0 || sourceRulesetIndex >= remoteCssRulesets.length) {
                            success.set((Object)false);
                            return;
                        }
                        CssRuleset remoteRuleset = remoteCssRulesets[sourceRulesetIndex];
                        if (!CssHelper.compareSelectorList(cssRuleset.getSelectorList(), remoteRuleset.getSelectorList())) {
                            success.set((Object)false);
                            return;
                        }
                        String text = localDeclaration.getPropertyName() + ":" + String.valueOf(value == null ? "" : value) + ";";
                        Document document = styleSheet.document;
                        assert (document != null);
                        CssBlock remoteCssBlock = remoteRuleset.getBlock();
                        remoteDeclaration.set(remoteCssBlock == null ? null : remoteCssBlock.findDeclaration(localDeclaration.getPropertyName(), false));
                        if (remoteDeclaration.isNull()) {
                            if (remoteCssBlock == null) {
                                success.set((Object)false);
                                return;
                            }
                            int start = remoteCssBlock.getNode().getStartOffset();
                            int end = start + remoteCssBlock.getNode().getTextLength() - 1;
                            int endLine = document.getLineNumber(end);
                            int endColumn = end - document.getLineStartOffset(endLine);
                            StyleDeclarationEdit styleDeclarationEdit = new StyleDeclarationEdit((CharSequence)styleSheetId, new SourceRange(endLine, endColumn, endLine, endColumn), (CharSequence)text);
                            message.set((Object)CSSKt.SetStyleTexts(Collections.singletonList(styleDeclarationEdit), null));
                        } else {
                            StyleDeclarationEdit styleDeclarationEdit = new StyleDeclarationEdit((CharSequence)styleSheetId, CssHelper.getSourceRange(document, (PsiElement)remoteDeclaration.get()), (CharSequence)text);
                            message.set((Object)CSSKt.SetStyleTexts(Collections.singletonList(styleDeclarationEdit), null));
                        }
                        CssTermList cssDeclarationValue = localDeclaration.getValue();
                        newIdeaValue.set((Object)(cssDeclarationValue == null ? null : cssDeclarationValue.getText()));
                    });
                    if (!((Boolean)success.get()).booleanValue()) {
                        return;
                    }
                    this.doSendMessage((Request<SetStyleTextsResult>)((Request)message.get()), (String)newIdeaValue.get(), (CssDeclaration)remoteDeclaration.get(), styleSheet);
                }).doWhenRejected(error -> ApplicationInspectorImplKt.getLOG().error("Cannot get PSI CSS file: " + (String)ObjectUtils.notNull((Object)error, (Object)"internal error")));
                return false;
            }

            private void doSendMessage(@NotNull Request<SetStyleTextsResult> message, @Nullable String newIdeaValue, @Nullable CssDeclaration remoteDeclaration, @NotNull RemoteCssStyleSheet styleSheet) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (styleSheet == null) {
                    2.$$$reportNull$$$0(1);
                }
                styleSheet.stopUpdates();
                styleSheet.commandProcessor.send(message).onSuccess(o -> {
                    if (RemoteCssStyleSheet.isNeedToGetTextAfterChange() || newIdeaValue == null || remoteDeclaration == null || !remoteDeclaration.isValid()) {
                        styleSheet.startUpdates(false);
                    } else {
                        styleSheet.addIncrementalUpdate(() -> remoteDeclaration.setValue(newIdeaValue));
                    }
                }).onError(throwable -> styleSheet.startUpdates(false));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "styleSheet";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/liveEdit/update/CssHelper$2";
                objectArray[2] = "doSendMessage";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static List<VirtualFile> collectEffective(@NotNull List<RemoteCssStyleSheet> list, @NotNull Collection<? extends VirtualFile> files, @NotNull Project project, @NotNull JSCachingFileFinder fileFinder) {
        if (list == null) {
            CssHelper.$$$reportNull$$$0(9);
        }
        if (files == null) {
            CssHelper.$$$reportNull$$$0(10);
        }
        if (project == null) {
            CssHelper.$$$reportNull$$$0(11);
        }
        if (fileFinder == null) {
            CssHelper.$$$reportNull$$$0(12);
        }
        List effectiveFiles = null;
        block0: for (VirtualFile virtualFile : files) {
            for (RemoteCssStyleSheet styleSheet : list) {
                if (!CssHelper.sourceEquals(virtualFile, styleSheet.url, project, fileFinder)) continue;
                if (effectiveFiles == null) {
                    effectiveFiles = new SmartList();
                }
                effectiveFiles.add(virtualFile);
                continue block0;
            }
        }
        List<Object> list2 = effectiveFiles == null ? Collections.emptyList() : effectiveFiles;
        if (list2 == null) {
            CssHelper.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public static void processStylesheets(@NotNull List<? extends RemoteCssStyleSheet> list, @NotNull VirtualFile file, @NotNull JSCachingFileFinder fileFinder, @NotNull Processor<? super RemoteCssStyleSheet> processor) {
        if (list == null) {
            CssHelper.$$$reportNull$$$0(14);
        }
        if (file == null) {
            CssHelper.$$$reportNull$$$0(15);
        }
        if (fileFinder == null) {
            CssHelper.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            CssHelper.$$$reportNull$$$0(17);
        }
        for (RemoteCssStyleSheet remoteCssStyleSheet : list) {
            if (!CssHelper.sourceEquals(file, remoteCssStyleSheet.url, remoteCssStyleSheet.project, fileFinder) || !processor.process((Object)remoteCssStyleSheet)) continue;
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleSheets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFinder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDeclaration";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/update/CssHelper";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/update/CssHelper";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectEffective";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSetSourceExecutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sourceEquals";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSetCssPropertyProcessor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectEffective";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processStylesheets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

