/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintRequestData;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EslintLanguageServiceClient
extends LinterLanguageServiceClient {
    @NotNull
    public NodePackage getNodePackage();

    @NotNull
    public VirtualFile getWorkingDirectory();

    @Nullable
    public CompletableFuture<Response<List<EslintError>>> highlight(@NotNull EslintRequestData var1, String var2);

    @Nullable
    public CompletableFuture<Response<String>> fixFile(@NotNull EslintRequestData var1, String var2);

    public static class Response<T> {
        public final @InspectionMessage String globalError;
        public final boolean isNoConfigFile;
        public final T value;

        public Response(@InspectionMessage String globalError, T value, boolean isNoConfigFile) {
            this.globalError = globalError;
            this.isNoConfigFile = isNoConfigFile;
            this.value = value;
        }

        public static <T> Response<T> error(@InspectionMessage String globalError, boolean isNoConfigFile) {
            return new Response<Object>(globalError, null, isNoConfigFile);
        }

        public static <T> Response<T> ok(T value) {
            return new Response<T>(null, value, false);
        }
    }
}

