/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webstorm.customization;

import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.customization.FeedbackReporter;
import com.intellij.platform.ide.impl.customization.JetBrainsFeedbackReporter;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/webstorm/customization/WebStormFeedbackReporter;", "Lcom/intellij/platform/ide/customization/FeedbackReporter;", "productName", "", "useInIdeGeneralFeedback", "", "useInIdeEvaluationFeedback", "<init>", "(Ljava/lang/String;ZZ)V", "jetBrainsFeedbackReporter", "Lcom/intellij/platform/ide/impl/customization/JetBrainsFeedbackReporter;", "destinationDescription", "getDestinationDescription", "()Ljava/lang/String;", "feedbackFormUrl", "Lcom/intellij/util/Url;", "description", "showFeedbackForm", "project", "Lcom/intellij/openapi/project/Project;", "requestedForEvaluation", "intellij.webstorm.customization"})
@ApiStatus.Internal
public final class WebStormFeedbackReporter
implements FeedbackReporter {
    @NotNull
    private final JetBrainsFeedbackReporter jetBrainsFeedbackReporter;
    @NotNull
    private final String destinationDescription;

    public WebStormFeedbackReporter(@NotNull String productName, boolean useInIdeGeneralFeedback, boolean useInIdeEvaluationFeedback) {
        Intrinsics.checkNotNullParameter((Object)productName, (String)"productName");
        this.jetBrainsFeedbackReporter = new JetBrainsFeedbackReporter(productName, useInIdeGeneralFeedback, useInIdeEvaluationFeedback);
        this.destinationDescription = this.jetBrainsFeedbackReporter.getDestinationDescription();
    }

    @NotNull
    public String getDestinationDescription() {
        return this.destinationDescription;
    }

    @NotNull
    public Url feedbackFormUrl(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return Urls.newFromEncoded((String)"https://surveys.jetbrains.com/s3/webstorm-evaluation-feedback");
    }

    public boolean showFeedbackForm(@Nullable Project project, boolean requestedForEvaluation) {
        if (requestedForEvaluation) {
            return false;
        }
        return this.jetBrainsFeedbackReporter.showFeedbackForm(project, false);
    }
}

