/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.unix.Pty;
import java.io.IOException;
import java.io.InputStream;

class PTYInputStream
extends InputStream {
    Pty myPty;

    public PTYInputStream(Pty pty) {
        this.myPty = pty;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmpBuf = new byte[len];
        if ((len = this.myPty.read(tmpBuf, len)) <= 0) {
            return -1;
        }
        System.arraycopy(tmpBuf, 0, buf, off, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        this.myPty.close();
    }

    @Override
    public int available() throws IOException {
        if (this.myPty.isClosed()) {
            throw new IOException("File descriptor is closed");
        }
        return 0;
    }
}

