/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="NodeJsRemoteInterpreters", category=SettingsCategory.TOOLS, exportable=true, presentableName=NodeJsLocalInterpreterManager.PresentableNameGetter.class, storages={@Storage(value="nodejs.xml", roamingType=RoamingType.DISABLED)})
public class NodeRemoteInterpreters
implements PersistentStateComponent<Element>,
Disposable {
    @NonNls
    private static final String INTERPRETER_PATH = "node-remote-interpreter";
    private final Object myModifyLock = new Object();
    private volatile List<NodeJSRemoteSdkAdditionalData> myInterpreters = List.of();

    public NodeRemoteInterpreters() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                SshConfigManager manager = SshConfigManager.getInstance(null);
                for (NodeJSRemoteSdkAdditionalData interpreter : NodeRemoteInterpreters.this.myInterpreters) {
                    RemoteSdkUtil.updateSshConfigData((SdkAdditionalData)interpreter, (SshConfigManager)manager);
                }
            }
        });
        CredentialsType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<CredentialsType<?>>(){

            public void extensionAdded(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                CredentialsManager.recogniseCredentialType(NodeRemoteInterpreters.this.myInterpreters.stream(), extension);
            }

            public void extensionRemoved(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                CredentialsManager.forgetCredentialType(NodeRemoteInterpreters.this.myInterpreters.stream(), extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeRemoteInterpreters$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    @NotNull
    public static NodeRemoteInterpreters getInstance() {
        NodeRemoteInterpreters nodeRemoteInterpreters = (NodeRemoteInterpreters)ApplicationManager.getApplication().getService(NodeRemoteInterpreters.class);
        if (nodeRemoteInterpreters == null) {
            NodeRemoteInterpreters.$$$reportNull$$$0(0);
        }
        return nodeRemoteInterpreters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            NodeRemoteInterpreters.$$$reportNull$$$0(1);
        }
        ArrayList<NodeJSRemoteSdkAdditionalData> list = new ArrayList<NodeJSRemoteSdkAdditionalData>();
        for (Element child : state.getChildren()) {
            String path = child.getAttributeValue(INTERPRETER_PATH);
            if (path == null) continue;
            list.add(NodeJSRemoteSdkAdditionalData.load(child, path));
        }
        Object object = this.myModifyLock;
        synchronized (object) {
            this.myInterpreters = List.copyOf(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noStateLoaded() {
        NodeRemoteInterpreters oldManager = (NodeRemoteInterpreters)ApplicationManager.getApplication().getService(OldNodeRemoteInterpreters.class);
        List<NodeJSRemoteSdkAdditionalData> oldInterpreters = oldManager.myInterpreters;
        if (!oldInterpreters.isEmpty()) {
            Logger.getInstance(NodeRemoteInterpreters.class).info("Imported from previous settings: " + String.valueOf(oldInterpreters));
            Object object = this.myModifyLock;
            synchronized (object) {
                this.myInterpreters = List.copyOf(oldInterpreters);
            }
            object = oldManager.myModifyLock;
            synchronized (object) {
                oldManager.myInterpreters = List.of();
            }
        }
    }

    @NotNull
    public Element getState() {
        Element rootElement = new Element("node-remote-interpreters");
        for (NodeJSRemoteSdkAdditionalData interpreter : this.myInterpreters) {
            Element element = new Element("interpreter");
            rootElement.addContent(element);
            element.setAttribute(INTERPRETER_PATH, interpreter.getSdkId());
            interpreter.save(element);
        }
        Element element = rootElement;
        if (element == null) {
            NodeRemoteInterpreters.$$$reportNull$$$0(2);
        }
        return element;
    }

    public boolean isEmpty() {
        return this.myInterpreters.isEmpty();
    }

    @NotNull
    public List<NodeJSRemoteSdkAdditionalData> getInterpreters() {
        List<NodeJSRemoteSdkAdditionalData> list = this.myInterpreters;
        if (list == null) {
            NodeRemoteInterpreters.$$$reportNull$$$0(3);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            NodeRemoteInterpreters.$$$reportNull$$$0(4);
        }
        Object object = this.myModifyLock;
        synchronized (object) {
            this.myInterpreters = List.copyOf(ContainerUtil.concat(this.myInterpreters, List.of(data)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(@NotNull String id) {
        if (id == null) {
            NodeRemoteInterpreters.$$$reportNull$$$0(5);
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)id);
        Object object = this.myModifyLock;
        synchronized (object) {
            ArrayList<NodeJSRemoteSdkAdditionalData> mutableCopy = new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters);
            boolean result = mutableCopy.removeIf(data -> FileUtil.toSystemIndependentName((String)data.getSdkId()).equals(systemIndependentId));
            if (result) {
                this.myInterpreters = List.copyOf(mutableCopy);
            }
            return result;
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/NodeRemoteInterpreters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeRemoteInterpreters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    @Deprecated(forRemoval=true)
    @State(name="NodeJSRemoteInterpreters", storages={@Storage(value="nodeJsRemoteInterpreters.xml", roamingType=RoamingType.DISABLED)})
    @Service(value={Service.Level.APP})
    public static final class OldNodeRemoteInterpreters
    extends NodeRemoteInterpreters {
        @Override
        public void noStateLoaded() {
        }
    }
}

