/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDataSourceValidator
extends DatabaseConfigValidator<SqlDataSourceImpl> {
    public Class<SqlDataSourceImpl> getTargetClass() {
        return SqlDataSourceImpl.class;
    }

    public void collectProblems(@NotNull Project project, @NotNull SqlDataSourceImpl target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(2);
        }
        this.detectDialectProblems(project, target, problems, configInfoProvider);
        if (target.getUrls().isEmpty()) {
            problems.consume((Object)new DataSourceProblem((Object)target, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(SqlBundle.message((String)"notification.title.incomplete.configuration", (Object[])new Object[0]), SqlBundle.message((String)"notification.content.no.ddl.files.specified", (Object[])new Object[0]), SqlBundle.message((String)"notification.content.no.ddl.files.specified", (Object[])new Object[0]), new Object[0]), null));
        }
    }

    private void detectDialectProblems(@NotNull Project project, @NotNull SqlDataSourceImpl target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        boolean dialectConflict;
        SqlLanguageDialect parentDsDialect;
        Dbms definedDbms;
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(3);
        }
        if (target == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(5);
        }
        SqlLanguageDialect explicitDialect = (definedDbms = target.getDefinedDbms()) == null ? null : DbSqlUtilCore.getSqlDialect((Dbms)definedDbms);
        Set<SqlLanguageDialect> dialects = SqlDataSourceValidator.collectDialects(project, target);
        DbDataSource parentDs = target.getParentDataSource();
        SqlLanguageDialect sqlLanguageDialect = parentDsDialect = parentDs == null ? null : DbSqlUtilCore.getSqlDialect((DbDataSource)parentDs);
        if (parentDsDialect != null) {
            dialects.add(parentDsDialect);
        }
        Set dbms = (Set)JBIterable.from(dialects).map(SqlLanguageDialect::getDbms).addAllTo(new LinkedHashSet());
        Dbms explicitDbms = explicitDialect == null ? null : explicitDialect.getDbms();
        boolean explicitConflict = !dbms.isEmpty() && explicitDbms != null && !dbms.contains(explicitDbms);
        ContainerUtil.addIfNotNull((Collection)dbms, (Object)explicitDbms);
        boolean bl = dialectConflict = dbms.size() > 1;
        if (!explicitConflict && !dialectConflict) {
            return;
        }
        ContainerUtil.addIfNotNull(dialects, (Object)explicitDialect);
        @Nls String msg = SqlBundle.message((String)"inconsistent.dialects.for.files.0.choice.0.and.parent.data.source.1", (Object[])new Object[]{parentDs != null ? 0 : 1});
        ArrayList<Object> actions = new ArrayList<Object>(dialects.size());
        @NlsSafe StringBuilder actionsText = new StringBuilder(SqlBundle.message((String)"sql.data.source.dialect.set.all.to", (Object[])new Object[0])).append(" ");
        int sz = actionsText.length();
        for (SqlLanguageDialect dialect : ContainerUtil.sorted(dialects, Comparator.comparing(Language::getDisplayName))) {
            if (actionsText.length() != sz) {
                actionsText.append(", ");
            }
            actionsText.append("<a href='$ACTION").append(actions.size()).append("'>");
            actionsText.append(dialect.getDisplayName());
            actionsText.append("</a>");
            actions.add(editor -> {
                SqlDataSourceConfigurable configurable = editor == null ? null : (SqlDataSourceConfigurable)((Object)((Object)editor.getConfigurable((Object)target, false, SqlDataSourceConfigurable.class)));
                SqlDataSourceValidator.setAllFilesTo(project, target, dialect.getDbms(), dialect, configurable);
            });
        }
        actionsText.append(". ").append("<a href='$ACTION").append(actions.size()).append("'>").append(SqlBundle.message((String)"sql.data.source.dialect.configure", (Object[])new Object[0])).append("</a>");
        actions.add(() -> SqlDataSourceValidator.configureMappings(project, target));
        problems.consume((Object)new DataSourceProblem((Object)target, (Object)this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(msg, actionsText.toString(), actionsText.toString(), actions.toArray()), null));
    }

    @NotNull
    private static Set<SqlLanguageDialect> collectDialects(@NotNull Project project, @NotNull SqlDataSourceImpl target) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(6);
        }
        if (target == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(7);
        }
        TreeSet<SqlLanguageDialect> dialects = new TreeSet<SqlLanguageDialect>(Comparator.comparing(Language::getDisplayName));
        SqlDialectMappings mapping = SqlDialectMappings.getInstance((Project)project);
        target.processFilesInner(true, (Processor<VirtualFile>)((Processor)f -> {
            ContainerUtil.addIfNotNull((Collection)dialects, (Object)((SqlLanguageDialect)mapping.getImmediateMapping(f)));
            return true;
        }));
        for (VirtualFile root : target.getRoots()) {
            SqlLanguageDialect dialect = (SqlLanguageDialect)mapping.getDirectlyConfiguredMapping(root);
            if (dialect == null) {
                dialect = (SqlLanguageDialect)mapping.getImmediateMapping(null);
            }
            if (dialect == null) {
                dialect = mapping.getDefaultMapping(root);
            }
            ContainerUtil.addIfNotNull(dialects, (Object)dialect);
        }
        TreeSet<SqlLanguageDialect> treeSet = dialects;
        if (treeSet == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(8);
        }
        return treeSet;
    }

    public static void configureMappings(Project project, SqlDataSourceImpl target) {
        List<VirtualFile> files = target.getRoots();
        SqlDialectsConfigurable.openDialectsConfigurable(project, files);
    }

    public static void setAllFilesTo(@NotNull Project project, SqlDataSourceImpl target, @NotNull Dbms dbms, SqlLanguageDialect dialect, SqlDataSourceConfigurable configurable) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(9);
        }
        if (dbms == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(10);
        }
        SqlDialectMappings instance = SqlDialectMappings.getInstance((Project)project);
        for (VirtualFile root : target.getRoots()) {
            if (instance.getMapping(root) == dialect) continue;
            instance.setMapping(root, (Object)dialect);
        }
        target.setDefinedDbms(dbms);
        if (configurable != null) {
            configurable.setCurrentDbms(dbms);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceValidator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceValidator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectDialectProblems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDialects";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAllFilesTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

