/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.highlighting;

import com.intellij.javascript.typeEngine.JSTypeEngineUtils;
import com.intellij.javascript.types.TSSymbol;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"findSuperMembersFromContextType", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "Lcom/intellij/lang/javascript/psi/JSPsiElementBase;", "element", "intellij.javascript.backend"})
public final class JSInheritanceUtilKt {
    @Nullable
    public static final Pair<JSClass, JSPsiElementBase> findSuperMembersFromContextType(@NotNull JSPsiElementBase element2) {
        JSClass aClass;
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        JSPsiElementBase element3 = element2;
        if (element3 instanceof JSFunctionExpression && (parent = element3.getParent()) instanceof JSProperty) {
            element3 = (JSPsiElementBase)parent;
        }
        parent = element3.getParent();
        if (!(element3 instanceof JSProperty) || !(parent instanceof JSExpression)) {
            return null;
        }
        if (!DialectDetector.isTypeScript((PsiElement)((PsiElement)element3))) {
            return null;
        }
        String name = ((JSProperty)element3).getName();
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        TSType expectedType = JSTypeEngineUtils.INSTANCE.getContextualTSType((JSExpression)parent, false);
        if (expectedType == null) {
            return null;
        }
        TSSymbol tSSymbol = expectedType.getProperty(name);
        if (tSSymbol == null) {
            return null;
        }
        TSSymbol property = tSSymbol;
        List declarations = property.findPsiDeclarations();
        PsiElement singleElement = (PsiElement)CollectionsKt.singleOrNull((List)declarations);
        if (singleElement instanceof JSPsiElementBase && (aClass = JSUtils.getMemberContainingClass((PsiElement)singleElement)) != null) {
            return new Pair((Object)aClass, (Object)singleElement);
        }
        return null;
    }
}

