/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSImportCompletionUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.frameworks.jsx.JSXXmlExtension;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSCompletionInsertHandlerFactory;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXComponentCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        boolean needComponents;
        if (parameters2 == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(1);
        }
        PrefixMatcher matcher = result2.getPrefixMatcher();
        String prefix = matcher.getPrefix();
        String capitalized = StringUtil.capitalize((String)prefix);
        boolean bl = needComponents = StringUtil.isEmpty((String)prefix) || JSXResolveUtil.isComponentName((String)prefix) || JSXResolveUtil.isComponentName((String)capitalized) && matcher.prefixMatches(capitalized);
        if (!needComponents) {
            return;
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters2, (CompletionResultSet)result2, (reference, set) -> {
            if (!(reference instanceof TagNameReference)) {
                return;
            }
            TagNameReference tagNameReference = (TagNameReference)reference;
            PsiElement element2 = tagNameReference.getElement();
            if (element2 instanceof XmlTag) {
                XmlTag tag = (XmlTag)element2;
                if (tagNameReference.isStartTagFlag() && element2 instanceof JSXXmlLiteralExpressionImpl) {
                    JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)tag, () -> {
                        HashSet<String> collectedNames = new HashSet<String>();
                        if (JSXXmlExtension.hasQualifiedName(tag)) {
                            JSXComponentCompletionContributor.addExportedComponentForNamespace(result2, tag, collectedNames, DialectDetector.isTypeScript((PsiElement)tag));
                        } else {
                            JSXComponentCompletionContributor.addLocalVariants(result2, tag, collectedNames);
                            JSXComponentCompletionContributor.addExportedComponents(result2, tag, collectedNames);
                        }
                    });
                }
            }
        });
    }

    private static void addExportedComponentForNamespace(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, Set<String> collectedNames, boolean isStrict) {
        JSXNamespaceReference reference;
        if (result2 == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((reference = JSXXmlExtension.getQualifierReference(tag)) == null) {
            return;
        }
        Collection elements = JSXResolveUtil.expandReferenceElements((PsiElement)tag, (JSXNamespaceReference)reference);
        if (elements.isEmpty()) {
            return;
        }
        JSResolveProcessor processor = JSXComponentCompletionContributor.createCompletionProcessor(result2, tag, collectedNames, true);
        JSXComponentCompletionContributor.processNestedComponentInScopes(tag, reference, (PsiScopeProcessor)processor, elements);
        if (!isStrict) {
            JSXComponentCompletionContributor.processNestedComponentsFromIndex(tag, processor);
        }
    }

    private static void processNestedComponentsFromIndex(@NotNull XmlTag tag, @NotNull JSResolveProcessor processor) {
        GlobalSearchScope scope2;
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((scope2 = JSXXmlExtension.getResolveScopeForIndexProcessing(tag, true)) == null) {
            return;
        }
        String parentQualifier = tag.getNamespacePrefix();
        if (!StringUtil.isEmpty((String)parentQualifier)) {
            JSClassResolver.processNamespaceMembers((String)parentQualifier, (GlobalSearchScope)scope2, (GlobalSearchScope)scope2, el -> processor.execute((PsiElement)el, ResolveState.initial()));
        }
    }

    private static void processNestedComponentInScopes(@NotNull XmlTag tag, @NotNull JSXNamespaceReference prevRef, @NotNull PsiScopeProcessor processor, @NotNull Collection<PsiElement> elements) {
        List results;
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(6);
        }
        if (prevRef == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(9);
        }
        JSModuleElementsResolveProcessor moduleProcessor = new JSModuleElementsResolveProcessor(processor);
        QualifiedItemProcessor<?> localProcessor = JSXComponentCompletionContributor.createQualifiedLocalProcessor(tag, prevRef);
        for (PsiElement element2 : elements) {
            if (!ES6PsiUtil.isExportScope((PsiElement)element2)) {
                if (element2 instanceof JSClass) {
                    element2.processDeclarations(localProcessor, ResolveState.initial(), element2, (PsiElement)tag);
                    continue;
                }
                JSTypeEvaluator.evaluateExpressionOrElementTypes((PsiFile)tag.getContainingFile(), localProcessor, (PsiElement)element2);
                continue;
            }
            if (ES6PsiUtil.processExportDeclarationInScope((PsiElement)element2, (JSModuleElementsProcessor)moduleProcessor)) continue;
            break;
        }
        if ((results = localProcessor.getResults()) == null) {
            return;
        }
        for (PsiElement el : results) {
            if (processor.execute(el, ResolveState.initial())) continue;
            return;
        }
    }

    @NotNull
    private static QualifiedItemProcessor<?> createQualifiedLocalProcessor(@NotNull XmlTag tag, @NotNull JSXNamespaceReference prevRef) {
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(10);
        }
        if (prevRef == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(11);
        }
        QualifiedItemProcessor localProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)tag).createQualifiedItemProcessor((ResultSink)new CompletionResultSink((PsiElement)tag, null), (PsiElement)tag);
        localProcessor.setLocalResolve(true);
        localProcessor.getAccessibilityProcessingHandler().setProcessStatics(!prevRef.isThisQualifier());
        QualifiedItemProcessor qualifiedItemProcessor = localProcessor;
        if (qualifiedItemProcessor == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(12);
        }
        return qualifiedItemProcessor;
    }

    private static void addExportedComponents(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull Set<String> localNames) {
        if (result2 == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(14);
        }
        if (localNames == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(15);
        }
        JSCompletionInsertHandlerFactory autoImportSupport = JSCompletionInsertHandlerFactory.getInstance();
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher();
        JSImportPlaceInfo info = JSHandlersFactory.forElement((PsiElement)tag).createImportPlaceInfo((PsiElement)tag);
        Predicate<String> keyFilter = name -> JSXResolveUtil.isComponentName((String)name) && prefixMatcher.prefixMatches(name) && !localNames.contains(name);
        List<JSImportCandidatesProvider> providers = JSImportCandidatesProvider.getProviders(info);
        AtomicInteger size = new AtomicInteger();
        JSImportCompletionUtil.processExportedElements((PsiElement)tag, providers, keyFilter, (PairProcessor<? super Collection<? extends JSImportCandidate>, ? super String>)((PairProcessor)(candidates, name) -> {
            JSImportCandidate candidate = candidates.size() == 1 ? (JSImportCandidate)ContainerUtil.getFirstItem((Collection)candidates) : null;
            PsiElement element2 = candidate != null ? candidate.getElement() : null;
            LookupElementBuilder lookup = JSXComponentCompletionContributor.createLookup(name, candidate, element2);
            result2.addElement((LookupElement)lookup.withInsertHandler(autoImportSupport.getTagImportInsertHandler(candidate)));
            if (size.incrementAndGet() > JSCompletionUtil.getCompletionLimit()) {
                JSCompletionUtil.handleOverflow(result2);
                return false;
            }
            return true;
        }));
    }

    private static void addLocalVariants(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, Set<String> collectedNames) {
        if (result2 == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(16);
        }
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(17);
        }
        JSResolveProcessor processor = JSXComponentCompletionContributor.createCompletionProcessor(result2, tag, collectedNames, false);
        JSResolveUtil.treeWalkUp((JSResolveProcessor)processor, (PsiElement)tag, null, (PsiElement)tag);
    }

    @NotNull
    private static JSResolveProcessor createCompletionProcessor(final @NotNull CompletionResultSet result2, @NotNull XmlTag tag, final @NotNull Set<String> collectedNames, final boolean qualified) {
        if (result2 == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(18);
        }
        if (tag == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(19);
        }
        if (collectedNames == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(20);
        }
        final PrefixMatcher matcher = result2.getPrefixMatcher();
        final JSCompletionPlaceFilter filter2 = JSCompletionPlaceFilter.forPlace((PsiElement)tag);
        return new JSResolveProcessor(){

            @Nullable
            public String getName() {
                return null;
            }

            public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!qualified && element2 instanceof JSDefinitionExpression) {
                    return true;
                }
                String name = ResolveProcessor.getName((PsiElement)element2);
                if (JSXResolveUtil.isComponentName((String)name) && !collectedNames.contains(name) && matcher.prefixMatches(name) && !"React".equals(name)) {
                    Collection<PsiElement> elementsByImport = JSXXmlExtension.expandElements(element2);
                    collectedNames.add(name);
                    for (PsiElement candidate : elementsByImport) {
                        ProgressManager.checkCanceled();
                        if (!filter2.isAcceptable(candidate)) continue;
                        LookupElementBuilder lookup = JSXComponentCompletionContributor.createLookup(name, null, candidate);
                        result2.addElement((LookupElement)lookup);
                        break;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXComponentCompletionContributor$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static LookupElementBuilder createLookup(@NotNull String name, @Nullable JSImportCandidate importCandidate, @Nullable PsiElement element2) {
        ItemPresentation presentation;
        if (name == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(21);
        }
        if (element2 instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)element2;
            v0 = namedElement.getPresentation();
        } else {
            v0 = presentation = null;
        }
        LookupElementBuilder lookupElementBuilder = (importCandidate == null && element2 == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)(importCandidate != null ? importCandidate : element2), (String)name)).withTypeText(presentation != null ? presentation.getLocationString() : null, true).withIcon(JavaScriptLanguageIcons.Logos.Jsx_16).withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        if (lookupElementBuilder == null) {
            JSXComponentCompletionContributor.$$$reportNull$$$0(22);
        }
        return lookupElementBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXComponentCompletionContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localNames";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXComponentCompletionContributor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedLocalProcessor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponentForNamespace";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNestedComponentsFromIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processNestedComponentInScopes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedLocalProcessor";
                break;
            }
            case 12: 
            case 22: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponents";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addLocalVariants";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProcessor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLookup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 22 -> new IllegalStateException(string);
        };
    }
}

