/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSTooltipWithHtmlHighlighter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J;\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0015\u0010\t\u001a\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSBundleMessageHighlighter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "message", "", "Lorg/jetbrains/annotations/Nls;", "propertyKey", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.JavaScriptBundle", "arguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "convertArguments", "([Ljava/lang/Object;)[Ljava/lang/Object;", "applyCodeTags", "NameOfElement", "TextWithAttributes", "intellij.javascript.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nJSBundleMessageHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSBundleMessageHighlighter.kt\ncom/intellij/lang/javascript/highlighting/JSBundleMessageHighlighter\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,80:1\n254#2:81\n*S KotlinDebug\n*F\n+ 1 JSBundleMessageHighlighter.kt\ncom/intellij/lang/javascript/highlighting/JSBundleMessageHighlighter\n*L\n32#1:81\n*E\n"})
public final class JSBundleMessageHighlighter {
    @NotNull
    private final Project project;

    public JSBundleMessageHighlighter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final String message(@NotNull String propertyKey, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)propertyKey, (String)"propertyKey");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Object[] objectArray = this.convertArguments(arguments);
        String string = JavaScriptBundle.message((String)propertyKey, (Object[])Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = XmlStringUtil.wrapInHtml((CharSequence)this.applyCodeTags(string));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrapInHtml(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] convertArguments(Object[] arguments) {
        Object[] $this$map2Array$iv = arguments;
        boolean $i$f$map2Array = false;
        int n = $this$map2Array$iv.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            void it;
            int n2 = i;
            Object object2 = $this$map2Array$iv[n2];
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            void var10_10 = it;
            if (var10_10 instanceof String) {
                object = XmlStringUtil.escapeString((String)((String)it));
            } else if (var10_10 instanceof JSType) {
                String typeText;
                Intrinsics.checkNotNullExpressionValue((Object)((JSType)it).getTypeText(JSType.TypeTextFormat.PRESENTABLE), (String)"getTypeText(...)");
                object = JSTooltipWithHtmlHighlighter.Companion.highlightTypeOrStmt$default(JSTooltipWithHtmlHighlighter.Companion, this.project, typeText, false, 0, false, 28, null);
            } else if (var10_10 instanceof NameOfElement) {
                object = JSTooltipWithHtmlHighlighter.Companion.highlightName$default(JSTooltipWithHtmlHighlighter.Companion, ((NameOfElement)it).getElement(), ((NameOfElement)it).getName(), false, 4, null);
            } else if (var10_10 instanceof PsiElement) {
                String string = ((PsiElement)it).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                object = JSTooltipWithHtmlHighlighter.Companion.highlightTypeOrStmt$default(JSTooltipWithHtmlHighlighter.Companion, this.project, ((Object)StringsKt.trim((CharSequence)string)).toString(), false, 0, false, 28, null);
            } else {
                object = var10_10 instanceof TextWithAttributes ? JSTooltipWithHtmlHighlighter.Companion.applyAttributes$default(JSTooltipWithHtmlHighlighter.Companion, this.project, ((TextWithAttributes)it).getText(), ((TextWithAttributes)it).getTextAttributesKey(), false, 8, null) : it;
            }
            String string = object;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            objectArray2[n3] = string2;
        }
        return objectArray;
    }

    private final String applyCodeTags(String message) {
        int codeEnd = 0;
        int codeStart = StringsKt.indexOf$default((CharSequence)message, (String)"<code>", (int)0, (boolean)false, (int)6, null);
        if (codeStart == -1) {
            return message;
        }
        StringBuilder builder2 = new StringBuilder();
        while (true) {
            String content;
            boolean found;
            boolean bl = found = codeStart != -1;
            if (!found) {
                codeStart = message.length();
            }
            builder2.append(message, codeEnd, codeStart);
            if (!found) break;
            codeEnd = StringsKt.indexOf$default((CharSequence)message, (String)"</code>", (int)(codeStart += 6), (boolean)false, (int)4, null);
            Intrinsics.checkNotNullExpressionValue((Object)message.substring(codeStart, codeEnd), (String)"substring(...)");
            codeEnd += 7;
            builder2.append("<code>");
            StringBuilder stringBuilder = !StringsKt.startsWith$default((String)content, (String)"<span", (boolean)false, (int)2, null) ? builder2.append(JSTooltipWithHtmlHighlighter.Companion.highlightWithLexer$default(JSTooltipWithHtmlHighlighter.Companion, this.project, content, null, false, 4, null)) : builder2.append(content);
            builder2.append("</code>");
            codeStart = StringsKt.indexOf$default((CharSequence)message, (String)"<code>", (int)codeEnd, (boolean)false, (int)4, null);
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSBundleMessageHighlighter$NameOfElement;", "", "name", "", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getName", "()Ljava/lang/String;", "getElement", "()Lcom/intellij/psi/PsiElement;", "intellij.javascript.analysis.impl"})
    public static final class NameOfElement {
        @NotNull
        private final String name;
        @NotNull
        private final PsiElement element;

        public NameOfElement(@NotNull String name, @NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            this.name = name;
            this.element = element2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSBundleMessageHighlighter$TextWithAttributes;", "", "text", "", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getText", "()Ljava/lang/String;", "getTextAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.javascript.analysis.impl"})
    public static final class TextWithAttributes {
        @NotNull
        private final String text;
        @NotNull
        private final TextAttributesKey textAttributesKey;

        public TextWithAttributes(@NotNull String text, @NotNull TextAttributesKey textAttributesKey) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
            this.text = text;
            this.textAttributesKey = textAttributesKey;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final TextAttributesKey getTextAttributesKey() {
            return this.textAttributesKey;
        }
    }
}

