/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.compiler.InlayHintsPreferences;
import com.intellij.lang.typescript.compiler.TypeScriptServiceRestarter;
import com.intellij.lang.typescript.editing.GetInlayHintsPreferencesKt;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptServiceCompletionSupport;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServerDescriptor;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServiceKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoServiceUtilKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyCustomizer;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyDisabled;
import com.intellij.platform.lsp.api.customization.LspCustomization;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolDisabled;
import com.intellij.platform.lsp.api.customization.LspFoldingRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToDefinitionCustomizer;
import com.intellij.platform.lsp.api.customization.LspGoToDefinitionSupport;
import com.intellij.platform.lsp.api.customization.LspInlayHintCustomizer;
import com.intellij.platform.lsp.api.customization.LspInlayHintSupport;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeCustomizer;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpCustomizer;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpDisabled;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolDisabled;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ApplicationKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R \u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspCustomization", "Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "getLspCustomization", "()Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "getWorkspaceConfiguration", "", "item", "Lorg/eclipse/lsp4j/ConfigurationItem;", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.javascript.backend"})
public final class TypeScriptGoLspServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    @NotNull
    private final LspCustomization lspCustomization;

    public TypeScriptGoLspServerDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = JavaScriptBundle.message((String)"typescript.go.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, string);
        this.lsp4jServerClass = JSFrameworkLsp4jServer.class;
        this.lspCustomization = new LspCustomization(project){
            private final lspCustomization.diagnosticsCustomizer.1 diagnosticsCustomizer;
            private final BaseLspTypeScriptServiceCompletionSupport completionCustomizer;
            private final LspFoldingRangeDisabled foldingRangeCustomizer;
            private final LspWorkspaceSymbolCustomizer workspaceSymbolCustomizer;
            private final LspDocumentHighlightsCustomizer documentHighlightsCustomizer;
            private final LspDocumentSymbolCustomizer documentSymbolCustomizer;
            private final LspSignatureHelpCustomizer signatureHelpCustomizer;
            private final LspCallHierarchyCustomizer callHierarchyCustomizer;
            private final LspSelectionRangeCustomizer selectionRangeCustomizer;
            private final LspInlayHintCustomizer inlayHintCustomizer;
            private final LspGoToDefinitionCustomizer goToDefinitionCustomizer;
            {
                this.diagnosticsCustomizer = new LspDiagnosticsSupport(){

                    public void createAnnotation(AnnotationHolder holder, Diagnostic diagnostic, TextRange textRange, List<? extends IntentionAction> quickFixes) {
                        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
                        Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
                    }
                };
                this.completionCustomizer = new BaseLspTypeScriptServiceCompletionSupport();
                this.foldingRangeCustomizer = LspFoldingRangeDisabled.INSTANCE;
                this.workspaceSymbolCustomizer = (LspWorkspaceSymbolCustomizer)LspWorkspaceSymbolDisabled.INSTANCE;
                this.documentHighlightsCustomizer = (LspDocumentHighlightsCustomizer)LspDocumentHighlightsDisabled.INSTANCE;
                this.documentSymbolCustomizer = (LspDocumentSymbolCustomizer)LspDocumentSymbolDisabled.INSTANCE;
                this.signatureHelpCustomizer = (LspSignatureHelpCustomizer)LspSignatureHelpDisabled.INSTANCE;
                this.callHierarchyCustomizer = (LspCallHierarchyCustomizer)LspCallHierarchyDisabled.INSTANCE;
                this.selectionRangeCustomizer = (LspSelectionRangeCustomizer)LspSelectionRangeDisabled.INSTANCE;
                this.inlayHintCustomizer = (LspInlayHintCustomizer)new LspInlayHintSupport($project){
                    private volatile InlayHintsPreferences currentPrefs;
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public final InlayHintsPreferences getCurrentPrefs() {
                        return this.currentPrefs;
                    }

                    public final void setCurrentPrefs(InlayHintsPreferences inlayHintsPreferences) {
                        this.currentPrefs = inlayHintsPreferences;
                    }

                    public boolean shouldAskServerForInlayHints(VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        InlayHintsPreferences currPrefs = this.currentPrefs;
                        InlayHintsPreferences newPrefs = GetInlayHintsPreferencesKt.getInlayHintsPreferences();
                        if (currPrefs != null && !Intrinsics.areEqual((Object)currPrefs, (Object)newPrefs)) {
                            ApplicationKt.getApplication().invokeLater(() -> lspCustomization.inlayHintCustomizer.1.shouldAskServerForInlayHints$lambda$0(this.$project));
                        }
                        this.currentPrefs = newPrefs;
                        return true;
                    }

                    private static final void shouldAskServerForInlayHints$lambda$0(Project $project) {
                        TypeScriptServiceRestarter.restartServices($project);
                    }
                };
                this.goToDefinitionCustomizer = (LspGoToDefinitionCustomizer)new LspGoToDefinitionSupport($project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public List<LocationLink> filterDefinitions(VirtualFile file, int offset, List<? extends LocationLink> definitions) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
                        if (definitions.size() != 1) {
                            return definitions;
                        }
                        PsiFile psiFile = PsiManager.getInstance((Project)this.$project).findFile(file);
                        if (psiFile == null) {
                            return definitions;
                        }
                        PsiFile psiFile2 = psiFile;
                        PsiElement psiElement = psiFile2.findElementAt(offset);
                        if (psiElement == null) {
                            return definitions;
                        }
                        PsiElement srcElement = psiElement;
                        Position position = ((LocationLink)CollectionsKt.first(definitions)).getTargetSelectionRange().getStart();
                        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                        Integer n = lspCustomization.goToDefinitionCustomizer.1.filterDefinitions$toOffset(psiFile2, position);
                        if (n == null) {
                            return definitions;
                        }
                        int targetStartOffset = n;
                        Position position2 = ((LocationLink)CollectionsKt.first(definitions)).getTargetSelectionRange().getEnd();
                        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
                        Integer n2 = lspCustomization.goToDefinitionCustomizer.1.filterDefinitions$toOffset(psiFile2, position2);
                        if (n2 == null) {
                            return definitions;
                        }
                        int targetEndOffset = n2;
                        PsiElement psiElement2 = psiFile2.findElementAt(targetStartOffset);
                        if (psiElement2 == null) {
                            return definitions;
                        }
                        PsiElement targetElement = psiElement2;
                        return Intrinsics.areEqual((Object)targetElement, (Object)srcElement) && PsiTreeUtilKt.getEndOffset((PsiElement)targetElement) == targetEndOffset ? CollectionsKt.emptyList() : definitions;
                    }

                    private static final Integer filterDefinitions$toOffset(PsiFile psiFile, Position pos) {
                        if (pos.getLine() >= psiFile.getFileDocument().getLineCount()) {
                            return null;
                        }
                        return psiFile.getFileDocument().getLineStartOffset(pos.getLine()) + pos.getCharacter();
                    }
                };
            }

            public lspCustomization.diagnosticsCustomizer.1 getDiagnosticsCustomizer() {
                return this.diagnosticsCustomizer;
            }

            public BaseLspTypeScriptServiceCompletionSupport getCompletionCustomizer() {
                return this.completionCustomizer;
            }

            public LspFoldingRangeDisabled getFoldingRangeCustomizer() {
                return this.foldingRangeCustomizer;
            }

            public LspWorkspaceSymbolCustomizer getWorkspaceSymbolCustomizer() {
                return this.workspaceSymbolCustomizer;
            }

            public LspDocumentHighlightsCustomizer getDocumentHighlightsCustomizer() {
                return this.documentHighlightsCustomizer;
            }

            public LspDocumentSymbolCustomizer getDocumentSymbolCustomizer() {
                return this.documentSymbolCustomizer;
            }

            public LspSignatureHelpCustomizer getSignatureHelpCustomizer() {
                return this.signatureHelpCustomizer;
            }

            public LspCallHierarchyCustomizer getCallHierarchyCustomizer() {
                return this.callHierarchyCustomizer;
            }

            public LspSelectionRangeCustomizer getSelectionRangeCustomizer() {
                return this.selectionRangeCustomizer;
            }

            public LspInlayHintCustomizer getInlayHintCustomizer() {
                return this.inlayHintCustomizer;
            }

            public LspGoToDefinitionCustomizer getGoToDefinitionCustomizer() {
                return this.goToDefinitionCustomizer;
            }
        };
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    @NotNull
    public LspCustomization getLspCustomization() {
        return this.lspCustomization;
    }

    @Nullable
    public Object getWorkspaceConfiguration(@NotNull ConfigurationItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (Intrinsics.areEqual((Object)item.getSection(), (Object)"typescript")) {
            InlayHintsPreferences hintsParams = GetInlayHintsPreferencesKt.getInlayHintsPreferences();
            Pair[] pairArray = new Pair[6];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"enabled", (Object)(hintsParams.getNonLiteralParameterName() ? "all" : (hintsParams.getLiteralParameterName() ? "literals" : "none"))), TuplesKt.to((Object)"suppressWhenArgumentMatchesName", (Object)(!hintsParams.getIncludeParameterNameWhenArgumentMatchesName() ? 1 : 0))};
            pairArray[0] = TuplesKt.to((Object)"parameterNames", (Object)MapsKt.mapOf((Pair[])pairArray2));
            pairArray[1] = TuplesKt.to((Object)"parameterTypes", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"enabled", (Object)hintsParams.getFunctionParameterType())));
            pairArray2 = new Pair[]{TuplesKt.to((Object)"enabled", (Object)hintsParams.getVariableType()), TuplesKt.to((Object)"suppressWhenTypeMatchesName", (Object)(!hintsParams.getIncludeVariableTypeWhenTypeMatchesName() ? 1 : 0))};
            pairArray[2] = TuplesKt.to((Object)"variableTypes", (Object)MapsKt.mapOf((Pair[])pairArray2));
            pairArray[3] = TuplesKt.to((Object)"propertyDeclarationTypes", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"enabled", (Object)hintsParams.getVariableType())));
            pairArray[4] = TuplesKt.to((Object)"functionLikeReturnTypes", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"enabled", (Object)hintsParams.getFunctionLikeReturnType())));
            pairArray[5] = TuplesKt.to((Object)"enumMemberValues", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"enabled", (Object)hintsParams.getEnumMemberValue())));
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"inlayHints", (Object)MapsKt.mapOf((Pair[])pairArray)));
        }
        return super.getWorkspaceConfiguration(item);
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptGoLspServiceKt.getTsGoLSPService(this.getProject()).isAcceptable(file);
    }

    @NotNull
    public OSProcessHandler startServerProcess() {
        OSProcessHandler oSProcessHandler = TypeScriptGoServiceUtilKt.tryStartInWsl(this.createCommandLine(), LspServerDescriptor.LOG);
        if (oSProcessHandler == null) {
            oSProcessHandler = super.startServerProcess();
        }
        return oSProcessHandler;
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        String serviceDirectory = (String)ReadAction.nonBlocking(() -> TypeScriptGoLspServerDescriptor.createCommandLine$lambda$0(this)).executeSynchronously();
        Intrinsics.checkNotNull((Object)serviceDirectory);
        TypeScriptGoPackageInfo typeScriptGoPackageInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(serviceDirectory);
        if (typeScriptGoPackageInfo == null) {
            Object[] objectArray = new Object[]{serviceDirectory};
            throw new ExecutionException(JavaScriptBundle.message((String)"typescript.go.bad.package", (Object[])objectArray));
        }
        TypeScriptGoPackageInfo tsGoInfo = typeScriptGoPackageInfo;
        String string = tsGoInfo.getBinaryExecutable().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new GeneralCommandLine(TypeScriptGoServiceUtilKt.getTsGoCommandLine(string));
    }

    private static final String createCommandLine$lambda$0(TypeScriptGoLspServerDescriptor this$0) {
        return TypeScriptServiceDirectoryWatcher.getService(this$0.getProject()).calcServiceDirectoryAndRefresh();
    }
}

