/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.renderers;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.util.NlsSafe;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPropertyRenderer
extends JLabel
implements PropertyRenderer {
    @Nullable
    @Nls
    private final String myStaticText;

    public LabelPropertyRenderer(@Nullable @Nls String staticText) {
        this.myStaticText = staticText;
        this.setOpaque(true);
        this.putClientProperty("html.disable", true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, PropertyContext context, @Nullable Object value, boolean selected, boolean hasFocus) {
        this.setText(null);
        this.setIcon(null);
        PropertyTable.updateRenderer(this, selected);
        if (value != null) {
            this.customize(value);
        }
        LabelPropertyRenderer labelPropertyRenderer = this;
        if (labelPropertyRenderer == null) {
            LabelPropertyRenderer.$$$reportNull$$$0(0);
        }
        return labelPropertyRenderer;
    }

    protected void customize(@NotNull Object value) {
        if (value == null) {
            LabelPropertyRenderer.$$$reportNull$$$0(1);
        }
        @NlsSafe String stringValue = value.toString();
        this.setText(this.myStaticText != null ? this.myStaticText : stringValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/propertyTable/renderers/LabelPropertyRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/propertyTable/renderers/LabelPropertyRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

