/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CommonActionsPanel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/bookmark/BookmarksListProviderService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "reference", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "Companion", "Adapter", "intellij.platform.bookmarks"})
@ApiStatus.Internal
public final class BookmarksListProviderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<List<BookmarksListProvider>> reference;

    public BookmarksListProviderService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.reference = new AtomicReference();
        BookmarksListProvider.EP.addChangeListener((AreaInstance)project, () -> BookmarksListProviderService._init_$lambda$0(this), (Disposable)project);
        FavoritesListProvider.EP_NAME.getPoint((AreaInstance)project).addChangeListener(() -> BookmarksListProviderService._init_$lambda$1(this), (Disposable)project);
    }

    private static final void _init_$lambda$0(BookmarksListProviderService this$0) {
        this$0.reference.set(null);
    }

    private static final void _init_$lambda$1(BookmarksListProviderService this$0) {
        this$0.reference.set(null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000f\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\rH\u0016J\u0014\u0010\u000e\u001a\u000e\u0018\u00010\u000f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u000e\u0018\u00010\u000f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0010H\u0016J\u0014\u0010\u001a\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00162\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/bookmark/BookmarksListProviderService$Adapter;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/ide/favoritesTreeView/FavoritesListProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/favoritesTreeView/FavoritesListProvider;)V", "getProject", "getWeight", "", "createNode", "Lcom/intellij/ide/favoritesTreeView/FavoritesListNode;", "Lorg/jetbrains/annotations/Nullable;", "getEditActionText", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "canEdit", "", "selection", "", "performEdit", "", "parent", "Ljavax/swing/JComponent;", "getDeleteActionText", "canDelete", "", "performDelete", "intellij.platform.bookmarks"})
    private static final class Adapter
    implements BookmarksListProvider {
        @NotNull
        private final Project project;
        @NotNull
        private final FavoritesListProvider provider;

        public Adapter(@NotNull Project project, @NotNull FavoritesListProvider provider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.project = project;
            this.provider = provider;
        }

        @NotNull
        public Project getProject() {
            return this.project;
        }

        public int getWeight() {
            return this.provider.getWeight();
        }

        @Nullable
        public FavoritesListNode createNode() {
            return this.provider.createFavoriteListNode(this.project);
        }

        @Nullable
        public String getEditActionText() {
            return this.provider.getCustomName(CommonActionsPanel.Buttons.EDIT);
        }

        public boolean canEdit(@NotNull Object selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return this.provider.willHandle(CommonActionsPanel.Buttons.EDIT, this.project, SetsKt.setOf((Object)selection));
        }

        public void performEdit(@NotNull Object selection, @NotNull JComponent parent) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.provider.handle(CommonActionsPanel.Buttons.EDIT, this.project, SetsKt.setOf((Object)selection), parent);
        }

        @Nullable
        public String getDeleteActionText() {
            return this.provider.getCustomName(CommonActionsPanel.Buttons.REMOVE);
        }

        public boolean canDelete(@NotNull List<?> selection) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            return this.provider.willHandle(CommonActionsPanel.Buttons.REMOVE, this.project, CollectionsKt.toSet((Iterable)selection));
        }

        public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.provider.handle(CommonActionsPanel.Buttons.REMOVE, this.project, CollectionsKt.toSet((Iterable)selection), parent);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/bookmark/BookmarksListProviderService$Companion;", "", "<init>", "()V", "findProvider", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "predicate", "Lkotlin/Function1;", "", "getProviders", "", "createProviders", "intellij.platform.bookmarks"})
    @SourceDebugExtension(value={"SMAP\nBookmarksListProviderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksListProviderService.kt\ncom/intellij/ide/bookmark/BookmarksListProviderService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1#2:54\n1661#3,3:55\n1033#3,2:58\n*S KotlinDebug\n*F\n+ 1 BookmarksListProviderService.kt\ncom/intellij/ide/bookmark/BookmarksListProviderService$Companion\n*L\n33#1:55,3\n34#1:58,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BookmarksListProvider findProvider(@NotNull Project project, @NotNull Function1<? super BookmarksListProvider, Boolean> predicate) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                Iterable iterable = this.getProviders(project);
                for (Object t : iterable) {
                    if (!((Boolean)predicate.invoke(t)).booleanValue()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final List<BookmarksListProvider> getProviders(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDisposed()) {
                return CollectionsKt.emptyList();
            }
            Object object = (BookmarksListProviderService)project.getService(BookmarksListProviderService.class);
            if (object == null || (object = ((BookmarksListProviderService)object).reference) == null) {
                return CollectionsKt.emptyList();
            }
            Object reference = object;
            List<BookmarksListProvider> list2 = (List<BookmarksListProvider>)((AtomicReference)reference).get();
            if (list2 == null) {
                List<BookmarksListProvider> list3;
                List<BookmarksListProvider> it = list3 = this.createProviders(project);
                boolean bl = false;
                ((AtomicReference)reference).set(it);
                list2 = list3;
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<BookmarksListProvider> createProviders(Project project) {
            void $this$mapTo$iv;
            List providers = CollectionsKt.toMutableList((Collection)BookmarksListProvider.EP.getExtensions((AreaInstance)project));
            Iterable iterable = FavoritesListProvider.EP_NAME.getExtensionList((AreaInstance)project);
            Collection destination$iv = providers;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FavoritesListProvider favoritesListProvider = (FavoritesListProvider)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new Adapter(project, (FavoritesListProvider)it));
            }
            List $this$sortByDescending$iv = providers;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        BookmarksListProvider it = (BookmarksListProvider)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getWeight());
                        it = (BookmarksListProvider)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getWeight()));
                    }
                });
            }
            List<BookmarksListProvider> list2 = Collections.unmodifiableList(providers);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(...)");
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

