/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Macro {
    public static final ExtensionPointName<Macro> EP_NAME = ExtensionPointName.create((String)"com.intellij.macro");

    @NonNls
    @NotNull
    public abstract String getName();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public abstract String getDescription();

    @Nullable
    public abstract String expand(@NotNull DataContext var1) throws ExecutionCancelledException;

    @Nullable
    public String expand(@NotNull DataContext dataContext, String ... args) throws ExecutionCancelledException {
        if (dataContext == null) {
            Macro.$$$reportNull$$$0(0);
        }
        if (args == null) {
            Macro.$$$reportNull$$$0(1);
        }
        return this.expand(dataContext);
    }

    @Nullable
    public String preview(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Macro.$$$reportNull$$$0(2);
        }
        try {
            return this.expand(dataContext);
        }
        catch (ExecutionCancelledException ignore) {
            return null;
        }
    }

    @Nullable
    public TextRange findOccurence(@NotNull CharSequence s, int offset) {
        if (s == null) {
            Macro.$$$reportNull$$$0(3);
        }
        String prefix = "$" + this.getName();
        int start = Strings.indexOf((CharSequence)s, (CharSequence)prefix, (int)offset);
        int next = start + prefix.length();
        if (start < 0 || next >= s.length()) {
            return null;
        }
        return this.getRangeForSuffix(s, start, next);
    }

    @Nullable
    protected TextRange getRangeForSuffix(@NotNull CharSequence s, int start, int next) {
        if (s == null) {
            Macro.$$$reportNull$$$0(4);
        }
        return switch (s.charAt(next)) {
            case '$' -> TextRange.create((int)start, (int)(next + 1));
            case '(' -> {
                int end = Strings.indexOf((CharSequence)s, (CharSequence)")$", (int)next);
                if (end < 0) {
                    yield null;
                }
                yield TextRange.create((int)start, (int)(end + 2));
            }
            default -> null;
        };
    }

    public String expandOccurence(@NotNull DataContext context, @NotNull String occurence) throws ExecutionCancelledException {
        if (context == null) {
            Macro.$$$reportNull$$$0(5);
        }
        if (occurence == null) {
            Macro.$$$reportNull$$$0(6);
        }
        if (occurence.endsWith(")$")) {
            return this.expand(context, occurence.substring(occurence.indexOf(40) + 1, occurence.length() - 2));
        }
        return this.expand(context);
    }

    @NotNull
    protected static String getPath(@NotNull VirtualFile file) {
        if (file == null) {
            Macro.$$$reportNull$$$0(7);
        }
        String string = file.getPath().replace('/', File.separatorChar);
        if (string == null) {
            Macro.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    static File getIOFile(@NotNull VirtualFile file) {
        if (file == null) {
            Macro.$$$reportNull$$$0(9);
        }
        return new File(Macro.getPath(file));
    }

    @Nullable
    protected static VirtualFile getVirtualDirOrParent(@NotNull DataContext dataContext) {
        VirtualFile vFile;
        if (dataContext == null) {
            Macro.$$$reportNull$$$0(10);
        }
        if ((vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && !vFile.isDirectory()) {
            vFile = vFile.getParent();
        }
        return vFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurence";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/Macro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/Macro";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preview";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findOccurence";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRangeForSuffix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandOccurence";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIOFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualDirOrParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public static final class ExecutionCancelledException
    extends Exception {
    }

    public static class Silent
    extends Macro {
        private final Macro myDelegate;
        private final String myValue;

        public Silent(@NotNull Macro delegate, String value) {
            if (delegate == null) {
                Silent.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myValue = value;
        }

        @Override
        public String expand(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                Silent.$$$reportNull$$$0(1);
            }
            return this.myValue;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myDelegate.getDescription();
            if (string == null) {
                Silent.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myDelegate.getName();
            if (string == null) {
                Silent.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/macro/Macro$Silent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/macro/Macro$Silent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "expand";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

